/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.event;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.distribution.CacheReplicator;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.NotificationScope;
import net.sf.ehcache.statistics.LiveCacheStatisticsData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisteredEventListeners {
    private static final Element DUMMY_ELEMENT = new Element(null, null);
    private final Set<ListenerWrapper> cacheEventListeners = new CopyOnWriteArraySet<ListenerWrapper>();
    private final Ehcache cache;
    private final AtomicLong elementsRemovedCounter = new AtomicLong(0L);
    private final AtomicLong elementsPutCounter = new AtomicLong(0L);
    private final AtomicLong elementsUpdatedCounter = new AtomicLong(0L);
    private final AtomicLong elementsExpiredCounter = new AtomicLong(0L);
    private final AtomicLong elementsEvictedCounter = new AtomicLong(0L);
    private final AtomicLong elementsRemoveAllCounter = new AtomicLong(0L);

    public RegisteredEventListeners(Ehcache cache) {
        this.cache = cache;
    }

    public final void notifyElementRemoved(Element element, boolean remoteEvent) throws CacheException {
        this.internalNotifyElementRemoved(element, null, remoteEvent);
    }

    public final void notifyElementRemoved(ElementCreationCallback callback, boolean remoteEvent) throws CacheException {
        this.internalNotifyElementRemoved(null, callback, remoteEvent);
    }

    private void internalNotifyElementRemoved(Element element, ElementCreationCallback callback, boolean remoteEvent) {
        this.elementsRemovedCounter.incrementAndGet();
        if (this.hasCacheEventListeners()) {
            for (ListenerWrapper listenerWrapper : this.cacheEventListeners) {
                if (!listenerWrapper.getScope().shouldDeliver(remoteEvent) || RegisteredEventListeners.isCircularNotification(remoteEvent, listenerWrapper.getListener())) continue;
                CacheEventListener listener = listenerWrapper.getListener();
                this.invokeListener(listener, element, callback, Event.REMOVED);
            }
        }
    }

    public final void notifyElementPut(Element element, boolean remoteEvent) throws CacheException {
        this.internalNotifyElementPut(element, null, remoteEvent);
    }

    public final void notifyElementPut(ElementCreationCallback callback, boolean remoteEvent) throws CacheException {
        this.internalNotifyElementPut(null, callback, remoteEvent);
    }

    private void internalNotifyElementPut(Element element, ElementCreationCallback callback, boolean remoteEvent) {
        this.elementsPutCounter.incrementAndGet();
        if (this.hasCacheEventListeners()) {
            for (ListenerWrapper listenerWrapper : this.cacheEventListeners) {
                if (!listenerWrapper.getScope().shouldDeliver(remoteEvent) || RegisteredEventListeners.isCircularNotification(remoteEvent, listenerWrapper.getListener())) continue;
                CacheEventListener listener = listenerWrapper.getListener();
                this.invokeListener(listener, element, callback, Event.PUT);
            }
        }
    }

    public final void notifyElementUpdated(Element element, boolean remoteEvent) {
        this.internalNotifyElementUpdated(element, null, remoteEvent);
    }

    public final void notifyElementUpdated(ElementCreationCallback callback, boolean remoteEvent) {
        this.internalNotifyElementUpdated(null, callback, remoteEvent);
    }

    private void internalNotifyElementUpdated(Element element, ElementCreationCallback callback, boolean remoteEvent) {
        this.elementsUpdatedCounter.incrementAndGet();
        if (this.hasCacheEventListeners()) {
            for (ListenerWrapper listenerWrapper : this.cacheEventListeners) {
                if (!listenerWrapper.getScope().shouldDeliver(remoteEvent) || RegisteredEventListeners.isCircularNotification(remoteEvent, listenerWrapper.getListener())) continue;
                CacheEventListener listener = listenerWrapper.getListener();
                this.invokeListener(listener, element, callback, Event.UPDATED);
            }
        }
    }

    public final void notifyElementExpiry(Element element, boolean remoteEvent) {
        this.internalNotifyElementExpiry(element, null, remoteEvent);
    }

    public final void notifyElementExpiry(ElementCreationCallback callback, boolean remoteEvent) {
        this.internalNotifyElementExpiry(null, callback, remoteEvent);
    }

    private void internalNotifyElementExpiry(Element element, ElementCreationCallback callback, boolean remoteEvent) {
        this.elementsExpiredCounter.incrementAndGet();
        if (this.hasCacheEventListeners()) {
            for (ListenerWrapper listenerWrapper : this.cacheEventListeners) {
                if (!listenerWrapper.getScope().shouldDeliver(remoteEvent) || RegisteredEventListeners.isCircularNotification(remoteEvent, listenerWrapper.getListener())) continue;
                CacheEventListener listener = listenerWrapper.getListener();
                this.invokeListener(listener, element, callback, Event.EXPIRY);
            }
        }
    }

    public final boolean hasCacheEventListeners() {
        return this.cacheEventListeners.size() > 0;
    }

    public final void notifyElementEvicted(Element element, boolean remoteEvent) {
        this.internalNotifyElementEvicted(element, null, remoteEvent);
    }

    public final void notifyElementEvicted(ElementCreationCallback callback, boolean remoteEvent) {
        this.internalNotifyElementEvicted(null, callback, remoteEvent);
    }

    private void internalNotifyElementEvicted(Element element, ElementCreationCallback callback, boolean remoteEvent) {
        this.elementsEvictedCounter.incrementAndGet();
        if (this.hasCacheEventListeners()) {
            for (ListenerWrapper listenerWrapper : this.cacheEventListeners) {
                if (!listenerWrapper.getScope().shouldDeliver(remoteEvent) || RegisteredEventListeners.isCircularNotification(remoteEvent, listenerWrapper.getListener())) continue;
                CacheEventListener listener = listenerWrapper.getListener();
                this.invokeListener(listener, element, callback, Event.EVICTED);
            }
        }
    }

    private void invokeListener(CacheEventListener listener, Element element, ElementCreationCallback callback, Event eventType) {
        Element e = listener instanceof LiveCacheStatisticsData ? DUMMY_ELEMENT : (callback != null ? callback.createElement(listener.getClass().getClassLoader()) : element);
        this.notifyListener(listener, e, eventType);
    }

    private void notifyListener(CacheEventListener listener, Element element, Event eventType) {
        switch (eventType) {
            case EVICTED: {
                listener.notifyElementEvicted(this.cache, element);
                break;
            }
            case PUT: {
                listener.notifyElementPut(this.cache, element);
                break;
            }
            case EXPIRY: {
                listener.notifyElementExpired(this.cache, element);
                break;
            }
            case REMOVED: {
                listener.notifyElementRemoved(this.cache, element);
                break;
            }
            case UPDATED: {
                listener.notifyElementUpdated(this.cache, element);
                break;
            }
            default: {
                throw new AssertionError((Object)eventType.toString());
            }
        }
    }

    public final void notifyRemoveAll(boolean remoteEvent) {
        this.elementsRemoveAllCounter.incrementAndGet();
        if (this.hasCacheEventListeners()) {
            for (ListenerWrapper listenerWrapper : this.cacheEventListeners) {
                if (!listenerWrapper.getScope().shouldDeliver(remoteEvent) || RegisteredEventListeners.isCircularNotification(remoteEvent, listenerWrapper.getListener())) continue;
                listenerWrapper.getListener().notifyRemoveAll(this.cache);
            }
        }
    }

    private static boolean isCircularNotification(boolean remoteEvent, CacheEventListener cacheEventListener) {
        return remoteEvent && cacheEventListener instanceof CacheReplicator;
    }

    public final boolean registerListener(CacheEventListener cacheEventListener) {
        return this.registerListener(cacheEventListener, NotificationScope.ALL);
    }

    public final boolean registerListener(CacheEventListener cacheEventListener, NotificationScope scope) {
        if (cacheEventListener == null) {
            return false;
        }
        return this.cacheEventListeners.add(new ListenerWrapper(cacheEventListener, scope));
    }

    public final boolean unregisterListener(CacheEventListener cacheEventListener) {
        for (ListenerWrapper listenerWrapper : this.cacheEventListeners) {
            if (!listenerWrapper.getListener().equals(cacheEventListener)) continue;
            this.cacheEventListeners.remove(listenerWrapper);
            return true;
        }
        return false;
    }

    public final Set<CacheEventListener> getCacheEventListeners() {
        HashSet<CacheEventListener> listenerSet = new HashSet<CacheEventListener>();
        for (ListenerWrapper listenerWrapper : this.cacheEventListeners) {
            listenerSet.add(listenerWrapper.getListener());
        }
        return listenerSet;
    }

    public final void dispose() {
        for (ListenerWrapper listenerWrapper : this.cacheEventListeners) {
            listenerWrapper.getListener().dispose();
        }
        this.cacheEventListeners.clear();
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(" cacheEventListeners: ");
        for (ListenerWrapper listenerWrapper : this.cacheEventListeners) {
            sb.append(listenerWrapper.getListener().getClass().getName()).append(" ");
        }
        return sb.toString();
    }

    public void clearCounters() {
        this.elementsRemovedCounter.set(0L);
        this.elementsPutCounter.set(0L);
        this.elementsUpdatedCounter.set(0L);
        this.elementsExpiredCounter.set(0L);
        this.elementsEvictedCounter.set(0L);
        this.elementsRemoveAllCounter.set(0L);
    }

    public long getElementsRemovedCounter() {
        return this.elementsRemovedCounter.get();
    }

    public long getElementsPutCounter() {
        return this.elementsPutCounter.get();
    }

    public long getElementsUpdatedCounter() {
        return this.elementsUpdatedCounter.get();
    }

    public long getElementsExpiredCounter() {
        return this.elementsExpiredCounter.get();
    }

    public long getElementsEvictedCounter() {
        return this.elementsEvictedCounter.get();
    }

    public long getElementsRemoveAllCounter() {
        return this.elementsRemoveAllCounter.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Event {
        EVICTED,
        PUT,
        EXPIRY,
        UPDATED,
        REMOVED;

    }

    public static interface ElementCreationCallback {
        public Element createElement(ClassLoader var1);
    }

    private static final class ListenerWrapper {
        private final CacheEventListener listener;
        private final NotificationScope scope;

        private ListenerWrapper(CacheEventListener listener, NotificationScope scope) {
            this.listener = listener;
            this.scope = scope;
        }

        private CacheEventListener getListener() {
            return this.listener;
        }

        private NotificationScope getScope() {
            return this.scope;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ListenerWrapper other = (ListenerWrapper)obj;
            return !(this.listener == null ? other.listener != null : !this.listener.equals(other.listener));
        }

        public String toString() {
            return this.listener.toString();
        }
    }
}

