/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.api;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.asn1.ber.tlv.TLVStateEnum;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.api.MessageDecorator;
import org.apache.directory.shared.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.shared.ldap.model.exception.ResponseCarryingMessageException;
import org.apache.directory.shared.ldap.model.message.Message;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapDecoder {
    private static Logger LOG = LoggerFactory.getLogger(LdapDecoder.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private Asn1Decoder asn1Decoder = new Asn1Decoder();

    public Message decode(InputStream in, LdapMessageContainer<MessageDecorator<? extends Message>> container) throws DecoderException {
        try {
            byte[] buf;
            int amount;
            while (in.available() > 0 && (amount = in.read(buf = new byte[in.available()])) != -1) {
                this.asn1Decoder.decode(ByteBuffer.wrap(buf, 0, amount), container);
            }
        }
        catch (Exception e) {
            String message = I18n.err(I18n.ERR_04060, e.getLocalizedMessage());
            LOG.error(message);
            throw new DecoderException(message, e);
        }
        if (container.getState() == TLVStateEnum.PDU_DECODED) {
            if (IS_DEBUG) {
                LOG.debug("Decoded LdapMessage : " + container);
            }
            return container.getMessage();
        }
        LOG.error(I18n.err(I18n.ERR_04062, new Object[0]));
        throw new DecoderException(I18n.err(I18n.ERR_04063, new Object[0]));
    }

    public void decode(ByteBuffer buffer, LdapMessageContainer<MessageDecorator<? extends Message>> messageContainer, List<Message> decodedMessages) throws DecoderException {
        buffer.mark();
        while (buffer.hasRemaining()) {
            try {
                if (IS_DEBUG) {
                    LOG.debug("Decoding the PDU : ");
                    int size = buffer.limit();
                    int position = buffer.position();
                    int pduLength = size - position;
                    byte[] array = new byte[pduLength];
                    System.arraycopy(buffer.array(), position, array, 0, pduLength);
                    buffer.position(size);
                    if (array.length == 0) {
                        LOG.debug("NULL buffer, what the HELL ???");
                    } else {
                        LOG.debug(Strings.dumpBytes(array));
                    }
                    buffer.reset();
                }
                this.asn1Decoder.decode(buffer, messageContainer);
                if (messageContainer.getState() != TLVStateEnum.PDU_DECODED) continue;
                if (IS_DEBUG) {
                    LOG.debug("Decoded LdapMessage : " + messageContainer.getMessage());
                }
                MessageDecorator<? extends Message> message = messageContainer.getMessage();
                decodedMessages.add(message);
                messageContainer.clean();
            }
            catch (DecoderException de) {
                buffer.clear();
                messageContainer.clean();
                if (de instanceof ResponseCarryingException) {
                    ResponseCarryingMessageException rcme = new ResponseCarryingMessageException(de.getMessage());
                    rcme.setResponse(((ResponseCarryingException)de).getResponse());
                    throw rcme;
                }
                throw new ResponseCarryingException(de.getMessage());
            }
        }
    }
}

