/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.ForwardIndexEntry;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.impl.LessEqEvaluator;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.filter.LeafNode;
import org.apache.directory.shared.ldap.model.filter.SimpleNode;
import org.apache.directory.shared.ldap.model.schema.AttributeType;

public class LessEqCursor<V, ID extends Comparable<ID>>
extends AbstractIndexCursor<V, Entry, ID> {
    private static final String UNSUPPORTED_MSG = I18n.err(I18n.ERR_716, new Object[0]);
    private final LessEqEvaluator<V, ID> lessEqEvaluator;
    private final IndexCursor<V, Entry, ID> userIdxCursor;
    private final IndexCursor<V, Entry, ID> uuidIdxCursor;
    IndexEntry<V, ID> ndnCandidate;

    public LessEqCursor(Store<Entry, ID> db, LessEqEvaluator<V, ID> lessEqEvaluator) throws Exception {
        this.lessEqEvaluator = lessEqEvaluator;
        AttributeType attributeType = ((LeafNode)lessEqEvaluator.getExpression()).getAttributeType();
        if (db.hasIndexOn(attributeType)) {
            this.userIdxCursor = db.getIndex(attributeType).forwardCursor();
            this.uuidIdxCursor = null;
        } else {
            this.uuidIdxCursor = db.getEntryUuidIndex().forwardCursor();
            this.userIdxCursor = null;
        }
    }

    @Override
    protected String getUnsupportedMessage() {
        return UNSUPPORTED_MSG;
    }

    @Override
    public void beforeValue(ID id, V value) throws Exception {
        this.checkNotClosed("beforeValue()");
        if (this.userIdxCursor != null) {
            int compareValue = this.lessEqEvaluator.getComparator().compare(value, ((SimpleNode)this.lessEqEvaluator.getExpression()).getValue().getValue());
            if (compareValue > 0) {
                this.afterLast();
                return;
            }
            if (compareValue == 0) {
                this.last();
                this.previous();
                this.setAvailable(false);
                return;
            }
            this.userIdxCursor.beforeValue(id, value);
            this.setAvailable(false);
        } else {
            super.beforeValue(id, value);
        }
    }

    @Override
    public void before(IndexEntry<V, ID> element) throws Exception {
        this.checkNotClosed("before()");
        if (this.userIdxCursor != null) {
            int compareValue = this.lessEqEvaluator.getComparator().compare(element.getValue(), ((SimpleNode)this.lessEqEvaluator.getExpression()).getValue().getValue());
            if (compareValue > 0) {
                this.afterLast();
                return;
            }
            if (compareValue == 0) {
                this.last();
                this.previous();
                this.setAvailable(false);
                return;
            }
            this.userIdxCursor.before((Entry)((Object)element));
            this.setAvailable(false);
        } else {
            super.before(element);
        }
    }

    @Override
    public void afterValue(ID id, V value) throws Exception {
        this.checkNotClosed("afterValue()");
        if (this.userIdxCursor != null) {
            int comparedValue = this.lessEqEvaluator.getComparator().compare(value, ((SimpleNode)this.lessEqEvaluator.getExpression()).getValue().getValue());
            if (comparedValue >= 0) {
                this.afterLast();
                return;
            }
            this.userIdxCursor.afterValue(id, value);
            this.setAvailable(false);
        } else {
            super.afterValue(id, value);
        }
    }

    @Override
    public void after(IndexEntry<V, ID> element) throws Exception {
        this.checkNotClosed("after()");
        if (this.userIdxCursor != null) {
            int comparedValue = this.lessEqEvaluator.getComparator().compare(element.getValue(), ((SimpleNode)this.lessEqEvaluator.getExpression()).getValue().getValue());
            if (comparedValue >= 0) {
                this.afterLast();
                return;
            }
            this.userIdxCursor.after((Entry)((Object)element));
            this.setAvailable(false);
        } else {
            super.after(element);
        }
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.beforeFirst();
        } else {
            this.uuidIdxCursor.beforeFirst();
            this.ndnCandidate = null;
        }
        this.setAvailable(false);
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        if (this.userIdxCursor != null) {
            ForwardIndexEntry advanceTo = new ForwardIndexEntry();
            advanceTo.setValue(((SimpleNode)this.lessEqEvaluator.getExpression()).getValue().getValue());
            this.userIdxCursor.after((Entry)((Object)advanceTo));
        } else {
            this.uuidIdxCursor.afterLast();
            this.ndnCandidate = null;
        }
        this.setAvailable(false);
    }

    @Override
    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    @Override
    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        if (this.userIdxCursor != null) {
            return this.setAvailable(this.userIdxCursor.previous());
        }
        while (this.uuidIdxCursor.previous()) {
            this.checkNotClosed("previous()");
            this.ndnCandidate = (IndexEntry)this.uuidIdxCursor.get();
            if (this.lessEqEvaluator.evaluate(this.ndnCandidate)) {
                return this.setAvailable(true);
            }
            this.ndnCandidate = null;
        }
        return this.setAvailable(false);
    }

    @Override
    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        if (this.userIdxCursor != null) {
            while (this.userIdxCursor.next()) {
                this.checkNotClosed("next()");
                IndexEntry candidate = (IndexEntry)this.userIdxCursor.get();
                if (this.lessEqEvaluator.getComparator().compare(candidate.getValue(), ((SimpleNode)this.lessEqEvaluator.getExpression()).getValue().getValue()) > 0) continue;
                return this.setAvailable(true);
            }
            return this.setAvailable(false);
        }
        while (this.uuidIdxCursor.next()) {
            this.checkNotClosed("next()");
            this.ndnCandidate = (IndexEntry)this.uuidIdxCursor.get();
            if (this.lessEqEvaluator.evaluate(this.ndnCandidate)) {
                return this.setAvailable(true);
            }
            this.ndnCandidate = null;
        }
        return this.setAvailable(false);
    }

    @Override
    public IndexEntry<V, ID> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.userIdxCursor != null) {
            if (this.available()) {
                return (IndexEntry)this.userIdxCursor.get();
            }
            throw new InvalidCursorPositionException(I18n.err(I18n.ERR_708, new Object[0]));
        }
        if (this.available()) {
            return this.ndnCandidate;
        }
        throw new InvalidCursorPositionException(I18n.err(I18n.ERR_708, new Object[0]));
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.userIdxCursor != null) {
            this.userIdxCursor.close();
        } else {
            this.uuidIdxCursor.close();
            this.ndnCandidate = null;
        }
    }
}

