/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.trigger;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.DefaultCoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapOperationException;
import org.apache.directory.shared.ldap.model.filter.EqualityNode;
import org.apache.directory.shared.ldap.model.message.AliasDerefMode;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.NormalizerMappingResolver;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.normalizers.OidNormalizer;
import org.apache.directory.shared.ldap.trigger.TriggerSpecification;
import org.apache.directory.shared.ldap.trigger.TriggerSpecificationParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerSpecCache {
    private static final String PRESCRIPTIVE_TRIGGER_ATTR = "prescriptiveTriggerSpecification";
    private static final Logger LOG = LoggerFactory.getLogger(TriggerSpecCache.class);
    private final Map<String, List<TriggerSpecification>> triggerSpecs = new HashMap<String, List<TriggerSpecification>>();
    private final PartitionNexus nexus;
    private final TriggerSpecificationParser triggerSpecParser;

    public TriggerSpecCache(DirectoryService directoryService) throws LdapException {
        this.nexus = directoryService.getPartitionNexus();
        final SchemaManager schemaManager = directoryService.getSchemaManager();
        this.triggerSpecParser = new TriggerSpecificationParser(new NormalizerMappingResolver(){

            public Map<String, OidNormalizer> getNormalizerMapping() throws Exception {
                return schemaManager.getNormalizerMapping();
            }
        });
        this.initialize(directoryService);
    }

    private void initialize(DirectoryService directoryService) throws LdapException {
        Set<String> suffixes = this.nexus.listSuffixes();
        AttributeType objectClassAt = directoryService.getSchemaManager().getAttributeType("objectClass");
        for (String suffix : suffixes) {
            Dn baseDn = directoryService.getDnFactory().create(suffix);
            EqualityNode<String> filter = new EqualityNode<String>(objectClassAt, new StringValue("triggerExecutionSubentry"));
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            Dn adminDn = directoryService.getDnFactory().create("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            DefaultCoreSession adminSession = new DefaultCoreSession(new LdapPrincipal(directoryService.getSchemaManager(), adminDn, AuthenticationLevel.STRONG), directoryService);
            SearchOperationContext searchOperationContext = new SearchOperationContext(adminSession, baseDn, filter, ctls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            EntryFilteringCursor results = this.nexus.search(searchOperationContext);
            try {
                while (results.next()) {
                    Entry resultEntry = (Entry)results.get();
                    Dn subentryDn = resultEntry.getDn();
                    Attribute triggerSpec = resultEntry.get(PRESCRIPTIVE_TRIGGER_ATTR);
                    if (triggerSpec == null) {
                        LOG.warn("Found triggerExecutionSubentry '" + subentryDn + "' without any " + PRESCRIPTIVE_TRIGGER_ATTR);
                        continue;
                    }
                    Dn normSubentryName = subentryDn.apply(directoryService.getSchemaManager());
                    this.subentryAdded(normSubentryName, resultEntry);
                }
                results.close();
            }
            catch (Exception e) {
                throw new LdapOperationException(e.getMessage(), e);
            }
        }
    }

    private boolean hasPrescriptiveTrigger(Entry entry) throws LdapException {
        Attribute triggerSpec = entry.get(PRESCRIPTIVE_TRIGGER_ATTR);
        return triggerSpec != null;
    }

    public void subentryAdded(Dn normName, Entry entry) throws LdapException {
        Attribute triggerSpec = entry.get(PRESCRIPTIVE_TRIGGER_ATTR);
        if (triggerSpec == null) {
            return;
        }
        ArrayList<TriggerSpecification> subentryTriggerSpecs = new ArrayList<TriggerSpecification>();
        for (Value value : triggerSpec) {
            TriggerSpecification item = null;
            try {
                item = this.triggerSpecParser.parse(value.getString());
                subentryTriggerSpecs.add(item);
            }
            catch (ParseException e) {
                String msg = I18n.err(I18n.ERR_73, item);
                LOG.error(msg, e);
            }
        }
        this.triggerSpecs.put(normName.getNormName(), subentryTriggerSpecs);
    }

    public void subentryDeleted(Dn normName, Entry entry) throws LdapException {
        if (!this.hasPrescriptiveTrigger(entry)) {
            return;
        }
        this.triggerSpecs.remove(normName.toString());
    }

    public void subentryModified(ModifyOperationContext opContext, Entry entry) throws LdapException {
        if (!this.hasPrescriptiveTrigger(entry)) {
            return;
        }
        Dn normName = opContext.getDn();
        List<Modification> mods = opContext.getModItems();
        boolean isTriggerSpecModified = false;
        for (Modification mod : mods) {
            isTriggerSpecModified |= mod.getAttribute().contains(PRESCRIPTIVE_TRIGGER_ATTR);
        }
        if (isTriggerSpecModified) {
            this.subentryDeleted(normName, entry);
            this.subentryAdded(normName, entry);
        }
    }

    public List<TriggerSpecification> getSubentryTriggerSpecs(String subentryDn) {
        List<TriggerSpecification> subentryTriggerSpecs = this.triggerSpecs.get(subentryDn);
        if (subentryTriggerSpecs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(subentryTriggerSpecs);
    }

    public void subentryRenamed(Dn oldName, Dn newName) {
        this.triggerSpecs.put(newName.getNormName(), this.triggerSpecs.remove(oldName.getNormName()));
    }
}

