/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DefaultCoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.admin.AdministrativePointInterceptor;
import org.apache.directory.server.core.authn.AnonymousAuthenticator;
import org.apache.directory.server.core.authn.Authenticator;
import org.apache.directory.server.core.authn.PasswordHistory;
import org.apache.directory.server.core.authn.PasswordUtil;
import org.apache.directory.server.core.authn.SimpleAuthenticator;
import org.apache.directory.server.core.authn.StrongAuthenticator;
import org.apache.directory.server.core.authn.ppolicy.PasswordPolicyConfiguration;
import org.apache.directory.server.core.authn.ppolicy.PasswordPolicyException;
import org.apache.directory.server.core.authn.ppolicy.PpolicyConfigContainer;
import org.apache.directory.server.core.authz.AciAuthorizationInterceptor;
import org.apache.directory.server.core.authz.DefaultAuthorizationInterceptor;
import org.apache.directory.server.core.collective.CollectiveAttributeInterceptor;
import org.apache.directory.server.core.event.EventInterceptor;
import org.apache.directory.server.core.exception.ExceptionInterceptor;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetRootDSEOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.normalization.NormalizationInterceptor;
import org.apache.directory.server.core.operational.OperationalAttributeInterceptor;
import org.apache.directory.server.core.schema.SchemaInterceptor;
import org.apache.directory.server.core.subtree.SubentryInterceptor;
import org.apache.directory.server.core.trigger.TriggerInterceptor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.extras.controls.ppolicy.PasswordPolicyDecorator;
import org.apache.directory.shared.ldap.extras.controls.ppolicy.PasswordPolicyErrorEnum;
import org.apache.directory.shared.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.model.constants.LdapSecurityConstants;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.BinaryValue;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.entry.DefaultModification;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.ModificationOperation;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.model.exception.LdapOperationException;
import org.apache.directory.shared.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.util.DateUtils;
import org.apache.directory.shared.util.StringConstants;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationInterceptor.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private Set<Authenticator> authenticators = new HashSet<Authenticator>();
    private final Map<AuthenticationLevel, Collection<Authenticator>> authenticatorsMapByType = new HashMap<AuthenticationLevel, Collection<Authenticator>>();
    private CoreSession adminSession;
    private Set<Dn> pwdResetSet = new HashSet<Dn>();
    private AttributeType AT_PWD_RESET;
    private AttributeType AT_PWD_CHANGED_TIME;
    private AttributeType AT_PWD_HISTORY;
    private AttributeType AT_PWD_FAILURE_TIME;
    private AttributeType AT_PWD_ACCOUNT_LOCKED_TIME;
    private AttributeType AT_PWD_LAST_SUCCESS;
    private AttributeType AT_PWD_GRACE_USE_TIME;
    private PpolicyConfigContainer pwdPolicyContainer;
    private AttributeType pwdPolicySubentryAT;
    private static final Collection<String> BYPASS_INTERCEPTORS;

    @Override
    public void init(DirectoryService directoryService) throws LdapException {
        super.init(directoryService);
        this.adminSession = directoryService.getAdminSession();
        this.pwdPolicySubentryAT = this.schemaManager.lookupAttributeTypeRegistry("pwdPolicySubentry");
        if (this.authenticators == null || this.authenticators.size() == 0) {
            this.setDefaultAuthenticators();
        }
        for (Authenticator authenticator : this.authenticators) {
            this.register(authenticator, directoryService);
        }
        this.loadPwdPolicyStateAtributeTypes();
    }

    private void setDefaultAuthenticators() {
        if (this.authenticators == null) {
            this.authenticators = new HashSet<Authenticator>();
        }
        this.authenticators.clear();
        this.authenticators.add(new AnonymousAuthenticator());
        this.authenticators.add(new SimpleAuthenticator());
        this.authenticators.add(new StrongAuthenticator());
    }

    public Set<Authenticator> getAuthenticators() {
        return this.authenticators;
    }

    public void setAuthenticators(Set<Authenticator> authenticators) {
        if (authenticators == null) {
            this.authenticators.clear();
        } else {
            this.authenticators = authenticators;
        }
    }

    public void setAuthenticators(Authenticator[] authenticators) {
        if (authenticators == null) {
            throw new IllegalArgumentException("The given authenticators set is null");
        }
        this.authenticators.clear();
        for (Authenticator authenticator : authenticators) {
            this.authenticators.add(authenticator);
        }
    }

    @Override
    public void destroy() {
        this.authenticatorsMapByType.clear();
        HashSet<Authenticator> copy = new HashSet<Authenticator>(this.authenticators);
        this.authenticators = null;
        for (Authenticator authenticator : copy) {
            authenticator.destroy();
        }
    }

    private void register(Authenticator authenticator, DirectoryService directoryService) throws LdapException {
        authenticator.init(directoryService);
        Collection<Authenticator> authenticatorList = this.getAuthenticators(authenticator.getAuthenticatorType());
        if (authenticatorList == null) {
            authenticatorList = new ArrayList<Authenticator>();
            this.authenticatorsMapByType.put(authenticator.getAuthenticatorType(), authenticatorList);
        }
        authenticatorList.add(authenticator);
    }

    private Collection<Authenticator> getAuthenticators(AuthenticationLevel type) {
        Collection<Authenticator> result = this.authenticatorsMapByType.get((Object)type);
        if (result != null && result.size() > 0) {
            return result;
        }
        return null;
    }

    @Override
    public void add(NextInterceptor next, AddOperationContext addContext) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", addContext);
        }
        this.checkAuthenticated(addContext);
        Entry entry = addContext.getEntry();
        if (!this.directoryService.isPwdPolicyEnabled()) {
            next.add(addContext);
            return;
        }
        PasswordPolicyConfiguration policyConfig = this.getPwdPolicy(entry);
        boolean isPPolicyReqCtrlPresent = addContext.hasRequestControl("1.3.6.1.4.1.42.2.27.8.5.1");
        this.checkPwdReset(addContext);
        if (entry.get("userPassword") != null) {
            String username = null;
            BinaryValue userPassword = (BinaryValue)entry.get("userPassword").get();
            try {
                username = entry.getDn().getRdn().getUpValue().getString();
                this.check(username, userPassword.getValue(), policyConfig);
            }
            catch (PasswordPolicyException e) {
                if (isPPolicyReqCtrlPresent) {
                    PasswordPolicyDecorator responseControl = new PasswordPolicyDecorator(this.directoryService.getLdapCodecService(), true);
                    responseControl.getResponse().setPasswordPolicyError(PasswordPolicyErrorEnum.get(e.getErrorCode()));
                    addContext.addResponseControl(responseControl);
                }
                throw new LdapOperationException(ResultCodeEnum.CONSTRAINT_VIOLATION, e.getMessage(), e);
            }
            String pwdChangedTime = DateUtils.getGeneralizedTime();
            if (policyConfig.getPwdMinAge() > 0 || policyConfig.getPwdMaxAge() > 0) {
                DefaultAttribute pwdChangedTimeAt = new DefaultAttribute(this.AT_PWD_CHANGED_TIME);
                pwdChangedTimeAt.add(pwdChangedTime);
                entry.add(pwdChangedTimeAt);
            }
            if (policyConfig.isPwdMustChange() && addContext.getSession().isAnAdministrator()) {
                DefaultAttribute pwdResetAt = new DefaultAttribute(this.AT_PWD_RESET);
                pwdResetAt.add("TRUE");
                entry.add(pwdResetAt);
            }
            if (policyConfig.getPwdInHistory() > 0) {
                DefaultAttribute pwdHistoryAt = new DefaultAttribute(this.AT_PWD_HISTORY);
                byte[] pwdHistoryVal = new PasswordHistory(pwdChangedTime, userPassword.getValue()).getHistoryValue();
                pwdHistoryAt.add(new byte[][]{pwdHistoryVal});
                entry.add(pwdHistoryAt);
            }
        }
        next.add(addContext);
    }

    @Override
    public void delete(NextInterceptor next, DeleteOperationContext deleteContext) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", deleteContext);
        }
        this.checkAuthenticated(deleteContext);
        this.checkPwdReset(deleteContext);
        next.delete(deleteContext);
        this.invalidateAuthenticatorCaches(deleteContext.getDn());
    }

    @Override
    public Entry getRootDSE(NextInterceptor next, GetRootDSEOperationContext getRootDseContext) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", getRootDseContext);
        }
        this.checkAuthenticated(getRootDseContext);
        this.checkPwdReset(getRootDseContext);
        return next.getRootDSE(getRootDseContext);
    }

    @Override
    public boolean hasEntry(NextInterceptor next, EntryOperationContext hasEntryContext) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", hasEntryContext);
        }
        this.checkAuthenticated(hasEntryContext);
        this.checkPwdReset(hasEntryContext);
        return next.hasEntry(hasEntryContext);
    }

    @Override
    public EntryFilteringCursor list(NextInterceptor next, ListOperationContext listContext) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", listContext);
        }
        this.checkAuthenticated(listContext);
        this.checkPwdReset(listContext);
        return next.list(listContext);
    }

    @Override
    public Entry lookup(NextInterceptor next, LookupOperationContext lookupContext) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", lookupContext);
        }
        this.checkAuthenticated(lookupContext);
        this.checkPwdReset(lookupContext);
        return next.lookup(lookupContext);
    }

    private void invalidateAuthenticatorCaches(Dn principalDn) {
        for (AuthenticationLevel authMech : this.authenticatorsMapByType.keySet()) {
            Collection<Authenticator> authenticators = this.getAuthenticators(authMech);
            for (Authenticator authenticator : authenticators) {
                authenticator.invalidateCache(principalDn);
            }
        }
    }

    @Override
    public void modify(NextInterceptor next, ModifyOperationContext modifyContext) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", modifyContext);
        }
        this.checkAuthenticated(modifyContext);
        if (!this.directoryService.isPwdPolicyEnabled()) {
            next.modify(modifyContext);
            this.invalidateAuthenticatorCaches(modifyContext.getDn());
            return;
        }
        PasswordPolicyConfiguration policyConfig = this.getPwdPolicy(modifyContext.getOriginalEntry());
        boolean isPPolicyReqCtrlPresent = modifyContext.hasRequestControl("1.3.6.1.4.1.42.2.27.8.5.1");
        Dn userDn = modifyContext.getSession().getAuthenticatedPrincipal().getDn();
        PwdModDetailsHolder pwdModDetails = null;
        if (policyConfig.isPwdSafeModify() || this.pwdResetSet.contains(userDn) || policyConfig.getPwdMinAge() > 0) {
            pwdModDetails = this.getPwdModDetails(modifyContext, policyConfig);
        }
        if (pwdModDetails != null && pwdModDetails.isPwdModPresent()) {
            Attribute pwdGraceUseTimeAt;
            Attribute pwdFailureTimeAt;
            if (this.pwdResetSet.contains(userDn) && pwdModDetails.isOtherModExists()) {
                if (isPPolicyReqCtrlPresent) {
                    PasswordPolicyDecorator responseControl = new PasswordPolicyDecorator(this.directoryService.getLdapCodecService(), true);
                    responseControl.getResponse().setPasswordPolicyError(PasswordPolicyErrorEnum.CHANGE_AFTER_RESET);
                    modifyContext.addResponseControl(responseControl);
                }
                throw new LdapNoPermissionException();
            }
            if (policyConfig.isPwdSafeModify() && pwdModDetails.isAddOrReplace() && !pwdModDetails.isDelete()) {
                LOG.debug("trying to update password attribute without the supplying the old password");
                if (isPPolicyReqCtrlPresent) {
                    PasswordPolicyDecorator responseControl = new PasswordPolicyDecorator(this.directoryService.getLdapCodecService(), true);
                    responseControl.getResponse().setPasswordPolicyError(PasswordPolicyErrorEnum.MUST_SUPPLY_OLD_PASSWORD);
                    modifyContext.addResponseControl(responseControl);
                }
                throw new LdapNoPermissionException();
            }
            if (!policyConfig.isPwdAllowUserChange() && !modifyContext.getSession().isAnAdministrator()) {
                if (isPPolicyReqCtrlPresent) {
                    PasswordPolicyDecorator responseControl = new PasswordPolicyDecorator(this.directoryService.getLdapCodecService(), true);
                    responseControl.getResponse().setPasswordPolicyError(PasswordPolicyErrorEnum.PASSWORD_MOD_NOT_ALLOWED);
                    modifyContext.addResponseControl(responseControl);
                }
                throw new LdapNoPermissionException();
            }
            Entry entry = modifyContext.getEntry();
            if (this.isPwdTooYoung(entry, policyConfig)) {
                if (isPPolicyReqCtrlPresent) {
                    PasswordPolicyDecorator responseControl = new PasswordPolicyDecorator(this.directoryService.getLdapCodecService(), true);
                    responseControl.getResponse().setPasswordPolicyError(PasswordPolicyErrorEnum.PASSWORD_TOO_YOUNG);
                    modifyContext.addResponseControl(responseControl);
                }
                throw new LdapOperationException(ResultCodeEnum.CONSTRAINT_VIOLATION, "password is too young to update");
            }
            byte[] newPassword = null;
            if (pwdModDetails != null) {
                newPassword = pwdModDetails.getNewPwd();
                try {
                    String userName = entry.getDn().getRdn().getUpValue().getString();
                    this.check(userName, newPassword, policyConfig);
                }
                catch (PasswordPolicyException e) {
                    if (isPPolicyReqCtrlPresent) {
                        PasswordPolicyDecorator responseControl = new PasswordPolicyDecorator(this.directoryService.getLdapCodecService(), true);
                        responseControl.getResponse().setPasswordPolicyError(PasswordPolicyErrorEnum.get(e.getErrorCode()));
                        modifyContext.addResponseControl(responseControl);
                    }
                    throw new LdapOperationException(ResultCodeEnum.CONSTRAINT_VIOLATION, e.getMessage(), e);
                }
            }
            int histSize = policyConfig.getPwdInHistory();
            DefaultModification pwdRemHistMod = null;
            DefaultModification pwdAddHistMod = null;
            String pwdChangedTime = DateUtils.getGeneralizedTime();
            if (histSize > 0) {
                Attribute pwdHistoryAt = entry.get("pwdHistory");
                TreeSet<PasswordHistory> pwdHistSet = new TreeSet<PasswordHistory>();
                for (Value value : pwdHistoryAt) {
                    PasswordHistory pwdh = new PasswordHistory(Strings.utf8ToString(value.getBytes()));
                    boolean matched = Arrays.equals(newPassword, pwdh.getPassword());
                    if (matched) {
                        if (isPPolicyReqCtrlPresent) {
                            PasswordPolicyDecorator responseControl = new PasswordPolicyDecorator(this.directoryService.getLdapCodecService(), true);
                            responseControl.getResponse().setPasswordPolicyError(PasswordPolicyErrorEnum.PASSWORD_IN_HISTORY);
                            modifyContext.addResponseControl(responseControl);
                        }
                        throw new LdapOperationException(ResultCodeEnum.CONSTRAINT_VIOLATION, "invalid reuse of password present in password history");
                    }
                    pwdHistSet.add(pwdh);
                }
                PasswordHistory newPwdHist = new PasswordHistory(pwdChangedTime, newPassword);
                pwdHistSet.add(newPwdHist);
                pwdHistoryAt = new DefaultAttribute(pwdHistoryAt.getAttributeType());
                pwdHistoryAt.add(new byte[][]{newPwdHist.getHistoryValue()});
                pwdAddHistMod = new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, pwdHistoryAt);
                if (pwdHistSet.size() > histSize) {
                    pwdHistoryAt = new DefaultAttribute(pwdHistoryAt.getAttributeType());
                    PasswordHistory remPwdHist = (PasswordHistory)pwdHistSet.toArray()[histSize - 1];
                    pwdHistoryAt.add(new byte[][]{remPwdHist.getHistoryValue()});
                    pwdRemHistMod = new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, pwdHistoryAt);
                }
            }
            next.modify(modifyContext);
            this.invalidateAuthenticatorCaches(modifyContext.getDn());
            ArrayList<Modification> mods = new ArrayList<Modification>();
            if (policyConfig.getPwdMinAge() > 0 || policyConfig.getPwdMaxAge() > 0) {
                DefaultAttribute pwdChangedTimeAt = new DefaultAttribute(this.AT_PWD_CHANGED_TIME);
                pwdChangedTimeAt.add(pwdChangedTime);
                DefaultModification pwdChangedTimeMod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, pwdChangedTimeAt);
                mods.add(pwdChangedTimeMod);
            }
            if (pwdAddHistMod != null) {
                mods.add(pwdAddHistMod);
            }
            if (pwdRemHistMod != null) {
                mods.add(pwdRemHistMod);
            }
            boolean removeFromPwdResetSet = false;
            if (policyConfig.isPwdMustChange()) {
                DefaultAttribute pwdMustChangeAt = new DefaultAttribute(this.AT_PWD_RESET);
                DefaultModification pwdMustChangeMod = null;
                if (modifyContext.getSession().isAnAdministrator()) {
                    pwdMustChangeAt.add("TRUE");
                    pwdMustChangeMod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, pwdMustChangeAt);
                } else {
                    pwdMustChangeMod = new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, pwdMustChangeAt);
                    removeFromPwdResetSet = true;
                }
                mods.add(pwdMustChangeMod);
            }
            if ((pwdFailureTimeAt = entry.get("pwdFailureTime")) != null) {
                mods.add(new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, pwdFailureTimeAt));
            }
            if ((pwdGraceUseTimeAt = entry.get("pwdGraceUseTime")) != null) {
                mods.add(new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, pwdGraceUseTimeAt));
            }
            this.directoryService.getAdminSession().modify(modifyContext.getDn(), mods);
            if (removeFromPwdResetSet) {
                this.pwdResetSet.remove(userDn);
            }
        } else {
            next.modify(modifyContext);
            this.invalidateAuthenticatorCaches(modifyContext.getDn());
        }
    }

    @Override
    public void rename(NextInterceptor next, RenameOperationContext renameContext) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", renameContext);
        }
        this.checkAuthenticated(renameContext);
        this.checkPwdReset(renameContext);
        next.rename(renameContext);
        this.invalidateAuthenticatorCaches(renameContext.getDn());
    }

    @Override
    public boolean compare(NextInterceptor next, CompareOperationContext compareContext) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", compareContext);
        }
        this.checkAuthenticated(compareContext);
        this.checkPwdReset(compareContext);
        boolean result = next.compare(compareContext);
        this.invalidateAuthenticatorCaches(compareContext.getDn());
        return result;
    }

    @Override
    public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", moveAndRenameContext);
        }
        this.checkAuthenticated(moveAndRenameContext);
        this.checkPwdReset(moveAndRenameContext);
        next.moveAndRename(moveAndRenameContext);
        this.invalidateAuthenticatorCaches(moveAndRenameContext.getDn());
    }

    @Override
    public void move(NextInterceptor next, MoveOperationContext moveContext) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", moveContext);
        }
        this.checkAuthenticated(moveContext);
        this.checkPwdReset(moveContext);
        next.move(moveContext);
        this.invalidateAuthenticatorCaches(moveContext.getDn());
    }

    @Override
    public EntryFilteringCursor search(NextInterceptor next, SearchOperationContext searchContext) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", searchContext);
        }
        this.checkAuthenticated(searchContext);
        this.checkPwdReset(searchContext);
        return next.search(searchContext);
    }

    private void checkAuthenticated(OperationContext operation) throws LdapException {
        if (operation.getSession().isAnonymous() && !this.directoryService.isAllowAnonymousAccess() && !operation.getDn().isEmpty()) {
            String msg = I18n.err(I18n.ERR_5, operation.getName());
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
    }

    @Override
    public void bind(NextInterceptor next, BindOperationContext bindContext) throws LdapException {
        AuthenticationLevel level;
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", bindContext);
        }
        if (bindContext.getSession() != null && bindContext.getSession().getEffectivePrincipal() != null) {
            bindContext.setCredentials(null);
        }
        if ((level = bindContext.getAuthenticationLevel()) == AuthenticationLevel.UNAUTHENT) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, "Cannot Bind for Dn " + bindContext.getDn().getName());
        }
        Collection<Authenticator> authenticators = this.getAuthenticators(level);
        if (authenticators == null) {
            LOG.debug("No authenticators found, delegating bind to the nexus.");
            next.bind(bindContext);
            LOG.debug("Nexus succeeded on bind operation.");
            LdapPrincipal principal = new LdapPrincipal(this.schemaManager, bindContext.getDn(), AuthenticationLevel.SIMPLE);
            DefaultCoreSession session = new DefaultCoreSession(principal, this.directoryService);
            bindContext.setSession(session);
            bindContext.setCredentials(null);
            return;
        }
        boolean isPPolicyReqCtrlPresent = bindContext.hasRequestControl("1.3.6.1.4.1.42.2.27.8.5.1");
        PasswordPolicyDecorator pwdRespCtrl = new PasswordPolicyDecorator(this.directoryService.getLdapCodecService(), true);
        boolean authenticated = false;
        PasswordPolicyException ppe = null;
        for (Authenticator authenticator : authenticators) {
            try {
                LdapPrincipal principal = authenticator.authenticate(bindContext);
                LdapPrincipal clonedPrincipal = (LdapPrincipal)principal.clone();
                bindContext.setCredentials(null);
                clonedPrincipal.setUserPassword(StringConstants.EMPTY_BYTES);
                DefaultCoreSession session = new DefaultCoreSession(clonedPrincipal, this.directoryService);
                bindContext.setSession(session);
                authenticated = true;
                break;
            }
            catch (PasswordPolicyException e) {
                ppe = e;
                break;
            }
            catch (LdapAuthenticationException e) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info("Authenticator {} failed to authenticate: {}", authenticator, (Object)bindContext);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.info("Unexpected failure for Authenticator {} : {}", authenticator, (Object)bindContext);
            }
        }
        if (ppe != null) {
            if (isPPolicyReqCtrlPresent) {
                pwdRespCtrl.getResponse().setPasswordPolicyError(PasswordPolicyErrorEnum.get(ppe.getErrorCode()));
                bindContext.addResponseControl(pwdRespCtrl);
            }
            throw ppe;
        }
        Dn dn = bindContext.getDn();
        Entry userEntry = bindContext.getEntry();
        PasswordPolicyConfiguration policyConfig = this.getPwdPolicy(userEntry);
        if (authenticated && userEntry == null && this.directoryService.isAllowAnonymousAccess()) {
            return;
        }
        if (!authenticated) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Cannot bind to the server ");
            }
            if (policyConfig != null && userEntry != null) {
                Attribute pwdFailTimeAt = userEntry.get("pwdFailureTime");
                if (pwdFailTimeAt == null) {
                    pwdFailTimeAt = new DefaultAttribute(this.AT_PWD_FAILURE_TIME);
                } else {
                    PasswordUtil.purgeFailureTimes(policyConfig, pwdFailTimeAt);
                }
                String failureTime = DateUtils.getGeneralizedTime();
                pwdFailTimeAt.add(failureTime);
                DefaultModification pwdFailTimeMod = new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, pwdFailTimeAt);
                ArrayList<Modification> mods = new ArrayList<Modification>();
                mods.add(pwdFailTimeMod);
                int numFailures = pwdFailTimeAt.size();
                if (policyConfig.isPwdLockout() && numFailures >= policyConfig.getPwdMaxFailure()) {
                    DefaultAttribute pwdAccountLockedTimeAt = new DefaultAttribute(this.AT_PWD_ACCOUNT_LOCKED_TIME);
                    if (policyConfig.getPwdLockoutDuration() == 0) {
                        pwdAccountLockedTimeAt.add("000001010000Z");
                    } else {
                        pwdAccountLockedTimeAt.add(failureTime);
                    }
                    DefaultModification pwdAccountLockedMod = new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, pwdAccountLockedTimeAt);
                    mods.add(pwdAccountLockedMod);
                    pwdRespCtrl.getResponse().setPasswordPolicyError(PasswordPolicyErrorEnum.ACCOUNT_LOCKED);
                } else if (policyConfig.getPwdMinDelay() > 0) {
                    int maxDelay;
                    int numDelay = numFailures * policyConfig.getPwdMinDelay();
                    if (numDelay > (maxDelay = policyConfig.getPwdMaxDelay())) {
                        numDelay = maxDelay;
                    }
                    try {
                        Thread.sleep(numDelay * 1000);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Interrupted while delaying to send the failed authentication response for the user {}", dn, (Object)e);
                    }
                }
                ModifyOperationContext bindModCtx = new ModifyOperationContext(this.adminSession);
                bindModCtx.setByPassed(BYPASS_INTERCEPTORS);
                bindModCtx.setDn(dn);
                bindModCtx.setModItems(mods);
                this.directoryService.getOperationManager().modify(bindModCtx);
            }
            String upDn = dn == null ? "" : dn.getName();
            throw new LdapAuthenticationException(I18n.err(I18n.ERR_229, upDn));
        }
        if (policyConfig != null) {
            boolean expired;
            Attribute pwdChangeTimeAttr;
            Attribute pwdAccLockedTimeAt;
            Attribute pwdFailTimeAt;
            ArrayList<Modification> mods = new ArrayList<Modification>();
            if (policyConfig.getPwdMaxIdle() > 0) {
                DefaultAttribute pwdLastSuccesTimeAt = new DefaultAttribute(this.AT_PWD_LAST_SUCCESS);
                pwdLastSuccesTimeAt.add(DateUtils.getGeneralizedTime());
                DefaultModification pwdLastSuccesTimeMod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, pwdLastSuccesTimeAt);
                mods.add(pwdLastSuccesTimeMod);
            }
            if ((pwdFailTimeAt = userEntry.get(this.AT_PWD_FAILURE_TIME)) != null) {
                DefaultModification pwdFailTimeMod = new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, pwdFailTimeAt);
                mods.add(pwdFailTimeMod);
            }
            if ((pwdAccLockedTimeAt = userEntry.get(this.AT_PWD_ACCOUNT_LOCKED_TIME)) != null) {
                DefaultModification pwdAccLockedTimeMod = new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, pwdAccLockedTimeAt);
                mods.add(pwdAccLockedTimeMod);
            }
            if (policyConfig.getPwdMaxAge() > 0 && policyConfig.getPwdGraceAuthNLimit() > 0 && (pwdChangeTimeAttr = userEntry.get("pwdChangedTime")) != null && (expired = PasswordUtil.isPwdExpired(pwdChangeTimeAttr.getString(), policyConfig.getPwdMaxAge()))) {
                Attribute pwdGraceUseAttr = userEntry.get("pwdGraceUseTime");
                if (pwdGraceUseAttr != null) {
                    pwdRespCtrl.getResponse().setGraceAuthNsRemaining(policyConfig.getPwdGraceAuthNLimit() - (pwdGraceUseAttr.size() + 1));
                } else {
                    pwdGraceUseAttr = new DefaultAttribute(this.AT_PWD_GRACE_USE_TIME);
                }
                pwdGraceUseAttr.add(DateUtils.getGeneralizedTime());
                DefaultModification pwdGraceUseMod = new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, pwdGraceUseAttr);
                mods.add(pwdGraceUseMod);
            }
            if (!mods.isEmpty()) {
                ModifyOperationContext bindModCtx = new ModifyOperationContext(this.adminSession);
                bindModCtx.setByPassed(BYPASS_INTERCEPTORS);
                bindModCtx.setDn(dn);
                bindModCtx.setModItems(mods);
                this.directoryService.getOperationManager().modify(bindModCtx);
            }
            if (isPPolicyReqCtrlPresent) {
                int expiryWarnTime = this.getPwdTimeBeforeExpiry(userEntry, policyConfig);
                if (expiryWarnTime > 0) {
                    pwdRespCtrl.getResponse().setTimeBeforeExpiration(expiryWarnTime);
                }
                if (this.isPwdMustReset(userEntry)) {
                    pwdRespCtrl.getResponse().setPasswordPolicyError(PasswordPolicyErrorEnum.CHANGE_AFTER_RESET);
                    this.pwdResetSet.add(dn);
                }
                bindContext.addResponseControl(pwdRespCtrl);
            }
        }
    }

    @Override
    public void unbind(NextInterceptor next, UnbindOperationContext unbindContext) throws LdapException {
        super.unbind(next, unbindContext);
        if (!this.directoryService.isPwdPolicyEnabled()) {
            this.pwdResetSet.remove(unbindContext.getDn());
        }
    }

    public void loadPwdPolicyStateAtributeTypes() throws LdapException {
        if (this.directoryService.isPwdPolicyEnabled()) {
            this.AT_PWD_RESET = this.schemaManager.lookupAttributeTypeRegistry("pwdReset");
            PWD_POLICY_STATE_ATTRIBUTE_TYPES.add(this.AT_PWD_RESET);
            this.AT_PWD_CHANGED_TIME = this.schemaManager.lookupAttributeTypeRegistry("pwdChangedTime");
            PWD_POLICY_STATE_ATTRIBUTE_TYPES.add(this.AT_PWD_CHANGED_TIME);
            this.AT_PWD_HISTORY = this.schemaManager.lookupAttributeTypeRegistry("pwdHistory");
            PWD_POLICY_STATE_ATTRIBUTE_TYPES.add(this.AT_PWD_HISTORY);
            this.AT_PWD_FAILURE_TIME = this.schemaManager.lookupAttributeTypeRegistry("pwdFailureTime");
            PWD_POLICY_STATE_ATTRIBUTE_TYPES.add(this.AT_PWD_FAILURE_TIME);
            this.AT_PWD_ACCOUNT_LOCKED_TIME = this.schemaManager.lookupAttributeTypeRegistry("pwdAccountLockedTime");
            PWD_POLICY_STATE_ATTRIBUTE_TYPES.add(this.AT_PWD_ACCOUNT_LOCKED_TIME);
            this.AT_PWD_LAST_SUCCESS = this.schemaManager.lookupAttributeTypeRegistry("pwdLastSuccess");
            PWD_POLICY_STATE_ATTRIBUTE_TYPES.add(this.AT_PWD_LAST_SUCCESS);
            this.AT_PWD_GRACE_USE_TIME = this.schemaManager.lookupAttributeTypeRegistry("pwdGraceUseTime");
            PWD_POLICY_STATE_ATTRIBUTE_TYPES.add(this.AT_PWD_GRACE_USE_TIME);
        }
    }

    private void check(String username, byte[] password, PasswordPolicyConfiguration policyConfig) throws LdapException {
        int qualityVal = policyConfig.getPwdCheckQuality();
        if (qualityVal == 0) {
            return;
        }
        LdapSecurityConstants secConst = PasswordUtil.findAlgorithm(password);
        if (secConst != null) {
            if (qualityVal == 1) {
                return;
            }
            throw new PasswordPolicyException("cannot verify the quality of the non-cleartext passwords", PasswordPolicyErrorEnum.INSUFFICIENT_PASSWORD_QUALITY.getValue());
        }
        String strPassword = Strings.utf8ToString(password);
        this.validatePasswordLength(strPassword, policyConfig);
        policyConfig.getPwdValidator().validate(strPassword, username);
    }

    private void validatePasswordLength(String password, PasswordPolicyConfiguration policyConfig) throws PasswordPolicyException {
        int maxLen = policyConfig.getPwdMaxLength();
        int minLen = policyConfig.getPwdMinLength();
        int pwdLen = password.length();
        if (maxLen > 0 && pwdLen > maxLen) {
            throw new PasswordPolicyException("Password should not have more than " + maxLen + " characters", PasswordPolicyErrorEnum.INSUFFICIENT_PASSWORD_QUALITY.getValue());
        }
        if (minLen > 0 && pwdLen < minLen) {
            throw new PasswordPolicyException("Password should have a minmum of " + minLen + " characters", PasswordPolicyErrorEnum.PASSWORD_TOO_SHORT.getValue());
        }
    }

    private int getPwdTimeBeforeExpiry(Entry userEntry, PasswordPolicyConfiguration policyConfig) throws LdapException {
        if (policyConfig.getPwdMaxAge() == 0) {
            return 0;
        }
        Attribute pwdExpireWarningAt = userEntry.get("pwdExpireWarning");
        if (pwdExpireWarningAt == null) {
            return 0;
        }
        Attribute pwdChangedTimeAt = userEntry.get("pwdChangedTime");
        long changedTime = DateUtils.getDate(pwdChangedTimeAt.getString()).getTime();
        int pwdAge = (int)(System.currentTimeMillis() - changedTime) / 1000;
        if (pwdAge > policyConfig.getPwdMaxAge()) {
            return 0;
        }
        int warningAge = (int)DateUtils.getDate(pwdExpireWarningAt.getString()).getTime() / 1000;
        if (pwdAge >= warningAge) {
            return policyConfig.getPwdMaxAge() - pwdAge;
        }
        return 0;
    }

    private boolean isPwdTooYoung(Entry userEntry, PasswordPolicyConfiguration policyConfig) throws LdapException {
        if (policyConfig.getPwdMinAge() == 0) {
            return false;
        }
        Attribute pwdChangedTimeAt = userEntry.get("pwdChangedTime");
        long changedTime = DateUtils.getDate(pwdChangedTimeAt.getString()).getTime();
        return (changedTime += (long)(policyConfig.getPwdMinAge() * 1000)) > System.currentTimeMillis();
    }

    private boolean isPwdMustReset(Entry userEntry) throws LdapException {
        boolean mustChange = false;
        Attribute pwdResetAt = userEntry.get("pwdReset");
        if (pwdResetAt != null) {
            mustChange = Boolean.parseBoolean(pwdResetAt.getString());
        }
        return mustChange;
    }

    private PwdModDetailsHolder getPwdModDetails(ModifyOperationContext modifyContext, PasswordPolicyConfiguration policyConfig) throws LdapException {
        PwdModDetailsHolder pwdModDetails = new PwdModDetailsHolder();
        List<Modification> mods = modifyContext.getModItems();
        for (Modification m : mods) {
            Attribute at = m.getAttribute();
            if (at.getUpId().equalsIgnoreCase(policyConfig.getPwdAttribute())) {
                pwdModDetails.setPwdModPresent(true);
                ModificationOperation op = m.getOperation();
                if (op == ModificationOperation.REMOVE_ATTRIBUTE) {
                    pwdModDetails.setDelete(true);
                    continue;
                }
                if (op != ModificationOperation.REPLACE_ATTRIBUTE && op != ModificationOperation.ADD_ATTRIBUTE) continue;
                pwdModDetails.setAddOrReplace(true);
                pwdModDetails.setNewPwd(at.getBytes());
                continue;
            }
            pwdModDetails.setOtherModExists(true);
        }
        return pwdModDetails;
    }

    private void checkPwdReset(OperationContext opContext) throws LdapException {
        CoreSession session;
        Dn userDn;
        if (!this.directoryService.isPwdPolicyEnabled() && this.pwdResetSet.contains(userDn = (session = opContext.getSession()).getAuthenticatedPrincipal().getDn())) {
            boolean isPPolicyReqCtrlPresent = opContext.hasRequestControl("1.3.6.1.4.1.42.2.27.8.5.1");
            if (isPPolicyReqCtrlPresent) {
                PasswordPolicyDecorator pwdRespCtrl = new PasswordPolicyDecorator(this.directoryService.getLdapCodecService(), true);
                pwdRespCtrl.getResponse().setPasswordPolicyError(PasswordPolicyErrorEnum.CHANGE_AFTER_RESET);
                opContext.addResponseControl(pwdRespCtrl);
            }
            throw new LdapNoPermissionException("password needs to be reset before performing this operation");
        }
    }

    public PasswordPolicyConfiguration getPwdPolicy(Entry userEntry) throws LdapException {
        Attribute pwdPolicySubentry;
        if (this.pwdPolicyContainer == null) {
            return null;
        }
        if (this.pwdPolicyContainer.hasCustomConfigs() && (pwdPolicySubentry = userEntry.get(this.pwdPolicySubentryAT)) != null) {
            Dn configDn = this.adminSession.getDirectoryService().getDnFactory().create(pwdPolicySubentry.getString());
            return this.pwdPolicyContainer.getPolicyConfig(configDn);
        }
        return this.pwdPolicyContainer.getDefaultPolicy();
    }

    public void setPwdPolicies(PpolicyConfigContainer policyContainer) {
        this.pwdPolicyContainer = policyContainer;
    }

    public boolean isPwdPolicyEnabled() {
        return this.pwdPolicyContainer != null && (this.pwdPolicyContainer.getDefaultPolicy() != null || this.pwdPolicyContainer.hasCustomConfigs());
    }

    public PpolicyConfigContainer getPwdPolicyContainer() {
        return this.pwdPolicyContainer;
    }

    public void setPwdPolicyContainer(PpolicyConfigContainer pwdPolicyContainer) {
        this.pwdPolicyContainer = pwdPolicyContainer;
    }

    static {
        HashSet<String> c = new HashSet<String>();
        c.add(NormalizationInterceptor.class.getName());
        c.add(AuthenticationInterceptor.class.getName());
        c.add(AciAuthorizationInterceptor.class.getName());
        c.add(AdministrativePointInterceptor.class.getName());
        c.add(DefaultAuthorizationInterceptor.class.getName());
        c.add(AdministrativePointInterceptor.class.getName());
        c.add(ExceptionInterceptor.class.getName());
        c.add(OperationalAttributeInterceptor.class.getName());
        c.add(SchemaInterceptor.class.getName());
        c.add(CollectiveAttributeInterceptor.class.getName());
        c.add(SubentryInterceptor.class.getName());
        c.add(EventInterceptor.class.getName());
        c.add(TriggerInterceptor.class.getName());
        BYPASS_INTERCEPTORS = Collections.unmodifiableCollection(c);
    }

    private class PwdModDetailsHolder {
        private boolean pwdModPresent = false;
        private boolean isDelete = false;
        private boolean isAddOrReplace = false;
        private boolean otherModExists = false;
        private byte[] newPwd;

        private PwdModDetailsHolder() {
        }

        public boolean isPwdModPresent() {
            return this.pwdModPresent;
        }

        public void setPwdModPresent(boolean pwdModPresent) {
            this.pwdModPresent = pwdModPresent;
        }

        public boolean isDelete() {
            return this.isDelete;
        }

        public void setDelete(boolean isDelete) {
            this.isDelete = isDelete;
        }

        public boolean isAddOrReplace() {
            return this.isAddOrReplace;
        }

        public void setAddOrReplace(boolean isAddOrReplace) {
            this.isAddOrReplace = isAddOrReplace;
        }

        public boolean isOtherModExists() {
            return this.otherModExists;
        }

        public void setOtherModExists(boolean otherModExists) {
            this.otherModExists = otherModExists;
        }

        public byte[] getNewPwd() {
            return this.newPwd;
        }

        public void setNewPwd(byte[] newPwd) {
            this.newPwd = newPwd;
        }
    }
}

