/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.util.Strings;

public enum ReferralHandlingMode {
    THROW("throw"),
    FOLLOW("follow"),
    IGNORE("ignore"),
    THROW_FINDING_BASE("throw-finding-base");

    private final String jndiValue;

    private ReferralHandlingMode(String jndiValue) {
        this.jndiValue = jndiValue;
    }

    public String getJndiValue() {
        return this.jndiValue;
    }

    public static final ReferralHandlingMode getModeFromJndi(String jndiValue) {
        if ((jndiValue = Strings.toLowerCase(Strings.trim(jndiValue))).equals("throw")) {
            return THROW;
        }
        if (jndiValue.equals("follow")) {
            return FOLLOW;
        }
        if (jndiValue.equals("ignore")) {
            return IGNORE;
        }
        if (jndiValue.equals("throw-finding-base")) {
            return THROW_FINDING_BASE;
        }
        throw new IllegalArgumentException(I18n.err(I18n.ERR_437, jndiValue));
    }
}

