/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.util.LinkedList;
import org.apache.directory.mavibot.btree.AbstractBTree;
import org.apache.directory.mavibot.btree.AbstractPage;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BTreeTypeEnum;
import org.apache.directory.mavibot.btree.InMemoryBTree;
import org.apache.directory.mavibot.btree.InMemoryBTreeConfiguration;
import org.apache.directory.mavibot.btree.InMemoryLeaf;
import org.apache.directory.mavibot.btree.InMemoryNode;
import org.apache.directory.mavibot.btree.KeyHolder;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.PageHolder;
import org.apache.directory.mavibot.btree.ParentPos;
import org.apache.directory.mavibot.btree.PersistedBTree;
import org.apache.directory.mavibot.btree.PersistedBTreeConfiguration;
import org.apache.directory.mavibot.btree.PersistedKeyHolder;
import org.apache.directory.mavibot.btree.PersistedLeaf;
import org.apache.directory.mavibot.btree.PersistedNode;
import org.apache.directory.mavibot.btree.PersistedPageHolder;
import org.apache.directory.mavibot.btree.RecordManager;
import org.apache.directory.mavibot.btree.ValueHolder;
import org.apache.directory.mavibot.btree.serializer.ElementSerializer;

public class BTreeFactory<K, V> {
    public static <K, V> BTree<K, V> createPersistedBTree() {
        PersistedBTree btree = new PersistedBTree();
        return btree;
    }

    public static <K, V> BTree<K, V> createPersistedBTree(BTreeTypeEnum type) {
        PersistedBTree btree = new PersistedBTree();
        ((AbstractBTree)btree).setType(type);
        return btree;
    }

    public static <K, V> void setBtreeHeaderOffset(PersistedBTree<K, V> btree, long btreeHeaderOffset) {
        btree.setBtreeHeaderOffset(btreeHeaderOffset);
    }

    public static <K, V> BTree<K, V> createPersistedBTree(PersistedBTreeConfiguration<K, V> configuration) {
        PersistedBTree<K, V> btree = new PersistedBTree<K, V>(configuration);
        return btree;
    }

    public static <K, V> BTree<K, V> createPersistedBTree(String name, ElementSerializer<K> keySerializer, ElementSerializer<V> valueSerializer) {
        PersistedBTreeConfiguration<K, V> configuration = new PersistedBTreeConfiguration<K, V>();
        configuration.setName(name);
        configuration.setKeySerializer(keySerializer);
        configuration.setValueSerializer(valueSerializer);
        configuration.setPageSize(16);
        configuration.setAllowDuplicates(false);
        configuration.setCacheSize(1000);
        configuration.setWriteBufferSize(1024000);
        PersistedBTree btree = new PersistedBTree(configuration);
        return btree;
    }

    public static <K, V> BTree<K, V> createPersistedBTree(String name, ElementSerializer<K> keySerializer, ElementSerializer<V> valueSerializer, boolean allowDuplicates) {
        PersistedBTreeConfiguration<K, V> configuration = new PersistedBTreeConfiguration<K, V>();
        configuration.setName(name);
        configuration.setKeySerializer(keySerializer);
        configuration.setValueSerializer(valueSerializer);
        configuration.setPageSize(16);
        configuration.setAllowDuplicates(allowDuplicates);
        configuration.setCacheSize(1000);
        configuration.setWriteBufferSize(1024000);
        PersistedBTree btree = new PersistedBTree(configuration);
        return btree;
    }

    public static <K, V> BTree<K, V> createPersistedBTree(String name, ElementSerializer<K> keySerializer, ElementSerializer<V> valueSerializer, boolean allowDuplicates, int cacheSize) {
        PersistedBTreeConfiguration<K, V> configuration = new PersistedBTreeConfiguration<K, V>();
        configuration.setName(name);
        configuration.setKeySerializer(keySerializer);
        configuration.setValueSerializer(valueSerializer);
        configuration.setPageSize(16);
        configuration.setAllowDuplicates(allowDuplicates);
        configuration.setCacheSize(cacheSize);
        configuration.setWriteBufferSize(1024000);
        PersistedBTree btree = new PersistedBTree(configuration);
        return btree;
    }

    public static <K, V> BTree<K, V> createPersistedBTree(String name, ElementSerializer<K> keySerializer, ElementSerializer<V> valueSerializer, int pageSize) {
        PersistedBTreeConfiguration<K, V> configuration = new PersistedBTreeConfiguration<K, V>();
        configuration.setName(name);
        configuration.setKeySerializer(keySerializer);
        configuration.setValueSerializer(valueSerializer);
        configuration.setPageSize(pageSize);
        configuration.setAllowDuplicates(false);
        configuration.setCacheSize(1000);
        configuration.setWriteBufferSize(1024000);
        PersistedBTree btree = new PersistedBTree(configuration);
        return btree;
    }

    public static <K, V> BTree<K, V> createPersistedBTree(String name, ElementSerializer<K> keySerializer, ElementSerializer<V> valueSerializer, int pageSize, boolean allowDuplicates) {
        PersistedBTreeConfiguration<K, V> configuration = new PersistedBTreeConfiguration<K, V>();
        configuration.setName(name);
        configuration.setKeySerializer(keySerializer);
        configuration.setValueSerializer(valueSerializer);
        configuration.setPageSize(pageSize);
        configuration.setAllowDuplicates(allowDuplicates);
        configuration.setCacheSize(1000);
        configuration.setWriteBufferSize(1024000);
        PersistedBTree btree = new PersistedBTree(configuration);
        return btree;
    }

    public static <K, V> BTree<K, V> createPersistedBTree(String name, ElementSerializer<K> keySerializer, ElementSerializer<V> valueSerializer, int pageSize, boolean allowDuplicates, int cacheSize) {
        PersistedBTreeConfiguration<K, V> configuration = new PersistedBTreeConfiguration<K, V>();
        configuration.setName(name);
        configuration.setKeySerializer(keySerializer);
        configuration.setValueSerializer(valueSerializer);
        configuration.setPageSize(pageSize);
        configuration.setAllowDuplicates(allowDuplicates);
        configuration.setCacheSize(cacheSize);
        configuration.setWriteBufferSize(1024000);
        PersistedBTree btree = new PersistedBTree(configuration);
        return btree;
    }

    public static <K, V> BTree<K, V> createInMemoryBTree() {
        InMemoryBTree btree = new InMemoryBTree();
        return btree;
    }

    public static <K, V> BTree<K, V> createInMemoryBTree(InMemoryBTreeConfiguration<K, V> configuration) {
        InMemoryBTree<K, V> btree = new InMemoryBTree<K, V>(configuration);
        return btree;
    }

    public static <K, V> BTree<K, V> createInMemoryBTree(String name, ElementSerializer<K> keySerializer, ElementSerializer<V> valueSerializer) {
        InMemoryBTreeConfiguration<K, V> configuration = new InMemoryBTreeConfiguration<K, V>();
        configuration.setName(name);
        configuration.setKeySerializer(keySerializer);
        configuration.setValueSerializer(valueSerializer);
        configuration.setPageSize(16);
        configuration.setAllowDuplicates(false);
        configuration.setWriteBufferSize(1024000);
        InMemoryBTree btree = new InMemoryBTree(configuration);
        return btree;
    }

    public static <K, V> BTree<K, V> createInMemoryBTree(String name, ElementSerializer<K> keySerializer, ElementSerializer<V> valueSerializer, boolean allowDuplicates) {
        InMemoryBTreeConfiguration<K, V> configuration = new InMemoryBTreeConfiguration<K, V>();
        configuration.setName(name);
        configuration.setKeySerializer(keySerializer);
        configuration.setValueSerializer(valueSerializer);
        configuration.setPageSize(16);
        configuration.setAllowDuplicates(allowDuplicates);
        configuration.setWriteBufferSize(1024000);
        InMemoryBTree btree = new InMemoryBTree(configuration);
        return btree;
    }

    public static <K, V> BTree<K, V> createInMemoryBTree(String name, ElementSerializer<K> keySerializer, ElementSerializer<V> valueSerializer, int pageSize) {
        InMemoryBTreeConfiguration<K, V> configuration = new InMemoryBTreeConfiguration<K, V>();
        configuration.setName(name);
        configuration.setKeySerializer(keySerializer);
        configuration.setValueSerializer(valueSerializer);
        configuration.setPageSize(pageSize);
        configuration.setAllowDuplicates(false);
        configuration.setWriteBufferSize(1024000);
        InMemoryBTree btree = new InMemoryBTree(configuration);
        return btree;
    }

    public static <K, V> BTree<K, V> createInMemoryBTree(String name, String filePath, ElementSerializer<K> keySerializer, ElementSerializer<V> valueSerializer) {
        InMemoryBTreeConfiguration<K, V> configuration = new InMemoryBTreeConfiguration<K, V>();
        configuration.setName(name);
        configuration.setFilePath(filePath);
        configuration.setKeySerializer(keySerializer);
        configuration.setValueSerializer(valueSerializer);
        configuration.setPageSize(16);
        configuration.setAllowDuplicates(false);
        configuration.setWriteBufferSize(1024000);
        InMemoryBTree btree = new InMemoryBTree(configuration);
        return btree;
    }

    public static <K, V> BTree<K, V> createInMemoryBTree(String name, String filePath, ElementSerializer<K> keySerializer, ElementSerializer<V> valueSerializer, int pageSize) {
        InMemoryBTreeConfiguration<K, V> configuration = new InMemoryBTreeConfiguration<K, V>();
        configuration.setName(name);
        configuration.setFilePath(filePath);
        configuration.setKeySerializer(keySerializer);
        configuration.setValueSerializer(valueSerializer);
        configuration.setPageSize(pageSize);
        configuration.setAllowDuplicates(false);
        configuration.setWriteBufferSize(1024000);
        InMemoryBTree btree = new InMemoryBTree(configuration);
        return btree;
    }

    public static <K, V> BTree<K, V> createInMemoryBTree(String name, String filePath, ElementSerializer<K> keySerializer, ElementSerializer<V> valueSerializer, int pageSize, boolean allowDuplicates) {
        InMemoryBTreeConfiguration<K, V> configuration = new InMemoryBTreeConfiguration<K, V>();
        configuration.setName(name);
        configuration.setFilePath(filePath);
        configuration.setKeySerializer(keySerializer);
        configuration.setValueSerializer(valueSerializer);
        configuration.setPageSize(pageSize);
        configuration.setAllowDuplicates(allowDuplicates);
        configuration.setWriteBufferSize(1024000);
        InMemoryBTree btree = new InMemoryBTree(configuration);
        return btree;
    }

    static <K, V> Page<K, V> createLeaf(BTree<K, V> btree, long revision, int nbElems) {
        if (btree.getType() != BTreeTypeEnum.IN_MEMORY) {
            return new PersistedLeaf<K, V>(btree, revision, nbElems);
        }
        return new InMemoryLeaf<K, V>(btree, revision, nbElems);
    }

    static <K, V> Page<K, V> createNode(BTree<K, V> btree, long revision, int nbElems) {
        if (btree.getType() != BTreeTypeEnum.IN_MEMORY) {
            return new PersistedNode<K, V>(btree, revision, nbElems);
        }
        return new InMemoryNode<K, V>(btree, revision, nbElems);
    }

    static <K, V> void setKey(BTree<K, V> btree, Page<K, V> page, int pos, K key) {
        KeyHolder keyHolder = btree.getType() != BTreeTypeEnum.IN_MEMORY ? new PersistedKeyHolder<K>(btree.getKeySerializer(), key) : new KeyHolder(key);
        ((AbstractPage)page).setKey(pos, keyHolder);
    }

    static <K, V> void setValue(BTree<K, V> btree, Page<K, V> page, int pos, ValueHolder<V> value) {
        if (btree.getType() != BTreeTypeEnum.IN_MEMORY) {
            ((PersistedLeaf)page).setValue(pos, value);
        } else {
            ((InMemoryLeaf)page).setValue(pos, value);
        }
    }

    static <K, V> void setPage(BTree<K, V> btree, Page<K, V> page, int pos, Page<K, V> child) {
        if (btree.getType() != BTreeTypeEnum.IN_MEMORY) {
            ((PersistedNode)page).setValue(pos, new PersistedPageHolder<K, V>(btree, child));
        } else {
            ((InMemoryNode)page).setPageHolder(pos, new PageHolder<K, V>(btree, child));
        }
    }

    static <K, V> void setKeySerializer(BTree<K, V> btree, String keySerializerFqcn) throws ClassNotFoundException, IllegalAccessException, InstantiationException, IllegalArgumentException, SecurityException, NoSuchFieldException {
        Class<?> keySerializer = Class.forName(keySerializerFqcn);
        ElementSerializer instance = null;
        try {
            instance = (ElementSerializer)keySerializer.getDeclaredField("INSTANCE").get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (instance == null) {
            instance = (ElementSerializer)keySerializer.newInstance();
        }
        btree.setKeySerializer(instance);
    }

    static <K, V> void setValueSerializer(BTree<K, V> btree, String valueSerializerFqcn) throws ClassNotFoundException, IllegalAccessException, InstantiationException, IllegalArgumentException, SecurityException, NoSuchFieldException {
        Class<?> valueSerializer = Class.forName(valueSerializerFqcn);
        ElementSerializer instance = null;
        try {
            instance = (ElementSerializer)valueSerializer.getDeclaredField("INSTANCE").get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (instance == null) {
            instance = (ElementSerializer)valueSerializer.newInstance();
        }
        btree.setValueSerializer(instance);
    }

    static <K, V> void setRootPage(BTree<K, V> btree, Page<K, V> root) {
        ((AbstractBTree)btree).setRootPage(root);
    }

    static <K, V> Page<K, V> getRootPage(BTree<K, V> btree) {
        return btree.getRootPage();
    }

    static <K, V> void setNbElems(BTree<K, V> btree, long nbElems) {
        ((AbstractBTree)btree).setNbElems(nbElems);
    }

    static <K, V> void setRevision(BTree<K, V> btree, long revision) {
        ((AbstractBTree)btree).setRevision(revision);
    }

    static <K, V> void setName(BTree<K, V> btree, String name) {
        btree.setName(name);
    }

    static <K, V> void setPageSize(BTree<K, V> btree, int pageSize) {
        btree.setPageSize(pageSize);
    }

    static <K, V> LinkedList<ParentPos<K, V>> getPathToRightMostLeaf(BTree<K, V> btree) {
        LinkedList<ParentPos<K, V>> stack = new LinkedList<ParentPos<K, V>>();
        ParentPos<K, V> last = new ParentPos<K, V>(btree.getRootPage(), btree.getRootPage().getNbElems());
        stack.push(last);
        if (btree.getRootPage().isLeaf()) {
            Page<K, V> leaf = btree.getRootPage();
            ValueHolder valueHolder = ((AbstractPage)leaf).getValue(last.pos);
            last.valueCursor = valueHolder.getCursor();
        } else {
            Page p;
            Page<K, V> node = btree.getRootPage();
            do {
                p = ((AbstractPage)node).getPage(node.getNbElems());
                last = new ParentPos(p, p.getNbElems());
                stack.push(last);
            } while (!p.isLeaf());
            Page leaf = last.page;
            ValueHolder valueHolder = ((AbstractPage)leaf).getValue(last.pos);
            last.valueCursor = valueHolder.getCursor();
        }
        return stack;
    }

    static <K, V> void setRootPageOffset(BTree<K, V> btree, long rootPageOffset) {
        if (!(btree instanceof PersistedBTree)) {
            throw new IllegalArgumentException("The B-tree must be a PersistedBTree");
        }
        ((PersistedBTree)btree).getBtreeHeader().setRootPageOffset(rootPageOffset);
    }

    static <K, V> void setRecordManager(BTree<K, V> btree, RecordManager recordManager) {
        if (!(btree instanceof PersistedBTree)) {
            throw new IllegalArgumentException("The B-tree must be a PersistedBTree");
        }
        ((PersistedBTree)btree).setRecordManager(recordManager);
    }

    static <K, V> void setKey(BTree<K, V> btree, Page<K, V> page, int pos, byte[] buffer) {
        if (!(btree instanceof PersistedBTree)) {
            throw new IllegalArgumentException("The B-tree must be a PersistedBTree");
        }
        PersistedKeyHolder<K> keyHolder = new PersistedKeyHolder<K>(btree.getKeySerializer(), buffer);
        ((AbstractPage)page).setKey(pos, keyHolder);
    }

    static <K, V> LinkedList<ParentPos<K, V>> getPathToLeftMostLeaf(BTree<K, V> btree) {
        if (btree instanceof PersistedBTree) {
            LinkedList<ParentPos<K, V>> stack = new LinkedList<ParentPos<K, V>>();
            ParentPos<K, V> first = new ParentPos<K, V>(btree.getRootPage(), 0);
            stack.push(first);
            if (btree.getRootPage().isLeaf()) {
                Page<K, V> leaf = btree.getRootPage();
                ValueHolder valueHolder = ((AbstractPage)leaf).getValue(first.pos);
                first.valueCursor = valueHolder.getCursor();
            } else {
                Page page;
                Page<K, V> node = btree.getRootPage();
                do {
                    page = ((AbstractPage)node).getPage(0);
                    first = new ParentPos(page, 0);
                    stack.push(first);
                } while (!page.isLeaf());
                ValueHolder valueHolder = ((AbstractPage)page).getValue(first.pos);
                first.valueCursor = valueHolder.getCursor();
            }
            return stack;
        }
        throw new IllegalArgumentException("The B-tree must be a PersistedBTree");
    }
}

