/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.protocol.shared.kerberos;

import java.nio.ByteBuffer;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StoreUtils {
    private static final Logger LOG = LoggerFactory.getLogger(StoreUtils.class);
    private static final Logger LOG_KRB = LoggerFactory.getLogger(Loggers.KERBEROS_LOG.getName());

    private StoreUtils() {
    }

    public static Entry toServerEntry(CoreSession session, Dn dn, PrincipalStoreEntry principalEntry) throws Exception {
        Entry outAttrs = session.getDirectoryService().newEntry(dn);
        outAttrs.add("objectClass", "top", "uidObject", "uidObject", "extensibleObject", "person", "organizationalPerson", "inetOrgPerson", "krb5Principal", "krb5KDCEntry");
        outAttrs.add("uid", principalEntry.getUserId());
        outAttrs.add("apacheSamType", "7");
        outAttrs.add("sn", principalEntry.getUserId());
        outAttrs.add("cn", principalEntry.getCommonName());
        EncryptionKey encryptionKey = principalEntry.getKeyMap().get((Object)EncryptionType.DES_CBC_MD5);
        ByteBuffer buffer = ByteBuffer.allocate(encryptionKey.computeLength());
        outAttrs.add("krb5Key", (byte[][])new byte[][]{encryptionKey.encode(buffer).array()});
        int keyVersion = encryptionKey.getKeyVersion();
        outAttrs.add("krb5PrincipalName", principalEntry.getPrincipal().toString());
        outAttrs.add("krb5KeyVersionNumber", Integer.toString(keyVersion));
        return outAttrs;
    }

    private static ExprNode getFilter(SchemaManager schemaManager, String principal) throws Exception {
        AttributeType type = schemaManager.lookupAttributeTypeRegistry("krb5PrincipalName");
        StringValue value = new StringValue(type, principal);
        return new EqualityNode<String>(type, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Entry findPrincipalEntry(CoreSession session, Dn searchBaseDn, String principal) throws Exception {
        try (Cursor<Entry> cursor = null;){
            SchemaManager schemaManager = session.getDirectoryService().getSchemaManager();
            cursor = session.search(searchBaseDn, SearchScope.SUBTREE, StoreUtils.getFilter(schemaManager, principal), AliasDerefMode.DEREF_ALWAYS, "*");
            cursor.beforeFirst();
            if (cursor.next()) {
                Entry entry = cursor.get();
                LOG.debug("Found entry {} for kerberos principal name {}", (Object)entry.getDn(), (Object)principal);
                LOG_KRB.debug("Found entry {} for kerberos principal name {}", (Object)entry.getDn(), (Object)principal);
                while (cursor.next()) {
                    LOG.error(I18n.err(I18n.ERR_149, principal, cursor.next()));
                }
                Entry entry2 = entry;
                return entry2;
            }
            LOG.warn("No server entry found for kerberos principal name {}", (Object)principal);
            LOG_KRB.warn("No server entry found for kerberos principal name {}", (Object)principal);
            Entry entry = null;
            return entry;
        }
    }
}

