/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.comparators;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.SchemaManager;

public class DnComparator
extends LdapComparator<Object> {
    private static final long serialVersionUID = 2L;
    private SchemaManager schemaManager;

    public DnComparator(String oid) {
        super(oid);
    }

    @Override
    public int compare(Object obj0, Object obj1) {
        Dn dn0 = null;
        Dn dn1 = null;
        try {
            dn0 = this.getDn(obj0);
            dn1 = this.getDn(obj1);
        }
        catch (LdapException e) {
            return -1;
        }
        int dn0Size = dn0.getRdns().size();
        int dn1Size = dn1.getRdns().size();
        if (dn0.equals(dn1)) {
            return 0;
        }
        if (dn0Size > dn1Size) {
            return -1;
        }
        if (dn1Size > dn0Size) {
            return 1;
        }
        return dn0.getNormName().compareTo(dn1.getNormName());
    }

    private Dn getDn(Object obj) throws LdapInvalidDnException {
        Dn dn = null;
        if (obj instanceof Dn) {
            dn = (Dn)obj;
            dn = dn.isSchemaAware() ? dn : dn.apply(this.schemaManager);
        } else if (obj instanceof String) {
            dn = new Dn(this.schemaManager, (String)obj);
        } else {
            throw new IllegalStateException(I18n.err(I18n.ERR_04218, obj == null ? null : obj.getClass()));
        }
        return dn;
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }
}

