/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.syncrepl.syncState;

import java.util.Arrays;
import org.apache.directory.api.ldap.extras.controls.syncrepl.syncState.SyncStateTypeEnum;
import org.apache.directory.api.ldap.extras.controls.syncrepl.syncState.SyncStateValue;
import org.apache.directory.api.ldap.model.message.controls.AbstractControl;
import org.apache.directory.api.util.Strings;

public class SyncStateValueImpl
extends AbstractControl
implements SyncStateValue {
    private SyncStateTypeEnum type;
    private byte[] cookie;
    private byte[] entryUuid;

    public SyncStateValueImpl() {
        super("1.3.6.1.4.1.4203.1.9.1.2");
    }

    public SyncStateValueImpl(boolean isCritical) {
        super("1.3.6.1.4.1.4203.1.9.1.2", isCritical);
    }

    @Override
    public byte[] getCookie() {
        return this.cookie;
    }

    @Override
    public void setCookie(byte[] cookie) {
        this.cookie = cookie;
    }

    @Override
    public SyncStateTypeEnum getSyncStateType() {
        return this.type;
    }

    @Override
    public void setSyncStateType(SyncStateTypeEnum syncStateType) {
        this.type = syncStateType;
    }

    @Override
    public byte[] getEntryUUID() {
        return this.entryUuid;
    }

    @Override
    public void setEntryUUID(byte[] entryUUID) {
        this.entryUuid = entryUUID;
    }

    @Override
    public int hashCode() {
        int h = 37;
        h = h * 17 + super.hashCode();
        h = h * 17 + this.type.getValue();
        if (this.cookie != null) {
            for (byte b : this.cookie) {
                h = h * 17 + b;
            }
        }
        if (this.entryUuid != null) {
            for (byte b : this.entryUuid) {
                h = h * 17 + b;
            }
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof SyncStateValue)) {
            return false;
        }
        SyncStateValue otherControl = (SyncStateValue)o;
        return this.type == otherControl.getSyncStateType() && Arrays.equals(this.entryUuid, otherControl.getEntryUUID()) && Arrays.equals(this.cookie, otherControl.getCookie()) && this.isCritical() == otherControl.isCritical();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    SyncStateValue control :\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        sb.append("        syncStateType     : '").append((Object)this.getSyncStateType()).append("'\n");
        sb.append("        entryUUID         : '").append(Strings.dumpBytes(this.getEntryUUID())).append("'\n");
        sb.append("        cookie            : '").append(Strings.dumpBytes(this.getCookie())).append("'\n");
        return sb.toString();
    }
}

