/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.protocol.codec;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.tlv.TLVStateEnum;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.util.Strings;
import org.apache.directory.shared.kerberos.codec.KerberosMessageContainer;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinaKerberosDecoder
extends CumulativeProtocolDecoder {
    private static final String KERBEROS_MESSAGE_CONTAINER = "kerberosMessageContainer";
    private Asn1Decoder asn1Decoder = new Asn1Decoder();
    private static final int DEFAULT_MAX_PDU_SIZE = 7168;
    private int maxPduSize = 7168;
    private static final Logger LOG_KRB = LoggerFactory.getLogger(Loggers.KERBEROS_LOG.getName());
    private static final boolean IS_DEBUG = LOG_KRB.isDebugEnabled();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doDecode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        int curLen;
        ByteBuffer incomingBuf = in.buf();
        KerberosMessageContainer krbMsgContainer = (KerberosMessageContainer)session.getAttribute(KERBEROS_MESSAGE_CONTAINER);
        if (krbMsgContainer == null) {
            krbMsgContainer = new KerberosMessageContainer();
            krbMsgContainer.setMaxPDUSize(this.maxPduSize);
            session.setAttribute(KERBEROS_MESSAGE_CONTAINER, krbMsgContainer);
            krbMsgContainer.setGathering(true);
            boolean tcp = !session.getTransportMetadata().isConnectionless();
            krbMsgContainer.setTCP(tcp);
            if (tcp) {
                if (incomingBuf.remaining() <= 4) {
                    String err = "Could not determine the length of TCP buffer";
                    LOG_KRB.warn("{} {}", (Object)err, (Object)Strings.dumpBytes(incomingBuf.array()));
                    throw new IllegalStateException(err);
                }
                int len = incomingBuf.getInt();
                if (len > this.maxPduSize) {
                    session.removeAttribute(KERBEROS_MESSAGE_CONTAINER);
                    String err = "Request length %d exceeds allowed max PDU size %d";
                    err = String.format(err, len, this.maxPduSize);
                    throw new DecoderException(err);
                }
                krbMsgContainer.setTcpLength(len);
                incomingBuf.mark();
                ByteBuffer tmp = ByteBuffer.allocate(len);
                tmp.put(incomingBuf);
                krbMsgContainer.setStream(tmp);
            } else {
                krbMsgContainer.setStream(incomingBuf);
            }
        } else {
            int totLen = incomingBuf.limit() + krbMsgContainer.getStream().position();
            if (totLen > this.maxPduSize) {
                session.removeAttribute(KERBEROS_MESSAGE_CONTAINER);
                String err = "Total length of recieved bytes %d exceeds allowed max PDU size %d";
                err = String.format(err, totLen, this.maxPduSize);
                throw new DecoderException(err);
            }
            krbMsgContainer.getStream().put(incomingBuf);
        }
        if (krbMsgContainer.isTCP() && (curLen = krbMsgContainer.getStream().position()) < krbMsgContainer.getTcpLength()) {
            return false;
        }
        try {
            ByteBuffer stream = krbMsgContainer.getStream();
            if (stream.position() != 0) {
                stream.flip();
            }
            this.asn1Decoder.decode(stream, krbMsgContainer);
            if (krbMsgContainer.getState() != TLVStateEnum.PDU_DECODED) throw new DecoderException("Invalid buffer");
            if (IS_DEBUG) {
                LOG_KRB.debug("Decoded KerberosMessage : " + krbMsgContainer.getMessage());
                incomingBuf.mark();
            }
            out.write(krbMsgContainer.getMessage());
            boolean bl = true;
            return bl;
        }
        catch (DecoderException de) {
            LOG_KRB.warn("Error while decoding kerberos message", de);
            incomingBuf.clear();
            krbMsgContainer.clean();
            throw de;
        }
        finally {
            session.removeAttribute(KERBEROS_MESSAGE_CONTAINER);
        }
    }

    public int getMaxPduSize() {
        return this.maxPduSize;
    }

    public void setMaxPduSize(int maxPduSize) {
        this.maxPduSize = maxPduSize;
    }
}

