/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.io.IOException;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.ClosureMonitor;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.server.core.partition.impl.btree.AbstractBTreePartition;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.server.xdbm.search.PartitionSearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryCursorAdaptor
extends AbstractCursor<Entry> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger(Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private final Cursor<IndexEntry<String, String>> indexCursor;
    private final Evaluator<? extends ExprNode> evaluator;

    public EntryCursorAdaptor(AbstractBTreePartition db, PartitionSearchResult searchResult) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating EntryCursorAdaptor {}", (Object)this);
        }
        this.indexCursor = searchResult.getResultSet();
        this.evaluator = searchResult.getEvaluator();
    }

    @Override
    public void after(Entry element) throws LdapException, CursorException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void afterLast() throws LdapException, CursorException {
        this.indexCursor.afterLast();
    }

    @Override
    public boolean available() {
        return this.indexCursor.available();
    }

    @Override
    public void before(Entry element) throws LdapException, CursorException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException {
        this.indexCursor.beforeFirst();
    }

    @Override
    public final void setClosureMonitor(ClosureMonitor monitor) {
        this.indexCursor.setClosureMonitor(monitor);
    }

    @Override
    public void close() throws IOException {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing EntryCursorAdaptor {}", (Object)this);
        }
        this.indexCursor.close();
    }

    @Override
    public void close(Exception cause) throws IOException {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing EntryCursorAdaptor {}", (Object)this);
        }
        this.indexCursor.close(cause);
    }

    @Override
    public boolean first() throws LdapException, CursorException {
        return this.indexCursor.first();
    }

    @Override
    public Entry get() throws CursorException {
        IndexEntry<String, String> indexEntry = this.indexCursor.get();
        try {
            if (this.evaluator.evaluate(indexEntry)) {
                Entry entry = indexEntry.getEntry();
                indexEntry.setEntry(null);
                return entry;
            }
            indexEntry.setEntry(null);
            return null;
        }
        catch (Exception e) {
            throw new CursorException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isClosed() {
        return this.indexCursor.isClosed();
    }

    @Override
    public boolean last() throws LdapException, CursorException {
        return this.indexCursor.last();
    }

    @Override
    public boolean next() throws LdapException, CursorException {
        return this.indexCursor.next();
    }

    @Override
    public boolean previous() throws LdapException, CursorException {
        return this.indexCursor.previous();
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("EntryCursorAdaptor\n");
        if (this.indexCursor != null) {
            sb.append(tabs).append("    ").append("IndexCursor : \n");
            sb.append(this.indexCursor.toString(tabs + "        "));
        }
        if (this.evaluator != null) {
            sb.append(tabs).append("    ").append("Evaluator : \n");
            sb.append(this.evaluator.toString(tabs + "        "));
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

