/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.ldap.codec.api.BinaryAttributeDetector;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.EmptyCursor;
import org.apache.directory.api.ldap.model.cursor.EntryCursor;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapNoPermissionException;
import org.apache.directory.api.ldap.model.exception.LdapOperationException;
import org.apache.directory.api.ldap.model.message.AbandonRequest;
import org.apache.directory.api.ldap.model.message.AddRequest;
import org.apache.directory.api.ldap.model.message.AddRequestImpl;
import org.apache.directory.api.ldap.model.message.AddResponse;
import org.apache.directory.api.ldap.model.message.AddResponseImpl;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.ldap.model.message.BindRequestImpl;
import org.apache.directory.api.ldap.model.message.BindResponse;
import org.apache.directory.api.ldap.model.message.BindResponseImpl;
import org.apache.directory.api.ldap.model.message.CompareRequest;
import org.apache.directory.api.ldap.model.message.CompareRequestImpl;
import org.apache.directory.api.ldap.model.message.CompareResponse;
import org.apache.directory.api.ldap.model.message.CompareResponseImpl;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.DeleteRequest;
import org.apache.directory.api.ldap.model.message.DeleteRequestImpl;
import org.apache.directory.api.ldap.model.message.DeleteResponse;
import org.apache.directory.api.ldap.model.message.DeleteResponseImpl;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.ModifyDnRequest;
import org.apache.directory.api.ldap.model.message.ModifyDnRequestImpl;
import org.apache.directory.api.ldap.model.message.ModifyDnResponse;
import org.apache.directory.api.ldap.model.message.ModifyDnResponseImpl;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.api.ldap.model.message.ModifyResponse;
import org.apache.directory.api.ldap.model.message.ModifyResponseImpl;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponseRequest;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchRequestImpl;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.ldap.client.api.AbstractLdapConnection;
import org.apache.directory.ldap.client.api.EntryCursorImpl;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.EntryToResponseCursor;
import org.apache.directory.server.core.api.OperationEnum;
import org.apache.directory.server.core.api.OperationManager;
import org.apache.directory.server.core.api.interceptor.context.BindOperationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapCoreSessionConnection
extends AbstractLdapConnection {
    private static final Logger LOG = LoggerFactory.getLogger(LdapCoreSessionConnection.class);
    private CoreSession session;
    private DirectoryService directoryService;

    public LdapCoreSessionConnection() {
    }

    public LdapCoreSessionConnection(DirectoryService directoryService) {
        this.setDirectoryService(directoryService);
    }

    public LdapCoreSessionConnection(CoreSession session) {
        this.session = session;
        this.setDirectoryService(session.getDirectoryService());
        this.messageId.incrementAndGet();
    }

    @Override
    public void close() throws IOException {
        try {
            this.unBind();
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    @Override
    public boolean connect() throws LdapException {
        return true;
    }

    @Override
    public AddResponse add(AddRequest addRequest) throws LdapException {
        if (addRequest == null) {
            String msg = "Cannot process a null addRequest";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        if (addRequest.getEntry() == null) {
            String msg = "Cannot add a null entry";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        int newId = this.messageId.incrementAndGet();
        addRequest.setMessageId(newId);
        AddResponseImpl resp = new AddResponseImpl(newId);
        resp.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
        try {
            this.session.add(addRequest);
        }
        catch (LdapException e) {
            LOG.warn(e.getMessage(), e);
            resp.getLdapResult().setResultCode(ResultCodeEnum.getResultCode(e));
            resp.getLdapResult().setDiagnosticMessage(e.getMessage());
        }
        this.addResponseControls(addRequest, resp);
        return resp;
    }

    @Override
    public void add(Entry entry) throws LdapException {
        if (entry == null) {
            String msg = "Cannot add an empty entry";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        AddRequestImpl addRequest = new AddRequestImpl();
        addRequest.setEntry(entry);
        addRequest.setEntryDn(entry.getDn());
        AddResponse addResponse = this.add(addRequest);
        ResultCodeEnum.processResponse(addResponse);
    }

    @Override
    public CompareResponse compare(CompareRequest compareRequest) throws LdapException {
        if (compareRequest == null) {
            String msg = "Cannot process a null compareRequest";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        int newId = this.messageId.incrementAndGet();
        CompareResponseImpl resp = new CompareResponseImpl(newId);
        resp.getLdapResult().setResultCode(ResultCodeEnum.COMPARE_TRUE);
        try {
            this.session.compare(compareRequest);
        }
        catch (Exception e) {
            resp.getLdapResult().setResultCode(ResultCodeEnum.getResultCode(e));
        }
        this.addResponseControls(compareRequest, resp);
        return resp;
    }

    @Override
    public boolean compare(Dn dn, String attributeName, byte[] value) throws LdapException {
        CompareRequestImpl compareRequest = new CompareRequestImpl();
        compareRequest.setName(dn);
        compareRequest.setAttributeId(attributeName);
        compareRequest.setAssertionValue(value);
        CompareResponse compareResponse = this.compare(compareRequest);
        return ResultCodeEnum.processResponse(compareResponse);
    }

    @Override
    public boolean compare(Dn dn, String attributeName, String value) throws LdapException {
        CompareRequestImpl compareRequest = new CompareRequestImpl();
        compareRequest.setName(dn);
        compareRequest.setAttributeId(attributeName);
        compareRequest.setAssertionValue(value);
        CompareResponse compareResponse = this.compare(compareRequest);
        return ResultCodeEnum.processResponse(compareResponse);
    }

    @Override
    public boolean compare(String dn, String attributeName, byte[] value) throws LdapException {
        return this.compare(new Dn(this.schemaManager, dn), attributeName, value);
    }

    @Override
    public boolean compare(String dn, String attributeName, String value) throws LdapException {
        return this.compare(new Dn(this.schemaManager, dn), attributeName, value);
    }

    @Override
    public boolean compare(Dn dn, String attributeName, Value<?> value) throws LdapException {
        CompareRequestImpl compareRequest = new CompareRequestImpl();
        compareRequest.setName(dn);
        compareRequest.setAttributeId(attributeName);
        if (value.isHumanReadable()) {
            compareRequest.setAssertionValue(value.getString());
        } else {
            compareRequest.setAssertionValue(value.getBytes());
        }
        CompareResponse compareResponse = this.compare(compareRequest);
        return ResultCodeEnum.processResponse(compareResponse);
    }

    @Override
    public boolean compare(String dn, String attributeName, Value<?> value) throws LdapException {
        return this.compare(new Dn(this.schemaManager, dn), attributeName, value);
    }

    @Override
    public DeleteResponse delete(DeleteRequest deleteRequest) throws LdapException {
        if (deleteRequest == null) {
            String msg = "Cannot process a null deleteRequest";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        int newId = this.messageId.incrementAndGet();
        DeleteResponseImpl resp = new DeleteResponseImpl(newId);
        resp.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
        try {
            this.session.delete(deleteRequest);
        }
        catch (LdapException e) {
            LOG.warn(e.getMessage(), e);
            resp.getLdapResult().setResultCode(ResultCodeEnum.getResultCode(e));
            resp.getLdapResult().setDiagnosticMessage(e.getMessage());
        }
        this.addResponseControls(deleteRequest, resp);
        return resp;
    }

    @Override
    public void delete(Dn dn) throws LdapException {
        DeleteRequestImpl deleteRequest = new DeleteRequestImpl();
        deleteRequest.setName(dn);
        DeleteResponse deleteResponse = this.delete(deleteRequest);
        ResultCodeEnum.processResponse(deleteResponse);
    }

    @Override
    public void delete(String dn) throws LdapException {
        this.delete(new Dn(this.schemaManager, dn));
    }

    @Override
    public boolean doesFutureExistFor(int messageId) {
        return false;
    }

    @Override
    public SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    @Override
    public LdapApiService getCodecService() {
        return this.codec;
    }

    @Override
    public List<String> getSupportedControls() throws LdapException {
        return null;
    }

    @Override
    public boolean isAuthenticated() {
        return this.session != null;
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public boolean isControlSupported(String controlOID) throws LdapException {
        return false;
    }

    @Override
    public void loadSchema() throws LdapException {
    }

    @Override
    public void loadSchemaRelaxed() throws LdapException {
    }

    @Override
    public Entry lookup(Dn dn, String ... attributes) throws LdapException {
        return this.lookup(dn, (Control[])null, attributes);
    }

    @Override
    public Entry lookup(Dn dn, Control[] controls, String ... attributes) throws LdapException {
        this.messageId.incrementAndGet();
        Entry entry = null;
        try {
            entry = this.session.lookup(dn, controls, attributes);
        }
        catch (LdapException e) {
            LOG.warn(e.getMessage(), e);
        }
        return entry;
    }

    @Override
    public Entry lookup(String dn, String ... attributes) throws LdapException {
        Dn baseDn = new Dn(this.schemaManager, dn);
        return this.lookup(baseDn, (Control[])null, attributes);
    }

    @Override
    public Entry lookup(String dn, Control[] controls, String ... attributes) throws LdapException {
        Dn baseDn = new Dn(this.schemaManager, dn);
        return this.lookup(baseDn, controls, attributes);
    }

    @Override
    public boolean exists(String dn) throws LdapException {
        return this.exists(new Dn(this.schemaManager, dn));
    }

    @Override
    public boolean exists(Dn dn) throws LdapException {
        try {
            Entry entry = this.lookup(dn, "1.1");
            return entry != null;
        }
        catch (LdapNoPermissionException lnpe) {
            return false;
        }
        catch (LdapException le) {
            throw le;
        }
    }

    @Override
    public Entry getRootDse() throws LdapException {
        return this.lookup(Dn.ROOT_DSE, SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
    }

    @Override
    public Entry getRootDse(String ... attributes) throws LdapException {
        return this.lookup(Dn.ROOT_DSE, attributes);
    }

    @Override
    public Entry lookup(Dn dn) throws LdapException {
        return this.lookup(dn, (String[])null);
    }

    @Override
    public Entry lookup(String dn) throws LdapException {
        return this.lookup(new Dn(this.schemaManager, dn), (String[])null);
    }

    @Override
    public void modify(Dn dn, Modification ... modifications) throws LdapException {
        if (dn == null) {
            LOG.debug("received a null dn for modification");
            throw new IllegalArgumentException("The Dn to be modified cannot be null");
        }
        if (modifications == null || modifications.length == 0) {
            String msg = "Cannot process a ModifyRequest without any modification";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        int newId = this.messageId.incrementAndGet();
        ModifyRequestImpl modifyRequest = new ModifyRequestImpl();
        modifyRequest.setMessageId(newId);
        modifyRequest.setName(dn);
        for (Modification modification : modifications) {
            modifyRequest.addModification(modification);
        }
        ModifyResponse modifyResponse = this.modify(modifyRequest);
        ResultCodeEnum.processResponse(modifyResponse);
    }

    @Override
    public void modify(String dn, Modification ... modifications) throws LdapException {
        this.modify(new Dn(this.schemaManager, dn), modifications);
    }

    @Override
    public void modify(Entry entry, ModificationOperation modOp) throws LdapException {
        if (entry == null) {
            LOG.debug("received a null entry for modification");
            throw new IllegalArgumentException("Entry to be modified cannot be null");
        }
        int newId = this.messageId.incrementAndGet();
        ModifyRequestImpl modifyRequest = new ModifyRequestImpl();
        modifyRequest.setMessageId(newId);
        modifyRequest.setName(entry.getDn());
        Iterator<Attribute> itr = entry.iterator();
        while (itr.hasNext()) {
            modifyRequest.addModification(new DefaultModification(modOp, itr.next()));
        }
        ModifyResponse modifyResponse = this.modify(modifyRequest);
        ResultCodeEnum.processResponse(modifyResponse);
    }

    @Override
    public ModifyResponse modify(ModifyRequest modRequest) throws LdapException {
        if (modRequest == null) {
            String msg = "Cannot process a null modifyRequest";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        int newId = this.messageId.incrementAndGet();
        modRequest.setMessageId(newId);
        ModifyResponseImpl resp = new ModifyResponseImpl(newId);
        resp.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
        try {
            this.session.modify(modRequest);
        }
        catch (LdapException e) {
            LOG.warn(e.getMessage(), e);
            resp.getLdapResult().setResultCode(ResultCodeEnum.getResultCode(e));
            resp.getLdapResult().setDiagnosticMessage(e.getMessage());
        }
        this.addResponseControls(modRequest, resp);
        return resp;
    }

    @Override
    public ModifyDnResponse modifyDn(ModifyDnRequest modDnRequest) throws LdapException {
        if (modDnRequest == null) {
            String msg = "Cannot process a null modDnRequest";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        int newId = this.messageId.incrementAndGet();
        ModifyDnResponseImpl resp = new ModifyDnResponseImpl(newId);
        LdapResult result = resp.getLdapResult();
        result.setResultCode(ResultCodeEnum.SUCCESS);
        if (modDnRequest.getName().isEmpty()) {
            String msg = "Modify Dn is not allowed on Root DSE.";
            result.setResultCode(ResultCodeEnum.PROTOCOL_ERROR);
            result.setDiagnosticMessage(msg);
            return resp;
        }
        try {
            boolean rdnChanged;
            Dn newRdn = null;
            if (modDnRequest.getNewRdn() != null) {
                newRdn = new Dn(this.schemaManager, modDnRequest.getNewRdn().getName());
            }
            Dn oldRdn = new Dn(this.schemaManager, modDnRequest.getName().getRdn().getName());
            boolean bl = rdnChanged = modDnRequest.getNewRdn() != null && !newRdn.getNormName().equals(oldRdn.getNormName());
            if (rdnChanged) {
                if (modDnRequest.getNewSuperior() != null) {
                    this.session.moveAndRename(modDnRequest);
                } else {
                    this.session.rename(modDnRequest);
                }
            } else if (modDnRequest.getNewSuperior() != null) {
                modDnRequest.setNewRdn(null);
                this.session.move(modDnRequest);
            } else {
                this.session.rename(modDnRequest);
            }
        }
        catch (LdapException e) {
            LOG.warn(e.getMessage(), e);
            resp.getLdapResult().setResultCode(ResultCodeEnum.getResultCode(e));
            resp.getLdapResult().setDiagnosticMessage(e.getMessage());
        }
        this.addResponseControls(modDnRequest, resp);
        return resp;
    }

    @Override
    public void move(Dn entryDn, Dn newSuperiorDn) throws LdapException {
        if (entryDn == null) {
            String msg = "Cannot process a move of a null Dn";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        if (newSuperiorDn == null) {
            String msg = "Cannot process a move to a null Dn";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        ModifyDnRequestImpl iModDnReq = new ModifyDnRequestImpl();
        iModDnReq.setName(entryDn);
        iModDnReq.setNewSuperior(newSuperiorDn);
        ModifyDnResponse modifyDnResponse = this.modifyDn(iModDnReq);
        ResultCodeEnum.processResponse(modifyDnResponse);
    }

    @Override
    public void move(String entryDn, String newSuperiorDn) throws LdapException {
        if (entryDn == null) {
            String msg = "Cannot process a move of a null Dn";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        if (newSuperiorDn == null) {
            String msg = "Cannot process a move to a null Dn";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        this.move(new Dn(this.schemaManager, entryDn), new Dn(this.schemaManager, newSuperiorDn));
    }

    @Override
    public void rename(Dn entryDn, Rdn newRdn, boolean deleteOldRdn) throws LdapException {
        if (entryDn == null) {
            String msg = "Cannot process a rename of a null Dn";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        if (newRdn == null) {
            String msg = "Cannot process a rename with a null Rdn";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        ModifyDnRequestImpl modifyDnRequest = new ModifyDnRequestImpl();
        modifyDnRequest.setName(entryDn);
        modifyDnRequest.setNewRdn(newRdn);
        modifyDnRequest.setDeleteOldRdn(deleteOldRdn);
        ModifyDnResponse modifyDnResponse = this.modifyDn(modifyDnRequest);
        ResultCodeEnum.processResponse(modifyDnResponse);
    }

    @Override
    public void rename(Dn entryDn, Rdn newRdn) throws LdapException {
        this.rename(entryDn, newRdn, false);
    }

    @Override
    public void rename(String entryDn, String newRdn, boolean deleteOldRdn) throws LdapException {
        this.rename(new Dn(this.schemaManager, entryDn), new Rdn(newRdn), deleteOldRdn);
    }

    @Override
    public void rename(String entryDn, String newRdn) throws LdapException {
        if (entryDn == null) {
            String msg = "Cannot process a rename of a null Dn";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        if (newRdn == null) {
            String msg = "Cannot process a rename with a null Rdn";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        this.rename(new Dn(this.schemaManager, entryDn), new Rdn(newRdn));
    }

    @Override
    public void moveAndRename(Dn entryDn, Dn newDn) throws LdapException {
        this.moveAndRename(entryDn, newDn, true);
    }

    @Override
    public void moveAndRename(String entryDn, String newDn) throws LdapException {
        this.moveAndRename(new Dn(this.schemaManager, entryDn), new Dn(this.schemaManager, newDn), true);
    }

    @Override
    public void moveAndRename(Dn entryDn, Dn newDn, boolean deleteOldRdn) throws LdapException {
        if (entryDn == null) {
            throw new IllegalArgumentException("The entry Dn must not be null");
        }
        if (entryDn.isRootDse()) {
            throw new IllegalArgumentException("The RootDSE cannot be moved");
        }
        if (newDn == null) {
            throw new IllegalArgumentException("The new Dn must not be null");
        }
        if (newDn.isRootDse()) {
            throw new IllegalArgumentException("The RootDSE cannot be the target");
        }
        ModifyDnResponseImpl resp = new ModifyDnResponseImpl();
        resp.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
        ModifyDnRequestImpl modifyDnRequest = new ModifyDnRequestImpl();
        modifyDnRequest.setName(entryDn);
        modifyDnRequest.setNewRdn(newDn.getRdn());
        modifyDnRequest.setNewSuperior(newDn.getParent());
        modifyDnRequest.setDeleteOldRdn(deleteOldRdn);
        ModifyDnResponse modifyDnResponse = this.modifyDn(modifyDnRequest);
        ResultCodeEnum.processResponse(modifyDnResponse);
    }

    @Override
    public void moveAndRename(String entryDn, String newDn, boolean deleteOldRdn) throws LdapException {
        this.moveAndRename(new Dn(this.schemaManager, entryDn), new Dn(this.schemaManager, newDn), deleteOldRdn);
    }

    @Override
    public SearchCursor search(SearchRequest searchRequest) throws LdapException {
        if (searchRequest == null) {
            String msg = "Cannot process a null searchRequest";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        try {
            int newId = this.messageId.incrementAndGet();
            searchRequest.setMessageId(newId);
            Cursor<Entry> entryCursor = this.session.search(searchRequest);
            entryCursor.beforeFirst();
            return new EntryToResponseCursor(searchRequest, newId, entryCursor);
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), e);
            return new EntryToResponseCursor(searchRequest, -1, new EmptyCursor<Entry>());
        }
    }

    @Override
    public EntryCursor search(Dn baseDn, String filter, SearchScope scope, String ... attributes) throws LdapException {
        if (baseDn == null) {
            LOG.debug("received a null dn for a search");
            throw new IllegalArgumentException("The base Dn cannot be null");
        }
        SearchRequestImpl searchRequest = new SearchRequestImpl();
        searchRequest.setBase(baseDn);
        searchRequest.setFilter(filter);
        searchRequest.setScope(scope);
        searchRequest.addAttributes(attributes);
        searchRequest.setDerefAliases(AliasDerefMode.DEREF_ALWAYS);
        return new EntryCursorImpl(this.search(searchRequest));
    }

    @Override
    public EntryCursor search(String baseDn, String filter, SearchScope scope, String ... attributes) throws LdapException {
        return this.search(new Dn(this.schemaManager, baseDn), filter, scope, attributes);
    }

    @Override
    public void unBind() throws LdapException {
        this.messageId.set(0);
        if (this.session != null) {
            if (!this.session.isAnonymous()) {
                this.session.unbind();
            }
            this.session = null;
        }
    }

    @Override
    public ExtendedResponse extended(String oid) throws LdapException {
        throw new UnsupportedOperationException("extended operations are not supported on CoreSession based connection");
    }

    @Override
    public ExtendedResponse extended(ExtendedRequest extendedRequest) throws LdapException {
        if (extendedRequest == null) {
            String msg = "Cannot process a null extendedRequest";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        return this.extended((String)null);
    }

    @Override
    public ExtendedResponse extended(Oid oid, byte[] value) throws LdapException {
        return this.extended((String)null);
    }

    @Override
    public ExtendedResponse extended(Oid oid) throws LdapException {
        return this.extended((String)null);
    }

    @Override
    public ExtendedResponse extended(String oid, byte[] value) throws LdapException {
        return this.extended((String)null);
    }

    @Override
    public void setTimeOut(long timeOut) {
        throw new UnsupportedOperationException("setting timeout is not supported on CoreSession");
    }

    @Override
    public void abandon(AbandonRequest abandonRequest) {
        throw new UnsupportedOperationException("abandon operation is not supported");
    }

    @Override
    public void abandon(int messageId) {
        this.abandon(null);
    }

    @Override
    public void bind() throws LdapException {
        throw new UnsupportedOperationException("Bind operation using LdapConnectionConfig are not supported on CoreSession based connection");
    }

    @Override
    public void anonymousBind() throws LdapException {
        BindRequestImpl bindRequest = new BindRequestImpl();
        bindRequest.setName("");
        bindRequest.setCredentials((byte[])null);
        BindResponse bindResponse = this.bind(bindRequest);
        ResultCodeEnum.processResponse(bindResponse);
    }

    @Override
    public BindResponse bind(BindRequest bindRequest) throws LdapException {
        if (bindRequest == null) {
            String msg = "Cannot process a null bindRequest";
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        int newId = this.messageId.incrementAndGet();
        BindOperationContext bindContext = new BindOperationContext(null);
        bindContext.setCredentials(bindRequest.getCredentials());
        bindContext.setDn(bindRequest.getDn().apply(this.directoryService.getSchemaManager()));
        bindContext.setInterceptors(this.directoryService.getInterceptors(OperationEnum.BIND));
        for (Control control : bindRequest.getControls().values()) {
            bindContext.addRequestControl(control);
        }
        OperationManager operationManager = this.directoryService.getOperationManager();
        BindResponseImpl bindResp = new BindResponseImpl(newId);
        bindResp.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
        try {
            if (!bindRequest.isSimple()) {
                bindContext.setSaslMechanism(bindRequest.getSaslMechanism());
            }
            operationManager.bind(bindContext);
            this.session = bindContext.getSession();
            bindResp.addAllControls(bindContext.getResponseControls());
        }
        catch (LdapOperationException e) {
            LOG.warn(e.getMessage(), e);
            LdapResult res = bindResp.getLdapResult();
            res.setDiagnosticMessage(e.getMessage());
            res.setResultCode(e.getResultCode());
        }
        return bindResp;
    }

    private void addResponseControls(ResultResponseRequest iReq, Message clientResp) {
        Collection<Control> ctrlSet = iReq.getResultResponse().getControls().values();
        for (Control c : ctrlSet) {
            clientResp.addControl(c);
        }
    }

    public DirectoryService getDirectoryService() {
        return this.directoryService;
    }

    public void setDirectoryService(DirectoryService directoryService) {
        this.directoryService = directoryService;
        this.schemaManager = directoryService.getSchemaManager();
        this.session = directoryService.getAdminSession();
    }

    @Override
    public BinaryAttributeDetector getBinaryAttributeDetector() {
        return null;
    }

    @Override
    public void setBinaryAttributeDetector(BinaryAttributeDetector binaryAttributeDetector) {
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }
}

