/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.normalizers;

import org.apache.directory.api.ldap.model.entry.BinaryValue;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.normalizers.NameComponentNormalizer;
import org.apache.directory.api.ldap.model.schema.normalizers.NoOpNormalizer;
import org.apache.directory.api.util.Hex;
import org.apache.directory.api.util.Strings;

public class ConcreteNameComponentNormalizer
implements NameComponentNormalizer {
    private final SchemaManager schemaManager;

    public ConcreteNameComponentNormalizer(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    private String unescape(String value) {
        char[] newVal = new char[value.length()];
        int escaped = 0;
        char high = '\u0000';
        char low = '\u0000';
        int pos = 0;
        block5: for (int index = 0; index < value.length(); ++index) {
            char c = value.charAt(index);
            switch (escaped) {
                case 0: {
                    if (c == '\\') {
                        escaped = 1;
                        continue block5;
                    }
                    newVal[pos++] = c;
                    continue block5;
                }
                case 1: {
                    ++escaped;
                    high = c;
                    continue block5;
                }
                case 2: {
                    escaped = 0;
                    low = c;
                    newVal[pos++] = (char)Hex.getHexValue(high, low);
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("escaped can never have such a value: " + value);
                }
            }
        }
        return new String(newVal, 0, pos);
    }

    @Override
    public Object normalizeByName(String name, String value) throws LdapException {
        AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(name);
        if (attributeType.getSyntax().isHumanReadable()) {
            return this.lookup(name).normalize(value);
        }
        String unescaped = this.unescape(value);
        byte[] valBytes = Strings.getBytesUtf8(unescaped);
        return this.lookup(name).normalize(new BinaryValue(valBytes));
    }

    @Override
    public Object normalizeByName(String name, byte[] value) throws LdapException {
        AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(name);
        if (!attributeType.getSyntax().isHumanReadable()) {
            return this.lookup(name).normalize(new BinaryValue(value));
        }
        String valStr = Strings.utf8ToString(value);
        return this.lookup(name).normalize(valStr);
    }

    @Override
    public Object normalizeByOid(String oid, String value) throws LdapException {
        return this.lookup(oid).normalize(value);
    }

    @Override
    public Object normalizeByOid(String oid, byte[] value) throws LdapException {
        return this.lookup(oid).normalize(new BinaryValue(value));
    }

    private Normalizer lookup(String id) throws LdapException {
        AttributeType type = this.schemaManager.lookupAttributeTypeRegistry(id);
        MatchingRule mrule = type.getEquality();
        if (mrule == null) {
            return new NoOpNormalizer(id);
        }
        return mrule.getNormalizer();
    }

    @Override
    public boolean isDefined(String id) {
        return this.schemaManager.getAttributeTypeRegistry().contains(id);
    }

    @Override
    public String normalizeName(String attributeName) throws LdapException {
        return this.schemaManager.getAttributeTypeRegistry().getOidByName(attributeName);
    }
}

