/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.UUID;
import org.apache.directory.server.ApacheDsService;
import org.apache.directory.server.core.api.InstanceLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UberjarMain {
    private static final Logger LOG = LoggerFactory.getLogger(UberjarMain.class);
    private static final String PROPERTY_SHUTDOWN_PORT = "apacheds.shutdown.port";
    private ApacheDsService service;

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) throws Exception {
        if (args == null || args.length < 1) {
            throw new IllegalArgumentException("Instance directory argument is missing");
        }
        instanceDirectory = args[0];
        action = args.length == 2 ? Action.fromString(args[1]) : Action.START;
        instance = new UberjarMain();
        switch (2.$SwitchMap$org$apache$directory$server$UberjarMain$Action[action.ordinal()]) {
            case 1: {
                UberjarMain.LOG.debug("Staring runtime");
                instance.start(new String[]{instanceDirectory});
                break;
            }
            case 2: {
                UberjarMain.LOG.debug("Stopping runtime");
                layout = new InstanceLayout(instanceDirectory);
                socket = new Socket(InetAddress.getLocalHost().getHostName(), UberjarMain.readShutdownPort(layout));
                var6_6 = null;
                writer = new PrintWriter(socket.getOutputStream());
                var8_10 = null;
                try {
                    writer.print(UberjarMain.readShutdownPassword(layout));
                }
                catch (Throwable var9_12) {
                    var8_10 = var9_12;
                    throw var9_12;
                }
                finally {
                    if (writer != null) {
                        if (var8_10 != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable var9_11) {
                                var8_10.addSuppressed(var9_11);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
                if (socket == null) break;
                if (var6_6 == null) ** GOTO lbl44
                try {
                    socket.close();
                }
                catch (Throwable var7_8) {
                    var6_6.addSuppressed(var7_8);
                }
                break;
lbl44:
                // 1 sources

                socket.close();
                break;
                catch (Throwable var7_9) {
                    try {
                        var6_6 = var7_9;
                        throw var7_9;
                    }
                    catch (Throwable var12_15) {
                        if (socket != null) {
                            if (var6_6 != null) {
                                try {
                                    socket.close();
                                }
                                catch (Throwable var13_16) {
                                    var6_6.addSuppressed(var13_16);
                                }
                            } else {
                                socket.close();
                            }
                        }
                        throw var12_15;
                    }
                }
            }
            default: {
                throw new IllegalArgumentException("Unexpected action " + (Object)action);
            }
        }
        UberjarMain.LOG.trace("Exiting main");
    }

    private int getShutdownPort() {
        int shutdownPort = Integer.parseInt(System.getProperty(PROPERTY_SHUTDOWN_PORT, "0"));
        if (shutdownPort < 0 || shutdownPort > 0 && shutdownPort < 1024 || shutdownPort > 65536) {
            throw new IllegalArgumentException("Shutdown port [" + shutdownPort + "] is an illegal port number");
        }
        return shutdownPort;
    }

    private static int readShutdownPort(InstanceLayout layout) throws IOException {
        return Integer.parseInt(new String(Files.readAllBytes(Paths.get(layout.getRunDirectory().getAbsolutePath(), ".shutdown.port")), Charset.forName("utf-8")));
    }

    private static String readShutdownPassword(InstanceLayout layout) throws IOException {
        return new String(Files.readAllBytes(Paths.get(layout.getRunDirectory().getAbsolutePath(), ".shutdown.pwd")), Charset.forName("utf-8"));
    }

    public void start(String ... args) {
        InstanceLayout layout = new InstanceLayout(args[0]);
        this.service = new ApacheDsService();
        try {
            LOG.info("Starting the service.");
            this.service.start(layout);
            this.startShutdownListener(layout);
        }
        catch (Exception e) {
            LOG.error("Failed to start the service.", e);
            this.stop();
            System.exit(1);
        }
    }

    public void stop() {
        if (this.service != null) {
            try {
                LOG.info("Stopping the service.");
                this.service.stop();
                LOG.info("Service stopped successfully.");
            }
            catch (Exception e) {
                LOG.error("Failed to start the service.", e);
                System.exit(1);
            }
        }
    }

    private void startShutdownListener(final InstanceLayout layout) throws IOException {
        final int shutdownPort = this.getShutdownPort();
        final String shutdownPassword = UberjarMain.writeShutdownPassword(layout, UUID.randomUUID().toString());
        new Thread(new Runnable(){

            @Override
            public void run() {
                try (ServerSocket shutdownSocket = new ServerSocket(shutdownPort, 1, InetAddress.getLocalHost());){
                    Socket socket;
                    UberjarMain.writeShutdownPort(layout, shutdownSocket.getLocalPort());
                    LOG.info("Start the shutdown listener on port {}", (Object)shutdownSocket.getLocalPort());
                    while ((socket = shutdownSocket.accept()) != null) {
                        if (shutdownPassword == null || shutdownPassword.isEmpty()) {
                            UberjarMain.this.stop();
                            break;
                        }
                        try {
                            InputStreamReader reader = new InputStreamReader(socket.getInputStream());
                            CharBuffer buffer = CharBuffer.allocate(2048);
                            while (reader.read(buffer) >= 0) {
                            }
                            buffer.flip();
                            String password = buffer.toString();
                            reader.close();
                            if (shutdownPassword.equals(password)) {
                                UberjarMain.this.stop();
                                break;
                            }
                            LOG.warn("Illegal attempt to shutdown, incorrect password {}", (Object)password);
                        }
                        catch (IOException e) {
                            LOG.warn("Failed to handle the shutdown request", e);
                        }
                    }
                }
                catch (IOException e) {
                    LOG.error("Failed to start the shutdown listener, stopping the server", e);
                    UberjarMain.this.stop();
                }
            }
        }).start();
    }

    private static String writeShutdownPassword(InstanceLayout layout, String password) throws IOException {
        Files.write(Paths.get(layout.getRunDirectory().getAbsolutePath(), ".shutdown.pwd"), password.getBytes(Charset.forName("utf-8")), new OpenOption[0]);
        return password;
    }

    private static int writeShutdownPort(InstanceLayout layout, int portNumber) throws IOException {
        Files.write(Paths.get(layout.getRunDirectory().getAbsolutePath(), ".shutdown.port"), Integer.toString(portNumber).getBytes(Charset.forName("utf-8")), new OpenOption[0]);
        return portNumber;
    }

    private static enum Action {
        START,
        STOP;


        public static Action fromString(String actionString) {
            for (Action action : Action.values()) {
                if (!action.name().equalsIgnoreCase(actionString)) continue;
                return action;
            }
            throw new IllegalArgumentException("Unknown action " + actionString);
        }
    }
}

