/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.filter.ExprNode;

public class NotCursor<V, ID extends Comparable<ID>>
extends AbstractIndexCursor<V, Entry, ID> {
    private static final String UNSUPPORTED_MSG = I18n.err(I18n.ERR_718, new Object[0]);
    private final IndexCursor<V, Entry, ID> uuidCursor;
    private final Evaluator<? extends ExprNode, Entry, ID> childEvaluator;
    private boolean available = false;

    public NotCursor(Store<Entry, ID> store, Evaluator<? extends ExprNode, Entry, ID> childEvaluator) throws Exception {
        this.childEvaluator = childEvaluator;
        this.uuidCursor = store.getEntryUuidIndex().forwardCursor();
    }

    @Override
    public boolean available() {
        return this.available;
    }

    @Override
    public void beforeValue(ID id, V value) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public void before(IndexEntry<V, Entry, ID> element) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public void after(IndexEntry<V, Entry, ID> element) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public void afterValue(ID id, V value) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.uuidCursor.beforeFirst();
        this.available = false;
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.uuidCursor.afterLast();
        this.available = false;
    }

    @Override
    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    @Override
    public boolean previous() throws Exception {
        while (this.uuidCursor.previous()) {
            this.checkNotClosed("previous()");
            IndexEntry candidate = (IndexEntry)this.uuidCursor.get();
            if (this.childEvaluator.evaluate(candidate)) continue;
            this.available = true;
            return true;
        }
        this.available = false;
        return false;
    }

    @Override
    public boolean next() throws Exception {
        while (this.uuidCursor.next()) {
            this.checkNotClosed("next()");
            IndexEntry candidate = (IndexEntry)this.uuidCursor.get();
            if (this.childEvaluator.evaluate(candidate)) continue;
            this.available = true;
            return true;
        }
        this.available = false;
        return false;
    }

    @Override
    public IndexEntry<V, Entry, ID> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.available) {
            return (IndexEntry)this.uuidCursor.get();
        }
        throw new InvalidCursorPositionException(I18n.err(I18n.ERR_708, new Object[0]));
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.uuidCursor.close();
    }
}

