/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.filtering.BaseEntryFilteringCursor;
import org.apache.directory.server.core.filtering.EntryFilter;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchingOperationContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.schema.SchemaService;
import org.apache.directory.server.core.schema.SchemaSubentryManager;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.constants.SchemaConstants;
import org.apache.directory.shared.ldap.model.cursor.EmptyCursor;
import org.apache.directory.shared.ldap.model.cursor.SingletonCursor;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.BinaryValue;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.entry.DefaultModification;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapAttributeInUseException;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidAttributeTypeException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.shared.ldap.model.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.model.exception.LdapNoSuchAttributeException;
import org.apache.directory.shared.ldap.model.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.model.filter.ApproximateNode;
import org.apache.directory.shared.ldap.model.filter.AssertionNode;
import org.apache.directory.shared.ldap.model.filter.BranchNode;
import org.apache.directory.shared.ldap.model.filter.EqualityNode;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.filter.ExtensibleNode;
import org.apache.directory.shared.ldap.model.filter.GreaterEqNode;
import org.apache.directory.shared.ldap.model.filter.LessEqNode;
import org.apache.directory.shared.ldap.model.filter.PresenceNode;
import org.apache.directory.shared.ldap.model.filter.ScopeNode;
import org.apache.directory.shared.ldap.model.filter.SimpleNode;
import org.apache.directory.shared.ldap.model.filter.SubstringNode;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.name.Ava;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.AttributeTypeOptions;
import org.apache.directory.shared.ldap.model.schema.ObjectClass;
import org.apache.directory.shared.ldap.model.schema.ObjectClassTypeEnum;
import org.apache.directory.shared.ldap.model.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.model.schema.UsageEnum;
import org.apache.directory.shared.ldap.model.schema.registries.Schema;
import org.apache.directory.shared.ldap.model.schema.registries.SchemaLoader;
import org.apache.directory.shared.ldap.model.schema.syntaxCheckers.OctetStringSyntaxChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaInterceptor
extends BaseInterceptor {
    private static Logger LOG = LoggerFactory.getLogger(SchemaInterceptor.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private PartitionNexus nexus;
    private BinaryAttributeFilter binaryAttributeFilter;
    private TopFilter topFilter;
    private List<EntryFilter> filters = new ArrayList<EntryFilter>();
    private String subschemaSubentryDnNorm;
    private Dn subschemaSubentryDn;
    private Dn schemaModificationAttributesDn;
    private SchemaSubentryManager schemaSubEntryManager;
    private Dn schemaBaseDn;
    private Map<String, List<ObjectClass>> superiors;
    private Map<String, List<AttributeType>> allMay;
    private Map<String, List<AttributeType>> allMust;
    private Map<String, List<AttributeType>> allowed;

    @Override
    public void init(DirectoryService directoryService) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Initializing SchemaInterceptor...");
        }
        super.init(directoryService);
        this.nexus = directoryService.getPartitionNexus();
        this.binaryAttributeFilter = new BinaryAttributeFilter();
        this.topFilter = new TopFilter();
        this.filters.add(this.binaryAttributeFilter);
        this.filters.add(this.topFilter);
        this.schemaBaseDn = directoryService.getDnFactory().create("ou=schema");
        Value<?> subschemaSubentry = this.nexus.getRootDSE(null).get("subschemaSubentry").get();
        this.subschemaSubentryDn = directoryService.getDnFactory().create(subschemaSubentry.getString());
        this.subschemaSubentryDn.apply(this.schemaManager);
        this.subschemaSubentryDnNorm = this.subschemaSubentryDn.getNormName();
        this.schemaModificationAttributesDn = directoryService.getDnFactory().create("ou=schemaModifications,ou=schema");
        this.schemaModificationAttributesDn.apply(this.schemaManager);
        this.computeSuperiors();
        SchemaLoader loader = directoryService.getSchemaManager().getLoader();
        this.schemaSubEntryManager = new SchemaSubentryManager(this.schemaManager, loader, directoryService.getDnFactory());
        if (IS_DEBUG) {
            LOG.debug("SchemaInterceptor Initialized !");
        }
    }

    private void computeMustAttributes(ObjectClass objectClass, Set<String> atSeen) throws LdapException {
        List<ObjectClass> parents = this.superiors.get(objectClass.getOid());
        ArrayList<AttributeType> mustList = new ArrayList<AttributeType>();
        ArrayList<AttributeType> allowedList = new ArrayList<AttributeType>();
        HashSet<String> mustSeen = new HashSet<String>();
        this.allMust.put(objectClass.getOid(), mustList);
        this.allowed.put(objectClass.getOid(), allowedList);
        for (ObjectClass parent : parents) {
            List<AttributeType> mustParent = parent.getMustAttributeTypes();
            if (mustParent == null || mustParent.size() == 0) continue;
            for (AttributeType attributeType : mustParent) {
                String oid = attributeType.getOid();
                if (mustSeen.contains(oid)) continue;
                mustSeen.add(oid);
                mustList.add(attributeType);
                allowedList.add(attributeType);
                atSeen.add(attributeType.getOid());
            }
        }
    }

    private void computeMayAttributes(ObjectClass objectClass, Set<String> atSeen) throws LdapException {
        List<ObjectClass> parents = this.superiors.get(objectClass.getOid());
        ArrayList<AttributeType> mayList = new ArrayList<AttributeType>();
        HashSet<String> maySeen = new HashSet<String>();
        List<AttributeType> allowedList = this.allowed.get(objectClass.getOid());
        this.allMay.put(objectClass.getOid(), mayList);
        for (ObjectClass parent : parents) {
            List<AttributeType> mustParent = parent.getMustAttributeTypes();
            if (mustParent == null || mustParent.size() == 0) continue;
            for (AttributeType attributeType : mustParent) {
                String oid = attributeType.getOid();
                if (maySeen.contains(oid)) continue;
                maySeen.add(oid);
                mayList.add(attributeType);
                if (atSeen.contains(oid)) continue;
                allowedList.add(attributeType);
            }
        }
    }

    private void computeOCSuperiors(ObjectClass objectClass, List<ObjectClass> superiors, Set<String> ocSeen) throws LdapException {
        List<ObjectClass> parents = objectClass.getSuperiors();
        if (parents != null && parents.size() != 0) {
            for (ObjectClass parent : parents) {
                if ("top".equals(parent.getName())) continue;
                this.computeOCSuperiors(parent, superiors, ocSeen);
                String oid = parent.getOid();
                if (ocSeen.contains(oid)) continue;
                superiors.add(parent);
                ocSeen.add(oid);
            }
        }
    }

    private void computeSuperior(ObjectClass objectClass) throws LdapException {
        ArrayList<ObjectClass> ocSuperiors = new ArrayList<ObjectClass>();
        this.superiors.put(objectClass.getOid(), ocSuperiors);
        this.computeOCSuperiors(objectClass, ocSuperiors, new HashSet<String>());
        HashSet<String> atSeen = new HashSet<String>();
        this.computeMustAttributes(objectClass, atSeen);
        this.computeMayAttributes(objectClass, atSeen);
        this.superiors.put(objectClass.getName(), ocSuperiors);
    }

    private void computeSuperiors() throws LdapException {
        Iterator objectClasses = this.schemaManager.getObjectClassRegistry().iterator();
        this.superiors = new ConcurrentHashMap<String, List<ObjectClass>>();
        this.allMust = new ConcurrentHashMap<String, List<AttributeType>>();
        this.allMay = new ConcurrentHashMap<String, List<AttributeType>>();
        this.allowed = new ConcurrentHashMap<String, List<AttributeType>>();
        while (objectClasses.hasNext()) {
            ObjectClass objectClass = (ObjectClass)objectClasses.next();
            this.computeSuperior(objectClass);
        }
    }

    @Override
    public EntryFilteringCursor list(NextInterceptor nextInterceptor, ListOperationContext listContext) throws LdapException {
        EntryFilteringCursor cursor = nextInterceptor.list(listContext);
        cursor.addEntryFilter(this.binaryAttributeFilter);
        return cursor;
    }

    @Override
    public boolean compare(NextInterceptor next, CompareOperationContext compareContext) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", compareContext);
        }
        if (!this.schemaManager.getAttributeTypeRegistry().contains(compareContext.getOid())) {
            throw new LdapInvalidAttributeTypeException(I18n.err(I18n.ERR_266, compareContext.getOid()));
        }
        boolean result = next.compare(compareContext);
        return result;
    }

    private void filterAttributesToReturn(SearchControls searchCtls) {
        String[] attributes = searchCtls.getReturningAttributes();
        if (attributes == null || attributes.length == 0) {
            searchCtls.setReturningAttributes(SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
            return;
        }
        HashMap<String, String> filteredAttrs = new HashMap<String, String>();
        boolean hasNoAttribute = false;
        boolean hasAttributes = false;
        for (String attribute : attributes) {
            if ("*".equals(attribute) || "+".equals(attribute) || "1.1".equals(attribute)) {
                if (!filteredAttrs.containsKey(attribute)) {
                    filteredAttrs.put(attribute, attribute);
                }
                if ("1.1".equals(attribute)) {
                    hasNoAttribute = true;
                    continue;
                }
                hasAttributes = true;
                continue;
            }
            try {
                if (this.schemaManager.getAttributeTypeRegistry().contains(attribute)) {
                    String oid = this.schemaManager.getAttributeTypeRegistry().getOidByName(attribute);
                    if (this.schemaManager.getAttributeTypeRegistry().contains(oid) && !filteredAttrs.containsKey(oid)) {
                        filteredAttrs.put(oid, attribute);
                    }
                }
                hasAttributes = true;
            }
            catch (Exception ne) {
                // empty catch block
            }
        }
        if (hasAttributes && hasNoAttribute) {
            filteredAttrs.remove("1.1");
        }
        if (filteredAttrs.size() == attributes.length) {
            return;
        }
        if (filteredAttrs.size() == 0) {
            searchCtls.setReturningAttributes(SchemaConstants.NO_ATTRIBUTE_ARRAY);
            return;
        }
        String[] newAttributesList = new String[filteredAttrs.size()];
        int pos = 0;
        for (String key : filteredAttrs.keySet()) {
            newAttributesList[pos++] = (String)filteredAttrs.get(key);
        }
        searchCtls.setReturningAttributes(newAttributesList);
    }

    private Value<?> convert(AttributeType attributeType, Value<?> value) throws LdapException {
        if (attributeType.getSyntax().isHumanReadable()) {
            if (value instanceof BinaryValue) {
                try {
                    return new StringValue(attributeType, new String(((BinaryValue)value).getBytes(), "UTF-8"));
                }
                catch (UnsupportedEncodingException uee) {
                    String message = I18n.err(I18n.ERR_47, new Object[0]);
                    LOG.error(message);
                    throw new LdapException(message);
                }
            }
        } else if (value instanceof StringValue) {
            return new BinaryValue(attributeType, ((StringValue)value).getBytes());
        }
        return null;
    }

    private void checkFilter(ExprNode filter) throws LdapException {
        block7: {
            block5: {
                block10: {
                    block9: {
                        block8: {
                            block6: {
                                if (filter == null) {
                                    String message = I18n.err(I18n.ERR_49, new Object[0]);
                                    LOG.error(message);
                                    throw new LdapException(message);
                                }
                                if (!filter.isLeaf()) break block5;
                                if (!(filter instanceof EqualityNode)) break block6;
                                EqualityNode node = (EqualityNode)filter;
                                Value value = node.getValue();
                                Value<?> newValue = this.convert(node.getAttributeType(), value);
                                if (newValue != null) {
                                    node.setValue(newValue);
                                }
                                break block7;
                            }
                            if (filter instanceof SubstringNode || filter instanceof PresenceNode || filter instanceof AssertionNode || filter instanceof ScopeNode) break block7;
                            if (!(filter instanceof GreaterEqNode)) break block8;
                            GreaterEqNode node = (GreaterEqNode)filter;
                            Value value = node.getValue();
                            Value<?> newValue = this.convert(node.getAttributeType(), value);
                            if (newValue != null) {
                                node.setValue(newValue);
                            }
                            break block7;
                        }
                        if (!(filter instanceof LessEqNode)) break block9;
                        LessEqNode node = (LessEqNode)filter;
                        Value value = node.getValue();
                        Value<?> newValue = this.convert(node.getAttributeType(), value);
                        if (newValue != null) {
                            node.setValue(newValue);
                        }
                        break block7;
                    }
                    if (!(filter instanceof ExtensibleNode)) break block10;
                    ExtensibleNode node = (ExtensibleNode)filter;
                    break block7;
                }
                if (!(filter instanceof ApproximateNode)) break block7;
                ApproximateNode node = (ApproximateNode)filter;
                Value value = node.getValue();
                Value<?> newValue = this.convert(node.getAttributeType(), value);
                if (newValue == null) break block7;
                node.setValue(newValue);
                break block7;
            }
            for (ExprNode child : ((BranchNode)filter).getChildren()) {
                this.checkFilter(child);
            }
        }
    }

    @Override
    public EntryFilteringCursor search(NextInterceptor nextInterceptor, SearchOperationContext searchContext) throws LdapException {
        String baseNormForm;
        Dn base = searchContext.getDn();
        SearchControls searchCtls = searchContext.getSearchControls();
        ExprNode filter = searchContext.getFilter();
        if (searchCtls.getReturningAttributes() != null) {
            this.filterAttributesToReturn(searchCtls);
        }
        this.checkFilter(filter);
        String string = baseNormForm = base.isSchemaAware() ? base.getNormName() : base.getNormName();
        if (!this.subschemaSubentryDnNorm.equals(baseNormForm)) {
            EntryFilteringCursor cursor = nextInterceptor.search(searchContext);
            if (searchCtls.getReturningAttributes() != null) {
                cursor.addEntryFilter(this.topFilter);
                return cursor;
            }
            for (EntryFilter ef : this.filters) {
                cursor.addEntryFilter(ef);
            }
            return cursor;
        }
        if (searchCtls.getSearchScope() == 0) {
            PresenceNode node;
            if (filter instanceof SimpleNode) {
                SimpleNode node2 = (SimpleNode)filter;
                String objectClass = node2.getValue().getString();
                String objectClassOid = null;
                if (!this.schemaManager.getObjectClassRegistry().contains(objectClass)) {
                    return new BaseEntryFilteringCursor(new EmptyCursor<Entry>(), searchContext);
                }
                objectClassOid = this.schemaManager.lookupObjectClassRegistry(objectClass).getOid();
                AttributeType nodeAt = node2.getAttributeType();
                if (nodeAt.equals(OBJECT_CLASS_AT) && (objectClassOid.equals("2.5.6.0") || objectClassOid.equals("2.5.20.1")) && node2 instanceof EqualityNode) {
                    Entry serverEntry = SchemaService.getSubschemaEntry(this.directoryService, searchCtls.getReturningAttributes());
                    serverEntry.setDn(base);
                    return new BaseEntryFilteringCursor(new SingletonCursor<Entry>(serverEntry), searchContext);
                }
                return new BaseEntryFilteringCursor(new EmptyCursor<Entry>(), searchContext);
            }
            if (filter instanceof PresenceNode && (node = (PresenceNode)filter).getAttributeType().equals(OBJECT_CLASS_AT)) {
                Entry serverEntry = SchemaService.getSubschemaEntry(this.directoryService, searchCtls.getReturningAttributes());
                serverEntry.setDn(base);
                BaseEntryFilteringCursor cursor = new BaseEntryFilteringCursor(new SingletonCursor<Entry>(serverEntry), searchContext);
                return cursor;
            }
        }
        return new BaseEntryFilteringCursor(new EmptyCursor<Entry>(), searchContext);
    }

    @Override
    public Entry lookup(NextInterceptor nextInterceptor, LookupOperationContext lookupContext) throws LdapException {
        Entry result = nextInterceptor.lookup(lookupContext);
        this.filterBinaryAttributes(result);
        return result;
    }

    private void getSuperiors(ObjectClass oc, Set<String> ocSeen, List<ObjectClass> result) throws LdapException {
        for (ObjectClass parent : oc.getSuperiors()) {
            if ("top".equals(parent.getName())) continue;
            if (!ocSeen.contains(parent.getOid())) {
                ocSeen.add(parent.getOid());
                result.add(parent);
            }
            this.getSuperiors(parent, ocSeen, result);
        }
    }

    private boolean getObjectClasses(Attribute objectClasses, List<ObjectClass> result) throws LdapException {
        HashSet<String> ocSeen = new HashSet<String>();
        boolean hasExtensibleObject = false;
        for (Value objectClass : objectClasses) {
            ObjectClass oc;
            String objectClassName = objectClass.getString();
            if ("top".equals(objectClassName)) continue;
            if ("extensibleObject".equalsIgnoreCase(objectClassName)) {
                hasExtensibleObject = true;
            }
            if (!ocSeen.contains((oc = this.schemaManager.lookupObjectClassRegistry(objectClassName)).getOid())) {
                ocSeen.add(oc.getOid());
                result.add(oc);
            }
            this.getSuperiors(oc, ocSeen, result);
        }
        return hasExtensibleObject;
    }

    private Set<String> getAllMust(Attribute objectClasses) throws LdapException {
        HashSet<String> must = new HashSet<String>();
        for (Value value : objectClasses) {
            String ocName = value.getString();
            ObjectClass oc = this.schemaManager.lookupObjectClassRegistry(ocName);
            List<AttributeType> types = oc.getMustAttributeTypes();
            if (types == null || types.size() <= 0) continue;
            for (AttributeType type : types) {
                must.add(type.getOid());
            }
        }
        return must;
    }

    private Set<String> getAllAllowed(Attribute objectClasses, Set<String> must) throws LdapException {
        HashSet<String> allowed = new HashSet<String>(must);
        allowed.add("2.5.4.0");
        for (Value objectClass : objectClasses) {
            String ocName = objectClass.getString();
            ObjectClass oc = this.schemaManager.lookupObjectClassRegistry(ocName);
            List<AttributeType> types = oc.getMayAttributeTypes();
            if (types == null || types.size() <= 0) continue;
            for (AttributeType type : types) {
                String oid = type.getOid();
                allowed.add(oid);
            }
        }
        return allowed;
    }

    private void alterObjectClasses(Attribute objectClassAttr) throws LdapException {
        HashSet<String> objectClasses = new HashSet<String>();
        HashSet<String> objectClassesUP = new HashSet<String>();
        objectClasses.add("top");
        objectClassesUP.add("top");
        for (Value ocValue : objectClassAttr) {
            List<ObjectClass> ocSuperiors;
            String ocName = ocValue.getString();
            if (ocName.equalsIgnoreCase("top")) continue;
            String ocLowerName = ocName.toLowerCase();
            ObjectClass objectClass = this.schemaManager.lookupObjectClassRegistry(ocLowerName);
            if (!objectClasses.contains(ocLowerName)) {
                objectClasses.add(ocLowerName);
                objectClassesUP.add(ocName);
            }
            if ((ocSuperiors = this.superiors.get(objectClass.getOid())) == null) continue;
            for (ObjectClass oc : ocSuperiors) {
                if (objectClasses.contains(oc.getName().toLowerCase())) continue;
                objectClasses.add(oc.getName());
                objectClassesUP.add(oc.getName());
            }
        }
        objectClassAttr.clear();
        for (String attribute : objectClassesUP) {
            objectClassAttr.add(attribute);
        }
    }

    @Override
    public void rename(NextInterceptor next, RenameOperationContext renameContext) throws LdapException {
        Dn oldDn = renameContext.getDn();
        Rdn newRdn = renameContext.getNewRdn();
        boolean deleteOldRn = renameContext.getDeleteOldRdn();
        Entry entry = ((ClonedServerEntry)renameContext.getEntry()).getClonedEntry();
        if (deleteOldRn) {
            Rdn oldRdn = oldDn.getRdn();
            for (Ava atav : oldRdn) {
                AttributeType type = this.schemaManager.lookupAttributeTypeRegistry(atav.getUpType());
                entry.remove(type, atav.getUpValue());
            }
            for (Ava atav : oldRdn) {
                AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(atav.getUpType());
                if (attributeType.isUserModifiable()) continue;
                throw new LdapNoPermissionException("Cannot modify the attribute '" + atav.getUpType() + "'");
            }
        }
        for (Ava atav : newRdn) {
            AttributeType type = this.schemaManager.lookupAttributeTypeRegistry(atav.getUpType());
            if (entry.contains(type, atav.getNormValue())) continue;
            entry.add(new DefaultAttribute(type, atav.getNormValue()));
        }
        entry.setDn(renameContext.getNewDn());
        this.check(renameContext.getNewDn(), entry);
        next.rename(renameContext);
    }

    private Attribute createNewAttribute(Attribute attribute) throws LdapException {
        AttributeType attributeType = attribute.getAttributeType();
        DefaultAttribute newAttribute = new DefaultAttribute(attribute.getUpId(), attributeType);
        for (Value value : attribute) {
            newAttribute.add(value);
        }
        return newAttribute;
    }

    private void checkModifyEntry(Dn dn, Entry currentEntry, List<Modification> mods) throws LdapException {
        Entry tempEntry = currentEntry.clone();
        block5: for (Modification mod : mods) {
            Attribute attribute = mod.getAttribute();
            AttributeType attributeType = attribute.getAttributeType();
            if (!(attributeType.isUserModifiable() || attributeType.equals(MODIFIERS_NAME_AT) || attributeType.equals(MODIFY_TIMESTAMP_AT) || attributeType.equals(ENTRY_CSN_AT) || PWD_POLICY_STATE_ATTRIBUTE_TYPES.contains(attributeType))) {
                String msg = I18n.err(I18n.ERR_52, attributeType);
                LOG.error(msg);
                throw new LdapNoPermissionException(msg);
            }
            switch (mod.getOperation()) {
                case ADD_ATTRIBUTE: {
                    Attribute currentAttribute = tempEntry.get(attributeType);
                    if (currentAttribute != null) {
                        for (Value value : attribute) {
                            if (currentAttribute.contains(value)) {
                                String msg = I18n.err(I18n.ERR_54, value);
                                LOG.error(msg);
                                throw new LdapAttributeInUseException(msg);
                            }
                            currentAttribute.add(value);
                        }
                        continue block5;
                    }
                    Attribute newAttribute = attribute.clone();
                    if (newAttribute.size() == 0 && !newAttribute.isValid(attributeType)) {
                        String msg = I18n.err(I18n.ERR_54, null);
                        LOG.error(msg);
                        throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, msg);
                    }
                    tempEntry.put(newAttribute);
                    break;
                }
                case REMOVE_ATTRIBUTE: {
                    if (!tempEntry.containsAttribute(attributeType)) {
                        String msg = I18n.err(I18n.ERR_55, attributeType);
                        LOG.error(msg);
                        throw new LdapNoSuchAttributeException(msg);
                    }
                    if (attribute.size() == 0) {
                        tempEntry.removeAttributes(attributeType);
                        break;
                    }
                    Attribute currentAttribute = tempEntry.get(attributeType);
                    for (Value value : attribute) {
                        if (currentAttribute.contains(value)) {
                            currentAttribute.remove(value);
                            continue;
                        }
                        String msg = I18n.err(I18n.ERR_56, attributeType);
                        LOG.error(msg);
                        throw new LdapNoSuchAttributeException(msg);
                    }
                    if (currentAttribute.size() != 0) break;
                    tempEntry.removeAttributes(attributeType);
                    break;
                }
                case REPLACE_ATTRIBUTE: {
                    Attribute newAttribute;
                    if (!tempEntry.containsAttribute(attributeType)) {
                        if (attribute.size() == 0) break;
                        newAttribute = this.createNewAttribute(attribute);
                        tempEntry.put(newAttribute);
                        break;
                    }
                    if (attribute.size() == 0) {
                        tempEntry.removeAttributes(attributeType);
                        break;
                    }
                    tempEntry.removeAttributes(attributeType);
                    newAttribute = this.createNewAttribute(attribute);
                    tempEntry.put(newAttribute);
                }
            }
        }
        this.check(dn, tempEntry);
    }

    @Override
    public void modify(NextInterceptor next, ModifyOperationContext modifyContext) throws LdapException {
        Dn dn = modifyContext.getDn();
        if (dn.equals(this.subschemaSubentryDn)) {
            LOG.debug("Modification attempt on schema subentry {}: \n{}", dn, (Object)modifyContext);
            List<Modification> mods = modifyContext.getModItems();
            ArrayList<Modification> cleanMods = new ArrayList<Modification>();
            for (Modification mod : mods) {
                AttributeType at = ((DefaultModification)mod).getAttribute().getAttributeType();
                if (MODIFIERS_NAME_AT.equals(at) || MODIFY_TIMESTAMP_AT.equals(at)) continue;
                cleanMods.add(mod);
            }
            modifyContext.setModItems(cleanMods);
            this.schemaSubEntryManager.modifySchemaSubentry(modifyContext, modifyContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1"));
            return;
        }
        Entry entry = modifyContext.getEntry();
        List<Modification> modifications = modifyContext.getModItems();
        this.checkModifyEntry(dn, entry, modifications);
        next.modify(modifyContext);
    }

    private void filterAttributeTypes(SearchingOperationContext operation, Entry result) {
        if (operation.getReturningAttributes() == null) {
            return;
        }
        block2: for (AttributeTypeOptions attrOptions : operation.getReturningAttributes()) {
            Attribute attribute = result.get(attrOptions.getAttributeType());
            if (!attrOptions.hasOption()) continue;
            for (String option : attrOptions.getOptions()) {
                if ("binary".equalsIgnoreCase(option)) continue;
                try {
                    if (!result.contains(attribute)) continue block2;
                    result.remove(attribute);
                }
                catch (LdapException ne) {}
                continue block2;
            }
        }
    }

    private void filterBinaryAttributes(Entry entry) throws LdapException {
        for (Attribute attribute : entry) {
            if (attribute.getAttributeType().getSyntax().isHumanReadable()) continue;
            ArrayList<BinaryValue> binaries = new ArrayList<BinaryValue>();
            for (Value value : attribute) {
                attribute.add(value);
                binaries.add(new BinaryValue(attribute.getAttributeType(), value.getBytes()));
            }
            attribute.clear();
            for (Value value : binaries) {
                attribute.add(value);
            }
        }
    }

    private void check(Dn dn, Entry entry) throws LdapException {
        for (AttributeType attributeType : entry.getAttributeTypes()) {
            if (this.schemaManager.getAttributeTypeRegistry().contains(attributeType.getName())) continue;
            throw new LdapInvalidAttributeTypeException(I18n.err(I18n.ERR_275, attributeType.getName()));
        }
        Attribute objectClassAttr = entry.get(OBJECT_CLASS_AT);
        if (objectClassAttr == null) {
            objectClassAttr = new DefaultAttribute(OBJECT_CLASS_AT);
        }
        ArrayList<ObjectClass> ocs = new ArrayList<ObjectClass>();
        this.alterObjectClasses(objectClassAttr);
        Set<String> must = this.getAllMust(objectClassAttr);
        Set<String> allowed = this.getAllAllowed(objectClassAttr, must);
        boolean hasExtensibleObject = this.getObjectClasses(objectClassAttr, ocs);
        this.assertObjectClasses(dn, ocs);
        this.assertRequiredAttributesPresent(dn, entry, must);
        this.assertNumberOfAttributeValuesValid(entry);
        if (!hasExtensibleObject) {
            this.assertAllAttributesAllowed(dn, entry, allowed);
        }
        this.assertHumanReadable(entry);
        this.assertSyntaxes(entry);
        this.assertRdn(dn, entry);
    }

    private void checkOcSuperior(Entry entry) throws LdapException {
        Attribute supOC = entry.get("m-supObjectClass");
        if (supOC != null) {
            ObjectClassTypeEnum ocType = ObjectClassTypeEnum.STRUCTURAL;
            if (entry.get("m-typeObjectClass") != null) {
                String type = entry.get("m-typeObjectClass").getString();
                ocType = ObjectClassTypeEnum.getClassType(type);
            }
            for (Value sup : supOC) {
                try {
                    String supName = sup.getString();
                    ObjectClass superior = this.schemaManager.lookupObjectClassRegistry(supName);
                    switch (ocType) {
                        case ABSTRACT: {
                            if (superior.isAbstract()) break;
                            String message = I18n.err(I18n.ERR_57, new Object[0]);
                            LOG.error(message);
                            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, message);
                        }
                        case AUXILIARY: {
                            if (superior.isAbstract() || superior.isAuxiliary()) break;
                            String message = I18n.err(I18n.ERR_58, new Object[0]);
                            LOG.error(message);
                            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, message);
                        }
                    }
                }
                catch (LdapException ne) {
                    String message = I18n.err(I18n.ERR_59, new Object[0]);
                    LOG.error(message);
                    throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, message);
                }
            }
        }
    }

    @Override
    public void add(NextInterceptor next, AddOperationContext addContext) throws LdapException {
        Dn name = addContext.getDn();
        Entry entry = addContext.getEntry();
        this.check(name, entry);
        if (name.isDescendantOf(this.schemaBaseDn)) {
            String schemaName = this.getSchemaName(name);
            if (entry.contains(OBJECT_CLASS_AT, "metaSchema")) {
                next.add(addContext);
                if (this.schemaManager.isSchemaLoaded(schemaName)) {
                    this.computeSuperiors();
                }
            } else if (entry.contains(OBJECT_CLASS_AT, "metaObjectClass")) {
                this.checkOcSuperior(addContext.getEntry());
                next.add(addContext);
                Schema schema = this.schemaManager.getLoadedSchema(schemaName);
                if (schema != null && schema.isEnabled()) {
                    Attribute oidAT = entry.get("m-oid");
                    String ocOid = oidAT.getString();
                    ObjectClass addedOC = this.schemaManager.lookupObjectClassRegistry(ocOid);
                    this.computeSuperior(addedOC);
                }
            } else if (entry.contains(OBJECT_CLASS_AT, "metaAttributeType")) {
                next.add(addContext);
            } else {
                next.add(addContext);
            }
        } else {
            next.add(addContext);
        }
    }

    private String getSchemaName(Dn dn) throws LdapException {
        int size = dn.size();
        if (size < 2) {
            throw new LdapException(I18n.err(I18n.ERR_276, new Object[0]));
        }
        Rdn rdn = dn.getRdn(size - 2);
        return rdn.getNormValue().getString();
    }

    private void assertAllAttributesAllowed(Dn dn, Entry entry, Set<String> allowed) throws LdapException {
        Attribute objectClass = entry.get(OBJECT_CLASS_AT);
        if (objectClass.contains("extensibleObject")) {
            return;
        }
        for (Attribute attribute : entry) {
            String attrOid = attribute.getAttributeType().getOid();
            AttributeType attributeType = attribute.getAttributeType();
            if (attributeType.isCollective() || attributeType.getUsage() != UsageEnum.USER_APPLICATIONS || allowed.contains(attrOid)) continue;
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, I18n.err(I18n.ERR_277, attribute.getUpId(), dn.getName()));
        }
    }

    private void assertNumberOfAttributeValuesValid(Entry entry) throws LdapInvalidAttributeValueException {
        for (Attribute attribute : entry) {
            this.assertNumberOfAttributeValuesValid(attribute);
        }
    }

    private void assertNumberOfAttributeValuesValid(Attribute attribute) throws LdapInvalidAttributeValueException {
        if (attribute.size() > 1 && attribute.getAttributeType().isSingleValued()) {
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.CONSTRAINT_VIOLATION, I18n.err(I18n.ERR_278, attribute.getUpId()));
        }
    }

    private void assertRequiredAttributesPresent(Dn dn, Entry entry, Set<String> must) throws LdapException {
        for (Attribute attribute : entry) {
            must.remove(attribute.getAttributeType().getOid());
        }
        if (must.size() != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            for (String oid : must) {
                String name = this.schemaManager.getAttributeType(oid).getName();
                sb.append(name).append('(').append(oid).append("), ");
            }
            int end = sb.length();
            sb.replace(end - 2, end, "");
            sb.append(']');
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, I18n.err(I18n.ERR_279, sb, dn.getName()));
        }
    }

    private void assertObjectClasses(Dn dn, List<ObjectClass> ocs) throws LdapException {
        HashSet<ObjectClass> structuralObjectClasses = new HashSet<ObjectClass>();
        for (ObjectClass oc : ocs) {
            if (!oc.isStructural()) continue;
            structuralObjectClasses.add(oc);
        }
        if (structuralObjectClasses.isEmpty()) {
            String message = I18n.err(I18n.ERR_60, dn);
            LOG.error(message);
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, message);
        }
        HashSet<ObjectClass> remaining = new HashSet<ObjectClass>(structuralObjectClasses.size());
        remaining.addAll(structuralObjectClasses);
        for (ObjectClass oc : structuralObjectClasses) {
            if (oc.getSuperiors() == null) continue;
            for (ObjectClass superClass : oc.getSuperiors()) {
                if (!superClass.isStructural()) continue;
                remaining.remove(superClass);
            }
        }
        if (remaining.size() > 1) {
            String message = I18n.err(I18n.ERR_61, dn, remaining);
            LOG.error(message);
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, message);
        }
    }

    private void assertSyntaxes(Entry entry) throws LdapException {
        for (Attribute attribute : entry) {
            AttributeType attributeType = attribute.getAttributeType();
            SyntaxChecker syntaxChecker = attributeType.getSyntax().getSyntaxChecker();
            if (syntaxChecker instanceof OctetStringSyntaxChecker) continue;
            for (Value value : attribute) {
                if (value.isSchemaAware()) continue;
                try {
                    syntaxChecker.assertSyntax(value.getValue());
                }
                catch (Exception ne) {
                    String message = I18n.err(I18n.ERR_280, value.getString(), attribute.getUpId());
                    LOG.info(message);
                    throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, message);
                }
            }
        }
    }

    private void assertRdn(Dn dn, Entry entry) throws LdapException {
        for (Ava atav : dn.getRdn()) {
            Attribute attribute = entry.get(atav.getNormType());
            if (attribute != null && attribute.contains(atav.getNormValue())) continue;
            String message = I18n.err(I18n.ERR_62, dn, atav.getUpType());
            LOG.error(message);
            throw new LdapSchemaViolationException(ResultCodeEnum.NOT_ALLOWED_ON_RDN, message);
        }
    }

    private boolean checkHumanReadable(Attribute attribute) throws LdapException {
        boolean isModified = false;
        for (Value value : attribute) {
            if (value instanceof StringValue) continue;
            if (value instanceof BinaryValue) {
                try {
                    String valStr = new String(value.getBytes(), "UTF-8");
                    attribute.remove(value);
                    attribute.add(valStr);
                    isModified = true;
                    continue;
                }
                catch (UnsupportedEncodingException uee) {
                    throw new LdapException(I18n.err(I18n.ERR_281, new Object[0]));
                }
            }
            throw new LdapException(I18n.err(I18n.ERR_282, new Object[0]));
        }
        return isModified;
    }

    private boolean checkNotHumanReadable(Attribute attribute) throws LdapException {
        boolean isModified = false;
        for (Value value : attribute) {
            if (value instanceof BinaryValue) continue;
            if (value instanceof StringValue) {
                try {
                    byte[] valBytes = value.getString().getBytes("UTF-8");
                    attribute.remove(value);
                    attribute.add(new byte[][]{valBytes});
                    isModified = true;
                    continue;
                }
                catch (UnsupportedEncodingException uee) {
                    String message = I18n.err(I18n.ERR_63, new Object[0]);
                    LOG.error(message);
                    throw new LdapException(message);
                }
            }
            String message = I18n.err(I18n.ERR_64, new Object[0]);
            LOG.error(message);
            throw new LdapException(message);
        }
        return isModified;
    }

    private void assertHumanReadable(Entry entry) throws LdapException {
        boolean isModified = false;
        Entry clonedEntry = null;
        for (Attribute attribute : entry) {
            AttributeType attributeType = attribute.getAttributeType();
            isModified = attributeType.getSyntax().isHumanReadable() ? this.checkHumanReadable(attribute) : this.checkNotHumanReadable(attribute);
            if (!isModified) continue;
            if (clonedEntry == null) {
                clonedEntry = entry.clone();
            }
            clonedEntry.put(attribute);
            isModified = false;
        }
        if (clonedEntry != null) {
            entry = clonedEntry;
        }
    }

    private class TopFilter
    implements EntryFilter {
        private TopFilter() {
        }

        @Override
        public boolean accept(SearchingOperationContext operation, Entry entry) throws Exception {
            SchemaInterceptor.this.filterAttributeTypes(operation, entry);
            return true;
        }
    }

    private class BinaryAttributeFilter
    implements EntryFilter {
        private BinaryAttributeFilter() {
        }

        @Override
        public boolean accept(SearchingOperationContext operation, Entry entry) throws Exception {
            SchemaInterceptor.this.filterBinaryAttributes(entry);
            return true;
        }
    }
}

