/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor.context;

import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.interceptor.context.AbstractChangeOperationContext;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.message.AddRequest;
import org.apache.directory.shared.ldap.model.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;

public class AddOperationContext
extends AbstractChangeOperationContext {
    public AddOperationContext(CoreSession session) {
        super(session);
    }

    public AddOperationContext(CoreSession session, Dn dn) {
        super(session, dn);
    }

    public AddOperationContext(CoreSession session, Entry entry) {
        super(session, entry.getDn());
        this.entry = new ClonedServerEntry(entry);
    }

    public AddOperationContext(CoreSession session, Dn dn, Entry entry) {
        super(session, dn);
        this.entry = new ClonedServerEntry(entry);
    }

    public AddOperationContext(CoreSession session, AddRequest addRequest) throws LdapException {
        super(session);
        this.entry = new ClonedServerEntry(new DefaultEntry(session.getDirectoryService().getSchemaManager(), addRequest.getEntry()));
        this.dn = addRequest.getEntry().getDn();
        this.requestControls = addRequest.getControls();
        if (this.requestControls.containsKey("2.16.840.1.113730.3.4.2")) {
            this.ignoreReferral();
        } else {
            this.throwReferral();
        }
    }

    @Override
    public String getName() {
        return MessageTypeEnum.ADD_REQUEST.name();
    }

    public String toString() {
        return "AddContext for Dn '" + this.getDn().getName() + "'" + ", added entry: " + this.entry;
    }
}

