/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core;

import java.util.ArrayList;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.OperationManager;
import org.apache.directory.server.core.ReferralManager;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.InterceptorChain;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetRootDSEOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapAffectMultipleDsaException;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapOperationErrorException;
import org.apache.directory.shared.ldap.model.exception.LdapPartialResultException;
import org.apache.directory.shared.ldap.model.exception.LdapReferralException;
import org.apache.directory.shared.ldap.model.exception.LdapServiceUnavailableException;
import org.apache.directory.shared.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.url.LdapUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOperationManager
implements OperationManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOperationManager.class);
    private static final Logger LOG_CHANGES = LoggerFactory.getLogger("LOG_CHANGES");
    private final DirectoryService directoryService;

    public DefaultOperationManager(DirectoryService directoryService) {
        this.directoryService = directoryService;
    }

    private LdapReferralException buildReferralException(Entry parentEntry, Dn childDn) throws LdapException {
        Attribute refs = parentEntry.get("ref");
        ArrayList<String> urls = new ArrayList<String>();
        try {
            for (Value url : refs) {
                LdapUrl ldapUrl = new LdapUrl(url.getString());
                Dn urlDn = ldapUrl.getDn().add(childDn);
                ldapUrl.setDn(urlDn);
                urls.add(ldapUrl.toString());
            }
        }
        catch (LdapURLEncodingException luee) {
            throw new LdapOperationErrorException(luee.getMessage(), luee);
        }
        LdapReferralException lre = new LdapReferralException(urls);
        lre.setRemainingDn(childDn);
        lre.setResolvedDn(parentEntry.getDn());
        lre.setResolvedObject(parentEntry);
        return lre;
    }

    private LdapReferralException buildReferralExceptionForSearch(Entry parentEntry, Dn childDn, SearchScope scope) throws LdapException {
        Attribute refs = parentEntry.get("ref");
        ArrayList<String> urls = new ArrayList<String>();
        for (Value url : refs) {
            try {
                LdapUrl ldapUrl = new LdapUrl(url.getString());
                StringBuilder urlString = new StringBuilder();
                if (ldapUrl.getDn() == null || ldapUrl.getDn() == Dn.ROOT_DSE) {
                    ldapUrl.setDn(parentEntry.getDn());
                } else {
                    Dn urlDn = ldapUrl.getDn().add(childDn);
                    ldapUrl.setDn(urlDn);
                }
                urlString.append(ldapUrl.toString()).append("??");
                switch (scope) {
                    case OBJECT: {
                        urlString.append("base");
                        break;
                    }
                    case SUBTREE: {
                        urlString.append("sub");
                        break;
                    }
                    case ONELEVEL: {
                        urlString.append("one");
                    }
                }
                urls.add(urlString.toString());
            }
            catch (LdapURLEncodingException luee) {
                urls.add(url.getString());
            }
        }
        LdapReferralException lre = new LdapReferralException(urls);
        lre.setRemainingDn(childDn);
        lre.setResolvedDn(parentEntry.getDn());
        lre.setResolvedObject(parentEntry);
        return lre;
    }

    private LdapPartialResultException buildLdapPartialResultException(Dn childDn) {
        LdapPartialResultException lpre = new LdapPartialResultException(I18n.err(I18n.ERR_315, new Object[0]));
        lpre.setRemainingDn(childDn);
        lpre.setResolvedDn(Dn.EMPTY_DN);
        return lpre;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(AddOperationContext addContext) throws LdapException {
        LOG.debug(">> AddOperation : {}", addContext);
        LOG_CHANGES.debug(">> AddOperation : {}", addContext);
        this.ensureStarted();
        this.push(addContext);
        try {
            Dn dn = addContext.getDn();
            dn.apply(this.directoryService.getSchemaManager());
            this.directoryService.getReferralManager().lockRead();
            if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
                Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                if (addContext.isReferralIgnored()) {
                    this.directoryService.getReferralManager().unlock();
                    LdapPartialResultException exception = this.buildLdapPartialResultException(childDn);
                    throw exception;
                }
                this.directoryService.getReferralManager().unlock();
                LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                throw exception;
            }
            this.directoryService.getReferralManager().unlock();
            InterceptorChain interceptorChain = this.directoryService.getInterceptorChain();
            interceptorChain.add(addContext);
        }
        finally {
            this.pop();
        }
        LOG.debug("<< AddOperation successful");
        LOG_CHANGES.debug("<< AddOperation successful");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(BindOperationContext bindContext) throws LdapException {
        LOG.debug(">> BindOperation : {}", bindContext);
        this.ensureStarted();
        this.push(bindContext);
        try {
            this.directoryService.getInterceptorChain().bind(bindContext);
        }
        finally {
            this.pop();
            LOG.debug("<< BindOperation successful");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compare(CompareOperationContext compareContext) throws LdapException {
        LOG.debug(">> CompareOperation : {}", compareContext);
        this.ensureStarted();
        this.push(compareContext);
        try {
            Dn dn = compareContext.getDn();
            dn.apply(this.directoryService.getSchemaManager());
            this.directoryService.getReferralManager().lockRead();
            Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
            if (parentEntry != null) {
                Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                if (this.directoryService.getReferralManager().isReferral(dn)) {
                    if (!compareContext.isReferralIgnored()) {
                        this.directoryService.getReferralManager().unlock();
                        LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                        throw exception;
                    }
                } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                    if (compareContext.isReferralIgnored()) {
                        this.directoryService.getReferralManager().unlock();
                        LdapPartialResultException exception = this.buildLdapPartialResultException(childDn);
                        throw exception;
                    }
                    this.directoryService.getReferralManager().unlock();
                    LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                    throw exception;
                }
            }
            this.directoryService.getReferralManager().unlock();
            InterceptorChain interceptorChain = this.directoryService.getInterceptorChain();
            boolean bl = interceptorChain.compare(compareContext);
            return bl;
        }
        finally {
            this.pop();
            LOG.debug("<< CompareOperation successful");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(DeleteOperationContext deleteContext) throws LdapException {
        LOG.debug(">> DeleteOperation : {}", deleteContext);
        LOG_CHANGES.debug(">> DeleteOperation : {}", deleteContext);
        this.ensureStarted();
        this.push(deleteContext);
        try {
            Dn dn = deleteContext.getDn();
            dn.apply(this.directoryService.getSchemaManager());
            this.directoryService.getReferralManager().lockRead();
            Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
            if (parentEntry != null) {
                Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                if (this.directoryService.getReferralManager().isReferral(dn)) {
                    if (!deleteContext.isReferralIgnored()) {
                        this.directoryService.getReferralManager().unlock();
                        LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                        throw exception;
                    }
                } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                    if (deleteContext.isReferralIgnored()) {
                        this.directoryService.getReferralManager().unlock();
                        LdapPartialResultException exception = this.buildLdapPartialResultException(childDn);
                        throw exception;
                    }
                    this.directoryService.getReferralManager().unlock();
                    LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                    throw exception;
                }
            }
            this.directoryService.getReferralManager().unlock();
            InterceptorChain interceptorChain = this.directoryService.getInterceptorChain();
            interceptorChain.delete(deleteContext);
        }
        finally {
            this.pop();
        }
        LOG.debug("<< DeleteOperation successful");
        LOG_CHANGES.debug("<< DeleteOperation successful");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry getRootDSE(GetRootDSEOperationContext getRootDseContext) throws LdapException {
        LOG.debug(">> GetRootDSEOperation : {}", getRootDseContext);
        this.ensureStarted();
        this.push(getRootDseContext);
        try {
            InterceptorChain chain = this.directoryService.getInterceptorChain();
            Entry entry = chain.getRootDSE(getRootDseContext);
            return entry;
        }
        finally {
            this.pop();
            LOG.debug("<< getRootDSEOperation successful");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasEntry(EntryOperationContext hasEntryContext) throws LdapException {
        LOG.debug(">> hasEntryOperation : {}", hasEntryContext);
        this.ensureStarted();
        this.push(hasEntryContext);
        try {
            boolean bl = this.directoryService.getInterceptorChain().hasEntry(hasEntryContext);
            return bl;
        }
        finally {
            this.pop();
            LOG.debug("<< HasEntryOperation successful");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntryFilteringCursor list(ListOperationContext listContext) throws LdapException {
        LOG.debug(">> ListOperation : {}", listContext);
        this.ensureStarted();
        this.push(listContext);
        try {
            EntryFilteringCursor entryFilteringCursor = this.directoryService.getInterceptorChain().list(listContext);
            return entryFilteringCursor;
        }
        finally {
            this.pop();
            LOG.debug("<< ListOperation successful");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        LOG.debug(">> LookupOperation : {}", lookupContext);
        this.ensureStarted();
        this.push(lookupContext);
        try {
            InterceptorChain chain = this.directoryService.getInterceptorChain();
            Entry entry = chain.lookup(lookupContext);
            return entry;
        }
        finally {
            this.pop();
            LOG.debug("<< LookupOperation successful");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        LOG.debug(">> ModifyOperation : {}", modifyContext);
        LOG_CHANGES.debug(">> ModifyOperation : {}", modifyContext);
        this.ensureStarted();
        this.push(modifyContext);
        try {
            Dn dn = modifyContext.getDn();
            dn.apply(this.directoryService.getSchemaManager());
            ReferralManager referralManager = this.directoryService.getReferralManager();
            referralManager.lockRead();
            Entry parentEntry = referralManager.getParentReferral(dn);
            if (parentEntry != null) {
                if (referralManager.isReferral(dn)) {
                    if (!modifyContext.isReferralIgnored()) {
                        referralManager.unlock();
                        Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                        LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                        throw exception;
                    }
                } else if (referralManager.hasParentReferral(dn)) {
                    if (modifyContext.isReferralIgnored()) {
                        referralManager.unlock();
                        Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                        LdapPartialResultException exception = this.buildLdapPartialResultException(childDn);
                        throw exception;
                    }
                    referralManager.unlock();
                    Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                    LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                    throw exception;
                }
            }
            referralManager.unlock();
            InterceptorChain interceptorChain = this.directoryService.getInterceptorChain();
            interceptorChain.modify(modifyContext);
        }
        finally {
            this.pop();
            LOG.debug("<< ModifyOperation successful");
            LOG_CHANGES.debug("<< ModifyOperation successful");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(MoveOperationContext moveContext) throws LdapException {
        LOG.debug(">> MoveOperation : {}", moveContext);
        LOG_CHANGES.debug(">> MoveOperation : {}", moveContext);
        this.ensureStarted();
        this.push(moveContext);
        try {
            Dn dn = moveContext.getDn();
            dn.apply(this.directoryService.getSchemaManager());
            Dn newSuperiorDn = moveContext.getNewSuperior();
            newSuperiorDn.apply(this.directoryService.getSchemaManager());
            this.directoryService.getReferralManager().lockRead();
            Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
            if (parentEntry != null) {
                Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                if (this.directoryService.getReferralManager().isReferral(dn)) {
                    if (!moveContext.isReferralIgnored()) {
                        this.directoryService.getReferralManager().unlock();
                        LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                        throw exception;
                    }
                } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                    if (moveContext.isReferralIgnored()) {
                        this.directoryService.getReferralManager().unlock();
                        LdapPartialResultException exception = this.buildLdapPartialResultException(childDn);
                        throw exception;
                    }
                    this.directoryService.getReferralManager().unlock();
                    LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                    throw exception;
                }
            }
            if (this.directoryService.getReferralManager().isReferral(newSuperiorDn) || this.directoryService.getReferralManager().hasParentReferral(newSuperiorDn)) {
                this.directoryService.getReferralManager().unlock();
                LdapAffectMultipleDsaException exception = new LdapAffectMultipleDsaException();
                throw exception;
            }
            this.directoryService.getReferralManager().unlock();
            InterceptorChain interceptorChain = this.directoryService.getInterceptorChain();
            interceptorChain.move(moveContext);
        }
        finally {
            this.pop();
            LOG.debug("<< MoveOperation successful");
            LOG_CHANGES.debug("<< MoveOperation successful");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        LOG.debug(">> MoveAndRenameOperation : {}", moveAndRenameContext);
        LOG_CHANGES.debug(">> MoveAndRenameOperation : {}", moveAndRenameContext);
        this.ensureStarted();
        this.push(moveAndRenameContext);
        try {
            Dn dn = moveAndRenameContext.getDn();
            dn.apply(this.directoryService.getSchemaManager());
            this.directoryService.getReferralManager().lockRead();
            Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
            if (parentEntry != null) {
                Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                if (this.directoryService.getReferralManager().isReferral(dn)) {
                    if (!moveAndRenameContext.isReferralIgnored()) {
                        this.directoryService.getReferralManager().unlock();
                        LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                        throw exception;
                    }
                } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                    if (moveAndRenameContext.isReferralIgnored()) {
                        this.directoryService.getReferralManager().unlock();
                        LdapPartialResultException exception = this.buildLdapPartialResultException(childDn);
                        throw exception;
                    }
                    this.directoryService.getReferralManager().unlock();
                    LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                    throw exception;
                }
            }
            Dn newSuperiorDn = moveAndRenameContext.getNewSuperiorDn();
            newSuperiorDn.apply(this.directoryService.getSchemaManager());
            if (this.directoryService.getReferralManager().isReferral(newSuperiorDn) || this.directoryService.getReferralManager().hasParentReferral(newSuperiorDn)) {
                this.directoryService.getReferralManager().unlock();
                LdapAffectMultipleDsaException exception = new LdapAffectMultipleDsaException();
                throw exception;
            }
            this.directoryService.getReferralManager().unlock();
            InterceptorChain interceptorChain = this.directoryService.getInterceptorChain();
            interceptorChain.moveAndRename(moveAndRenameContext);
        }
        finally {
            this.pop();
            LOG.debug("<< MoveAndRenameOperation successful");
            LOG_CHANGES.debug("<< MoveAndRenameOperation successful");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(RenameOperationContext renameContext) throws LdapException {
        LOG.debug(">> RenameOperation : {}", renameContext);
        LOG_CHANGES.debug(">> RenameOperation : {}", renameContext);
        this.ensureStarted();
        this.push(renameContext);
        try {
            Dn dn = renameContext.getDn();
            dn.apply(this.directoryService.getSchemaManager());
            if (!dn.isEmpty()) {
                Dn newDn = dn.getParent();
                newDn = newDn.add(renameContext.getNewRdn());
                renameContext.setNewDn(newDn);
            }
            this.directoryService.getReferralManager().lockRead();
            Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
            if (parentEntry != null) {
                Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                if (this.directoryService.getReferralManager().isReferral(dn)) {
                    if (!renameContext.isReferralIgnored()) {
                        this.directoryService.getReferralManager().unlock();
                        LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                        throw exception;
                    }
                } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                    if (renameContext.isReferralIgnored()) {
                        this.directoryService.getReferralManager().unlock();
                        LdapPartialResultException exception = this.buildLdapPartialResultException(childDn);
                        throw exception;
                    }
                    this.directoryService.getReferralManager().unlock();
                    LdapReferralException exception = this.buildReferralException(parentEntry, childDn);
                    throw exception;
                }
            }
            this.directoryService.getReferralManager().unlock();
            InterceptorChain interceptorChain = this.directoryService.getInterceptorChain();
            interceptorChain.rename(renameContext);
        }
        finally {
            this.pop();
            LOG.debug("<< RenameOperation successful");
            LOG_CHANGES.debug("<< RenameOperation successful");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        LOG.debug(">> SearchOperation : {}", searchContext);
        this.ensureStarted();
        this.push(searchContext);
        try {
            Dn dn = searchContext.getDn();
            dn.apply(this.directoryService.getSchemaManager());
            this.directoryService.getReferralManager().lockRead();
            Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
            if (parentEntry != null) {
                Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                if (this.directoryService.getReferralManager().isReferral(dn)) {
                    if (!searchContext.isReferralIgnored()) {
                        this.directoryService.getReferralManager().unlock();
                        LdapReferralException exception = this.buildReferralExceptionForSearch(parentEntry, childDn, searchContext.getScope());
                        throw exception;
                    }
                } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                    if (searchContext.isReferralIgnored()) {
                        this.directoryService.getReferralManager().unlock();
                        LdapPartialResultException exception = this.buildLdapPartialResultException(childDn);
                        throw exception;
                    }
                    this.directoryService.getReferralManager().unlock();
                    LdapReferralException exception = this.buildReferralExceptionForSearch(parentEntry, childDn, searchContext.getScope());
                    throw exception;
                }
            }
            this.directoryService.getReferralManager().unlock();
            InterceptorChain interceptorChain = this.directoryService.getInterceptorChain();
            EntryFilteringCursor entryFilteringCursor = interceptorChain.search(searchContext);
            return entryFilteringCursor;
        }
        finally {
            this.pop();
            LOG.debug("<< SearchOperation successful");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(UnbindOperationContext unbindContext) throws LdapException {
        LOG.debug(">> UnbindOperation : {}", unbindContext);
        this.ensureStarted();
        this.push(unbindContext);
        try {
            this.directoryService.getInterceptorChain().unbind(unbindContext);
        }
        finally {
            this.pop();
        }
        LOG.debug("<< UnbindOperation successful");
    }

    private void ensureStarted() throws LdapServiceUnavailableException {
        if (!this.directoryService.isStarted()) {
            throw new LdapServiceUnavailableException(ResultCodeEnum.UNAVAILABLE, I18n.err(I18n.ERR_316, new Object[0]));
        }
    }

    private void pop() {
        InvocationStack stack = InvocationStack.getInstance();
        stack.pop();
    }

    private void push(OperationContext opContext) {
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(opContext);
    }
}

