/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.directory.server.config.ConfigPartitionReader;
import org.apache.directory.server.config.LdifConfigExtractor;
import org.apache.directory.server.config.ServiceBuilder;
import org.apache.directory.server.config.beans.ConfigBean;
import org.apache.directory.server.config.beans.DirectoryServiceBean;
import org.apache.directory.server.config.beans.HttpServerBean;
import org.apache.directory.server.config.beans.KdcServerBean;
import org.apache.directory.server.config.beans.LdapServerBean;
import org.apache.directory.server.config.beans.NtpServerBean;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.InstanceLayout;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.ldif.LdifPartition;
import org.apache.directory.server.core.partition.ldif.SingleFileLdifPartition;
import org.apache.directory.server.core.schema.SchemaPartition;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.integration.http.HttpServer;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ntp.NtpServer;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.entry.DefaultModification;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.ModificationOperation;
import org.apache.directory.shared.ldap.model.filter.PresenceNode;
import org.apache.directory.shared.ldap.model.message.AliasDerefMode;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.AttributeTypeOptions;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.syntaxCheckers.CsnSyntaxChecker;
import org.apache.directory.shared.ldap.model.schema.syntaxCheckers.GeneralizedTimeSyntaxChecker;
import org.apache.directory.shared.ldap.model.schema.syntaxCheckers.UuidSyntaxChecker;
import org.apache.directory.shared.ldap.schemaextractor.impl.DefaultSchemaLdifExtractor;
import org.apache.directory.shared.ldap.schemaloader.LdifSchemaLoader;
import org.apache.directory.shared.ldap.schemamanager.impl.DefaultSchemaManager;
import org.apache.directory.shared.util.DateUtils;
import org.apache.directory.shared.util.exception.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheDsService {
    private static final Logger LOG = LoggerFactory.getLogger(ApacheDsService.class);
    private LdapServer ldapServer;
    private NtpServer ntpServer;
    private KdcServer kdcServer;
    private HttpServer httpServer;
    private LdifPartition schemaLdifPartition;
    private SchemaManager schemaManager;
    private SingleFileLdifPartition configPartition;
    private ConfigPartitionReader cpReader;
    private UuidSyntaxChecker uuidChecker = new UuidSyntaxChecker();
    private CsnSyntaxChecker csnChecker = new CsnSyntaxChecker();
    private GeneralizedTimeSyntaxChecker timeChecker = new GeneralizedTimeSyntaxChecker();
    private static final Map<String, AttributeTypeOptions> MANDATORY_ENTRY_ATOP_MAP = new HashMap<String, AttributeTypeOptions>();
    private boolean isConfigPartitionFirstExtraction = false;
    private boolean isSchemaPartitionFirstExtraction = false;
    private static final String BANNER_LDAP = "           _                     _          ____  ____   \n          / \\   _ __    ___  ___| |__   ___|  _ \\/ ___|  \n         / _ \\ | '_ \\ / _` |/ __| '_ \\ / _ \\ | | \\___ \\  \n        / ___ \\| |_) | (_| | (__| | | |  __/ |_| |___) | \n       /_/   \\_\\ .__/ \\__,_|\\___|_| |_|\\___|____/|____/  \n               |_|                                       \n";
    private static final String BANNER_NTP = "           _                     _          _   _ _____ _ __    \n          / \\   _ __    ___  ___| |__   ___| \\ | |_  __| '_ \\   \n         / _ \\ | '_ \\ / _` |/ __| '_ \\ / _ \\ .\\| | | | | |_) |  \n        / ___ \\| |_) | (_| | (__| | | |  __/ |\\  | | | | .__/   \n       /_/   \\_\\ .__/ \\__,_|\\___|_| |_|\\___|_| \\_| |_| |_|      \n               |_|                                              \n";
    private static final String BANNER_KERBEROS = "           _                     _          _  __ ____   ___    \n          / \\   _ __    ___  ___| |__   ___| |/ /|  _ \\ / __|   \n         / _ \\ | '_ \\ / _` |/ __| '_ \\ / _ \\ ' / | | | / /      \n        / ___ \\| |_) | (_| | (__| | | |  __/ . \\ | |_| \\ \\__    \n       /_/   \\_\\ .__/ \\__,_|\\___|_| |_|\\___|_|\\_\\|____/ \\___|   \n               |_|                                              \n";
    private static final String BANNER_CHANGE_PWD = "         ___                              ___ __  __ __  ______    \n        / __|_       ___ _ __   ____  ___|  _ \\ \\ \\ / / / |  _ \\   \n       / /  | |__  / _` | '  \\ / ___\\/ _ \\ |_) \\ \\ / /\\/ /| | | |  \n       \\ \\__| '_  \\ (_| | |\\  | |___ | __/  __/ \\ ' /   / | |_| |  \n        \\___|_| |_|\\__,_|_| |_|\\__. |\\___| |     \\_/ \\_/  |____/   \n                                  |_|    |_|                       \n";

    public void start(InstanceLayout instanceLayout) throws Exception {
        File partitionsDir = instanceLayout.getPartitionsDirectory();
        if (!partitionsDir.exists()) {
            LOG.info("partition directory doesn't exist, creating {}", (Object)partitionsDir.getAbsolutePath());
            partitionsDir.mkdirs();
        }
        LOG.info("using partition dir {}", (Object)partitionsDir.getAbsolutePath());
        this.initSchemaManager(instanceLayout);
        this.initSchemaLdifPartition(instanceLayout);
        this.initConfigPartition(instanceLayout);
        this.cpReader = new ConfigPartitionReader(this.configPartition);
        ConfigBean configBean = this.cpReader.readConfig();
        DirectoryServiceBean directoryServiceBean = configBean.getDirectoryServiceBean();
        DirectoryService directoryService = this.initDirectoryService(instanceLayout, directoryServiceBean);
        this.startLdap(directoryServiceBean.getLdapServerBean(), directoryService);
        this.startNtp(directoryServiceBean.getNtpServerBean(), directoryService);
        this.startKerberos(directoryServiceBean.getKdcServerBean(), directoryService);
        this.startHttpServer(directoryServiceBean.getHttpServerBean(), directoryService);
    }

    private void initSchemaManager(InstanceLayout instanceLayout) throws Exception {
        File schemaPartitionDirectory = new File(instanceLayout.getPartitionsDirectory(), "schema");
        if (schemaPartitionDirectory.exists()) {
            LOG.info("schema partition already exists, skipping schema extraction");
        } else {
            DefaultSchemaLdifExtractor extractor = new DefaultSchemaLdifExtractor(instanceLayout.getPartitionsDirectory());
            extractor.extractOrCopy();
            this.isSchemaPartitionFirstExtraction = true;
        }
        LdifSchemaLoader loader = new LdifSchemaLoader(schemaPartitionDirectory);
        this.schemaManager = new DefaultSchemaManager(loader);
        this.schemaManager.loadAllEnabled();
        List<Throwable> errors = this.schemaManager.getErrors();
        if (errors.size() != 0) {
            throw new Exception(I18n.err(I18n.ERR_317, Exceptions.printErrors(errors)));
        }
    }

    private void initSchemaLdifPartition(InstanceLayout instanceLayout) throws Exception {
        File schemaPartitionDirectory = new File(instanceLayout.getPartitionsDirectory(), "schema");
        this.schemaLdifPartition = new LdifPartition(this.schemaManager);
        this.schemaLdifPartition.setPartitionPath(schemaPartitionDirectory.toURI());
    }

    private void initConfigPartition(InstanceLayout instanceLayout) throws Exception {
        File confFile = new File(instanceLayout.getConfDirectory(), "config.ldif");
        if (confFile.exists()) {
            LOG.info("config partition already exists, skipping default config extraction");
        } else {
            LdifConfigExtractor.extractSingleFileConfig(instanceLayout.getConfDirectory(), "config.ldif", true);
            this.isConfigPartitionFirstExtraction = true;
        }
        this.configPartition = new SingleFileLdifPartition(this.schemaManager);
        this.configPartition.setId("config");
        this.configPartition.setPartitionPath(confFile.toURI());
        this.configPartition.setSuffixDn(new Dn(this.schemaManager, "ou=config"));
        this.configPartition.setSchemaManager(this.schemaManager);
        this.configPartition.initialize();
    }

    private DirectoryService initDirectoryService(InstanceLayout instanceLayout, DirectoryServiceBean directoryServiceBean) throws Exception {
        LOG.info("Initializing the DirectoryService...");
        long startTime = System.currentTimeMillis();
        DirectoryService directoryService = ServiceBuilder.createDirectoryService(directoryServiceBean, instanceLayout, this.schemaManager);
        SchemaPartition schemaPartition = new SchemaPartition(this.schemaManager);
        schemaPartition.setWrappedPartition(this.schemaLdifPartition);
        directoryService.setSchemaPartition(schemaPartition);
        directoryService.addPartition(this.configPartition);
        directoryService.setInstanceLayout(instanceLayout);
        directoryService.startup();
        AttributeType ocAt = this.schemaManager.lookupAttributeTypeRegistry("objectClass");
        MANDATORY_ENTRY_ATOP_MAP.put(ocAt.getName(), new AttributeTypeOptions(ocAt));
        AttributeType uuidAt = this.schemaManager.lookupAttributeTypeRegistry("entryUUID");
        MANDATORY_ENTRY_ATOP_MAP.put(uuidAt.getName(), new AttributeTypeOptions(uuidAt));
        AttributeType csnAt = this.schemaManager.lookupAttributeTypeRegistry("entryCSN");
        MANDATORY_ENTRY_ATOP_MAP.put(csnAt.getName(), new AttributeTypeOptions(csnAt));
        AttributeType creatorAt = this.schemaManager.lookupAttributeTypeRegistry("creatorsName");
        MANDATORY_ENTRY_ATOP_MAP.put(creatorAt.getName(), new AttributeTypeOptions(creatorAt));
        AttributeType createdTimeAt = this.schemaManager.lookupAttributeTypeRegistry("createTimestamp");
        MANDATORY_ENTRY_ATOP_MAP.put(createdTimeAt.getName(), new AttributeTypeOptions(createdTimeAt));
        if (this.isConfigPartitionFirstExtraction) {
            LOG.info("begining to update config partition LDIF files after modifying manadatory attributes");
            this.configPartition.setEnableRewriting(false);
            this.updateMandatoryOpAttributes(this.configPartition, directoryService);
            this.configPartition.setEnableRewriting(true);
            LOG.info("config partition data was successfully updated");
        }
        if (this.isSchemaPartitionFirstExtraction) {
            LOG.info("begining to update schema partition LDIF files after modifying manadatory attributes");
            this.updateMandatoryOpAttributes(this.schemaLdifPartition, directoryService);
            LOG.info("schema partition data was successfully updated");
        }
        LOG.info("DirectoryService initialized in {} milliseconds", System.currentTimeMillis() - startTime);
        return directoryService;
    }

    private void startLdap(LdapServerBean ldapServerBean, DirectoryService directoryService) throws Exception {
        LOG.info("Starting the LDAP server");
        long startTime = System.currentTimeMillis();
        this.ldapServer = ServiceBuilder.createLdapServer(ldapServerBean, directoryService);
        if (this.ldapServer == null) {
            LOG.info("Cannot find any reference to the LDAP Server in the configuration : the server won't be started");
            return;
        }
        ApacheDsService.printBanner(BANNER_LDAP);
        this.ldapServer.setDirectoryService(directoryService);
        try {
            this.ldapServer.start();
        }
        catch (Exception e) {
            LOG.error("Cannot start the server : " + e.getMessage());
        }
        LOG.info("LDAP server: started in {} milliseconds", (Object)(System.currentTimeMillis() - startTime + ""));
    }

    private void startNtp(NtpServerBean ntpServerBean, DirectoryService directoryService) throws Exception {
        LOG.info("Starting the NTP server");
        long startTime = System.currentTimeMillis();
        this.ntpServer = ServiceBuilder.createNtpServer(ntpServerBean, directoryService);
        if (this.ntpServer == null) {
            LOG.info("Cannot find any reference to the NTP Server in the configuration : the server won't be started");
            return;
        }
        ApacheDsService.printBanner(BANNER_NTP);
        this.ntpServer.start();
        if (LOG.isInfoEnabled()) {
            LOG.info("NTP server: started in {} milliseconds", (Object)(System.currentTimeMillis() - startTime + ""));
        }
    }

    private void startKerberos(KdcServerBean kdcServerBean, DirectoryService directoryService) throws Exception {
        LOG.info("Starting the Kerberos server");
        long startTime = System.currentTimeMillis();
        this.kdcServer = ServiceBuilder.createKdcServer(kdcServerBean, directoryService);
        if (this.kdcServer == null) {
            LOG.info("Cannot find any reference to the Kerberos Server in the configuration : the server won't be started");
            return;
        }
        this.getDirectoryService().startup();
        this.kdcServer.setDirectoryService(this.getDirectoryService());
        ApacheDsService.printBanner(BANNER_KERBEROS);
        this.kdcServer.start();
        if (LOG.isInfoEnabled()) {
            LOG.info("Kerberos server: started in {} milliseconds", (Object)(System.currentTimeMillis() - startTime + ""));
        }
    }

    private void startHttpServer(HttpServerBean httpServerBean, DirectoryService directoryService) throws Exception {
        this.httpServer = ServiceBuilder.createHttpServer(httpServerBean, directoryService);
        if (this.httpServer == null) {
            LOG.info("Cannot find any reference to the HTTP Server in the configuration : the server won't be started");
            return;
        }
        LOG.info("Starting the Http server");
        long startTime = System.currentTimeMillis();
        this.httpServer.start(this.getDirectoryService());
        if (LOG.isInfoEnabled()) {
            LOG.info("Http server: started in {} milliseconds", (Object)(System.currentTimeMillis() - startTime + ""));
        }
    }

    public DirectoryService getDirectoryService() {
        return this.ldapServer.getDirectoryService();
    }

    public void synch() throws Exception {
        this.ldapServer.getDirectoryService().sync();
    }

    public void stop() throws Exception {
        if (this.ldapServer != null) {
            this.ldapServer.stop();
        }
        if (this.kdcServer != null) {
            this.kdcServer.stop();
        }
        if (this.ntpServer != null) {
            this.ntpServer.stop();
        }
        if (this.httpServer != null) {
            this.httpServer.stop();
        }
        this.ldapServer.getDirectoryService().shutdown();
    }

    public static void printBanner(String bannerConstant) {
        System.out.println(bannerConstant);
    }

    public void updateMandatoryOpAttributes(Partition partition, DirectoryService dirService) throws Exception {
        CoreSession session = dirService.getAdminSession();
        String adminDn = session.getEffectivePrincipal().getName();
        PresenceNode filter = new PresenceNode("objectClass");
        EntryFilteringCursor cursor = session.search(partition.getSuffixDn(), SearchScope.SUBTREE, filter, AliasDerefMode.NEVER_DEREF_ALIASES, new HashSet<AttributeTypeOptions>(MANDATORY_ENTRY_ATOP_MAP.values()));
        cursor.beforeFirst();
        ArrayList<Modification> mods = new ArrayList<Modification>();
        while (cursor.next()) {
            String createdTime;
            String creator;
            String csn;
            String uuid;
            AttributeType atType;
            Entry entry = (Entry)cursor.get();
            Attribute uuidAt = entry.get(atType = MANDATORY_ENTRY_ATOP_MAP.get("entryUUID").getAttributeType());
            String string = uuid = uuidAt == null ? null : uuidAt.getString();
            if (!this.uuidChecker.isValidSyntax(uuid)) {
                uuidAt = new DefaultAttribute(atType, UUID.randomUUID().toString());
            }
            DefaultModification uuidMod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, uuidAt);
            mods.add(uuidMod);
            atType = MANDATORY_ENTRY_ATOP_MAP.get("entryCSN").getAttributeType();
            Attribute csnAt = entry.get(atType);
            String string2 = csn = csnAt == null ? null : csnAt.getString();
            if (!this.csnChecker.isValidSyntax(csn)) {
                csnAt = new DefaultAttribute(atType, dirService.getCSN().toString());
            }
            DefaultModification csnMod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, csnAt);
            mods.add(csnMod);
            atType = MANDATORY_ENTRY_ATOP_MAP.get("creatorsName").getAttributeType();
            Attribute creatorAt = entry.get(atType);
            String string3 = creator = creatorAt == null ? "" : creatorAt.getString().trim();
            if (creator.length() == 0 || !Dn.isValid(creator)) {
                creatorAt = new DefaultAttribute(atType, adminDn);
            }
            DefaultModification creatorMod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, creatorAt);
            mods.add(creatorMod);
            atType = MANDATORY_ENTRY_ATOP_MAP.get("createTimestamp").getAttributeType();
            Attribute createdTimeAt = entry.get(atType);
            String string4 = createdTime = createdTimeAt == null ? null : createdTimeAt.getString();
            if (!this.timeChecker.isValidSyntax(createdTime)) {
                createdTimeAt = new DefaultAttribute(atType, DateUtils.getGeneralizedTime());
            }
            DefaultModification createdMod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, createdTimeAt);
            mods.add(createdMod);
            if (!mods.isEmpty()) {
                LOG.debug("modifying the entry {} after adding missing manadatory operational attributes", entry.getDn());
                ModifyOperationContext modifyContext = new ModifyOperationContext(session);
                modifyContext.setEntry(entry);
                modifyContext.setDn(entry.getDn());
                modifyContext.setModItems(mods);
                partition.modify(modifyContext);
            }
            mods.clear();
        }
        cursor.close();
    }
}

