/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import jdbm.recman.BlockIo;
import jdbm.recman.FileHeader;
import jdbm.recman.PageHeader;
import jdbm.recman.RecordFile;
import org.apache.directory.server.i18n.I18n;

final class PageManager {
    private RecordFile recordFile;
    private FileHeader header;
    private BlockIo headerBuf;

    PageManager(RecordFile recordFile) throws IOException {
        this.recordFile = recordFile;
        this.headerBuf = recordFile.get(0L);
        this.header = this.headerBuf.readShort(0) == 0 ? new FileHeader(this.headerBuf, true) : new FileHeader(this.headerBuf, false);
    }

    long allocate(short type) throws IOException {
        if (type == 0) {
            throw new Error(I18n.err(I18n.ERR_548, new Object[0]));
        }
        boolean isNew = false;
        long retval = this.header.getFirstOf(0);
        if (retval != 0L) {
            this.header.setFirstOf(0, this.getNext(retval));
        } else {
            retval = this.header.getLastOf(0);
            if (retval == 0L) {
                retval = 1L;
            }
            this.header.setLastOf(0, retval + 1L);
            isNew = true;
        }
        BlockIo buf = this.recordFile.get(retval);
        PageHeader pageHdr = null;
        pageHdr = isNew ? new PageHeader(buf, type) : PageHeader.getView(buf);
        long oldLast = this.header.getLastOf(type);
        System.arraycopy(RecordFile.cleanData, 0, buf.getData(), 0, 8192);
        pageHdr.setType(type);
        pageHdr.setPrev(oldLast);
        pageHdr.setNext(0L);
        if (oldLast == 0L) {
            this.header.setFirstOf(type, retval);
        }
        this.header.setLastOf(type, retval);
        this.recordFile.release(retval, true);
        if (oldLast != 0L) {
            buf = this.recordFile.get(oldLast);
            pageHdr = PageHeader.getView(buf);
            pageHdr.setNext(retval);
            this.recordFile.release(oldLast, true);
        }
        buf.setView(null);
        return retval;
    }

    void free(short type, long recid) throws IOException {
        if (type == 0) {
            throw new Error(I18n.err(I18n.ERR_549, new Object[0]));
        }
        if (recid == 0L) {
            throw new Error(I18n.err(I18n.ERR_550, new Object[0]));
        }
        BlockIo buf = this.recordFile.get(recid);
        PageHeader pageHdr = PageHeader.getView(buf);
        long prev = pageHdr.getPrev();
        long next = pageHdr.getNext();
        pageHdr.setType((short)0);
        pageHdr.setNext(this.header.getFirstOf(0));
        pageHdr.setPrev(0L);
        this.header.setFirstOf(0, recid);
        this.recordFile.release(recid, true);
        if (prev != 0L) {
            buf = this.recordFile.get(prev);
            pageHdr = PageHeader.getView(buf);
            pageHdr.setNext(next);
            this.recordFile.release(prev, true);
        } else {
            this.header.setFirstOf(type, next);
        }
        if (next != 0L) {
            buf = this.recordFile.get(next);
            pageHdr = PageHeader.getView(buf);
            pageHdr.setPrev(prev);
            this.recordFile.release(next, true);
        } else {
            this.header.setLastOf(type, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getNext(long block) throws IOException {
        try {
            long l = PageHeader.getView(this.recordFile.get(block)).getNext();
            return l;
        }
        finally {
            this.recordFile.release(block, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getPrev(long block) throws IOException {
        try {
            long l = PageHeader.getView(this.recordFile.get(block)).getPrev();
            return l;
        }
        finally {
            this.recordFile.release(block, false);
        }
    }

    long getFirst(short type) throws IOException {
        return this.header.getFirstOf(type);
    }

    long getLast(short type) throws IOException {
        return this.header.getLastOf(type);
    }

    void commit() throws IOException {
        this.recordFile.release(this.headerBuf);
        this.recordFile.commit();
        this.headerBuf = this.recordFile.get(0L);
        this.header = new FileHeader(this.headerBuf, false);
    }

    void rollback() throws IOException {
        this.recordFile.discard(this.headerBuf);
        this.recordFile.rollback();
        this.headerBuf = this.recordFile.get(0L);
        this.header = this.headerBuf.readShort(0) == 0 ? new FileHeader(this.headerBuf, true) : new FileHeader(this.headerBuf, false);
    }

    void close() throws IOException {
        this.recordFile.release(this.headerBuf);
        this.recordFile.commit();
        this.headerBuf = null;
        this.header = null;
        this.recordFile = null;
    }

    FileHeader getFileHeader() {
        return this.header;
    }

    RecordFile getRecordFile() {
        return this.recordFile;
    }
}

