/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.operational;

import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapNoPermissionException;
import org.apache.directory.api.ldap.model.name.Ava;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.util.DateUtils;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.filtering.EntryFilter;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.shared.SchemaService;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationalAttributeInterceptor
extends BaseInterceptor {
    private static Logger LOG = LoggerFactory.getLogger(OperationalAttributeInterceptor.class);
    private final EntryFilter DENORMALIZING_SEARCH_FILTER = new OperationalAttributeDenormalizingSearchFilter();
    private Dn subschemaSubentryDn;
    private Dn adminDn;

    public OperationalAttributeInterceptor() {
        super(InterceptorEnum.OPERATIONAL_ATTRIBUTE_INTERCEPTOR);
    }

    @Override
    public void init(DirectoryService directoryService) throws LdapException {
        super.init(directoryService);
        Value<?> subschemaSubentry = directoryService.getPartitionNexus().getRootDseValue(SUBSCHEMA_SUBENTRY_AT);
        this.subschemaSubentryDn = this.dnFactory.create(subschemaSubentry.getString());
        this.adminDn = this.dnFactory.create("uid=admin,ou=system");
    }

    @Override
    public void destroy() {
    }

    private boolean checkAddOperationalAttribute(boolean isAdmin, Entry entry, AttributeType attribute) throws LdapException {
        if (entry.containsAttribute(attribute)) {
            if (!isAdmin) {
                String message = I18n.err(I18n.ERR_30, attribute);
                LOG.error(message);
                throw new LdapNoPermissionException(message);
            }
            return true;
        }
        return false;
    }

    @Override
    public void add(AddOperationContext addContext) throws LdapException {
        String principal = OperationalAttributeInterceptor.getPrincipal(addContext).getName();
        Entry entry = addContext.getEntry();
        boolean isAdmin = addContext.getSession().getAuthenticatedPrincipal().getName().equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
        if (!this.checkAddOperationalAttribute(isAdmin, entry, ENTRY_UUID_AT)) {
            entry.put(ENTRY_UUID_AT, UUID.randomUUID().toString());
        }
        if (!this.checkAddOperationalAttribute(isAdmin, entry, ENTRY_CSN_AT)) {
            entry.put(ENTRY_CSN_AT, this.directoryService.getCSN().toString());
        }
        if (!this.checkAddOperationalAttribute(isAdmin, entry, CREATORS_NAME_AT)) {
            entry.put(CREATORS_NAME_AT, principal);
        }
        if (!this.checkAddOperationalAttribute(isAdmin, entry, CREATE_TIMESTAMP_AT)) {
            entry.put(CREATE_TIMESTAMP_AT, DateUtils.getGeneralizedTime());
        }
        this.checkAddOperationalAttribute(isAdmin, entry, ACCESS_CONTROL_SUBENTRIES_AT);
        this.checkAddOperationalAttribute(isAdmin, entry, COLLECTIVE_ATTRIBUTE_SUBENTRIES_AT);
        this.checkAddOperationalAttribute(isAdmin, entry, TRIGGER_EXECUTION_SUBENTRIES_AT);
        this.checkAddOperationalAttribute(isAdmin, entry, SUBSCHEMA_SUBENTRY_AT);
        this.next(addContext);
    }

    @Override
    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        Dn dn = lookupContext.getDn();
        if (dn.equals(this.subschemaSubentryDn)) {
            Entry serverEntry = SchemaService.getSubschemaEntry(this.directoryService, lookupContext);
            serverEntry.setDn(dn);
            return serverEntry;
        }
        Entry result = this.next(lookupContext);
        this.denormalizeEntryOpAttrs(result);
        return result;
    }

    @Override
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        List<Modification> mods = modifyContext.getModItems();
        boolean isAdmin = modifyContext.getSession().getAuthenticatedPrincipal().getDn().equals(this.adminDn);
        boolean modifierAtPresent = false;
        boolean modifiedTimeAtPresent = false;
        boolean entryCsnAtPresent = false;
        Dn dn = modifyContext.getDn();
        for (Modification modification : mods) {
            AttributeType attributeType = modification.getAttribute().getAttributeType();
            if (attributeType.equals(MODIFIERS_NAME_AT)) {
                if (!isAdmin) {
                    String message = I18n.err(I18n.ERR_31, new Object[0]);
                    LOG.error(message);
                    throw new LdapNoPermissionException(message);
                }
                modifierAtPresent = true;
            }
            if (attributeType.equals(MODIFY_TIMESTAMP_AT)) {
                if (!isAdmin) {
                    String message = I18n.err(I18n.ERR_30, attributeType);
                    LOG.error(message);
                    throw new LdapNoPermissionException(message);
                }
                modifiedTimeAtPresent = true;
            }
            if (attributeType.equals(ENTRY_CSN_AT)) {
                if (!isAdmin) {
                    String message = I18n.err(I18n.ERR_30, attributeType);
                    LOG.error(message);
                    throw new LdapNoPermissionException(message);
                }
                entryCsnAtPresent = true;
            }
            if (!PWD_POLICY_STATE_ATTRIBUTE_TYPES.contains(attributeType) || isAdmin) continue;
            String message = I18n.err(I18n.ERR_30, attributeType);
            LOG.error(message);
            throw new LdapNoPermissionException(message);
        }
        if (!dn.equals(this.subschemaSubentryDn)) {
            DefaultAttribute attribute;
            if (!modifierAtPresent) {
                attribute = new DefaultAttribute(MODIFIERS_NAME_AT, OperationalAttributeInterceptor.getPrincipal(modifyContext).getName());
                DefaultModification modifiersName = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, attribute);
                mods.add(modifiersName);
            }
            if (!modifiedTimeAtPresent) {
                attribute = new DefaultAttribute(MODIFY_TIMESTAMP_AT, DateUtils.getGeneralizedTime());
                DefaultModification timestamp = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, attribute);
                mods.add(timestamp);
            }
            if (!entryCsnAtPresent) {
                String csn = this.directoryService.getCSN().toString();
                DefaultAttribute attribute2 = new DefaultAttribute(ENTRY_CSN_AT, csn);
                DefaultModification updatedCsn = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, attribute2);
                mods.add(updatedCsn);
            }
        }
        this.next(modifyContext);
    }

    @Override
    public void move(MoveOperationContext moveContext) throws LdapException {
        Entry modifiedEntry = moveContext.getOriginalEntry().clone();
        modifiedEntry.put("modifiersName", OperationalAttributeInterceptor.getPrincipal(moveContext).getName());
        modifiedEntry.put("modifyTimestamp", DateUtils.getGeneralizedTime());
        DefaultAttribute csnAt = new DefaultAttribute(ENTRY_CSN_AT, this.directoryService.getCSN().toString());
        modifiedEntry.put(csnAt);
        modifiedEntry.setDn(moveContext.getNewDn());
        moveContext.setModifiedEntry(modifiedEntry);
        this.next(moveContext);
    }

    @Override
    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        Entry modifiedEntry = moveAndRenameContext.getOriginalEntry().clone();
        modifiedEntry.put("modifiersName", OperationalAttributeInterceptor.getPrincipal(moveAndRenameContext).getName());
        modifiedEntry.put("modifyTimestamp", DateUtils.getGeneralizedTime());
        modifiedEntry.setDn(moveAndRenameContext.getNewDn());
        DefaultAttribute csnAt = new DefaultAttribute(ENTRY_CSN_AT, this.directoryService.getCSN().toString());
        modifiedEntry.put(csnAt);
        moveAndRenameContext.setModifiedEntry(modifiedEntry);
        this.next(moveAndRenameContext);
    }

    @Override
    public void rename(RenameOperationContext renameContext) throws LdapException {
        Entry entry = ((ClonedServerEntry)renameContext.getEntry()).getClonedEntry();
        entry.put("modifiersName", OperationalAttributeInterceptor.getPrincipal(renameContext).getName());
        entry.put("modifyTimestamp", DateUtils.getGeneralizedTime());
        Entry modifiedEntry = renameContext.getOriginalEntry().clone();
        modifiedEntry.put("modifiersName", OperationalAttributeInterceptor.getPrincipal(renameContext).getName());
        modifiedEntry.put("modifyTimestamp", DateUtils.getGeneralizedTime());
        DefaultAttribute csnAt = new DefaultAttribute(ENTRY_CSN_AT, this.directoryService.getCSN().toString());
        modifiedEntry.put(csnAt);
        renameContext.setModifiedEntry(modifiedEntry);
        this.next(renameContext);
    }

    @Override
    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        EntryFilteringCursor cursor = this.next(searchContext);
        if (searchContext.isAllOperationalAttributes() || searchContext.getReturningAttributes() != null && !searchContext.getReturningAttributes().isEmpty()) {
            if (this.directoryService.isDenormalizeOpAttrsEnabled()) {
                cursor.addEntryFilter(this.DENORMALIZING_SEARCH_FILTER);
            }
            return cursor;
        }
        return cursor;
    }

    @Override
    public void delete(DeleteOperationContext deleteContext) throws LdapException {
        Entry entry = deleteContext.getEntry();
        DefaultAttribute csnAt = new DefaultAttribute(ENTRY_CSN_AT, this.directoryService.getCSN().toString());
        entry.put(csnAt);
        this.next(deleteContext);
    }

    private void denormalizeEntryOpAttrs(Entry entry) throws LdapException {
        if (this.directoryService.isDenormalizeOpAttrsEnabled()) {
            Dn modifiersName;
            Attribute attr = entry.get("creatorsName");
            if (attr != null) {
                Dn creatorsName = this.dnFactory.create(attr.getString());
                attr.clear();
                attr.add(this.denormalizeTypes(creatorsName).getName());
            }
            if ((attr = entry.get("modifiersName")) != null) {
                modifiersName = this.dnFactory.create(attr.getString());
                attr.clear();
                attr.add(this.denormalizeTypes(modifiersName).getName());
            }
            if ((attr = entry.get("schemaModifiersName")) != null) {
                modifiersName = this.dnFactory.create(attr.getString());
                attr.clear();
                attr.add(this.denormalizeTypes(modifiersName).getName());
            }
        }
    }

    private Dn denormalizeTypes(Dn dn) throws LdapException {
        Dn newDn = new Dn(this.schemaManager);
        int size = dn.size();
        for (int pos = 0; pos < size; ++pos) {
            Rdn rdn = dn.getRdn(size - 1 - pos);
            if (rdn.size() == 0) {
                newDn = newDn.add(new Rdn());
                continue;
            }
            if (rdn.size() == 1) {
                String name = this.schemaManager.lookupAttributeTypeRegistry(rdn.getNormType()).getName();
                String value = rdn.getNormValue().getString();
                newDn = newDn.add(new Rdn(name, value));
                continue;
            }
            StringBuffer buf = new StringBuffer();
            Iterator<Ava> atavs = rdn.iterator();
            while (atavs.hasNext()) {
                Ava atav = atavs.next();
                String type = this.schemaManager.lookupAttributeTypeRegistry(rdn.getNormType()).getName();
                buf.append(type).append('=').append(atav.getNormValue());
                if (!atavs.hasNext()) continue;
                buf.append('+');
            }
            newDn = newDn.add(new Rdn(buf.toString()));
        }
        return newDn;
    }

    private class OperationalAttributeDenormalizingSearchFilter
    implements EntryFilter {
        private OperationalAttributeDenormalizingSearchFilter() {
        }

        @Override
        public boolean accept(SearchOperationContext operation, Entry entry) throws LdapException {
            if (operation.getReturningAttributesString() == null) {
                return true;
            }
            OperationalAttributeInterceptor.this.denormalizeEntryOpAttrs(entry);
            return true;
        }

        @Override
        public String toString(String tabs) {
            return tabs + "OperationalAttributeDenormalizingSearchFilter";
        }
    }
}

