/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.directory.mavibot.btree.AbstractBTree;
import org.apache.directory.mavibot.btree.AbstractPage;
import org.apache.directory.mavibot.btree.AbstractTransactionManager;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BTreeFactory;
import org.apache.directory.mavibot.btree.BTreeHeader;
import org.apache.directory.mavibot.btree.BTreeTypeEnum;
import org.apache.directory.mavibot.btree.KeyHolder;
import org.apache.directory.mavibot.btree.MavibotInspector;
import org.apache.directory.mavibot.btree.NameRevision;
import org.apache.directory.mavibot.btree.NameRevisionSerializer;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.PageHolder;
import org.apache.directory.mavibot.btree.PageIO;
import org.apache.directory.mavibot.btree.PersistedBTree;
import org.apache.directory.mavibot.btree.PersistedBTreeConfiguration;
import org.apache.directory.mavibot.btree.PersistedKeyHolder;
import org.apache.directory.mavibot.btree.PersistedLeaf;
import org.apache.directory.mavibot.btree.PersistedNode;
import org.apache.directory.mavibot.btree.PersistedPageHolder;
import org.apache.directory.mavibot.btree.PersistedValueHolder;
import org.apache.directory.mavibot.btree.ReadTransaction;
import org.apache.directory.mavibot.btree.RevisionName;
import org.apache.directory.mavibot.btree.SpaceReclaimer;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.TupleCursor;
import org.apache.directory.mavibot.btree.ValueHolder;
import org.apache.directory.mavibot.btree.exception.BTreeAlreadyManagedException;
import org.apache.directory.mavibot.btree.exception.BTreeCreationException;
import org.apache.directory.mavibot.btree.exception.EndOfFileExceededException;
import org.apache.directory.mavibot.btree.exception.FileException;
import org.apache.directory.mavibot.btree.exception.InvalidOffsetException;
import org.apache.directory.mavibot.btree.exception.KeyNotFoundException;
import org.apache.directory.mavibot.btree.exception.RecordManagerException;
import org.apache.directory.mavibot.btree.serializer.ElementSerializer;
import org.apache.directory.mavibot.btree.serializer.IntSerializer;
import org.apache.directory.mavibot.btree.serializer.LongSerializer;
import org.apache.directory.mavibot.btree.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordManager
extends AbstractTransactionManager {
    protected static final Logger LOG = LoggerFactory.getLogger(RecordManager.class);
    protected static final Logger LOG_PAGES = LoggerFactory.getLogger("org.apache.directory.mavibot.LOG_PAGES");
    protected static final Logger LOG_CHECK = LoggerFactory.getLogger("org.apache.directory.mavibot.LOG_CHECK");
    private File file;
    FileChannel fileChannel;
    int nbBtree;
    long firstFreePage;
    List<PageIO> freePages = new ArrayList<PageIO>();
    public AtomicLong nbFreedPages = new AtomicLong(0L);
    public AtomicLong nbCreatedPages = new AtomicLong(0L);
    public AtomicLong nbReusedPages = new AtomicLong(0L);
    public AtomicLong nbUpdateRMHeader = new AtomicLong(0L);
    public AtomicLong nbUpdateBtreeHeader = new AtomicLong(0L);
    public AtomicLong nbUpdatePageIOs = new AtomicLong(0L);
    private long endOfFileOffset;
    Map<RevisionName, long[]> copiedPageMap = null;
    public static final long NO_PAGE = -1L;
    private static final int PAGE_SIZE = 4;
    private static final int LINK_SIZE = 8;
    private static final int BYTE_SIZE = 1;
    static final int INT_SIZE = 4;
    static final int LONG_SIZE = 8;
    public static final int DEFAULT_PAGE_SIZE = 512;
    private static final int MIN_PAGE_SIZE = 64;
    static int RECORD_MANAGER_HEADER_SIZE = 512;
    private ByteBuffer RECORD_MANAGER_HEADER_BUFFER;
    private byte[] RECORD_MANAGER_HEADER_BYTES;
    private byte[] LONG_LENGTH = new byte[]{-1, -1, -1, -8};
    int pageSize = 512;
    private Map<String, BTree<Object, Object>> managedBtrees;
    private Queue<RevisionName> closedTransactionsQueue = new LinkedBlockingQueue<RevisionName>();
    private static final String DEFAULT_FILE_NAME = "mavibot.db";
    private boolean keepRevisions;
    public static final boolean INTERNAL_BTREE = true;
    public static final boolean NORMAL_BTREE = false;
    private BTree<NameRevision, Long> btreeOfBtrees;
    static final String BTREE_OF_BTREES_NAME = "_btree_of_btrees_";
    static final String COPIED_PAGE_BTREE_NAME = "_copiedPageBtree_";
    long currentBtreeOfBtreesOffset;
    private long previousBtreeOfBtreesOffset = -1L;
    private Lock transactionLock = new ReentrantLock();
    private static final ThreadLocal<Integer> context = new ThreadLocal();
    List<PageIO> freedPages = new ArrayList<PageIO>();
    private List<PageIO> allocatedPages = new ArrayList<PageIO>();
    private Map<String, BTreeHeader<?, ?>> currentBTreeHeaders = new HashMap();
    private Map<String, BTreeHeader<?, ?>> newBTreeHeaders = new HashMap();
    private ReadWriteLock btreeHeadersLock = new ReentrantReadWriteLock();
    private static final int ROLLBACKED_TXN = 0;
    private ReentrantLock freePageLock = new ReentrantLock();
    private SpaceReclaimer reclaimer;
    private int commitCount = 0;
    private int spaceReclaimerThreshold = 200;
    private static final byte[] HEX_CHAR = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    public RecordManager(String fileName) {
        this(fileName, 512);
    }

    public RecordManager(String fileName, int pageSize) {
        this.managedBtrees = new LinkedHashMap<String, BTree<Object, Object>>();
        this.pageSize = pageSize < 64 ? 64 : pageSize;
        this.RECORD_MANAGER_HEADER_BUFFER = ByteBuffer.allocate(this.pageSize);
        this.RECORD_MANAGER_HEADER_BYTES = new byte[this.pageSize];
        RECORD_MANAGER_HEADER_SIZE = this.pageSize;
        File tmpFile = new File(fileName);
        if (tmpFile.isDirectory()) {
            tmpFile = new File(tmpFile, DEFAULT_FILE_NAME);
        }
        boolean isNewFile = this.createFile(tmpFile);
        try {
            RandomAccessFile randomFile = new RandomAccessFile(this.file, "rw");
            this.fileChannel = randomFile.getChannel();
            this.endOfFileOffset = this.fileChannel.size();
            if (isNewFile) {
                this.initRecordManager();
            } else {
                this.loadRecordManager();
            }
            this.reclaimer = new SpaceReclaimer(this);
            this.copiedPageMap = this.reclaimer.readCopiedPageMap(this.file.getParentFile());
            this.runReclaimer();
        }
        catch (Exception e) {
            LOG.error("Error while initializing the RecordManager : {}", (Object)e.getMessage());
            LOG.error("", e);
            throw new RecordManagerException(e);
        }
    }

    private void runReclaimer() {
        try {
            this.commitCount = 0;
            this.reclaimer.reclaim();
        }
        catch (Exception e) {
            LOG.warn("SpaceReclaimer failed to free the pages", e);
        }
    }

    private boolean createFile(File mavibotFile) {
        try {
            boolean creation = mavibotFile.createNewFile();
            this.file = mavibotFile;
            if (mavibotFile.length() == 0L) {
                return true;
            }
            return creation;
        }
        catch (IOException ioe) {
            LOG.error("Cannot create the file {}", (Object)mavibotFile.getName());
            return false;
        }
    }

    private void initRecordManager() throws IOException {
        this.nbBtree = 0;
        this.firstFreePage = -1L;
        this.currentBtreeOfBtreesOffset = 0L;
        this.updateRecordManagerHeader();
        this.endOfFileOffset = this.fileChannel.size();
        this.createBtreeOfBtrees();
        try {
            this.manage(this.btreeOfBtrees, true);
            this.currentBtreeOfBtreesOffset = ((PersistedBTree)this.btreeOfBtrees).getBtreeHeader().getBTreeHeaderOffset();
            this.updateRecordManagerHeader();
            this.currentBTreeHeaders.put(BTREE_OF_BTREES_NAME, ((PersistedBTree)this.btreeOfBtrees).getBtreeHeader());
            this.newBTreeHeaders.put(BTREE_OF_BTREES_NAME, ((PersistedBTree)this.btreeOfBtrees).getBtreeHeader());
        }
        catch (BTreeAlreadyManagedException bTreeAlreadyManagedException) {
            // empty catch block
        }
        if (LOG_CHECK.isDebugEnabled()) {
            MavibotInspector.check(this);
        }
    }

    private void createBtreeOfBtrees() {
        PersistedBTreeConfiguration<NameRevision, Long> configuration = new PersistedBTreeConfiguration<NameRevision, Long>();
        configuration.setKeySerializer(NameRevisionSerializer.INSTANCE);
        configuration.setName(BTREE_OF_BTREES_NAME);
        configuration.setValueSerializer(LongSerializer.INSTANCE);
        configuration.setBtreeType(BTreeTypeEnum.BTREE_OF_BTREES);
        configuration.setCacheSize(1000);
        this.btreeOfBtrees = BTreeFactory.createPersistedBTree(configuration);
    }

    private void loadRecordManager() throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException, IllegalArgumentException, SecurityException, NoSuchFieldException, KeyNotFoundException {
        if (this.fileChannel.size() != 0L) {
            long btreeOffset;
            ByteBuffer recordManagerHeader = ByteBuffer.allocate(RECORD_MANAGER_HEADER_SIZE);
            this.fileChannel.read(recordManagerHeader);
            recordManagerHeader.rewind();
            this.pageSize = recordManagerHeader.getInt();
            this.nbBtree = recordManagerHeader.getInt();
            this.firstFreePage = recordManagerHeader.getLong();
            this.currentBtreeOfBtreesOffset = recordManagerHeader.getLong();
            this.previousBtreeOfBtreesOffset = recordManagerHeader.getLong();
            PageIO[] bobHeaderPageIos = this.readPageIOs(this.currentBtreeOfBtreesOffset, Long.MAX_VALUE);
            this.btreeOfBtrees = BTreeFactory.createPersistedBTree(BTreeTypeEnum.BTREE_OF_BTREES);
            this.loadBtree(bobHeaderPageIos, this.btreeOfBtrees);
            TupleCursor<NameRevision, Long> btreeCursor = this.btreeOfBtrees.browse();
            HashMap<String, Long> loadedBtrees = new HashMap<String, Long>();
            long currentRevision = -1L;
            while (btreeCursor.hasNext()) {
                Tuple<NameRevision, Long> btreeTuple = btreeCursor.next();
                NameRevision nameRevision = btreeTuple.getKey();
                btreeOffset = btreeTuple.getValue();
                long revision = (Long)nameRevision.getValue();
                Long loadedBtreeRevision = (Long)loadedBtrees.get(nameRevision.getName());
                if (loadedBtreeRevision != null) {
                    if (revision <= currentRevision) continue;
                    loadedBtrees.put(nameRevision.getName(), btreeOffset);
                    currentRevision = revision;
                    continue;
                }
                loadedBtrees.put(nameRevision.getName(), btreeOffset);
                currentRevision = nameRevision.getRevision();
            }
            for (String btreeName : loadedBtrees.keySet()) {
                btreeOffset = (Long)loadedBtrees.get(btreeName);
                PageIO[] btreePageIos = this.readPageIOs(btreeOffset, Long.MAX_VALUE);
                BTree btree = BTreeFactory.createPersistedBTree();
                this.loadBtree(btreePageIos, btree);
                this.managedBtrees.put(btreeName, btree);
            }
            this.endOfFileOffset = this.fileChannel.size();
        }
    }

    @Override
    public void beginTransaction() {
        this.transactionLock.lock();
        this.incrementTxnLevel();
    }

    @Override
    public void commit() {
        if (!this.fileChannel.isOpen()) {
            this.transactionLock.unlock();
            this.decrementTxnLevel();
            return;
        }
        int nbTxnStarted = context.get();
        switch (nbTxnStarted) {
            case 0: {
                this.transactionLock.unlock();
                return;
            }
            case 1: {
                this.updateRecordManagerHeader();
                this.swapCurrentBtreeHeaders();
                for (PageIO pageIo : this.freedPages) {
                    try {
                        this.free(pageIo);
                    }
                    catch (IOException ioe) {
                        throw new RecordManagerException(ioe.getMessage());
                    }
                }
                this.freedPages.clear();
                this.allocatedPages.clear();
                this.updateRecordManagerHeader();
                this.decrementTxnLevel();
                ++this.commitCount;
                if (this.commitCount >= this.spaceReclaimerThreshold) {
                    this.runReclaimer();
                }
                this.transactionLock.unlock();
                return;
            }
        }
        this.updateRecordManagerHeader();
        for (PageIO pageIo : this.freedPages) {
            try {
                this.free(pageIo);
            }
            catch (IOException ioe) {
                throw new RecordManagerException(ioe.getMessage());
            }
        }
        this.freedPages.clear();
        this.allocatedPages.clear();
        this.updateRecordManagerHeader();
        this.decrementTxnLevel();
        ++this.commitCount;
        if (this.commitCount >= this.spaceReclaimerThreshold) {
            this.runReclaimer();
        }
        this.transactionLock.unlock();
    }

    public boolean isContextOk() {
        return context == null ? true : context.get() == 0;
    }

    private void incrementTxnLevel() {
        Integer nbTxnLevel = context.get();
        if (nbTxnLevel == null) {
            context.set(1);
        } else {
            context.set(nbTxnLevel + 1);
        }
    }

    private void decrementTxnLevel() {
        int nbTxnStarted = context.get();
        context.set(nbTxnStarted - 1);
    }

    @Override
    public void rollback() {
        context.set(0);
        for (PageIO pageIo : this.allocatedPages) {
            try {
                this.free(pageIo);
            }
            catch (IOException ioe) {
                throw new RecordManagerException(ioe.getMessage());
            }
        }
        this.freedPages.clear();
        this.allocatedPages.clear();
        this.updateRecordManagerHeader();
        this.revertBtreeHeaders();
        this.transactionLock.unlock();
    }

    PageIO[] readPageIOs(long position, long limit) throws IOException, EndOfFileExceededException {
        long dataRead;
        LOG.debug("Read PageIOs at position {}", (Object)position);
        if (limit <= 0L) {
            limit = Long.MAX_VALUE;
        }
        PageIO firstPage = this.fetchPage(position);
        firstPage.setSize();
        ArrayList<PageIO> listPages = new ArrayList<PageIO>();
        listPages.add(firstPage);
        long nextPage = firstPage.getNextPage();
        if (dataRead < limit && nextPage != -1L) {
            for (dataRead = (long)(this.pageSize - 8 - 4); dataRead < limit; dataRead += (long)(this.pageSize - 8)) {
                PageIO page = this.fetchPage(nextPage);
                listPages.add(page);
                nextPage = page.getNextPage();
                if (nextPage != -1L) continue;
                page.setNextPage(-1L);
                break;
            }
        }
        LOG.debug("Nb of PageIOs read : {}", (Object)listPages.size());
        return listPages.toArray(new PageIO[0]);
    }

    void checkOffset(long offset) {
        if (offset < 0L || offset > this.endOfFileOffset || offset % (long)this.pageSize != 0L) {
            throw new InvalidOffsetException("Bad Offset : " + offset);
        }
    }

    private <K, V> void loadBtree(PageIO[] pageIos, BTree<K, V> btree) throws EndOfFileExceededException, IOException, ClassNotFoundException, IllegalAccessException, InstantiationException, IllegalArgumentException, SecurityException, NoSuchFieldException {
        this.loadBtree(pageIos, btree, null);
    }

    <K, V> void loadBtree(PageIO[] pageIos, BTree btree, BTree<K, V> parentBTree) throws EndOfFileExceededException, IOException, ClassNotFoundException, IllegalAccessException, InstantiationException, IllegalArgumentException, SecurityException, NoSuchFieldException {
        long dataPos = 0L;
        BTreeHeader btreeHeader = new BTreeHeader();
        btreeHeader.setBtree(btree);
        btreeHeader.setBTreeHeaderOffset(pageIos[0].getOffset());
        long revision = this.readLong(pageIos, dataPos);
        btreeHeader.setRevision(revision);
        long nbElems = this.readLong(pageIos, dataPos += 8L);
        btreeHeader.setNbElems(nbElems);
        long rootPageOffset = this.readLong(pageIos, dataPos += 8L);
        btreeHeader.setRootPageOffset(rootPageOffset);
        long btreeInfoOffset = this.readLong(pageIos, dataPos += 8L);
        PageIO[] infoPageIos = this.readPageIOs(btreeInfoOffset, Long.MAX_VALUE);
        ((PersistedBTree)btree).setBtreeInfoOffset(infoPageIos[0].getOffset());
        dataPos = 0L;
        int btreePageSize = this.readInt(infoPageIos, dataPos);
        BTreeFactory.setPageSize(btree, btreePageSize);
        ByteBuffer btreeNameBytes = this.readBytes(infoPageIos, dataPos += 4L);
        String btreeName = Strings.utf8ToString(btreeNameBytes);
        BTreeFactory.setName(btree, btreeName);
        ByteBuffer keySerializerBytes = this.readBytes(infoPageIos, dataPos += (long)(4 + btreeNameBytes.limit()));
        dataPos += (long)(4 + keySerializerBytes.limit());
        String keySerializerFqcn = "";
        if (keySerializerBytes != null) {
            keySerializerFqcn = Strings.utf8ToString(keySerializerBytes);
        }
        BTreeFactory.setKeySerializer(btree, keySerializerFqcn);
        ByteBuffer valueSerializerBytes = this.readBytes(infoPageIos, dataPos);
        String valueSerializerFqcn = "";
        dataPos += (long)(4 + valueSerializerBytes.limit());
        if (valueSerializerBytes != null) {
            valueSerializerFqcn = Strings.utf8ToString(valueSerializerBytes);
        }
        BTreeFactory.setValueSerializer(btree, valueSerializerFqcn);
        int allowDuplicates = this.readInt(infoPageIos, dataPos);
        ((PersistedBTree)btree).setAllowDuplicates(allowDuplicates != 0);
        dataPos += 4L;
        ((PersistedBTree)btree).setRecordManager(this);
        ((PersistedBTree)btree).storeRevision(btreeHeader, true);
        ((PersistedBTree)btree).init(parentBTree);
        this.currentBTreeHeaders.put(btree.getName(), ((PersistedBTree)btree).getBtreeHeader());
        this.newBTreeHeaders.put(btree.getName(), ((PersistedBTree)btree).getBtreeHeader());
        PageIO[] rootPageIos = this.readPageIOs(rootPageOffset, Long.MAX_VALUE);
        Page<K, V> btreeRoot = this.readPage(btree, rootPageIos);
        BTreeFactory.setRecordManager(btree, this);
        BTreeFactory.setRootPage(btree, btreeRoot);
    }

    public <K, V> Page<K, V> deserialize(BTree<K, V> btree, long offset) throws EndOfFileExceededException, IOException {
        this.checkOffset(offset);
        PageIO[] rootPageIos = this.readPageIOs(offset, Long.MAX_VALUE);
        Page<K, V> page = this.readPage(btree, rootPageIos);
        return page;
    }

    private <K, V> Page<K, V> readPage(BTree<K, V> btree, PageIO[] pageIos) throws IOException {
        long position = 0L;
        long revision = this.readLong(pageIos, position);
        int nbElems = this.readInt(pageIos, position += 8L);
        AbstractPage page = null;
        ByteBuffer byteBuffer = this.readBytes(pageIos, position += 4L);
        page = nbElems >= 0 ? this.readLeafKeysAndValues(btree, nbElems, revision, byteBuffer, pageIos) : this.readNodeKeysAndValues(btree, -nbElems, revision, byteBuffer, pageIos);
        ((AbstractPage)page).setOffset(pageIos[0].getOffset());
        if (pageIos.length > 1) {
            ((AbstractPage)page).setLastOffset(pageIos[pageIos.length - 1].getOffset());
        }
        return page;
    }

    private <K, V> PersistedLeaf<K, V> readLeafKeysAndValues(BTree<K, V> btree, int nbElems, long revision, ByteBuffer byteBuffer, PageIO[] pageIos) {
        PersistedLeaf leaf = (PersistedLeaf)BTreeFactory.createLeaf(btree, revision, nbElems);
        leaf.setOffset(pageIos[0].getOffset());
        leaf.setLastOffset(pageIos[pageIos.length - 1].getOffset());
        int[] keyLengths = new int[nbElems];
        int[] valueLengths = new int[nbElems];
        boolean isNotSubTree = btree.getType() != BTreeTypeEnum.PERSISTED_SUB;
        for (int i = 0; i < nbElems; ++i) {
            if (isNotSubTree) {
                int nbValues = byteBuffer.getInt();
                PersistedValueHolder<V> valueHolder = null;
                if (nbValues < 0) {
                    byte[] btreeOffsetBytes = new byte[8];
                    byteBuffer.get(btreeOffsetBytes);
                    valueHolder = new PersistedValueHolder<V>(btree, 1 - nbValues, btreeOffsetBytes);
                } else {
                    valueLengths[i] = byteBuffer.getInt();
                    byte[] arrayBytes = new byte[valueLengths[i]];
                    byteBuffer.get(arrayBytes);
                    valueHolder = new PersistedValueHolder<V>(btree, nbValues, arrayBytes);
                }
                BTreeFactory.setValue(btree, leaf, i, valueHolder);
            }
            keyLengths[i] = byteBuffer.getInt();
            byte[] data = new byte[keyLengths[i]];
            byteBuffer.get(data);
            BTreeFactory.setKey(btree, leaf, i, data);
        }
        return leaf;
    }

    private <K, V> PersistedNode<K, V> readNodeKeysAndValues(BTree<K, V> btree, int nbElems, long revision, ByteBuffer byteBuffer, PageIO[] pageIos) throws IOException {
        PersistedNode node = (PersistedNode)BTreeFactory.createNode(btree, revision, nbElems);
        for (int i = 0; i < nbElems; ++i) {
            long offset = LongSerializer.INSTANCE.deserialize(byteBuffer);
            long lastOffset = LongSerializer.INSTANCE.deserialize(byteBuffer);
            PersistedPageHolder<K, V> valueHolder = new PersistedPageHolder<K, V>(btree, null, offset, lastOffset);
            node.setValue(i, valueHolder);
            int keyLength = byteBuffer.getInt();
            int currentPosition = byteBuffer.position();
            K key = btree.getKeySerializer().deserialize(byteBuffer);
            byteBuffer.position(currentPosition + keyLength);
            BTreeFactory.setKey(btree, node, i, key);
        }
        long offset = LongSerializer.INSTANCE.deserialize(byteBuffer);
        long lastOffset = LongSerializer.INSTANCE.deserialize(byteBuffer);
        PersistedPageHolder<K, V> valueHolder = new PersistedPageHolder<K, V>(btree, null, offset, lastOffset);
        node.setValue(nbElems, valueHolder);
        return node;
    }

    ByteBuffer readBytes(PageIO[] pageIos, long position) {
        int length = this.readInt(pageIos, position);
        int pageNb = this.computePageNb(position += 4L);
        int pagePos = (int)(position + (long)((pageNb + 1) * 8) + 4L) - pageNb * this.pageSize;
        ByteBuffer pageData = pageIos[pageNb].getData();
        int remaining = pageData.capacity() - pagePos;
        if (length == 0) {
            return null;
        }
        ByteBuffer bytes = ByteBuffer.allocate(length);
        while (length > 0) {
            int oldLimit;
            if (length <= remaining) {
                pageData.mark();
                pageData.position(pagePos);
                oldLimit = pageData.limit();
                pageData.limit(pagePos + length);
                bytes.put(pageData);
                pageData.limit(oldLimit);
                pageData.reset();
                bytes.rewind();
                return bytes;
            }
            pageData.mark();
            pageData.position(pagePos);
            oldLimit = pageData.limit();
            pageData.limit(pagePos + remaining);
            bytes.put(pageData);
            pageData.limit(oldLimit);
            pageData.reset();
            pagePos = 8;
            pageData = pageIos[++pageNb].getData();
            length -= remaining;
            remaining = pageData.capacity() - pagePos;
        }
        bytes.rewind();
        return bytes;
    }

    int readInt(PageIO[] pageIos, long position) {
        int pageNb = this.computePageNb(position);
        int pagePos = (int)(position + (long)((pageNb + 1) * 8) + 4L) - pageNb * this.pageSize;
        ByteBuffer pageData = pageIos[pageNb].getData();
        int remaining = pageData.capacity() - pagePos;
        int value = 0;
        if (remaining >= 4) {
            value = pageData.getInt(pagePos);
        } else {
            value = 0;
            switch (remaining) {
                case 3: {
                    value += (pageData.get(pagePos + 2) & 0xFF) << 8;
                }
                case 2: {
                    value += (pageData.get(pagePos + 1) & 0xFF) << 16;
                }
                case 1: {
                    value += pageData.get(pagePos) << 24;
                }
            }
            pageData = pageIos[pageNb + 1].getData();
            pagePos = 8;
            switch (remaining) {
                case 1: {
                    value += (pageData.get(pagePos) & 0xFF) << 16;
                }
                case 2: {
                    value += (pageData.get(pagePos + 2 - remaining) & 0xFF) << 8;
                }
                case 3: {
                    value += pageData.get(pagePos + 3 - remaining) & 0xFF;
                }
            }
        }
        return value;
    }

    private byte readByte(PageIO[] pageIos, long position) {
        int pageNb = this.computePageNb(position);
        int pagePos = (int)(position + (long)((pageNb + 1) * 8) + 4L) - pageNb * this.pageSize;
        ByteBuffer pageData = pageIos[pageNb].getData();
        byte value = 0;
        value = pageData.get(pagePos);
        return value;
    }

    long readLong(PageIO[] pageIos, long position) {
        int pageNb = this.computePageNb(position);
        int pagePos = (int)(position + (long)((pageNb + 1) * 8) + 4L) - pageNb * this.pageSize;
        ByteBuffer pageData = pageIos[pageNb].getData();
        int remaining = pageData.capacity() - pagePos;
        long value = 0L;
        if (remaining >= 8) {
            value = pageData.getLong(pagePos);
        } else {
            switch (remaining) {
                case 7: {
                    value += ((long)pageData.get(pagePos + 6) & 0xFFL) << 8;
                }
                case 6: {
                    value += ((long)pageData.get(pagePos + 5) & 0xFFL) << 16;
                }
                case 5: {
                    value += ((long)pageData.get(pagePos + 4) & 0xFFL) << 24;
                }
                case 4: {
                    value += ((long)pageData.get(pagePos + 3) & 0xFFL) << 32;
                }
                case 3: {
                    value += ((long)pageData.get(pagePos + 2) & 0xFFL) << 40;
                }
                case 2: {
                    value += ((long)pageData.get(pagePos + 1) & 0xFFL) << 48;
                }
                case 1: {
                    value += (long)pageData.get(pagePos) << 56;
                }
            }
            pageData = pageIos[pageNb + 1].getData();
            pagePos = 8;
            switch (remaining) {
                case 1: {
                    value += ((long)pageData.get(pagePos) & 0xFFL) << 48;
                }
                case 2: {
                    value += ((long)pageData.get(pagePos + 2 - remaining) & 0xFFL) << 40;
                }
                case 3: {
                    value += ((long)pageData.get(pagePos + 3 - remaining) & 0xFFL) << 32;
                }
                case 4: {
                    value += ((long)pageData.get(pagePos + 4 - remaining) & 0xFFL) << 24;
                }
                case 5: {
                    value += ((long)pageData.get(pagePos + 5 - remaining) & 0xFFL) << 16;
                }
                case 6: {
                    value += ((long)pageData.get(pagePos + 6 - remaining) & 0xFFL) << 8;
                }
                case 7: {
                    value += (long)pageData.get(pagePos + 7 - remaining) & 0xFFL;
                }
            }
        }
        return value;
    }

    public synchronized <K, V> void manage(BTree<K, V> btree) throws BTreeAlreadyManagedException, IOException {
        this.beginTransaction();
        this.manage(btree, false);
        this.commit();
    }

    public synchronized <K, V> void manage(BTree<K, V> btree, boolean treeType) throws BTreeAlreadyManagedException, IOException {
        LOG.debug("Managing the btree {} which is an internam tree : {}", (Object)btree.getName(), (Object)treeType);
        BTreeFactory.setRecordManager(btree, this);
        String name = btree.getName();
        if (this.managedBtrees.containsKey(name)) {
            LOG.error("There is already a B-tree named '{}' managed by this recordManager", (Object)name);
            throw new BTreeAlreadyManagedException(name);
        }
        long btreeInfoOffset = this.writeBtreeInfo(btree);
        BTreeHeader btreeHeader = ((AbstractBTree)btree).getBtreeHeader();
        ((PersistedBTree)btree).setBtreeInfoOffset(btreeInfoOffset);
        Page rootPage = btreeHeader.getRootPage();
        PageIO[] rootPageIos = this.serializePage(btree, btreeHeader.getRevision(), rootPage);
        long rootPageOffset = rootPageIos[0].getOffset();
        btreeHeader.setRootPageOffset(rootPageOffset);
        ((PersistedLeaf)rootPage).setOffset(rootPageOffset);
        LOG.debug("Flushing the newly managed '{}' btree rootpage", (Object)btree.getName());
        this.flushPages(rootPageIos);
        long btreeHeaderOffset = this.writeBtreeHeader(btree, btreeHeader);
        if (!treeType) {
            this.managedBtrees.put(name, btree);
            this.currentBTreeHeaders.put(name, btreeHeader);
            this.newBTreeHeaders.put(name, btreeHeader);
            ++this.nbBtree;
            NameRevision nameRevision = new NameRevision(name, 0L);
            this.btreeOfBtrees.insert(nameRevision, btreeHeaderOffset);
        }
    }

    private <K, V> PageIO[] serializePage(BTree<K, V> btree, long revision, Page<K, V> page) throws IOException {
        boolean isNotSubTree;
        int nbElems = page.getNbElems();
        boolean bl = isNotSubTree = btree.getType() != BTreeTypeEnum.PERSISTED_SUB;
        if (nbElems == 0) {
            return this.serializeRootPage(revision);
        }
        int nbBuffers = 3 + nbElems * 3;
        int dataSize = 0;
        int serializedSize = 0;
        if (page.isNode()) {
            ++nbBuffers;
        }
        ArrayList<byte[]> serializedData = new ArrayList<byte[]>(nbBuffers);
        byte[] buffer = LongSerializer.serialize(revision);
        serializedData.add(buffer);
        serializedSize += buffer.length;
        int pageNbElems = nbElems;
        if (page.isNode()) {
            pageNbElems = -nbElems;
        }
        buffer = IntSerializer.serialize(pageNbElems);
        serializedData.add(buffer);
        serializedSize += buffer.length;
        for (int pos = 0; pos < nbElems; ++pos) {
            if (page.isNode()) {
                dataSize += this.serializeNodeValue((PersistedNode)page, pos, serializedData);
                dataSize += this.serializeNodeKey((PersistedNode)page, pos, serializedData);
                continue;
            }
            if (isNotSubTree) {
                dataSize += this.serializeLeafValue((PersistedLeaf)page, pos, serializedData);
            }
            dataSize += this.serializeLeafKey((PersistedLeaf)page, pos, serializedData);
        }
        if (page.isNode()) {
            dataSize += this.serializeNodeValue((PersistedNode)page, nbElems, serializedData);
        }
        buffer = IntSerializer.serialize(dataSize);
        serializedData.add(2, buffer);
        serializedSize += buffer.length;
        PageIO[] pageIos = this.getFreePageIOs(serializedSize += dataSize);
        long position = 0L;
        for (byte[] bytes : serializedData) {
            position = this.storeRaw(position, bytes, pageIos);
        }
        return pageIos;
    }

    private <K, V> int serializeNodeKey(PersistedNode<K, V> node, int pos, List<byte[]> serializedData) {
        KeyHolder<K> holder = node.getKeyHolder(pos);
        byte[] buffer = ((PersistedKeyHolder)holder).getRaw();
        byte[] length = IntSerializer.serialize(buffer.length);
        serializedData.add(length);
        if (buffer.length != 0) {
            serializedData.add(buffer);
        }
        return buffer.length + 4;
    }

    private <K, V> int serializeNodeValue(PersistedNode<K, V> node, int pos, List<byte[]> serializedData) throws IOException {
        Page child = node.getReference(pos);
        byte[] buffer = LongSerializer.serialize(((AbstractPage)child).getOffset());
        serializedData.add(buffer);
        int dataSize = buffer.length;
        buffer = LongSerializer.serialize(((AbstractPage)child).getLastOffset());
        serializedData.add(buffer);
        return dataSize += buffer.length;
    }

    private <K, V> int serializeLeafKey(PersistedLeaf<K, V> leaf, int pos, List<byte[]> serializedData) {
        int dataSize = 0;
        KeyHolder<K> keyHolder = leaf.getKeyHolder(pos);
        byte[] keyData = ((PersistedKeyHolder)keyHolder).getRaw();
        if (keyData != null) {
            byte[] length = IntSerializer.serialize(keyData.length);
            serializedData.add(length);
            serializedData.add(keyData);
            dataSize += keyData.length + 4;
        } else {
            serializedData.add(IntSerializer.serialize(0));
            dataSize += 4;
        }
        return dataSize;
    }

    private <K, V> int serializeLeafValue(PersistedLeaf<K, V> leaf, int pos, List<byte[]> serializedData) throws IOException {
        ValueHolder<V> valueHolder = leaf.getValue(pos);
        int dataSize = 0;
        int nbValues = valueHolder.size();
        if (!valueHolder.isSubBtree()) {
            byte[] buffer = IntSerializer.serialize(nbValues);
            serializedData.add(buffer);
            dataSize = 4;
            byte[] data = ((PersistedValueHolder)valueHolder).getRaw();
            dataSize += data.length;
            buffer = IntSerializer.serialize(data.length);
            serializedData.add(buffer);
            dataSize += 4;
            if (data.length > 0) {
                serializedData.add(data);
            }
        } else {
            if (nbValues == 0) {
                byte[] buffer = IntSerializer.serialize(nbValues);
                serializedData.add(buffer);
                return buffer.length;
            }
            if (valueHolder.isSubBtree()) {
                byte[] buffer = IntSerializer.serialize(-(nbValues + 1));
                serializedData.add(buffer);
                dataSize += buffer.length;
                buffer = LongSerializer.serialize(((PersistedValueHolder)valueHolder).getOffset());
                serializedData.add(buffer);
                dataSize += buffer.length;
            } else {
                byte[] buffer = IntSerializer.serialize(nbValues);
                serializedData.add(buffer);
                dataSize += buffer.length;
                byte[] data = ((PersistedValueHolder)valueHolder).getRaw();
                buffer = IntSerializer.serialize(data.length);
                serializedData.add(buffer);
                dataSize += buffer.length;
                if (data.length > 0) {
                    serializedData.add(data);
                }
                dataSize += data.length;
            }
        }
        return dataSize;
    }

    private PageIO[] serializeRootPage(long revision) throws IOException {
        PageIO[] pageIos = new PageIO[1];
        PageIO newPage = this.fetchNewPage();
        long position = 0L;
        position = this.store(position, revision, newPage);
        position = this.store(position, 0, newPage);
        newPage.setSize((int)position);
        pageIos[0] = newPage;
        return pageIos;
    }

    public void updateRecordManagerHeader() {
        int position = this.writeData(this.RECORD_MANAGER_HEADER_BYTES, 0, this.pageSize);
        position = this.writeData(this.RECORD_MANAGER_HEADER_BYTES, position, this.nbBtree);
        position = this.writeData(this.RECORD_MANAGER_HEADER_BYTES, position, this.firstFreePage);
        position = this.writeData(this.RECORD_MANAGER_HEADER_BYTES, position, this.currentBtreeOfBtreesOffset);
        position = this.writeData(this.RECORD_MANAGER_HEADER_BYTES, position, this.previousBtreeOfBtreesOffset);
        this.RECORD_MANAGER_HEADER_BUFFER.put(this.RECORD_MANAGER_HEADER_BYTES);
        this.RECORD_MANAGER_HEADER_BUFFER.flip();
        LOG.debug("Update RM header");
        if (LOG_PAGES.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("First free page     : 0x").append(Long.toHexString(this.firstFreePage)).append("\n");
            sb.append("Current BOB header  : 0x").append(Long.toHexString(this.currentBtreeOfBtreesOffset)).append("\n");
            sb.append("Previous BOB header : 0x").append(Long.toHexString(this.previousBtreeOfBtreesOffset)).append("\n");
            if (this.firstFreePage != -1L) {
                long freePage = this.firstFreePage;
                sb.append("free pages list : ");
                boolean isFirst = true;
                while (freePage != -1L) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append(" -> ");
                    }
                    sb.append("0x").append(Long.toHexString(freePage));
                    try {
                        PageIO[] freePageIO = this.readPageIOs(freePage, 8L);
                        freePage = freePageIO[0].getNextPage();
                    }
                    catch (EndOfFileExceededException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            LOG_PAGES.debug("Update RM Header : \n{}", (Object)sb.toString());
        }
        try {
            this.fileChannel.write(this.RECORD_MANAGER_HEADER_BUFFER, 0L);
        }
        catch (IOException ioe) {
            throw new FileException(ioe.getMessage());
        }
        this.RECORD_MANAGER_HEADER_BUFFER.clear();
        this.previousBtreeOfBtreesOffset = -1L;
        this.nbUpdateRMHeader.incrementAndGet();
    }

    public void updateRecordManagerHeader(long newBtreeOfBtreesOffset, long newCopiedPageBtreeOffset) {
        if (newBtreeOfBtreesOffset != -1L) {
            this.previousBtreeOfBtreesOffset = this.currentBtreeOfBtreesOffset;
            this.currentBtreeOfBtreesOffset = newBtreeOfBtreesOffset;
        }
    }

    private int writeData(byte[] buffer, int position, int value) {
        this.RECORD_MANAGER_HEADER_BYTES[position] = (byte)(value >>> 24);
        this.RECORD_MANAGER_HEADER_BYTES[position + 1] = (byte)(value >>> 16);
        this.RECORD_MANAGER_HEADER_BYTES[position + 2] = (byte)(value >>> 8);
        this.RECORD_MANAGER_HEADER_BYTES[position + 3] = (byte)value;
        return position + 4;
    }

    private int writeData(byte[] buffer, int position, long value) {
        this.RECORD_MANAGER_HEADER_BYTES[position] = (byte)(value >>> 56);
        this.RECORD_MANAGER_HEADER_BYTES[position + 1] = (byte)(value >>> 48);
        this.RECORD_MANAGER_HEADER_BYTES[position + 2] = (byte)(value >>> 40);
        this.RECORD_MANAGER_HEADER_BYTES[position + 3] = (byte)(value >>> 32);
        this.RECORD_MANAGER_HEADER_BYTES[position + 4] = (byte)(value >>> 24);
        this.RECORD_MANAGER_HEADER_BYTES[position + 5] = (byte)(value >>> 16);
        this.RECORD_MANAGER_HEADER_BYTES[position + 6] = (byte)(value >>> 8);
        this.RECORD_MANAGER_HEADER_BYTES[position + 7] = (byte)value;
        return position + 8;
    }

    <K, V> void addInBtreeOfBtrees(String name, long revision, long btreeHeaderOffset) throws IOException {
        this.checkOffset(btreeHeaderOffset);
        NameRevision nameRevision = new NameRevision(name, revision);
        this.btreeOfBtrees.insert(nameRevision, btreeHeaderOffset);
        this.currentBtreeOfBtreesOffset = this.getNewBTreeHeader(BTREE_OF_BTREES_NAME).getBTreeHeaderOffset();
    }

    <K, V> void addInCopiedPagesBtree(String name, long revision, List<Page<K, V>> pages) throws IOException {
        RevisionName revisionName = new RevisionName(revision, name);
        long[] pageOffsets = new long[pages.size()];
        int pos = 0;
        for (Page<K, V> page : pages) {
            pageOffsets[pos++] = ((AbstractPage)page).getOffset();
        }
        this.copiedPageMap.put(revisionName, pageOffsets);
    }

    void setBtreeOfBtreesOffset(long btreeOfBtreesOffset) {
        this.checkOffset(btreeOfBtreesOffset);
        this.currentBtreeOfBtreesOffset = btreeOfBtreesOffset;
    }

    <K, V> long writeBtreeHeader(BTree<K, V> btree, BTreeHeader<K, V> btreeHeader) throws IOException {
        int bufferSize = 32;
        PageIO[] btreeHeaderPageIos = this.getFreePageIOs(bufferSize);
        long btreeHeaderOffset = btreeHeaderPageIos[0].getOffset();
        long position = 0L;
        position = this.store(position, btreeHeader.getRevision(), btreeHeaderPageIos);
        position = this.store(position, btreeHeader.getNbElems(), btreeHeaderPageIos);
        position = this.store(position, btreeHeader.getRootPageOffset(), btreeHeaderPageIos);
        position = this.store(position, ((PersistedBTree)btree).getBtreeInfoOffset(), btreeHeaderPageIos);
        LOG.debug("Flushing the newly managed '{}' btree header", (Object)btree.getName());
        if (LOG_PAGES.isDebugEnabled()) {
            LOG_PAGES.debug("Writing BTreeHeader revision {} for {}", (Object)btreeHeader.getRevision(), (Object)btree.getName());
            StringBuilder sb = new StringBuilder();
            sb.append("Offset : ").append(Long.toHexString(btreeHeaderOffset)).append("\n");
            sb.append("    Revision : ").append(btreeHeader.getRevision()).append("\n");
            sb.append("    NbElems  : ").append(btreeHeader.getNbElems()).append("\n");
            sb.append("    RootPage : 0x").append(Long.toHexString(btreeHeader.getRootPageOffset())).append("\n");
            sb.append("    Info     : 0x").append(Long.toHexString(((PersistedBTree)btree).getBtreeInfoOffset())).append("\n");
            LOG_PAGES.debug("Btree Header[{}]\n{}", (Object)btreeHeader.getRevision(), (Object)sb.toString());
        }
        this.flushPages(btreeHeaderPageIos);
        btreeHeader.setBTreeHeaderOffset(btreeHeaderOffset);
        return btreeHeaderOffset;
    }

    private <K, V> long writeBtreeInfo(BTree<K, V> btree) throws IOException {
        byte[] btreeNameBytes = Strings.getBytesUtf8(btree.getName());
        byte[] keySerializerBytes = Strings.getBytesUtf8(btree.getKeySerializerFQCN());
        byte[] valueSerializerBytes = Strings.getBytesUtf8(btree.getValueSerializerFQCN());
        int bufferSize = 8 + btreeNameBytes.length + 4 + keySerializerBytes.length + 4 + valueSerializerBytes.length + 4;
        PageIO[] btreeHeaderPageIos = this.getFreePageIOs(bufferSize);
        long btreeInfoOffset = btreeHeaderPageIos[0].getOffset();
        long position = 0L;
        position = this.store(position, btree.getPageSize(), btreeHeaderPageIos);
        position = this.store(position, btreeNameBytes, btreeHeaderPageIos);
        position = this.store(position, keySerializerBytes, btreeHeaderPageIos);
        position = this.store(position, valueSerializerBytes, btreeHeaderPageIos);
        position = this.store(position, btree.isAllowDuplicates() ? 1 : 0, btreeHeaderPageIos);
        LOG.debug("Flushing the newly managed '{}' btree header", (Object)btree.getName());
        this.flushPages(btreeHeaderPageIos);
        return btreeInfoOffset;
    }

    <K, V> long updateBtreeHeader(BTree<K, V> btree, long btreeHeaderOffset) throws EndOfFileExceededException, IOException {
        return this.updateBtreeHeader(btree, btreeHeaderOffset, false);
    }

    <K, V> void updateBtreeHeaderOnPlace(BTree<K, V> btree, long btreeHeaderOffset) throws EndOfFileExceededException, IOException {
        this.updateBtreeHeader(btree, btreeHeaderOffset, true);
    }

    private <K, V> long updateBtreeHeader(BTree<K, V> btree, long btreeHeaderOffset, boolean onPlace) throws EndOfFileExceededException, IOException {
        long newBtreeHeaderOffset = -1L;
        long offset = ((PersistedBTree)btree).getBtreeOffset();
        if (onPlace) {
            long headerSize = 24L;
            PageIO[] pageIos = this.readPageIOs(offset, headerSize);
            long position = 0L;
            position = this.store(position, btree.getRevision(), pageIos);
            position = this.store(position, btree.getNbElems(), pageIos);
            position = this.store(position, btreeHeaderOffset, pageIos);
            if (LOG.isDebugEnabled()) {
                LOG.debug("-----> Flushing the '{}' B-treeHeader", (Object)btree.getName());
                LOG.debug("  revision : " + btree.getRevision() + ", NbElems : " + btree.getNbElems() + ", btreeHeader offset : 0x" + Long.toHexString(btreeHeaderOffset));
            }
            LOG.debug("Rewriting the B-treeHeader on place for B-tree " + btree.getName());
            this.flushPages(pageIos);
        } else {
            PageIO[] pageIos = this.readPageIOs(offset, Long.MAX_VALUE);
            PageIO[] newPageIOs = new PageIO[pageIos.length];
            int pos = 0;
            for (PageIO pageIo : pageIos) {
                newPageIOs[pos] = this.fetchNewPage();
                if (btree.getType() == BTreeTypeEnum.BTREE_OF_BTREES || btree.getType() == BTreeTypeEnum.COPIED_PAGES_BTREE) {
                    this.freedPages.add(pageIo);
                    this.allocatedPages.add(newPageIOs[pos]);
                }
                pageIo.copy(newPageIOs[pos]);
                if (pos > 0) {
                    newPageIOs[pos - 1].setNextPage(newPageIOs[pos].getOffset());
                }
                ++pos;
            }
            long position = 0L;
            position = this.store(position, btree.getRevision(), newPageIOs);
            position = this.store(position, btree.getNbElems(), newPageIOs);
            position = this.store(position, btreeHeaderOffset, newPageIOs);
            LOG.debug("Rewriting the B-treeHeader on place for B-tree " + btree.getName());
            this.flushPages(newPageIOs);
            newBtreeHeaderOffset = newPageIOs[0].getOffset();
        }
        this.nbUpdateBtreeHeader.incrementAndGet();
        if (LOG_CHECK.isDebugEnabled()) {
            MavibotInspector.check(this);
        }
        return newBtreeHeaderOffset;
    }

    private void flushPages(PageIO ... pageIos) throws IOException {
        if (LOG.isDebugEnabled()) {
            for (PageIO pageIo : pageIos) {
                this.dump(pageIo);
            }
        }
        for (PageIO pageIo : pageIos) {
            pageIo.getData().rewind();
            if (this.fileChannel.size() < pageIo.getOffset() + (long)this.pageSize) {
                LOG.debug("Adding a page at the end of the file");
                this.fileChannel.write(pageIo.getData(), this.fileChannel.size());
            } else {
                LOG.debug("Writing a page at position {}", (Object)pageIo.getOffset());
                this.fileChannel.write(pageIo.getData(), pageIo.getOffset());
            }
            this.nbUpdatePageIOs.incrementAndGet();
            pageIo.getData().rewind();
        }
    }

    private int computePageNb(long offset) {
        long pageNb = 0L;
        if ((offset -= (long)(this.pageSize - 8 - 4)) < 0L) {
            return (int)pageNb;
        }
        pageNb = 1L + offset / (long)(this.pageSize - 8);
        return (int)pageNb;
    }

    private long store(long position, byte[] bytes, PageIO ... pageIos) {
        if (bytes != null) {
            position = this.store(position, bytes.length, pageIos);
            int pageNb = this.computePageNb(position);
            ByteBuffer pageData = pageIos[pageNb].getData();
            int pagePos = (int)(position + (long)((pageNb + 1) * 8) + 4L) - pageNb * this.pageSize;
            int remaining = pageData.capacity() - pagePos;
            int nbStored = bytes.length;
            while (nbStored > 0) {
                if (remaining > nbStored) {
                    pageData.mark();
                    pageData.position(pagePos);
                    pageData.put(bytes, bytes.length - nbStored, nbStored);
                    pageData.reset();
                    nbStored = 0;
                    continue;
                }
                pageData.mark();
                pageData.position(pagePos);
                pageData.put(bytes, bytes.length - nbStored, remaining);
                pageData.reset();
                pageData = pageIos[++pageNb].getData();
                pagePos = 8;
                nbStored -= remaining;
                remaining = pageData.capacity() - pagePos;
            }
            position += (long)bytes.length;
        } else {
            position = this.store(position, 0, pageIos);
        }
        return position;
    }

    private long storeRaw(long position, byte[] bytes, PageIO ... pageIos) {
        if (bytes != null) {
            int pageNb = this.computePageNb(position);
            ByteBuffer pageData = pageIos[pageNb].getData();
            int pagePos = (int)(position + (long)((pageNb + 1) * 8) + 4L) - pageNb * this.pageSize;
            int remaining = pageData.capacity() - pagePos;
            int nbStored = bytes.length;
            while (nbStored > 0) {
                if (remaining > nbStored) {
                    pageData.mark();
                    pageData.position(pagePos);
                    pageData.put(bytes, bytes.length - nbStored, nbStored);
                    pageData.reset();
                    nbStored = 0;
                    continue;
                }
                pageData.mark();
                pageData.position(pagePos);
                pageData.put(bytes, bytes.length - nbStored, remaining);
                pageData.reset();
                if (++pageNb == pageIos.length) break;
                pageData = pageIos[pageNb].getData();
                pagePos = 8;
                nbStored -= remaining;
                remaining = pageData.capacity() - pagePos;
            }
            position += (long)bytes.length;
        } else {
            position = this.store(position, 0, pageIos);
        }
        return position;
    }

    private long store(long position, int value, PageIO ... pageIos) {
        int pageNb = this.computePageNb(position);
        int pagePos = (int)(position + (long)((pageNb + 1) * 8) + 4L) - pageNb * this.pageSize;
        ByteBuffer pageData = pageIos[pageNb].getData();
        int remaining = pageData.capacity() - pagePos;
        if (remaining < 4) {
            switch (remaining) {
                case 3: {
                    pageData.put(pagePos + 2, (byte)(value >>> 8));
                }
                case 2: {
                    pageData.put(pagePos + 1, (byte)(value >>> 16));
                }
                case 1: {
                    pageData.put(pagePos, (byte)(value >>> 24));
                }
            }
            pageData = pageIos[pageNb + 1].getData();
            pagePos = 8;
            switch (remaining) {
                case 1: {
                    pageData.put(pagePos, (byte)(value >>> 16));
                }
                case 2: {
                    pageData.put(pagePos + 2 - remaining, (byte)(value >>> 8));
                }
                case 3: {
                    pageData.put(pagePos + 3 - remaining, (byte)value);
                }
            }
        } else {
            pageData.putInt(pagePos, value);
        }
        return position += 4L;
    }

    private long store(long position, long value, PageIO ... pageIos) {
        int pageNb = this.computePageNb(position);
        int pagePos = (int)(position + (long)((pageNb + 1) * 8) + 4L) - pageNb * this.pageSize;
        ByteBuffer pageData = pageIos[pageNb].getData();
        int remaining = pageData.capacity() - pagePos;
        if (remaining < 8) {
            switch (remaining) {
                case 7: {
                    pageData.put(pagePos + 6, (byte)(value >>> 8));
                }
                case 6: {
                    pageData.put(pagePos + 5, (byte)(value >>> 16));
                }
                case 5: {
                    pageData.put(pagePos + 4, (byte)(value >>> 24));
                }
                case 4: {
                    pageData.put(pagePos + 3, (byte)(value >>> 32));
                }
                case 3: {
                    pageData.put(pagePos + 2, (byte)(value >>> 40));
                }
                case 2: {
                    pageData.put(pagePos + 1, (byte)(value >>> 48));
                }
                case 1: {
                    pageData.put(pagePos, (byte)(value >>> 56));
                }
            }
            pageData = pageIos[pageNb + 1].getData();
            pagePos = 8;
            switch (remaining) {
                case 1: {
                    pageData.put(pagePos, (byte)(value >>> 48));
                }
                case 2: {
                    pageData.put(pagePos + 2 - remaining, (byte)(value >>> 40));
                }
                case 3: {
                    pageData.put(pagePos + 3 - remaining, (byte)(value >>> 32));
                }
                case 4: {
                    pageData.put(pagePos + 4 - remaining, (byte)(value >>> 24));
                }
                case 5: {
                    pageData.put(pagePos + 5 - remaining, (byte)(value >>> 16));
                }
                case 6: {
                    pageData.put(pagePos + 6 - remaining, (byte)(value >>> 8));
                }
                case 7: {
                    pageData.put(pagePos + 7 - remaining, (byte)value);
                }
            }
        } else {
            pageData.putLong(pagePos, value);
        }
        return position += 8L;
    }

    <K, V> PageHolder<K, V> writePage(BTree<K, V> btree, Page<K, V> newPage, long newRevision) throws IOException {
        PageIO[] pageIos = this.serializePage(btree, newRevision, newPage);
        if (LOG_PAGES.isDebugEnabled()) {
            LOG_PAGES.debug("Write data for '{}' btree", (Object)btree.getName());
            RecordManager.logPageIos(pageIos);
        }
        this.flushPages(pageIos);
        long offset = pageIos[0].getOffset();
        long lastOffset = pageIos[pageIos.length - 1].getOffset();
        PersistedPageHolder<K, V> pageHolder = new PersistedPageHolder<K, V>(btree, newPage, offset, lastOffset);
        return pageHolder;
    }

    static void logPageIos(PageIO[] pageIos) {
        int pageNb = 0;
        for (PageIO pageIo : pageIos) {
            StringBuilder sb = new StringBuilder();
            sb.append("PageIO[").append(pageNb).append("]:0x");
            sb.append(Long.toHexString(pageIo.getOffset())).append("/");
            sb.append(pageIo.getSize());
            ++pageNb;
            ByteBuffer data = pageIo.getData();
            int position = data.position();
            int dataLength = (int)pageIo.getSize() + 12;
            if (dataLength > data.limit()) {
                dataLength = data.limit();
            }
            byte[] bytes = new byte[dataLength];
            data.get(bytes);
            data.position(position);
            int pos = 0;
            for (byte b : bytes) {
                int mod = pos % 16;
                switch (mod) {
                    case 0: {
                        sb.append("\n    ");
                    }
                    case 4: 
                    case 8: 
                    case 12: {
                        sb.append(" ");
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 13: 
                    case 14: 
                    case 15: {
                        sb.append(Strings.dumpByte(b)).append(" ");
                    }
                }
                ++pos;
            }
            LOG_PAGES.debug(sb.toString());
        }
    }

    private int computeNbPages(int dataSize) {
        if (dataSize <= 0) {
            return 0;
        }
        int availableSize = this.pageSize - 8;
        int nbNeededPages = 1;
        if (dataSize > availableSize - 4) {
            int remainingSize = dataSize - (availableSize - 4);
            nbNeededPages += remainingSize / availableSize;
            int remain = remainingSize % availableSize;
            if (remain > 0) {
                ++nbNeededPages;
            }
        }
        return nbNeededPages;
    }

    private PageIO[] getFreePageIOs(int dataSize) throws IOException {
        if (dataSize == 0) {
            return new PageIO[0];
        }
        int nbNeededPages = this.computeNbPages(dataSize);
        PageIO[] pageIOs = new PageIO[nbNeededPages];
        pageIOs[0] = this.fetchNewPage();
        pageIOs[0].setSize(dataSize);
        for (int i = 1; i < nbNeededPages; ++i) {
            pageIOs[i] = this.fetchNewPage();
            pageIOs[i - 1].setNextPage(pageIOs[i].getOffset());
        }
        return pageIOs;
    }

    private PageIO fetchNewPage() throws IOException {
        if (this.firstFreePage == -1L) {
            this.nbCreatedPages.incrementAndGet();
            PageIO newPage = new PageIO(this.endOfFileOffset);
            this.endOfFileOffset += (long)this.pageSize;
            ByteBuffer data = ByteBuffer.allocateDirect(this.pageSize);
            newPage.setData(data);
            newPage.setNextPage(-1L);
            newPage.setSize(0);
            LOG.debug("Requiring a new page at offset {}", (Object)newPage.getOffset());
            return newPage;
        }
        this.nbReusedPages.incrementAndGet();
        this.freePageLock.lock();
        PageIO pageIo = this.fetchPage(this.firstFreePage);
        this.firstFreePage = pageIo.getNextPage();
        this.freePageLock.unlock();
        ByteBuffer data = ByteBuffer.allocateDirect(this.pageSize);
        pageIo.setData(data);
        pageIo.setNextPage(-1L);
        pageIo.setSize(0);
        LOG.debug("Reused page at offset {}", (Object)pageIo.getOffset());
        return pageIo;
    }

    PageIO fetchPage(long offset) throws IOException, EndOfFileExceededException {
        this.checkOffset(offset);
        if (this.fileChannel.size() < offset + (long)this.pageSize) {
            throw new EndOfFileExceededException("We are fetching a page on " + offset + " when the file's size is " + this.fileChannel.size());
        }
        this.fileChannel.position(offset);
        ByteBuffer data = ByteBuffer.allocate(this.pageSize);
        this.fileChannel.read(data);
        data.rewind();
        PageIO readPage = new PageIO(offset);
        readPage.setData(data);
        return readPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    void setPageSize(int pageSize) {
        this.pageSize = this.pageSize >= 13 ? pageSize : 512;
    }

    public void close() throws IOException {
        this.beginTransaction();
        for (BTree<Object, Object> tree : this.managedBtrees.values()) {
            tree.close();
        }
        this.btreeOfBtrees.close();
        this.managedBtrees.clear();
        this.fileChannel.force(true);
        this.fileChannel.close();
        this.reclaimer.storeCopiedPageMap(this.file.getParentFile());
        this.commit();
    }

    public static String dump(byte octet) {
        return new String(new byte[]{HEX_CHAR[(octet & 0xF0) >> 4], HEX_CHAR[octet & 0xF]});
    }

    private void dump(PageIO pageIo) {
        ByteBuffer buffer = pageIo.getData();
        buffer.mark();
        byte[] longBuffer = new byte[8];
        byte[] intBuffer = new byte[4];
        buffer.get(longBuffer);
        long nextOffset = LongSerializer.deserialize(longBuffer);
        buffer.get(intBuffer);
        int size = IntSerializer.deserialize(intBuffer);
        buffer.reset();
        System.out.println("PageIO[" + Long.toHexString(pageIo.getOffset()) + "], size = " + size + ", NEXT PageIO:" + Long.toHexString(nextOffset));
        System.out.println(" 0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F ");
        System.out.println("+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+");
        for (int i = 0; i < buffer.limit(); i += 16) {
            System.out.print("|");
            for (int j = 0; j < 16; ++j) {
                System.out.print(RecordManager.dump(buffer.get()));
                if (j == 15) {
                    System.out.println("|");
                    continue;
                }
                System.out.print(" ");
            }
        }
        System.out.println("+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+");
        buffer.reset();
    }

    public void dump() {
        System.out.println("/---------------------------- Dump ----------------------------\\");
        try {
            RandomAccessFile randomFile = new RandomAccessFile(this.file, "r");
            FileChannel fileChannel = randomFile.getChannel();
            ByteBuffer recordManagerHeader = ByteBuffer.allocate(RECORD_MANAGER_HEADER_SIZE);
            fileChannel.read(recordManagerHeader);
            recordManagerHeader.rewind();
            long fileSize = fileChannel.size();
            int pageSize = recordManagerHeader.getInt();
            long nbPages = fileSize / (long)pageSize;
            int nbBtree = recordManagerHeader.getInt();
            long firstFreePage = recordManagerHeader.getLong();
            long currentBtreeOfBtreesPage = recordManagerHeader.getLong();
            long previousBtreeOfBtreesPage = recordManagerHeader.getLong();
            long currentCopiedPagesBtreePage = recordManagerHeader.getLong();
            long previousCopiedPagesBtreePage = recordManagerHeader.getLong();
            System.out.println("  RecordManager");
            System.out.println("  -------------");
            System.out.println("  Size = 0x" + Long.toHexString(fileSize));
            System.out.println("  NbPages = " + nbPages);
            System.out.println("    Header ");
            System.out.println("      page size : " + pageSize);
            System.out.println("      nbTree : " + nbBtree);
            System.out.println("      firstFreePage : 0x" + Long.toHexString(firstFreePage));
            System.out.println("      current BOB : 0x" + Long.toHexString(currentBtreeOfBtreesPage));
            System.out.println("      previous BOB : 0x" + Long.toHexString(previousBtreeOfBtreesPage));
            System.out.println("      current CopiedPages : 0x" + Long.toHexString(currentCopiedPagesBtreePage));
            System.out.println("      previous CopiedPages : 0x" + Long.toHexString(previousCopiedPagesBtreePage));
            this.dumpFreePages(firstFreePage);
            this.dumpBtreeHeader(currentBtreeOfBtreesPage);
            if (previousBtreeOfBtreesPage != -1L) {
                this.dumpBtreeHeader(previousBtreeOfBtreesPage);
            }
            this.dumpBtreeHeader(currentCopiedPagesBtreePage);
            if (previousCopiedPagesBtreePage != -1L) {
                this.dumpBtreeHeader(previousCopiedPagesBtreePage);
            }
            randomFile.close();
            System.out.println("\\---------------------------- Dump ----------------------------/");
        }
        catch (IOException ioe) {
            System.out.println("Exception while dumping the file : " + ioe.getMessage());
        }
    }

    private void dumpFreePages(long freePageOffset) throws EndOfFileExceededException, IOException {
        System.out.println("\n  FreePages : ");
        int pageNb = 1;
        while (freePageOffset != -1L) {
            PageIO pageIo = this.fetchPage(freePageOffset);
            System.out.println("    freePage[" + pageNb + "] : 0x" + Long.toHexString(pageIo.getOffset()));
            freePageOffset = pageIo.getNextPage();
            ++pageNb;
        }
    }

    private long dumpBtreeHeader(long btreeOffset) throws EndOfFileExceededException, IOException {
        int allowDuplicates;
        PageIO[] pageIos = this.readPageIOs(btreeOffset, Long.MAX_VALUE);
        long dataPos = 0L;
        long revision = this.readLong(pageIos, dataPos);
        long nbElems = this.readLong(pageIos, dataPos += 8L);
        long rootPageOffset = this.readLong(pageIos, dataPos += 8L);
        int btreePageSize = this.readInt(pageIos, dataPos += 8L);
        ByteBuffer btreeNameBytes = this.readBytes(pageIos, dataPos += 4L);
        String btreeName = Strings.utf8ToString(btreeNameBytes);
        ByteBuffer keySerializerBytes = this.readBytes(pageIos, dataPos += (long)(4 + btreeNameBytes.limit()));
        dataPos += (long)(4 + keySerializerBytes.limit());
        String keySerializerFqcn = "";
        if (keySerializerBytes != null) {
            keySerializerFqcn = Strings.utf8ToString(keySerializerBytes);
        }
        ByteBuffer valueSerializerBytes = this.readBytes(pageIos, dataPos);
        String valueSerializerFqcn = "";
        dataPos += (long)(4 + valueSerializerBytes.limit());
        if (valueSerializerBytes != null) {
            valueSerializerFqcn = Strings.utf8ToString(valueSerializerBytes);
        }
        boolean dupsAllowed = (allowDuplicates = this.readInt(pageIos, dataPos)) != 0;
        dataPos += 4L;
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            boolean isFirst = true;
            for (PageIO pageIo : pageIos) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append("0x").append(Long.toHexString(pageIo.getOffset()));
            }
            String pageIoList = sb.toString();
            LOG.debug("    PageIOs[{}] = {}", (Object)pageIos.length, (Object)pageIoList);
            LOG.debug("    dataSize = {}", (Object)pageIos[0].getSize());
            LOG.debug("    B-tree '{}'", (Object)btreeName);
            LOG.debug("    revision : {}", (Object)revision);
            LOG.debug("    nbElems : {}", (Object)nbElems);
            LOG.debug("    rootPageOffset : 0x{}", (Object)Long.toHexString(rootPageOffset));
            LOG.debug("    B-tree page size : {}", (Object)btreePageSize);
            LOG.debug("    keySerializer : '{}'", (Object)keySerializerFqcn);
            LOG.debug("    valueSerializer : '{}'", (Object)valueSerializerFqcn);
            LOG.debug("    dups allowed : {}", (Object)dupsAllowed);
        }
        return rootPageOffset;
    }

    public int getNbManagedTrees() {
        return this.nbBtree;
    }

    public Set<String> getManagedTrees() {
        HashSet<String> btrees = new HashSet<String>(this.managedBtrees.keySet());
        return btrees;
    }

    void storeCopiedPages(String name, long revision, long[] copiedPages) throws IOException {
        RevisionName revisionName = new RevisionName(revision, name);
        this.copiedPageMap.put(revisionName, copiedPages);
    }

    <K, V> void storeRootPage(BTree<K, V> btree, Page<K, V> rootPage) throws IOException {
        if (!this.isKeepRevisions()) {
            return;
        }
        NameRevision nameRevision = new NameRevision(btree.getName(), rootPage.getRevision());
        ((AbstractBTree)this.btreeOfBtrees).insert(nameRevision, ((AbstractPage)rootPage).getOffset(), 0L);
        if (LOG_CHECK.isDebugEnabled()) {
            MavibotInspector.check(this);
        }
    }

    <K, V> Page<K, V> getRootPage(BTree<K, V> btree, long revision) throws KeyNotFoundException, IOException {
        if (btree.getRevision() == revision) {
            return btree.getRootPage();
        }
        NameRevision nameRevision = new NameRevision(btree.getName(), revision);
        long btreeHeaderOffset = this.btreeOfBtrees.get(nameRevision);
        Page<K, V> btreeRoot = this.readRootPage(btree, btreeHeaderOffset);
        return btreeRoot;
    }

    private <K, V> Page<K, V> readRootPage(BTree<K, V> btree, long btreeHeaderOffset) throws EndOfFileExceededException, IOException {
        PageIO[] btreeHeaderPageIos = this.readPageIOs(btreeHeaderOffset, Long.MAX_VALUE);
        long dataPos = 16L;
        long rootPageOffset = this.readLong(btreeHeaderPageIos, dataPos);
        PageIO[] rootPageIos = this.readPageIOs(rootPageOffset, Long.MAX_VALUE);
        Page<K, V> btreeRoot = this.readPage(btree, rootPageIos);
        return btreeRoot;
    }

    public <K, V> BTree<K, V> getManagedTree(String name) {
        return this.managedBtrees.get(name);
    }

    <K, V> void freePages(BTree<K, V> btree, long revision, List<Page<K, V>> pages) throws EndOfFileExceededException, IOException {
        if (pages == null || pages.isEmpty()) {
            return;
        }
        if (!this.keepRevisions) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Freeing the following pages :");
                for (Page<K, V> page : pages) {
                    LOG.debug("    {}", (Object)page);
                }
            }
            for (Page<K, V> page : pages) {
                PageIO[] pageIos;
                long pageOffset = ((AbstractPage)page).getOffset();
                for (PageIO pageIo : pageIos = this.readPageIOs(pageOffset, Long.MAX_VALUE)) {
                    this.freedPages.add(pageIo);
                }
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Moving the following pages to the CopiedBtree :");
                for (Page<K, V> page : pages) {
                    LOG.debug("    {}", (Object)page);
                }
            }
            long[] pageOffsets = new long[pages.size()];
            int pos = 0;
            for (Page<K, V> page : pages) {
                pageOffsets[pos++] = ((AbstractPage)page).offset;
            }
            if (btree.getType() != BTreeTypeEnum.BTREE_OF_BTREES && btree.getType() != BTreeTypeEnum.COPIED_PAGES_BTREE) {
                RevisionName revisionName = new RevisionName(revision, btree.getName());
                this.copiedPageMap.put(revisionName, pageOffsets);
            } else {
                for (long pageOffset : pageOffsets) {
                    PageIO[] pageIos;
                    for (PageIO pageIo : pageIos = this.readPageIOs(pageOffset, Long.MAX_VALUE)) {
                        this.freedPages.add(pageIo);
                    }
                }
            }
        }
    }

    private void free(PageIO pageIo) throws IOException {
        this.freePageLock.lock();
        pageIo.setNextPage(this.firstFreePage);
        LOG.debug("Flushing the first free page");
        this.flushPages(pageIo);
        this.firstFreePage = pageIo.getOffset();
        this.freePageLock.unlock();
    }

    public void free(long[] offsets) throws IOException {
        ArrayList<PageIO> pageIos = new ArrayList<PageIO>();
        int pageIndex = 0;
        for (int i = 0; i < offsets.length; ++i) {
            PageIO[] ios;
            for (PageIO io : ios = this.readPageIOs(offsets[i], Long.MAX_VALUE)) {
                pageIos.add(io);
                if (pageIndex > 0) {
                    ((PageIO)pageIos.get(pageIndex - 1)).setNextPage(io.getOffset());
                }
                ++pageIndex;
            }
        }
        this.freePageLock.lock();
        ((PageIO)pageIos.get(pageIndex - 1)).setNextPage(this.firstFreePage);
        LOG.debug("Flushing the first free page");
        this.flushPages(pageIos.toArray(new PageIO[0]));
        this.firstFreePage = ((PageIO)pageIos.get(0)).getOffset();
        this.freePageLock.unlock();
    }

    public boolean isKeepRevisions() {
        return this.keepRevisions;
    }

    public void setKeepRevisions(boolean keepRevisions) {
        this.keepRevisions = keepRevisions;
    }

    public <K, V> BTree<K, V> addBTree(String name, ElementSerializer<K> keySerializer, ElementSerializer<V> valueSerializer, boolean allowDuplicates) throws IOException, BTreeAlreadyManagedException {
        PersistedBTreeConfiguration<K, V> config = new PersistedBTreeConfiguration<K, V>();
        config.setName(name);
        config.setKeySerializer(keySerializer);
        config.setValueSerializer(valueSerializer);
        config.setAllowDuplicates(allowDuplicates);
        PersistedBTree btree = new PersistedBTree(config);
        this.manage(btree);
        if (LOG_CHECK.isDebugEnabled()) {
            MavibotInspector.check(this);
        }
        return btree;
    }

    <K, V> void releaseTransaction(ReadTransaction<K, V> readTransaction) {
        RevisionName revisionName = new RevisionName(readTransaction.getRevision(), readTransaction.getBtreeHeader().getBtree().getName());
    }

    public BTreeHeader getBTreeHeader(String name) {
        this.btreeHeadersLock.readLock().lock();
        BTreeHeader<?, ?> btreeHeader = this.currentBTreeHeaders.get(name);
        this.btreeHeadersLock.readLock().unlock();
        return btreeHeader;
    }

    public BTreeHeader getNewBTreeHeader(String name) {
        BTreeHeader<?, ?> btreeHeader = this.newBTreeHeaders.get(name);
        return btreeHeader;
    }

    public void updateNewBTreeHeaders(BTreeHeader btreeHeader) {
        this.newBTreeHeaders.put(btreeHeader.getBtree().getName(), btreeHeader);
    }

    private void swapCurrentBtreeHeaders() {
        Map<String, BTreeHeader<?, ?>> tmp = this.currentBTreeHeaders;
        this.btreeHeadersLock.writeLock().lock();
        this.currentBTreeHeaders = this.newBTreeHeaders;
        this.btreeHeadersLock.writeLock().unlock();
        tmp.clear();
        tmp.putAll(this.currentBTreeHeaders);
        this.newBTreeHeaders = tmp;
    }

    private void revertBtreeHeaders() {
        this.newBTreeHeaders.clear();
        this.newBTreeHeaders.putAll(this.currentBTreeHeaders);
    }

    <K, V> BTree<V, V> loadDupsBtree(long btreeHeaderOffset, BTree<K, V> parentBtree) {
        try {
            PageIO[] pageIos = this.readPageIOs(btreeHeaderOffset, Long.MAX_VALUE);
            BTree subBtree = BTreeFactory.createPersistedBTree(BTreeTypeEnum.PERSISTED_SUB);
            this.loadBtree(pageIos, subBtree, parentBtree);
            return subBtree;
        }
        catch (Exception e) {
            throw new BTreeCreationException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RM free pages : [");
        if (this.firstFreePage != -1L) {
            long current = this.firstFreePage;
            boolean isFirst = true;
            while (current != -1L) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                try {
                    PageIO pageIo = this.fetchPage(current);
                    sb.append(pageIo.getOffset());
                    current = pageIo.getNextPage();
                }
                catch (EndOfFileExceededException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

