/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BTreeFactory;
import org.apache.directory.mavibot.btree.InMemoryBTree;
import org.apache.directory.mavibot.btree.InMemoryBTreeBuilder;
import org.apache.directory.mavibot.btree.InMemoryBTreeConfiguration;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.PageHolder;
import org.apache.directory.mavibot.btree.PersistedBTree;
import org.apache.directory.mavibot.btree.PersistedKeyHolder;
import org.apache.directory.mavibot.btree.PersistedLeaf;
import org.apache.directory.mavibot.btree.PersistedNode;
import org.apache.directory.mavibot.btree.PersistedValueHolder;
import org.apache.directory.mavibot.btree.RecordManager;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.TupleComparator;
import org.apache.directory.mavibot.btree.TupleCursor;
import org.apache.directory.mavibot.btree.comparator.IntComparator;
import org.apache.directory.mavibot.btree.exception.EndOfFileExceededException;
import org.apache.directory.mavibot.btree.exception.KeyNotFoundException;
import org.apache.directory.mavibot.btree.serializer.IntSerializer;

public class BulkLoader<K, V> {
    private int readElements(BTree<K, V> btree, Iterator<Tuple<K, V>> iterator, List<File> sortedFiles, List<Tuple<K, V>> tuples, int chunkSize) throws IOException {
        int nbRead = 0;
        int nbIteration = 0;
        int nbElems = 0;
        boolean inMemory = true;
        while (true) {
            ++nbIteration;
            tuples.clear();
            while (iterator.hasNext() && nbRead < chunkSize) {
                Tuple<K, V> tuple = iterator.next();
                tuples.add(tuple);
                ++nbRead;
            }
            if (nbRead < chunkSize) {
                if (nbIteration != 1) {
                    inMemory = false;
                    sortedFiles.add(this.flushToDisk(nbIteration, tuples, btree));
                }
                nbElems += nbRead;
                break;
            }
            if (!iterator.hasNext()) {
                if (nbIteration > 1) {
                    inMemory = false;
                    sortedFiles.add(this.flushToDisk(nbIteration, tuples, btree));
                }
                nbElems += nbRead;
                break;
            }
            nbElems += nbRead;
            nbRead = 0;
            sortedFiles.add(this.flushToDisk(nbIteration, tuples, btree));
        }
        if (!inMemory) {
            tuples.clear();
        }
        return nbElems;
    }

    private Tuple<Iterator<Tuple<K, Set<V>>>, Integer> processFiles(BTree<K, V> btree, Iterator<Tuple<K, Set<V>>> dataIterator) throws IOException {
        File file = File.createTempFile("sortedUnique", "data");
        file.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(file);
        int nbReads = 0;
        while (dataIterator.hasNext()) {
            ++nbReads;
            Tuple<K, Set<V>> tuple = dataIterator.next();
            byte[] bytesKey = btree.getKeySerializer().serialize(tuple.key);
            fos.write(IntSerializer.serialize(bytesKey.length));
            fos.write(bytesKey);
            int nbValues = tuple.getValue().size();
            fos.write(IntSerializer.serialize(nbValues));
            for (V value : tuple.getValue()) {
                byte[] bytesValue = btree.getValueSerializer().serialize(value);
                fos.write(IntSerializer.serialize(bytesValue.length));
                fos.write(bytesValue);
            }
        }
        fos.flush();
        fos.close();
        FileInputStream fis = new FileInputStream(file);
        Iterator<Tuple<K, Set<V>>> uniqueIterator = this.createUniqueFileIterator(btree, fis);
        Tuple<Iterator<Tuple<K, Set<V>>>, Integer> result = new Tuple<Iterator<Tuple<K, Set<V>>>, Integer>(uniqueIterator, nbReads);
        return result;
    }

    public BTree<K, V> load(PersistedBTree<K, V> btree, Iterator<Tuple<K, V>> iterator, int chunkSize) throws IOException {
        int nbFiles;
        if (btree == null) {
            throw new RuntimeException("Invalid BTree : it's null");
        }
        if (iterator == null) {
            return null;
        }
        boolean inMemory = true;
        ArrayList<File> sortedFiles = new ArrayList<File>();
        ArrayList<Tuple<K, V>> tuples = new ArrayList<Tuple<K, V>>(chunkSize);
        int nbElems = this.readElements(btree, iterator, sortedFiles, tuples, chunkSize);
        if (nbElems > 0) {
            inMemory = tuples.size() > 0;
        }
        Iterator<Tuple<K, Set<V>>> dataIterator = null;
        FileInputStream[] streams = null;
        BTree<K, V> resultBTree = null;
        if (inMemory) {
            dataIterator = this.createTupleIterator(btree, tuples);
            resultBTree = this.bulkLoad(btree, dataIterator, nbElems);
        } else {
            nbFiles = sortedFiles.size();
            streams = new FileInputStream[nbFiles];
            for (int i = 0; i < nbFiles; ++i) {
                streams[i] = new FileInputStream((File)sortedFiles.get(i));
            }
            dataIterator = this.createIterator(btree, streams);
            Tuple<Iterator<Tuple<K, Set<V>>>, Integer> result = this.processFiles(btree, dataIterator);
            resultBTree = this.bulkLoad(btree, (Iterator)result.key, (Integer)result.value);
        }
        if (!inMemory) {
            nbFiles = sortedFiles.size();
            for (int i = 0; i < nbFiles; ++i) {
                streams[i].close();
                ((File)sortedFiles.get(i)).delete();
            }
        }
        return resultBTree;
    }

    LevelInfo computeLevel(BTree<K, V> btree, int nbElems, LevelEnum levelType) {
        int pageSize = btree.getPageSize();
        int incrementNode = 0;
        if (levelType == LevelEnum.NODE) {
            incrementNode = 1;
        }
        LevelInfo level = new LevelInfo();
        level.isNode = levelType == LevelEnum.NODE;
        level.nbElems = nbElems;
        level.nbPages = nbElems / (pageSize + incrementNode);
        level.levelNumber = 0;
        level.nbAddedElems = 0;
        level.currentPos = 0;
        if (nbElems <= pageSize + incrementNode) {
            if (nbElems % (pageSize + incrementNode) != 0) {
                level.nbPages = 1;
            }
            level.nbElemsLimit = nbElems;
            level.currentPage = level.isNode ? BTreeFactory.createNode(btree, 0L, nbElems - 1) : BTreeFactory.createLeaf(btree, 0L, nbElems);
        } else {
            int remaining = nbElems % (pageSize + incrementNode);
            if (remaining == 0) {
                level.nbElemsLimit = nbElems;
                level.currentPage = level.isNode ? BTreeFactory.createNode(btree, 0L, pageSize) : BTreeFactory.createLeaf(btree, 0L, pageSize);
            } else {
                ++level.nbPages;
                if (remaining < pageSize / 2 + incrementNode) {
                    level.nbElemsLimit = nbElems - remaining - (pageSize + incrementNode);
                    level.currentPage = level.nbElemsLimit > 0 ? (level.isNode ? BTreeFactory.createNode(btree, 0L, pageSize) : BTreeFactory.createLeaf(btree, 0L, pageSize)) : (level.isNode ? BTreeFactory.createNode(btree, 0L, pageSize / 2 + remaining - 1) : BTreeFactory.createLeaf(btree, 0L, pageSize / 2 + remaining));
                } else {
                    level.nbElemsLimit = nbElems - remaining;
                    level.currentPage = level.isNode ? BTreeFactory.createNode(btree, 0L, pageSize) : BTreeFactory.createLeaf(btree, 0L, pageSize);
                }
            }
        }
        return level;
    }

    List<LevelInfo> computeLevels(BTree<K, V> btree, int nbElems) {
        ArrayList<LevelInfo> levelList = new ArrayList<LevelInfo>();
        LevelInfo leafLevel = this.computeLevel(btree, nbElems, LevelEnum.LEAF);
        levelList.add(leafLevel);
        int nbPages = leafLevel.nbPages;
        int levelNumber = 1;
        while (nbPages > 1) {
            LevelInfo nodeLevel = this.computeLevel(btree, nbPages, LevelEnum.NODE);
            nodeLevel.levelNumber = levelNumber++;
            levelList.add(nodeLevel);
            nbPages = nodeLevel.nbPages;
        }
        return levelList;
    }

    private void injectInLeaf(BTree<K, V> btree, Tuple<K, Set<V>> tuple, LevelInfo leafLevel) {
        PersistedLeaf leaf = (PersistedLeaf)leafLevel.currentPage;
        PersistedKeyHolder<K> keyHolder = new PersistedKeyHolder<K>(btree.getKeySerializer(), tuple.getKey());
        PersistedValueHolder<Object> valueHolder = new PersistedValueHolder<Object>(btree, tuple.getValue().toArray());
        leaf.setKey(leafLevel.currentPos, keyHolder);
        leaf.setValue(leafLevel.currentPos, valueHolder);
        leafLevel.currentPos++;
    }

    private int computeNbElemsLeaf(BTree<K, V> btree, LevelInfo levelInfo) {
        int pageSize = btree.getPageSize();
        int remaining = levelInfo.nbElems - levelInfo.nbAddedElems;
        if (remaining < pageSize) {
            return remaining;
        }
        if (remaining == pageSize) {
            return pageSize;
        }
        if (remaining > levelInfo.nbElems - levelInfo.nbElemsLimit) {
            return pageSize;
        }
        return remaining - pageSize / 2;
    }

    int computeNbElemsNode(BTree<K, V> btree, LevelInfo levelInfo) {
        int pageSize = btree.getPageSize();
        int remaining = levelInfo.nbElems - levelInfo.nbAddedElems;
        if (remaining < pageSize + 1) {
            return remaining;
        }
        if (remaining == pageSize + 1) {
            return pageSize + 1;
        }
        if (remaining > levelInfo.nbElems - levelInfo.nbElemsLimit) {
            return pageSize + 1;
        }
        return remaining - pageSize / 2;
    }

    private void injectInRoot(BTree<K, V> btree, Page<K, V> page, PageHolder<K, V> pageHolder, LevelInfo level) throws IOException {
        PersistedNode node = (PersistedNode)level.currentPage;
        if (level.currentPos == 0 && node.getPage(0) == null) {
            node.setPageHolder(0, pageHolder);
            level.nbAddedElems++;
        } else {
            node.setPageHolder(level.currentPos + 1, pageHolder);
            PersistedKeyHolder<K> keyHolder = new PersistedKeyHolder<K>(btree.getKeySerializer(), page.getLeftMostKey());
            node.setKey(level.currentPos, keyHolder);
            level.currentPos++;
            level.nbAddedElems++;
            if (level.nbAddedElems == level.nbElems) {
                PageHolder<K, V> rootHolder = ((PersistedBTree)btree).getRecordManager().writePage(btree, node, 0L);
                ((PersistedBTree)btree).setRootPage(rootHolder.getValue());
            }
        }
    }

    private void injectInNode(BTree<K, V> btree, Page<K, V> page, List<LevelInfo> levels, int levelIndex) throws IOException {
        int pageSize = btree.getPageSize();
        LevelInfo level = levels.get(levelIndex);
        PersistedNode node = (PersistedNode)level.currentPage;
        PageHolder<K, V> pageHolder = ((PersistedBTree)btree).getRecordManager().writePage(btree, page, 0L);
        if (level.nbElems <= pageSize + 1) {
            this.injectInRoot(btree, page, pageHolder, level);
            return;
        }
        if (level.nbAddedElems < level.nbElemsLimit) {
            if (level.currentPos == 0 && node.getKey(0) == null) {
                node.setPageHolder(0, pageHolder);
            } else {
                node.setPageHolder(level.currentPos, pageHolder);
                PersistedKeyHolder<K> keyHolder = new PersistedKeyHolder<K>(btree.getKeySerializer(), page.getLeftMostKey());
                node.setKey(level.currentPos - 1, keyHolder);
            }
            level.currentPos++;
            level.nbAddedElems++;
            if (level.nbAddedElems == level.nbElems) {
                this.injectInNode(btree, node, levels, levelIndex + 1);
                return;
            }
            if (level.currentPos == pageSize + 1 && level.levelNumber < levels.size() - 1) {
                this.injectInNode(btree, node, levels, levelIndex + 1);
                level.currentPage = level.nbAddedElems < level.nbElemsLimit ? BTreeFactory.createNode(btree, 0L, pageSize) : (level.nbElems - level.nbAddedElems <= pageSize ? BTreeFactory.createNode(btree, 0L, level.nbElems - level.nbAddedElems - 1) : BTreeFactory.createNode(btree, 0L, level.nbElems - 1 - (level.nbAddedElems + 1) - pageSize / 2));
                level.currentPos = 0;
            }
            return;
        }
        if (level.nbElems - level.nbElemsLimit > pageSize) {
            if (level.nbElems - level.nbAddedElems <= pageSize / 2 + 1) {
                if (level.currentPos == 0 && node.getKey(0) == null) {
                    node.setPageHolder(0, pageHolder);
                } else {
                    node.setPageHolder(level.currentPos, pageHolder);
                    PersistedKeyHolder<K> keyHolder = new PersistedKeyHolder<K>(btree.getKeySerializer(), page.getLeftMostKey());
                    node.setKey(level.currentPos - 1, keyHolder);
                }
                level.currentPos++;
                level.nbAddedElems++;
                if (level.nbAddedElems == level.nbElems) {
                    this.injectInNode(btree, node, levels, levelIndex + 1);
                }
            } else {
                if (level.currentPos == 0 && node.getKey(0) == null) {
                    node.setPageHolder(0, pageHolder);
                } else {
                    node.setPageHolder(level.currentPos, pageHolder);
                    PersistedKeyHolder<K> keyHolder = new PersistedKeyHolder<K>(btree.getKeySerializer(), page.getLeftMostKey());
                    node.setKey(level.currentPos - 1, keyHolder);
                }
                level.currentPos++;
                level.nbAddedElems++;
                if (level.currentPos == node.getNbElems() + 1) {
                    this.injectInNode(btree, node, levels, levelIndex + 1);
                    level.currentPage = BTreeFactory.createNode(btree, 0L, pageSize / 2);
                    level.currentPos = 0;
                }
            }
        } else {
            if (level.nbAddedElems == level.nbElems) {
                this.injectInNode(btree, node, levels, levelIndex + 1);
            } else {
                if (level.currentPos == 0 && node.getKey(0) == null) {
                    node.setPageHolder(0, pageHolder);
                } else {
                    node.setPageHolder(level.currentPos, pageHolder);
                    PersistedKeyHolder<K> keyHolder = new PersistedKeyHolder<K>(btree.getKeySerializer(), page.getLeftMostKey());
                    node.setKey(level.currentPos - 1, keyHolder);
                }
                level.currentPos++;
                level.nbAddedElems++;
                if (level.currentPos == node.getNbElems() + 1) {
                    this.injectInNode(btree, node, levels, levelIndex + 1);
                    level.currentPage = BTreeFactory.createNode(btree, 0L, pageSize / 2);
                    level.currentPos = 0;
                }
            }
            return;
        }
    }

    private BTree<K, V> bulkLoadSinglePage(BTree<K, V> btree, Iterator<Tuple<K, Set<V>>> dataIterator, int nbElems) throws IOException {
        PersistedLeaf rootPage = (PersistedLeaf)BTreeFactory.createLeaf(btree, 0L, nbElems);
        int pos = 0;
        while (dataIterator.hasNext()) {
            Tuple<K, Set<V>> tuple = dataIterator.next();
            PersistedKeyHolder<K> keyHolder = new PersistedKeyHolder<K>(btree.getKeySerializer(), tuple.getKey());
            PersistedValueHolder<Object> valueHolder = new PersistedValueHolder<Object>(btree, tuple.getValue().toArray());
            rootPage.setKey(pos, keyHolder);
            rootPage.setValue(pos, valueHolder);
            ++pos;
        }
        ((PersistedBTree)btree).getRecordManager().writePage(btree, rootPage, 0L);
        ((PersistedBTree)btree).getBtreeHeader().setRootPage(rootPage);
        ((PersistedBTree)btree).getBtreeHeader().setNbElems(nbElems);
        return btree;
    }

    private BTree<K, V> bulkLoad(BTree<K, V> btree, Iterator<Tuple<K, Set<V>>> dataIterator, int nbElems) throws IOException {
        int pageSize = btree.getPageSize();
        if (nbElems <= pageSize) {
            return this.bulkLoadSinglePage(btree, dataIterator, nbElems);
        }
        List<LevelInfo> levels = this.computeLevels(btree, nbElems);
        LevelInfo leafLevel = levels.get(0);
        while (dataIterator.hasNext()) {
            if (leafLevel.nbAddedElems < leafLevel.nbElemsLimit) {
                Tuple<K, Set<V>> tuple = dataIterator.next();
                this.injectInLeaf(btree, tuple, leafLevel);
                leafLevel.nbAddedElems++;
                if (leafLevel.currentPos != pageSize) continue;
                this.injectInNode(btree, leafLevel.currentPage, levels, 1);
                leafLevel.currentPage = BTreeFactory.createLeaf(btree, 0L, this.computeNbElemsLeaf(btree, leafLevel));
                leafLevel.currentPos = 0;
                continue;
            }
            if (leafLevel.nbAddedElems == nbElems) break;
            if (nbElems - leafLevel.nbElemsLimit > pageSize) {
                Tuple<K, Set<V>> tuple;
                int nbToAdd;
                for (nbToAdd = nbElems - leafLevel.nbElemsLimit - pageSize / 2; nbToAdd > 0; --nbToAdd) {
                    tuple = dataIterator.next();
                    this.injectInLeaf(btree, tuple, leafLevel);
                    leafLevel.nbAddedElems++;
                }
                this.injectInNode(btree, leafLevel.currentPage, levels, 1);
                leafLevel.currentPage = BTreeFactory.createLeaf(btree, 0L, nbToAdd);
                leafLevel.currentPos = 0;
                for (nbToAdd = pageSize / 2; nbToAdd > 0; --nbToAdd) {
                    tuple = dataIterator.next();
                    this.injectInLeaf(btree, tuple, leafLevel);
                    leafLevel.nbAddedElems++;
                }
                this.injectInNode(btree, leafLevel.currentPage, levels, 1);
                break;
            }
            for (int nbToAdd = nbElems - leafLevel.nbElemsLimit; nbToAdd > 0; --nbToAdd) {
                Tuple<K, Set<V>> tuple = dataIterator.next();
                this.injectInLeaf(btree, tuple, leafLevel);
                leafLevel.nbAddedElems++;
            }
            this.injectInNode(btree, leafLevel.currentPage, levels, 1);
            break;
        }
        return btree;
    }

    private File flushToDisk(int fileNb, List<Tuple<K, V>> tuples, BTree<K, V> btree) throws IOException {
        Tuple<K, Set<V>>[] sortedTuples = this.sort(btree, tuples);
        File file = File.createTempFile("sorted", Integer.toString(fileNb));
        file.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(file);
        for (Tuple<K, Set<V>> tuple : sortedTuples) {
            byte[] bytesKey = btree.getKeySerializer().serialize(tuple.key);
            fos.write(IntSerializer.serialize(bytesKey.length));
            fos.write(bytesKey);
            int nbValues = tuple.getValue().size();
            fos.write(IntSerializer.serialize(nbValues));
            for (V value : tuple.getValue()) {
                byte[] bytesValue = btree.getValueSerializer().serialize(value);
                fos.write(IntSerializer.serialize(bytesValue.length));
                fos.write(bytesValue);
            }
        }
        fos.flush();
        fos.close();
        return file;
    }

    private Tuple<K, Set<V>>[] sort(BTree<K, V> btree, List<Tuple<K, V>> tuples) {
        TupleComparator<K, V> tupleComparator = new TupleComparator<K, V>(btree.getKeyComparator(), btree.getValueComparator());
        Tuple[] tuplesArray = tuples.toArray(new Tuple[0]);
        HashMap mapTuples = new HashMap();
        for (Tuple tuple : tuplesArray) {
            Set foundSet = (Set)mapTuples.get(tuple.key);
            if (foundSet != null) {
                foundSet.add(tuple.value);
                continue;
            }
            TreeSet set = new TreeSet();
            set.add(tuple.value);
            mapTuples.put(tuple.key, set);
        }
        int size = mapTuples.size();
        Tuple[] sortedTuples = new Tuple[size];
        int pos = 0;
        for (Map.Entry entry : mapTuples.entrySet()) {
            sortedTuples[pos] = new Tuple();
            sortedTuples[pos].key = entry.getKey();
            sortedTuples[pos].value = entry.getValue();
            ++pos;
        }
        Arrays.sort(sortedTuples, tupleComparator);
        return sortedTuples;
    }

    private Iterator<Tuple<K, Set<V>>> createTupleIterator(BTree<K, V> btree, List<Tuple<K, V>> tuples) {
        final Tuple[] sortedTuples = this.sort(btree, tuples);
        Iterator tupleIterator = new Iterator<Tuple<K, Set<V>>>(){
            private int pos = 0;

            @Override
            public Tuple<K, Set<V>> next() {
                if (this.pos < sortedTuples.length) {
                    Tuple tuple = sortedTuples[this.pos];
                    ++this.pos;
                    return tuple;
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.pos < sortedTuples.length;
            }

            @Override
            public void remove() {
            }
        };
        return tupleIterator;
    }

    private Tuple<K, Set<V>> fetchTuple(BTree<K, V> btree, FileInputStream fis) {
        try {
            if (fis.available() == 0) {
                return null;
            }
            Tuple tuple = new Tuple();
            tuple.value = new TreeSet();
            byte[] intBytes = new byte[4];
            fis.read(intBytes);
            int keyLength = IntSerializer.deserialize(intBytes);
            byte[] keyBytes = new byte[keyLength];
            fis.read(keyBytes);
            K key = btree.getKeySerializer().fromBytes(keyBytes);
            tuple.key = key;
            fis.read(intBytes);
            int nbValues = IntSerializer.deserialize(intBytes);
            for (int i = 0; i < nbValues; ++i) {
                fis.read(intBytes);
                int valueLength = IntSerializer.deserialize(intBytes);
                byte[] valueBytes = new byte[valueLength];
                fis.read(valueBytes);
                V value = btree.getValueSerializer().fromBytes(valueBytes);
                ((Set)tuple.value).add(value);
            }
            return tuple;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private Iterator<Tuple<K, Set<V>>> createIterator(final BTree<K, V> btree, final FileInputStream[] streams) throws FileNotFoundException {
        int nbFiles = streams.length;
        final Tuple[] readTuples = new Tuple[nbFiles];
        final TreeMap candidates = new TreeMap(new TupleComparator<K, Integer>(btree.getKeyComparator(), IntComparator.INSTANCE));
        block0: for (int i = 0; i < nbFiles; ++i) {
            while (true) {
                readTuples[i] = this.fetchTuple(btree, streams[i]);
                if (readTuples[i] == null) continue block0;
                Tuple candidate = new Tuple(readTuples[i].key, i, btree.getKeySerializer().getComparator());
                if (!candidates.containsKey(candidate)) {
                    candidates.put(candidate, readTuples[i].getValue());
                    continue block0;
                }
                Set oldValues = (Set)candidates.get(candidate);
                oldValues.addAll((Collection)readTuples[i].getValue());
            }
        }
        Iterator tupleIterator = new Iterator<Tuple<K, Set<V>>>(){

            @Override
            public Tuple<K, Set<V>> next() {
                Tuple tuple;
                block1: {
                    Tuple tupleCandidate = (Tuple)candidates.firstKey();
                    candidates.remove(tupleCandidate);
                    tuple = readTuples[(Integer)tupleCandidate.value];
                    while (true) {
                        readTuples[((Integer)tupleCandidate.value).intValue()] = BulkLoader.this.fetchTuple(btree, streams[(Integer)tupleCandidate.value]);
                        if (readTuples[(Integer)tupleCandidate.value] == null) break block1;
                        if (readTuples[(Integer)tupleCandidate.value] == null) continue;
                        Set oldValues = (Set)candidates.get(readTuples[(Integer)tupleCandidate.value]);
                        if (oldValues == null) break;
                        oldValues.addAll((Collection)readTuples[((Integer)tupleCandidate.value).intValue()].value);
                    }
                    Tuple newTuple = new Tuple(readTuples[((Integer)tupleCandidate.value).intValue()].key, tupleCandidate.value);
                    candidates.put(newTuple, readTuples[(Integer)tupleCandidate.value].getValue());
                }
                return tuple;
            }

            @Override
            public boolean hasNext() {
                return !candidates.isEmpty();
            }

            @Override
            public void remove() {
            }
        };
        return tupleIterator;
    }

    private Iterator<Tuple<K, Set<V>>> createUniqueFileIterator(final BTree<K, V> btree, final FileInputStream stream) throws FileNotFoundException {
        Iterator tupleIterator = new Iterator<Tuple<K, Set<V>>>(){
            boolean hasNext = true;

            @Override
            public Tuple<K, Set<V>> next() {
                Tuple tuple = BulkLoader.this.fetchTuple(btree, stream);
                return tuple;
            }

            @Override
            public boolean hasNext() {
                try {
                    return stream.available() > 0;
                }
                catch (IOException e) {
                    return false;
                }
            }

            @Override
            public void remove() {
            }
        };
        return tupleIterator;
    }

    public static void compact(RecordManager recordManager, BTree<?, ?> btree) {
    }

    public static BTree<?, ?> compact(BTree<?, ?> btree) throws IOException, KeyNotFoundException {
        InMemoryBTreeConfiguration configuration = new InMemoryBTreeConfiguration();
        configuration.setName(btree.getName());
        configuration.setPageSize(btree.getPageSize());
        configuration.setKeySerializer(btree.getKeySerializer());
        configuration.setValueSerializer(btree.getValueSerializer());
        configuration.setAllowDuplicates(btree.isAllowDuplicates());
        configuration.setReadTimeOut(btree.getReadTimeOut());
        configuration.setWriteBufferSize(btree.getWriteBufferSize());
        File file = ((InMemoryBTree)btree).getFile();
        if (file != null) {
            configuration.setFilePath(file.getPath());
        }
        InMemoryBTreeBuilder btreeBuilder = new InMemoryBTreeBuilder(configuration);
        final TupleCursor<?, ?> cursor = btree.browse();
        Iterator<Tuple> tupleItr = new Iterator<Tuple>(){

            @Override
            public Tuple next() {
                try {
                    return cursor.next();
                }
                catch (EndOfFileExceededException e) {
                    return null;
                }
                catch (IOException e) {
                    return null;
                }
            }

            @Override
            public boolean hasNext() {
                try {
                    return cursor.hasNext();
                }
                catch (EndOfFileExceededException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }

            @Override
            public void remove() {
            }
        };
        return btreeBuilder.build(tupleItr);
    }

    class LevelInfo {
        private int levelNumber;
        int nbElems;
        int nbPages;
        int nbElemsLimit;
        private boolean isNode;
        Page<K, V> currentPage;
        private int currentPos;
        private int nbAddedElems;

        LevelInfo() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.isNode) {
                sb.append("NodeLevel[");
                sb.append(this.levelNumber);
                sb.append("] :");
            } else {
                sb.append("LeafLevel:");
            }
            sb.append("\n    nbElems           = ").append(this.nbElems);
            sb.append("\n    nbPages           = ").append(this.nbPages);
            sb.append("\n    nbElemsLimit      = ").append(this.nbElemsLimit);
            sb.append("\n    nbAddedElems      = ").append(this.nbAddedElems);
            sb.append("\n    currentPos        = ").append(this.currentPos);
            sb.append("\n    currentPage");
            sb.append("\n        nbKeys : ").append(this.currentPage.getNbElems());
            return sb.toString();
        }
    }

    static enum LevelEnum {
        LEAF,
        NODE;

    }
}

