/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.ad;

import java.util.Arrays;
import org.apache.directory.api.ldap.extras.controls.ad.AdDirSync;
import org.apache.directory.api.ldap.extras.controls.ad.AdDirSyncFlag;
import org.apache.directory.api.ldap.model.message.controls.AbstractControl;
import org.apache.directory.api.util.Strings;

public class AdDirSyncImpl
extends AbstractControl
implements AdDirSync {
    int parentFirst = 1;
    AdDirSyncFlag flag = AdDirSyncFlag.DEFAULT;
    int maxReturnLength = 0;
    private byte[] cookie;

    public AdDirSyncImpl() {
        super("1.2.840.113556.1.4.841", Boolean.TRUE);
    }

    @Override
    public int getParentFirst() {
        return this.parentFirst;
    }

    @Override
    public void setParentFirst(int parentFirst) {
        this.parentFirst = parentFirst;
    }

    @Override
    public AdDirSyncFlag getFlag() {
        return this.flag;
    }

    @Override
    public void setFlag(AdDirSyncFlag flag) {
        this.flag = flag;
    }

    @Override
    public int getMaxReturnLength() {
        return this.maxReturnLength;
    }

    @Override
    public void setMaxReturnLength(int maxReturnLength) {
        this.maxReturnLength = maxReturnLength;
    }

    @Override
    public byte[] getCookie() {
        return this.cookie;
    }

    @Override
    public void setCookie(byte[] cookie) {
        if (cookie != null) {
            this.cookie = new byte[cookie.length];
            System.arraycopy(cookie, 0, this.cookie, 0, cookie.length);
        } else {
            this.cookie = Strings.EMPTY_BYTES;
        }
    }

    @Override
    public int hashCode() {
        int h = 37;
        h = h * 17 + super.hashCode();
        h = h * 17 + this.parentFirst;
        h = h * 17 + this.maxReturnLength;
        if (this.cookie != null) {
            for (byte b : this.cookie) {
                h = h * 17 + b;
            }
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdDirSync)) {
            return false;
        }
        AdDirSync otherControl = (AdDirSync)o;
        return this.maxReturnLength == otherControl.getMaxReturnLength() && this.parentFirst == otherControl.getParentFirst() && Arrays.equals(this.cookie, otherControl.getCookie()) && this.isCritical() == otherControl.isCritical();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    DirSync control :\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        sb.append("        parentFirst : '").append(this.getParentFirst()).append("'\n");
        sb.append("        maxReturnLength : '").append(this.getMaxReturnLength()).append("'\n");
        sb.append("        cookie            : '").append(Strings.dumpBytes(this.getCookie())).append("'\n");
        return sb.toString();
    }
}

