/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.name;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.impl.BitSet;
import java.util.List;
import org.apache.directory.api.ldap.model.entry.BinaryValue;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.AntlrDnTokenTypes;
import org.apache.directory.api.ldap.model.name.Ava;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.parsers.ParserMonitor;
import org.apache.directory.api.util.ByteBuffer;
import org.apache.directory.api.util.Strings;

public class AntlrDnParser
extends LLkParser
implements AntlrDnTokenTypes {
    private ParserMonitor monitor = null;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "COMMA", "EQUALS", "PLUS", "HYPHEN", "UNDERSCORE", "DQUOTE", "SEMI", "LANGLE", "RANGLE", "SPACE", "NUMERICOID_OR_ALPHA_OR_DIGIT", "NUMERICOID", "DOT", "NUMBER", "LDIGIT", "DIGIT", "ALPHA", "HEXPAIR_OR_ESCESC_ESCSHARP_OR_ESC", "HEXPAIR", "ESC", "ESCESC", "ESCSHARP", "HEX", "HEXVALUE_OR_SHARP", "HEXVALUE", "SHARP", "UTFMB", "LUTF1_REST"};
    public static final BitSet _tokenSet_0 = new BitSet(AntlrDnParser.mk_tokenSet_0());

    public void setParserMonitor(ParserMonitor monitor) {
        this.monitor = monitor;
    }

    private void matchedProduction(String msg) {
        if (null != this.monitor) {
            this.monitor.matchedProduction(msg);
        }
    }

    protected AntlrDnParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public AntlrDnParser(TokenBuffer tokenBuf) {
        this(tokenBuf, 3);
    }

    protected AntlrDnParser(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    public AntlrDnParser(TokenStream lexer) {
        this(lexer, 3);
    }

    public AntlrDnParser(ParserSharedInputState state) {
        super(state, 3);
        this.tokenNames = _tokenNames;
    }

    public final void distinguishedName(Dn dn) throws RecognitionException, TokenStreamException {
        this.matchedProduction("distinguishedName()");
        Rdn rdn = null;
        switch (this.LA(1)) {
            case 13: 
            case 15: 
            case 20: {
                rdn = this.relativeDistinguishedName(new Rdn());
                try {
                    dn.add(rdn);
                }
                catch (LdapInvalidDnException lide) {
                    // empty catch block
                }
                rdn = null;
                while (this.LA(1) == 4 || this.LA(1) == 10) {
                    switch (this.LA(1)) {
                        case 4: {
                            this.match(4);
                            break;
                        }
                        case 10: {
                            this.match(10);
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    rdn = this.relativeDistinguishedName(new Rdn());
                    try {
                        dn.add(rdn);
                    }
                    catch (LdapInvalidDnException ldapInvalidDnException) {
                        // empty catch block
                    }
                    rdn = null;
                }
                this.match(1);
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final Rdn relativeDistinguishedName(Rdn initialRdn) throws RecognitionException, TokenStreamException {
        this.matchedProduction("relativeDistinguishedName()");
        Rdn rdn = initialRdn;
        String upName = "";
        String tmp = this.attributeTypeAndValue(rdn);
        upName = upName + tmp;
        while (this.LA(1) == 6) {
            this.match(6);
            upName = upName + "+";
            tmp = this.attributeTypeAndValue(rdn);
            upName = upName + tmp;
        }
        rdn.normalize();
        rdn.setUpName(upName);
        return rdn;
    }

    public final void relativeDistinguishedNames(List<Rdn> rdns) throws RecognitionException, TokenStreamException {
        this.matchedProduction("relativeDistinguishedNames()");
        Rdn rdn = null;
        switch (this.LA(1)) {
            case 13: 
            case 15: 
            case 20: {
                rdn = this.relativeDistinguishedName(new Rdn());
                rdns.add(rdn);
                while (this.LA(1) == 4 || this.LA(1) == 10) {
                    switch (this.LA(1)) {
                        case 4: {
                            this.match(4);
                            break;
                        }
                        case 10: {
                            this.match(10);
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    rdn = this.relativeDistinguishedName(new Rdn());
                    rdns.add(rdn);
                }
                this.match(1);
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final String attributeTypeAndValue(Rdn rdn) throws RecognitionException, TokenStreamException {
        String upName = "";
        this.matchedProduction("attributeTypeAndValue()");
        String type = null;
        UpAndNormValue value = new UpAndNormValue();
        String upValue = null;
        while (this.LA(1) == 13) {
            this.match(13);
            upName = upName + " ";
        }
        type = this.attributeType();
        upName = upName + type;
        while (this.LA(1) == 13) {
            this.match(13);
            upName = upName + " ";
        }
        this.match(5);
        upName = upName + "=";
        while (this.LA(1) == 13) {
            this.match(13);
            upName = upName + " ";
            if (upValue == null) {
                upValue = " ";
                continue;
            }
            upValue = upValue + " ";
        }
        this.attributeValue(value);
        try {
            upName = upName + value.rawValue;
            Ava ava = null;
            if (value.value instanceof String) {
                Object unescapedValue;
                if (upValue != null) {
                    value.rawValue = upValue + value.rawValue;
                }
                ava = (unescapedValue = Rdn.unescapeValue(Strings.trim(value.rawValue))) instanceof String ? new Ava(type, type, new StringValue((String)unescapedValue), new StringValue((String)value.value), upName) : new Ava(type, type, new BinaryValue((byte[])unescapedValue), new StringValue((String)value.value), upName);
            } else {
                ava = new Ava(type, type, new BinaryValue((byte[])value.value), new BinaryValue((byte[])value.value), upName);
            }
            rdn.addAVA(null, ava);
        }
        catch (LdapInvalidDnException e) {
            throw new SemanticException(e.getMessage());
        }
        return upName;
    }

    public final String attributeType() throws RecognitionException, TokenStreamException {
        String attributeType;
        this.matchedProduction("attributeType()");
        switch (this.LA(1)) {
            case 20: {
                attributeType = this.descr();
                break;
            }
            case 15: {
                attributeType = this.numericoid();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return attributeType;
    }

    public final void attributeValue(UpAndNormValue value) throws RecognitionException, TokenStreamException {
        this.matchedProduction("attributeValue()");
        switch (this.LA(1)) {
            case 9: {
                this.quotestring(value);
                while (this.LA(1) == 13) {
                    this.match(13);
                    value.rawValue = value.rawValue + " ";
                }
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 31: {
                this.string(value);
                break;
            }
            case 28: {
                this.hexstring(value);
                while (this.LA(1) == 13) {
                    this.match(13);
                    value.rawValue = value.rawValue + " ";
                }
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 10: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final String descr() throws RecognitionException, TokenStreamException {
        Token leadkeychar = null;
        Token alpha = null;
        Token digit = null;
        Token hyphen = null;
        Token underscore = null;
        this.matchedProduction("descr()");
        leadkeychar = this.LT(1);
        this.match(20);
        String descr = leadkeychar.getText();
        block6: while (true) {
            switch (this.LA(1)) {
                case 20: {
                    alpha = this.LT(1);
                    this.match(20);
                    descr = descr + alpha.getText();
                    continue block6;
                }
                case 19: {
                    digit = this.LT(1);
                    this.match(19);
                    descr = descr + digit.getText();
                    continue block6;
                }
                case 7: {
                    hyphen = this.LT(1);
                    this.match(7);
                    descr = descr + hyphen.getText();
                    continue block6;
                }
                case 8: {
                    underscore = this.LT(1);
                    this.match(8);
                    descr = descr + underscore.getText();
                    continue block6;
                }
            }
            break;
        }
        return descr;
    }

    public final String numericoid() throws RecognitionException, TokenStreamException {
        String numericoid = "";
        Token noid = null;
        this.matchedProduction("numericoid()");
        noid = this.LT(1);
        this.match(15);
        numericoid = numericoid + noid.getText();
        return numericoid;
    }

    public final void quotestring(UpAndNormValue value) throws RecognitionException, TokenStreamException {
        Token dq1 = null;
        Token s = null;
        Token dq2 = null;
        this.matchedProduction("quotestring()");
        ByteBuffer bb = new ByteBuffer();
        dq1 = this.LT(1);
        this.match(9);
        value.rawValue = value.rawValue + dq1.getText();
        block4: while (true) {
            switch (this.LA(1)) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    s = this.LT(1);
                    this.match(_tokenSet_0);
                    value.rawValue = value.rawValue + s.getText();
                    bb.append(Strings.getBytesUtf8(s.getText()));
                    continue block4;
                }
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    byte[] bytes = this.pair(value);
                    bb.append(bytes);
                    continue block4;
                }
            }
            break;
        }
        dq2 = this.LT(1);
        this.match(9);
        value.rawValue = value.rawValue + dq2.getText();
        String string = Strings.utf8ToString(bb.copyOfUsedBytes());
        value.value = string;
    }

    public final void string(UpAndNormValue value) throws RecognitionException, TokenStreamException {
        byte[] bytes;
        String tmp;
        this.matchedProduction("string()");
        ByteBuffer bb = new ByteBuffer();
        switch (this.LA(1)) {
            case 5: 
            case 7: 
            case 8: 
            case 15: 
            case 19: 
            case 20: 
            case 31: {
                tmp = this.lutf1();
                value.rawValue = value.rawValue + tmp;
                bb.append(Strings.getBytesUtf8(tmp));
                break;
            }
            case 30: {
                tmp = this.utfmb();
                value.rawValue = value.rawValue + tmp;
                bb.append(Strings.getBytesUtf8(tmp));
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                bytes = this.pair(value);
                bb.append(bytes);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        block10: while (true) {
            switch (this.LA(1)) {
                case 5: 
                case 7: 
                case 8: 
                case 13: 
                case 15: 
                case 19: 
                case 20: 
                case 28: 
                case 29: 
                case 31: {
                    tmp = this.sutf1();
                    value.rawValue = value.rawValue + tmp;
                    bb.append(Strings.getBytesUtf8(tmp));
                    continue block10;
                }
                case 30: {
                    tmp = this.utfmb();
                    value.rawValue = value.rawValue + tmp;
                    bb.append(Strings.getBytesUtf8(tmp));
                    continue block10;
                }
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    bytes = this.pair(value);
                    bb.append(bytes);
                    continue block10;
                }
            }
            break;
        }
        String string = Strings.utf8ToString(bb.copyOfUsedBytes());
        for (int rawIndex = value.rawValue.length(); string.length() > 0 && rawIndex > 1 && value.rawValue.charAt(rawIndex - 1) == ' ' && value.rawValue.charAt(rawIndex - 2) != '\\'; --rawIndex) {
            string = string.substring(0, string.length() - 1);
        }
        value.value = string;
    }

    public final void hexstring(UpAndNormValue value) throws RecognitionException, TokenStreamException {
        Token hexValue = null;
        this.matchedProduction("hexstring()");
        hexValue = this.LT(1);
        this.match(28);
        value.rawValue = "#" + hexValue.getText();
        value.value = Strings.toByteArray(hexValue.getText());
    }

    public final byte[] pair(UpAndNormValue value) throws RecognitionException, TokenStreamException {
        byte[] pair;
        Token hexpair = null;
        this.matchedProduction("pair()");
        switch (this.LA(1)) {
            case 24: {
                this.match(24);
                value.rawValue = value.rawValue + "\\\\";
                pair = Strings.getBytesUtf8("\\");
                break;
            }
            case 25: {
                this.match(25);
                value.rawValue = value.rawValue + "\\#";
                pair = Strings.getBytesUtf8("#");
                break;
            }
            case 23: {
                this.match(23);
                String tmp = this.special();
                value.rawValue = value.rawValue + "\\" + tmp;
                pair = Strings.getBytesUtf8(tmp);
                break;
            }
            case 22: {
                hexpair = this.LT(1);
                this.match(22);
                value.rawValue = value.rawValue + "\\" + hexpair.getText();
                pair = Strings.toByteArray(hexpair.getText());
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return pair;
    }

    public final String lutf1() throws RecognitionException, TokenStreamException {
        String lutf1 = "";
        Token rest = null;
        Token equals = null;
        Token hyphen = null;
        Token underscore = null;
        Token digit = null;
        Token alpha = null;
        Token numericoid = null;
        this.matchedProduction("lutf1()");
        switch (this.LA(1)) {
            case 31: {
                rest = this.LT(1);
                this.match(31);
                lutf1 = rest.getText();
                break;
            }
            case 5: {
                equals = this.LT(1);
                this.match(5);
                lutf1 = equals.getText();
                break;
            }
            case 7: {
                hyphen = this.LT(1);
                this.match(7);
                lutf1 = hyphen.getText();
                break;
            }
            case 8: {
                underscore = this.LT(1);
                this.match(8);
                lutf1 = underscore.getText();
                break;
            }
            case 19: {
                digit = this.LT(1);
                this.match(19);
                lutf1 = digit.getText();
                break;
            }
            case 20: {
                alpha = this.LT(1);
                this.match(20);
                lutf1 = alpha.getText();
                break;
            }
            case 15: {
                numericoid = this.LT(1);
                this.match(15);
                lutf1 = numericoid.getText();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return lutf1;
    }

    public final String utfmb() throws RecognitionException, TokenStreamException {
        Token s = null;
        this.matchedProduction("utfmb()");
        s = this.LT(1);
        this.match(30);
        String utfmb = s.getText();
        return utfmb;
    }

    public final String sutf1() throws RecognitionException, TokenStreamException {
        String sutf1 = "";
        Token rest = null;
        Token equals = null;
        Token hyphen = null;
        Token underscore = null;
        Token digit = null;
        Token alpha = null;
        Token sharp = null;
        Token space = null;
        Token hex = null;
        Token numericoid = null;
        this.matchedProduction("sutf1()");
        switch (this.LA(1)) {
            case 31: {
                rest = this.LT(1);
                this.match(31);
                sutf1 = rest.getText();
                break;
            }
            case 5: {
                equals = this.LT(1);
                this.match(5);
                sutf1 = equals.getText();
                break;
            }
            case 7: {
                hyphen = this.LT(1);
                this.match(7);
                sutf1 = hyphen.getText();
                break;
            }
            case 8: {
                underscore = this.LT(1);
                this.match(8);
                sutf1 = underscore.getText();
                break;
            }
            case 19: {
                digit = this.LT(1);
                this.match(19);
                sutf1 = digit.getText();
                break;
            }
            case 20: {
                alpha = this.LT(1);
                this.match(20);
                sutf1 = alpha.getText();
                break;
            }
            case 29: {
                sharp = this.LT(1);
                this.match(29);
                sutf1 = sharp.getText();
                break;
            }
            case 13: {
                space = this.LT(1);
                this.match(13);
                sutf1 = space.getText();
                break;
            }
            case 28: {
                hex = this.LT(1);
                this.match(28);
                sutf1 = "#" + hex.getText();
                break;
            }
            case 15: {
                numericoid = this.LT(1);
                this.match(15);
                sutf1 = numericoid.getText();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return sutf1;
    }

    public final String special() throws RecognitionException, TokenStreamException {
        String special;
        Token dquote = null;
        Token plus = null;
        Token comma = null;
        Token semi = null;
        Token langle = null;
        Token rangle = null;
        Token space = null;
        Token sharp = null;
        Token equals = null;
        this.matchedProduction("special()");
        switch (this.LA(1)) {
            case 9: {
                dquote = this.LT(1);
                this.match(9);
                special = dquote.getText();
                break;
            }
            case 6: {
                plus = this.LT(1);
                this.match(6);
                special = plus.getText();
                break;
            }
            case 4: {
                comma = this.LT(1);
                this.match(4);
                special = comma.getText();
                break;
            }
            case 10: {
                semi = this.LT(1);
                this.match(10);
                special = semi.getText();
                break;
            }
            case 11: {
                langle = this.LT(1);
                this.match(11);
                special = langle.getText();
                break;
            }
            case 12: {
                rangle = this.LT(1);
                this.match(12);
                special = rangle.getText();
                break;
            }
            case 13: {
                space = this.LT(1);
                this.match(13);
                special = space.getText();
                break;
            }
            case 29: {
                sharp = this.LT(1);
                this.match(29);
                special = sharp.getText();
                break;
            }
            case 5: {
                equals = this.LT(1);
                this.match(5);
                special = equals.getText();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return special;
    }

    private static final long[] mk_tokenSet_0() {
        long[] data = new long[]{4232052208L, 0L, 0L, 0L};
        return data;
    }

    static class UpAndNormValue {
        Object value = "";
        String rawValue = "";

        UpAndNormValue() {
        }
    }
}

