/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.schema;

import java.util.ArrayList;
import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapContextNotEmptyException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.message.SearchRequestImpl;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.SchemaUtils;
import org.apache.directory.api.util.DateUtils;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.api.partition.AbstractPartition;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.schema.registries.synchronizers.RegistrySynchronizerAdaptor;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaPartition
extends AbstractPartition {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaPartition.class);
    private static final String SCHEMA_ID = "schema";
    private Partition wrapped;
    private RegistrySynchronizerAdaptor synchronizer;
    private static Dn SCHEMA_MODIFICATION_DN;
    private static Dn SCHEMA_DN;
    private static AttributeType OBJECT_CLASS_AT;

    public SchemaPartition(SchemaManager schemaManager) {
        try {
            SCHEMA_DN = new Dn(schemaManager, "ou=schema");
        }
        catch (LdapInvalidDnException ldapInvalidDnException) {
            // empty catch block
        }
        this.id = SCHEMA_ID;
        this.suffixDn = SCHEMA_DN;
        this.schemaManager = schemaManager;
        OBJECT_CLASS_AT = schemaManager.getAttributeType("2.5.4.0");
    }

    public void setWrappedPartition(Partition wrapped) {
        if (this.isInitialized()) {
            throw new IllegalStateException(I18n.err(I18n.ERR_429, new Object[0]));
        }
        this.wrapped = wrapped;
    }

    public Partition getWrappedPartition() {
        return this.wrapped;
    }

    @Override
    public void setId(String id) {
        LOG.warn("This partition's ID is fixed: {}", (Object)SCHEMA_ID);
    }

    @Override
    public void sync() throws Exception {
        this.wrapped.sync();
    }

    @Override
    protected void doInit() throws Exception {
        if (!this.initialized) {
            this.wrapped.setId(SCHEMA_ID);
            this.wrapped.setSuffixDn(SCHEMA_DN);
            this.wrapped.setSchemaManager(this.schemaManager);
            try {
                this.wrapped.initialize();
                this.synchronizer = new RegistrySynchronizerAdaptor(this.schemaManager);
            }
            catch (Exception e) {
                LOG.error(I18n.err(I18n.ERR_90, new Object[0]), e);
                throw new RuntimeException(e);
            }
            SCHEMA_MODIFICATION_DN = new Dn(this.schemaManager, "ou=schemaModifications,ou=schema");
        }
    }

    @Override
    protected void doDestroy() {
        try {
            this.wrapped.destroy();
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_91, new Object[0]), e);
            throw new RuntimeException(e);
        }
        this.initialized = false;
    }

    @Override
    public void add(AddOperationContext addContext) throws LdapException {
        this.synchronizer.add(addContext);
        this.wrapped.add(addContext);
        this.updateSchemaModificationAttributes(addContext);
    }

    public final int getChildCount(DeleteOperationContext deleteContext) throws LdapException {
        try {
            int nbEntry;
            Dn dn = deleteContext.getDn();
            SearchRequestImpl searchRequest = new SearchRequestImpl();
            searchRequest.setBase(dn);
            PresenceNode node = new PresenceNode(OBJECT_CLASS_AT);
            searchRequest.setFilter(node);
            searchRequest.setTypesOnly(true);
            searchRequest.setScope(SearchScope.ONELEVEL);
            SearchOperationContext searchContext = new SearchOperationContext(deleteContext.getSession(), searchRequest);
            EntryFilteringCursor cursor = this.wrapped.search(searchContext);
            cursor.beforeFirst();
            for (nbEntry = 0; cursor.next() && nbEntry < 2; ++nbEntry) {
            }
            cursor.close();
            return nbEntry;
        }
        catch (Exception e) {
            LOG.warn("Failed to get the children of entry {}", (Object)deleteContext.getDn());
            return 0;
        }
    }

    @Override
    public Entry delete(DeleteOperationContext deleteContext) throws LdapException {
        boolean cascade = deleteContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1");
        int nbChild = this.getChildCount(deleteContext);
        if (nbChild > 1) {
            throw new LdapContextNotEmptyException("There are children under the entry " + deleteContext.getDn());
        }
        this.synchronizer.delete(deleteContext, cascade);
        Entry deletedEntry = null;
        deletedEntry = this.wrapped.delete(deleteContext);
        this.updateSchemaModificationAttributes(deleteContext);
        return deletedEntry;
    }

    @Override
    public boolean hasEntry(HasEntryOperationContext hasEntryContext) throws LdapException {
        return this.wrapped.hasEntry(hasEntryContext);
    }

    @Override
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        boolean cascade;
        Entry targetEntry;
        boolean hasModification;
        Entry entry = modifyContext.getEntry();
        if (entry == null) {
            LookupOperationContext lookupCtx = new LookupOperationContext(modifyContext.getSession(), modifyContext.getDn());
            entry = this.wrapped.lookup(lookupCtx);
            modifyContext.setEntry(entry);
        }
        if (hasModification = this.synchronizer.modify(modifyContext, targetEntry = SchemaUtils.getTargetEntry(modifyContext.getModItems(), entry), cascade = modifyContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1"))) {
            this.wrapped.modify(modifyContext);
        }
        if (!modifyContext.getDn().equals(SCHEMA_MODIFICATION_DN)) {
            this.updateSchemaModificationAttributes(modifyContext);
        }
    }

    @Override
    public void move(MoveOperationContext moveContext) throws LdapException {
        boolean cascade = moveContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1");
        CoreSession session = moveContext.getSession();
        LookupOperationContext lookupContext = new LookupOperationContext(session, moveContext.getDn(), SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        Entry entry = session.getDirectoryService().getPartitionNexus().lookup(lookupContext);
        this.synchronizer.move(moveContext, entry, cascade);
        this.wrapped.move(moveContext);
        this.updateSchemaModificationAttributes(moveContext);
    }

    @Override
    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        boolean cascade = moveAndRenameContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1");
        CoreSession session = moveAndRenameContext.getSession();
        LookupOperationContext lookupContext = new LookupOperationContext(session, moveAndRenameContext.getDn(), SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        Entry entry = session.getDirectoryService().getPartitionNexus().lookup(lookupContext);
        this.synchronizer.moveAndRename(moveAndRenameContext, entry, cascade);
        this.wrapped.moveAndRename(moveAndRenameContext);
        this.updateSchemaModificationAttributes(moveAndRenameContext);
    }

    @Override
    public void rename(RenameOperationContext renameContext) throws LdapException {
        boolean cascade = renameContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1");
        this.synchronizer.rename(renameContext, cascade);
        this.wrapped.rename(renameContext);
        this.updateSchemaModificationAttributes(renameContext);
    }

    @Override
    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        return this.wrapped.search(searchContext);
    }

    @Override
    public void unbind(UnbindOperationContext unbindContext) throws LdapException {
        this.wrapped.unbind(unbindContext);
    }

    @Override
    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        return this.wrapped.lookup(lookupContext);
    }

    private void updateSchemaModificationAttributes(OperationContext opContext) throws LdapException {
        String modifiersName = opContext.getSession().getEffectivePrincipal().getName();
        String modifyTimestamp = DateUtils.getGeneralizedTime();
        ArrayList<Modification> mods = new ArrayList<Modification>(2);
        mods.add(new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, new DefaultAttribute("schemaModifyTimestamp", this.schemaManager.lookupAttributeTypeRegistry("schemaModifyTimestamp"), modifyTimestamp)));
        mods.add(new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, new DefaultAttribute("schemaModifiersName", this.schemaManager.lookupAttributeTypeRegistry("schemaModifiersName"), modifiersName)));
        CoreSession session = opContext.getSession();
        ModifyOperationContext modifyContext = new ModifyOperationContext(session, SCHEMA_MODIFICATION_DN, mods);
        session.getDirectoryService().getPartitionNexus().modify(modifyContext);
    }

    @Override
    public String getContextCsn() {
        return this.wrapped.getContextCsn();
    }

    @Override
    public void saveContextCsn() throws Exception {
        this.wrapped.saveContextCsn();
    }

    public String toString() {
        return "Partition : schema";
    }
}

