/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.apache.directory.mavibot.btree.AbstractPage;
import org.apache.directory.mavibot.btree.AbstractValueHolder;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BTreeFactory;
import org.apache.directory.mavibot.btree.BTreeHeader;
import org.apache.directory.mavibot.btree.BTreeTypeEnum;
import org.apache.directory.mavibot.btree.KeyHolder;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.PageHolder;
import org.apache.directory.mavibot.btree.PersistedBTree;
import org.apache.directory.mavibot.btree.PersistedBTreeConfiguration;
import org.apache.directory.mavibot.btree.PersistedLeaf;
import org.apache.directory.mavibot.btree.PersistedNode;
import org.apache.directory.mavibot.btree.PersistedPageHolder;
import org.apache.directory.mavibot.btree.RecordManager;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.TupleCursor;
import org.apache.directory.mavibot.btree.ValueCursor;
import org.apache.directory.mavibot.btree.ValueHolder;
import org.apache.directory.mavibot.btree.exception.BTreeAlreadyCreatedException;
import org.apache.directory.mavibot.btree.exception.BTreeAlreadyManagedException;
import org.apache.directory.mavibot.btree.exception.BTreeCreationException;
import org.apache.directory.mavibot.btree.exception.KeyNotFoundException;
import org.apache.directory.mavibot.btree.serializer.IntSerializer;
import org.apache.directory.mavibot.btree.serializer.LongSerializer;

class PersistedValueHolder<V>
extends AbstractValueHolder<V> {
    protected PersistedBTree<V, V> parentBtree;
    private byte[] raw;
    private boolean isDeserialized = false;
    private boolean isRawUpToDate = false;

    PersistedValueHolder(BTree<?, V> parentBtree, int nbValues, byte[] raw) {
        this.parentBtree = (PersistedBTree)parentBtree;
        this.valueSerializer = parentBtree.getValueSerializer();
        this.raw = raw;
        this.isRawUpToDate = true;
        this.valueThresholdUp = PersistedBTree.valueThresholdUp;
        this.valueThresholdLow = PersistedBTree.valueThresholdLow;
        if (nbValues <= this.valueThresholdUp) {
            this.valueArray = (Object[])Array.newInstance(this.valueSerializer.getType(), nbValues);
        }
    }

    PersistedValueHolder(BTree<?, V> parentBtree, V ... values) {
        this.parentBtree = (PersistedBTree)parentBtree;
        this.valueSerializer = parentBtree.getValueSerializer();
        this.valueThresholdUp = PersistedBTree.valueThresholdUp;
        this.valueThresholdLow = PersistedBTree.valueThresholdLow;
        if (values != null) {
            int nbValues = values.length;
            if (nbValues < PersistedBTree.valueThresholdUp) {
                this.valueArray = (Object[])Array.newInstance(this.valueSerializer.getType(), nbValues);
                try {
                    System.arraycopy(values, 0, this.valueArray, 0, values.length);
                }
                catch (ArrayStoreException ase) {
                    ase.printStackTrace();
                    throw ase;
                }
            } else {
                this.createSubTree();
                try {
                    this.build((PersistedBTree)this.valueBtree, values);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            this.valueArray = (Object[])Array.newInstance(this.valueSerializer.getType(), 0);
        }
        this.isDeserialized = true;
    }

    @Override
    public ValueCursor<V> getCursor() {
        this.checkAndDeserialize();
        return super.getCursor();
    }

    byte[] getRaw() {
        if (this.isRawUpToDate) {
            return this.raw;
        }
        if (this.isSubBtree()) {
            long btreeOffset = ((PersistedBTree)this.valueBtree).getBtreeOffset();
            this.raw = LongSerializer.serialize(btreeOffset);
        } else {
            byte[][] valueBytes = new byte[this.valueArray.length * 2][];
            int length = 0;
            int pos = 0;
            for (Object value : this.valueArray) {
                byte[] bytes = this.valueSerializer.serialize(value);
                length += bytes.length;
                byte[] sizeBytes = IntSerializer.serialize(bytes.length);
                length += sizeBytes.length;
                valueBytes[pos++] = sizeBytes;
                valueBytes[pos++] = bytes;
            }
            this.raw = new byte[length];
            pos = 0;
            for (byte[] bytes : valueBytes) {
                System.arraycopy(bytes, 0, this.raw, pos, bytes.length);
                pos += bytes.length;
            }
        }
        this.isRawUpToDate = true;
        return this.raw;
    }

    @Override
    public int size() {
        this.checkAndDeserialize();
        if (this.valueArray == null) {
            return (int)this.valueBtree.getNbElems();
        }
        return this.valueArray.length;
    }

    @Override
    protected void createSubTree() {
        try {
            PersistedBTreeConfiguration configuration = new PersistedBTreeConfiguration();
            configuration.setAllowDuplicates(false);
            configuration.setKeySerializer(this.valueSerializer);
            configuration.setName(UUID.randomUUID().toString());
            configuration.setValueSerializer(this.valueSerializer);
            configuration.setParentBTree(this.parentBtree);
            configuration.setBtreeType(BTreeTypeEnum.PERSISTED_SUB);
            this.valueBtree = BTreeFactory.createPersistedBTree(configuration);
            try {
                this.parentBtree.getRecordManager().manage(this.valueBtree, true);
                this.raw = null;
            }
            catch (BTreeAlreadyManagedException e) {
                throw new BTreeAlreadyCreatedException(e);
            }
        }
        catch (IOException e) {
            throw new BTreeCreationException(e);
        }
    }

    void setSubBtree(BTree<V, V> subBtree) {
        this.valueBtree = subBtree;
        this.raw = null;
        this.valueArray = null;
        this.isDeserialized = true;
        this.isRawUpToDate = false;
    }

    private void checkAndDeserialize() {
        if (!this.isDeserialized) {
            if (this.valueArray == null) {
                this.deserializeSubBtree();
            } else {
                this.deserializeArray();
            }
            this.isDeserialized = true;
        }
    }

    @Override
    public void add(V value) {
        this.checkAndDeserialize();
        super.add(value);
        this.isRawUpToDate = false;
        this.raw = null;
    }

    private V removeFromArray(V value) {
        this.checkAndDeserialize();
        int pos = this.findPos(value);
        if (pos < 0) {
            return null;
        }
        Object[] newValueArray = (Object[])Array.newInstance(this.valueSerializer.getType(), this.valueArray.length - 1);
        System.arraycopy(this.valueArray, 0, newValueArray, 0, pos);
        System.arraycopy(this.valueArray, pos + 1, newValueArray, pos, this.valueArray.length - pos - 1);
        Object removedValue = this.valueArray[pos];
        this.valueArray = newValueArray;
        return (V)removedValue;
    }

    private V removeFromBtree(V removedValue) {
        this.checkAndDeserialize();
        if (this.btreeContains(removedValue)) {
            try {
                if (this.valueBtree.getNbElems() - 1L < (long)PersistedBTree.valueThresholdLow) {
                    int nbValues = (int)(this.valueBtree.getNbElems() - 1L);
                    this.valueArray = (Object[])Array.newInstance(this.valueSerializer.getType(), nbValues);
                    TupleCursor cursor = this.valueBtree.browse();
                    V returnedValue = null;
                    int pos = 0;
                    while (cursor.hasNext()) {
                        Tuple tuple = cursor.next();
                        Object value = tuple.getKey();
                        if (this.valueSerializer.getComparator().compare(removedValue, value) == 0) {
                            returnedValue = (V)value;
                            continue;
                        }
                        this.valueArray[pos++] = value;
                    }
                    return returnedValue;
                }
                Tuple removedTuple = this.valueBtree.delete(removedValue);
                if (removedTuple != null) {
                    return removedTuple.getKey();
                }
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            catch (KeyNotFoundException knfe) {
                knfe.printStackTrace();
                return null;
            }
        }
        return null;
    }

    @Override
    public V remove(V value) {
        V removedValue = null;
        removedValue = this.valueArray != null ? (V)this.removeFromArray(value) : (V)this.removeFromBtree(value);
        this.isRawUpToDate = false;
        this.raw = null;
        return removedValue;
    }

    @Override
    public boolean contains(V checkedValue) {
        this.checkAndDeserialize();
        return super.contains(checkedValue);
    }

    private int findPos(V value) {
        int result;
        if (this.valueArray.length == 0) {
            return -1;
        }
        int pivot = this.valueArray.length / 2;
        int low = 0;
        int high = this.valueArray.length - 1;
        Comparator<Object> comparator = this.valueSerializer.getComparator();
        while (high > low) {
            switch (high - low) {
                case 1: {
                    result = comparator.compare(value, this.valueArray[pivot]);
                    if (result == 0) {
                        return pivot;
                    }
                    if (result < 0) {
                        if (pivot == low) {
                            return -(low + 1);
                        }
                        result = comparator.compare(value, this.valueArray[low]);
                        if (result == 0) {
                            return low;
                        }
                        if (result < 0) {
                            return -(low + 1);
                        }
                        return -(low + 2);
                    }
                    if (pivot == high) {
                        return -(high + 2);
                    }
                    result = comparator.compare(value, this.valueArray[high]);
                    if (result == 0) {
                        return high;
                    }
                    if (result < 0) {
                        return -(high + 1);
                    }
                    return -(high + 2);
                }
            }
            result = comparator.compare(value, this.valueArray[pivot]);
            if (result == 0) {
                return pivot;
            }
            if (result < 0) {
                high = pivot - 1;
            } else {
                low = pivot + 1;
            }
            pivot = (high + low) / 2;
        }
        result = comparator.compare(value, this.valueArray[pivot]);
        if (result == 0) {
            return pivot;
        }
        if (result < 0) {
            return -(pivot + 1);
        }
        return -(pivot + 2);
    }

    @Override
    public ValueHolder<V> clone() throws CloneNotSupportedException {
        PersistedValueHolder copy = (PersistedValueHolder)super.clone();
        if (this.valueArray != null) {
            copy.valueArray = (Object[])Array.newInstance(this.valueSerializer.getType(), this.valueArray.length);
            System.arraycopy(this.valueArray, 0, copy.valueArray, 0, this.valueArray.length);
        }
        if (this.isRawUpToDate) {
            copy.raw = new byte[this.raw.length];
            System.arraycopy(this.raw, 0, copy.raw, 0, this.raw.length);
        }
        return copy;
    }

    private void deserializeArray() {
        int index = 0;
        int pos = 0;
        while (pos < this.raw.length) {
            try {
                int size = IntSerializer.deserialize(this.raw, pos);
                Object value = this.valueSerializer.fromBytes(this.raw, pos += 4);
                pos += size;
                this.valueArray[index++] = value;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void deserializeSubBtree() {
        long offset = LongSerializer.deserialize(this.raw);
        this.valueBtree = this.parentBtree.getRecordManager().loadDupsBtree(offset, this.parentBtree);
    }

    long getOffset() {
        if (this.valueArray == null) {
            return ((PersistedBTree)this.valueBtree).getBtreeOffset();
        }
        return -1L;
    }

    private BTree build(PersistedBTree<V, V> btree, V[] dupKeyValues) throws Exception {
        PageHolder<V, V> pageHolder;
        long newRevision = btree.getRevision() + 1L;
        int numKeysInNode = btree.getPageSize();
        RecordManager rm = btree.getRecordManager();
        ArrayList<Page<V, V>> lstLeaves = new ArrayList<Page<V, V>>();
        int totalTupleCount = 0;
        Page<V, V> leaf1 = BTreeFactory.createLeaf(btree, newRevision, numKeysInNode);
        lstLeaves.add(leaf1);
        int leafIndex = 0;
        for (V v : dupKeyValues) {
            BTreeFactory.setKey(btree, leaf1, leafIndex, v);
            ++leafIndex;
            if (++totalTupleCount % numKeysInNode != 0) continue;
            leafIndex = 0;
            pageHolder = rm.writePage(btree, leaf1, newRevision);
            leaf1 = BTreeFactory.createLeaf(btree, newRevision, numKeysInNode);
            lstLeaves.add(leaf1);
        }
        if (lstLeaves.isEmpty()) {
            return btree;
        }
        PersistedLeaf lastLeaf = (PersistedLeaf)lstLeaves.get(lstLeaves.size() - 1);
        for (int i = 0; i < lastLeaf.nbElems; ++i) {
            int n;
            if (lastLeaf.keys[i] != null) continue;
            lastLeaf.nbElems = n = i;
            KeyHolder[] keys = lastLeaf.keys;
            lastLeaf.keys = (KeyHolder[])Array.newInstance(KeyHolder.class, n);
            System.arraycopy(keys, 0, lastLeaf.keys, 0, n);
            pageHolder = rm.writePage(btree, lastLeaf, newRevision);
            break;
        }
        if (lastLeaf.keys.length == 0) {
            lstLeaves.remove(lastLeaf);
        }
        Page rootPage = this.attachNodes(lstLeaves, btree, numKeysInNode, rm);
        Page<V, V> oldRoot = btree.getRootPage();
        long newRootPageOffset = ((AbstractPage)rootPage).getOffset();
        System.out.println("replacing old offset " + btree.getRootPageOffset() + " of the BTree " + btree.getName() + " with " + newRootPageOffset);
        BTreeHeader header = btree.getBtreeHeader();
        header.setRootPage(rootPage);
        header.setRevision(newRevision);
        header.setNbElems(totalTupleCount);
        long newBtreeHeaderOffset = rm.writeBtreeHeader(btree, header);
        header.setBTreeHeaderOffset(newBtreeHeaderOffset);
        rm.freePages(btree, btree.getRevision(), Arrays.asList(oldRoot));
        return btree;
    }

    private Page attachNodes(List<Page<V, V>> children, BTree btree, int numKeysInNode, RecordManager rm) throws IOException {
        if (children.size() == 1) {
            return children.get(0);
        }
        ArrayList<Page<V, V>> lstNodes = new ArrayList<Page<V, V>>();
        int numChildren = numKeysInNode + 1;
        PersistedNode node = (PersistedNode)BTreeFactory.createNode(btree, btree.getRevision(), numKeysInNode);
        lstNodes.add(node);
        int i = 0;
        int totalNodes = 0;
        for (Page<V, V> p : children) {
            if (i != 0) {
                BTreeFactory.setKey(btree, node, i - 1, p.getLeftMostKey());
            }
            node.children[i] = new PersistedPageHolder<V, V>(btree, p);
            ++i;
            if (++totalNodes % numChildren != 0) continue;
            i = 0;
            PageHolder pageHolder = rm.writePage(btree, node, 1L);
            node = (PersistedNode)BTreeFactory.createNode(btree, btree.getRevision(), numKeysInNode);
            lstNodes.add(node);
        }
        AbstractPage lastNode = (AbstractPage)lstNodes.get(lstNodes.size() - 1);
        for (int j = 0; j < lastNode.nbElems; ++j) {
            int n;
            if (lastNode.keys[j] != null) continue;
            lastNode.nbElems = n = j;
            KeyHolder<K>[] keys = lastNode.keys;
            lastNode.keys = (KeyHolder[])Array.newInstance(KeyHolder.class, n);
            System.arraycopy(keys, 0, lastNode.keys, 0, n);
            PageHolder pageHolder = rm.writePage(btree, lastNode, 1L);
            break;
        }
        if (lastNode.keys.length == 0) {
            lstNodes.remove(lastNode);
        }
        return this.attachNodes(lstNodes, btree, numKeysInNode, rm);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ValueHolder[").append(this.valueSerializer.getClass().getSimpleName());
        if (!this.isDeserialized) {
            sb.append(", isRaw[").append(this.raw.length).append("]");
        } else if (this.valueArray == null) {
            sb.append(", SubBTree");
        } else {
            sb.append(", array{");
            if (this.valueArray == null) {
                sb.append("}");
            } else {
                boolean isFirst = true;
                for (Object value : this.valueArray) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append("/");
                    }
                    sb.append(value);
                }
                sb.append("}");
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

