/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.TupleCursor;
import org.apache.directory.mavibot.btree.exception.EndOfFileExceededException;

public class EmptyTupleCursor<K, V>
extends TupleCursor<K, V> {
    private long revision;
    private long creationDate;

    public EmptyTupleCursor(long revision) {
        this.revision = revision;
        this.creationDate = System.currentTimeMillis();
    }

    @Override
    public void afterLast() throws IOException {
    }

    @Override
    public void beforeFirst() throws IOException {
    }

    @Override
    public boolean hasNext() throws EndOfFileExceededException, IOException {
        return false;
    }

    @Override
    public Tuple<K, V> next() throws EndOfFileExceededException, IOException {
        throw new NoSuchElementException("No tuple present");
    }

    @Override
    public Tuple<K, V> nextKey() throws EndOfFileExceededException, IOException {
        throw new NoSuchElementException("No more tuples present");
    }

    @Override
    public boolean hasNextKey() throws EndOfFileExceededException, IOException {
        return false;
    }

    @Override
    public boolean hasPrev() throws EndOfFileExceededException, IOException {
        return false;
    }

    @Override
    public Tuple<K, V> prev() throws EndOfFileExceededException, IOException {
        throw new NoSuchElementException("No more tuple present");
    }

    @Override
    public Tuple<K, V> prevKey() throws EndOfFileExceededException, IOException {
        throw new NoSuchElementException("No more tuples present");
    }

    @Override
    public boolean hasPrevKey() throws EndOfFileExceededException, IOException {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public long getCreationDate() {
        return this.creationDate;
    }

    @Override
    public long getRevision() {
        return this.revision;
    }

    @Override
    public String toString() {
        return "EmptyTupleCursor";
    }
}

