/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;

public abstract class AbstractMessage
implements Message {
    protected final Map<String, Control> controls;
    private int id;
    private final MessageTypeEnum type;
    private final Map<Object, Object> parameters;

    protected AbstractMessage(int id, MessageTypeEnum type) {
        this.id = id;
        this.type = type;
        this.controls = new HashMap<String, Control>();
        this.parameters = new HashMap<Object, Object>();
    }

    @Override
    public int getMessageId() {
        return this.id;
    }

    @Override
    public Message setMessageId(int id) {
        this.id = id;
        return this;
    }

    @Override
    public Map<String, Control> getControls() {
        return Collections.unmodifiableMap(this.controls);
    }

    @Override
    public Control getControl(String oid) {
        return this.controls.get(oid);
    }

    @Override
    public boolean hasControl(String oid) {
        return this.controls.containsKey(oid);
    }

    @Override
    public Message addControl(Control control) {
        this.controls.put(control.getOid(), control);
        return this;
    }

    @Override
    public Message removeControl(Control control) {
        this.controls.remove(control.getOid());
        return this;
    }

    @Override
    public MessageTypeEnum getType() {
        return this.type;
    }

    @Override
    public Object get(Object key) {
        return this.parameters.get(key);
    }

    @Override
    public Object put(Object key, Object value) {
        return this.parameters.put(key, value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Message)) {
            return false;
        }
        Message msg = (Message)obj;
        if (msg.getMessageId() != this.id) {
            return false;
        }
        if (msg.getType() != this.type) {
            return false;
        }
        Map<String, Control> controls = msg.getControls();
        if (controls.size() != this.controls.size()) {
            return false;
        }
        for (String key : this.controls.keySet()) {
            if (controls.containsKey(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 37;
        hash = hash * 17 + this.id;
        hash = hash * 17 + (this.type == null ? 0 : this.type.hashCode());
        hash = hash * 17 + (this.parameters == null ? 0 : this.parameters.hashCode());
        hash = hash * 17 + (this.controls == null ? 0 : this.controls.hashCode());
        return hash;
    }

    @Override
    public Message addAllControls(Control[] controls) {
        for (Control c : controls) {
            this.controls.put(c.getOid(), c);
        }
        return this;
    }

    public String toString(String message) {
        StringBuilder sb = new StringBuilder();
        sb.append("MessageType : ").append((Object)this.type).append('\n');
        sb.append("Message ID : ").append(this.id).append('\n');
        sb.append(message);
        if (this.controls != null) {
            for (Control control : this.controls.values()) {
                sb.append(control);
            }
        }
        return sb.toString();
    }
}

