/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import jdbm.I18n;
import jdbm.helper.CacheEvictionException;
import jdbm.helper.CachePolicy;
import jdbm.helper.CachePolicyListener;
import jdbm.helper.MRU;

public class SoftCache
implements CachePolicy {
    private static final int INITIAL_CAPACITY = 128;
    private static final float DEFAULT_LOAD_FACTOR = 1.5f;
    private final ReferenceQueue clearQueue = new ReferenceQueue();
    private final CachePolicy internal;
    private final Map map;

    public SoftCache() {
        this(new MRU(128));
    }

    public SoftCache(CachePolicy internal) throws NullPointerException {
        this(1.5f, internal);
    }

    public SoftCache(float loadFactor, CachePolicy internal) throws IllegalArgumentException, NullPointerException {
        if (internal == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_531, new Object[0]));
        }
        this.internal = internal;
        this.map = new HashMap(128, loadFactor);
    }

    public void put(Object key, Object value) throws CacheEvictionException {
        if (key == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_532, new Object[0]));
        }
        if (value == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_533, new Object[0]));
        }
        this.internal.put(key, value);
        this.removeClearedEntries();
        this.map.put(key, new Entry(key, value, this.clearQueue));
    }

    public Object get(Object key) {
        Object value = this.internal.get(key);
        if (value != null) {
            return value;
        }
        this.removeClearedEntries();
        Entry entry = (Entry)this.map.get(key);
        if (entry == null) {
            return null;
        }
        value = entry.getValue();
        if (value == null) {
            return null;
        }
        try {
            this.internal.put(key, value);
        }
        catch (CacheEvictionException e) {
            this.map.remove(key);
            return null;
        }
        return value;
    }

    public void remove(Object key) {
        this.map.remove(key);
        this.internal.remove(key);
    }

    @Override
    public void removeAll() {
        this.map.clear();
        this.internal.removeAll();
    }

    public Enumeration elements() {
        return this.internal.elements();
    }

    public void addListener(CachePolicyListener listener) throws IllegalArgumentException {
        this.internal.addListener(listener);
    }

    public void removeListener(CachePolicyListener listener) {
        this.internal.removeListener(listener);
    }

    private final void removeClearedEntries() {
        Reference r = this.clearQueue.poll();
        while (r != null) {
            Object key = ((Entry)r).getKey();
            this.map.remove(key);
            r = this.clearQueue.poll();
        }
    }

    private static class Entry
    extends SoftReference {
        private final Object key;

        public Entry(Object key, Object value, ReferenceQueue queue) {
            super(value, queue);
            this.key = key;
        }

        final Object getKey() {
            return this.key;
        }

        final Object getValue() {
            return this.get();
        }
    }
}

