/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema;

import java.util.List;
import java.util.Map;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.DitContentRule;
import org.apache.directory.api.ldap.model.schema.DitStructureRule;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.LoadableSchemaObject;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.MatchingRuleUse;
import org.apache.directory.api.ldap.model.schema.NameForm;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.ldap.model.schema.UsageEnum;

public final class DescriptionUtils {
    private DescriptionUtils() {
    }

    public static String getDescription(AttributeType attributeType) {
        StringBuilder buf = new StringBuilder("( ");
        buf.append(attributeType.getOid());
        buf.append('\n');
        if (attributeType.getNames().size() != 0) {
            buf.append(" NAME ");
            DescriptionUtils.getQDescrs(buf, attributeType.getNames());
        }
        if (attributeType.getDescription() != null) {
            buf.append(" DESC ");
            buf.append(attributeType.getDescription());
            buf.append('\n');
        }
        if (attributeType.isObsolete()) {
            buf.append(" OBSOLETE\n");
        }
        if (attributeType.getSuperior() != null) {
            buf.append(" SUP ");
            buf.append(attributeType.getSuperiorName());
            buf.append('\n');
        }
        if (attributeType.getEquality() != null) {
            buf.append(" EQUALITY ");
            buf.append(attributeType.getEqualityName());
            buf.append('\n');
        }
        if (attributeType.getOrdering() != null) {
            buf.append(" ORDERING ");
            buf.append(attributeType.getOrderingName());
            buf.append('\n');
        }
        if (attributeType.getSubstring() != null) {
            buf.append(" SUBSTR ");
            buf.append(attributeType.getSubstringName());
            buf.append('\n');
        }
        if (attributeType.getSyntax() != null) {
            buf.append(" SYNTAX ");
            buf.append(attributeType.getSyntaxName());
            if (attributeType.getSyntaxLength() > 0L) {
                buf.append('{').append(attributeType.getSyntaxLength()).append('}');
            }
            buf.append('\n');
        }
        if (attributeType.isSingleValued()) {
            buf.append(" SINGLE-VALUE\n");
        }
        if (attributeType.isCollective()) {
            buf.append(" COLLECTIVE\n");
        }
        if (!attributeType.isUserModifiable()) {
            buf.append(" NO-USER-MODIFICATION\n");
        }
        buf.append(" USAGE ");
        buf.append(UsageEnum.render(attributeType.getUsage()));
        buf.append('\n');
        if (attributeType.getExtensions() != null) {
            DescriptionUtils.getExtensions(buf, attributeType.getExtensions());
        }
        buf.append(" )\n");
        return buf.toString();
    }

    public static String getDescription(LdapComparator<?> comparator) {
        return DescriptionUtils.getLoadableDescription(comparator);
    }

    public static String getDescription(DitContentRule dITContentRule) {
        List<AttributeType> not;
        List<AttributeType> may;
        List<AttributeType> must;
        List<ObjectClass> aux;
        StringBuilder buf = new StringBuilder("( ");
        buf.append(dITContentRule.getOid());
        buf.append('\n');
        if (dITContentRule.getNames() != null) {
            buf.append(" NAME ");
            DescriptionUtils.getQDescrs(buf, dITContentRule.getNames());
            buf.append('\n');
        }
        if (dITContentRule.getDescription() != null) {
            buf.append(" DESC ");
            buf.append(dITContentRule.getDescription());
            buf.append('\n');
        }
        if (dITContentRule.isObsolete()) {
            buf.append(" OBSOLETE\n");
        }
        if ((aux = dITContentRule.getAuxObjectClasses()) != null && aux.size() > 0) {
            buf.append(" AUX ");
            DescriptionUtils.getQDStrings(buf, aux);
        }
        if ((must = dITContentRule.getMustAttributeTypes()) != null && must.size() > 0) {
            buf.append(" MUST ");
            DescriptionUtils.getQDStrings(buf, must);
        }
        if ((may = dITContentRule.getMayAttributeTypes()) != null && may.size() > 0) {
            buf.append(" MAY ");
            DescriptionUtils.getQDStrings(buf, may);
        }
        if ((not = dITContentRule.getNotAttributeTypes()) != null && not.size() > 0) {
            buf.append(" NOT ");
            DescriptionUtils.getQDStrings(buf, not);
        }
        if (dITContentRule.getExtensions() != null) {
            DescriptionUtils.getExtensions(buf, dITContentRule.getExtensions());
        }
        buf.append(" )\n");
        return buf.toString();
    }

    public static String getDescription(DitStructureRule ditStructureRule) {
        StringBuilder buf = new StringBuilder("( ");
        buf.append(ditStructureRule.getOid());
        buf.append('\n');
        if (ditStructureRule.getNames() != null) {
            buf.append(" NAME ");
            DescriptionUtils.getQDescrs(buf, ditStructureRule.getNames());
        }
        if (ditStructureRule.getDescription() != null) {
            buf.append(" DESC ");
            buf.append(ditStructureRule.getDescription());
            buf.append('\n');
        }
        if (ditStructureRule.isObsolete()) {
            buf.append(" OBSOLETE\n");
        }
        buf.append(" FORM ");
        buf.append(ditStructureRule.getForm());
        buf.append('\n');
        List<Integer> sups = ditStructureRule.getSuperRules();
        if (sups != null && sups.size() > 0) {
            buf.append(" SUP\n");
            if (sups.size() == 1) {
                buf.append(sups.get(0));
            } else {
                boolean isFirst = true;
                buf.append("( ");
                for (int sup : sups) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        buf.append(" ");
                    }
                    buf.append(sup);
                }
                buf.append(" )");
            }
            buf.append('\n');
        }
        buf.append(" )\n");
        return buf.toString();
    }

    public static String getDescription(MatchingRule matchingRule) {
        StringBuilder buf = new StringBuilder("( ");
        buf.append(matchingRule.getOid());
        buf.append('\n');
        if (matchingRule.getNames() != null) {
            buf.append(" NAME ");
            DescriptionUtils.getQDescrs(buf, matchingRule.getNames());
        }
        if (matchingRule.getDescription() != null) {
            buf.append(" DESC ");
            buf.append(matchingRule.getDescription());
            buf.append('\n');
        }
        if (matchingRule.isObsolete()) {
            buf.append(" OBSOLETE\n");
        }
        buf.append(" SYNTAX ");
        buf.append(matchingRule.getSyntaxOid());
        buf.append('\n');
        if (matchingRule.getExtensions() != null) {
            DescriptionUtils.getExtensions(buf, matchingRule.getExtensions());
        }
        buf.append(" ) ");
        return buf.toString();
    }

    public static String getDescription(MatchingRuleUse matchingRuleUse) {
        StringBuilder buf = new StringBuilder("( ");
        buf.append(matchingRuleUse.getOid());
        buf.append('\n');
        buf.append(" NAME ");
        DescriptionUtils.getQDescrs(buf, matchingRuleUse.getNames());
        if (matchingRuleUse.getDescription() != null) {
            buf.append(" DESC ");
            buf.append(matchingRuleUse.getDescription());
            buf.append('\n');
        }
        if (matchingRuleUse.isObsolete()) {
            buf.append(" OBSOLETE\n");
        }
        buf.append(" APPLIES ");
        List<AttributeType> attributeTypes = matchingRuleUse.getApplicableAttributes();
        if (attributeTypes.size() == 1) {
            buf.append(attributeTypes.get(0).getOid());
        } else {
            buf.append("( ");
            boolean isFirst = true;
            for (AttributeType attributeType : attributeTypes) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append(" $ ");
                }
                buf.append(attributeType);
            }
            buf.append(" ) ");
        }
        if (matchingRuleUse.getExtensions() != null) {
            DescriptionUtils.getExtensions(buf, matchingRuleUse.getExtensions());
        }
        buf.append(" )\n");
        return buf.toString();
    }

    public static String getDescription(NameForm nameForm) {
        StringBuilder buf = new StringBuilder("( ");
        buf.append(nameForm.getOid());
        buf.append('\n');
        if (nameForm.getNames() != null) {
            buf.append(" NAME ");
            DescriptionUtils.getQDescrs(buf, nameForm.getNames());
        }
        if (nameForm.getDescription() != null) {
            buf.append(" DESC ");
            buf.append(nameForm.getDescription());
            buf.append('\n');
        }
        if (nameForm.isObsolete()) {
            buf.append(" OBSOLETE\n");
        }
        buf.append(" OC ");
        buf.append(nameForm.getStructuralObjectClassOid());
        buf.append('\n');
        buf.append(" MUST\n");
        List<AttributeType> must = nameForm.getMustAttributeTypes();
        DescriptionUtils.getQDStrings(buf, must);
        List<AttributeType> may = nameForm.getMayAttributeTypes();
        if (may != null && may.size() > 0) {
            buf.append(" MAY\n");
            DescriptionUtils.getQDStrings(buf, may);
        }
        if (nameForm.getExtensions() != null) {
            DescriptionUtils.getExtensions(buf, nameForm.getExtensions());
        }
        buf.append(" )\n");
        return buf.toString();
    }

    public static String getDescription(Normalizer normalizer) {
        return DescriptionUtils.getLoadableDescription(normalizer);
    }

    public static String getDescription(ObjectClass objectClass) {
        List<AttributeType> may;
        List<AttributeType> must;
        List<ObjectClass> sups;
        StringBuilder buf = new StringBuilder("( ");
        buf.append(objectClass.getOid());
        buf.append('\n');
        if (objectClass.getNames() != null && objectClass.getNames().size() != 0) {
            buf.append(" NAME ");
            DescriptionUtils.getQDescrs(buf, objectClass.getNames());
        }
        if (objectClass.getDescription() != null) {
            buf.append(" DESC ");
            buf.append(objectClass.getDescription());
            buf.append('\n');
        }
        if (objectClass.isObsolete()) {
            buf.append(" OBSOLETE\n");
        }
        if ((sups = objectClass.getSuperiors()) != null && sups.size() > 0) {
            buf.append(" SUP ");
            DescriptionUtils.getQDStrings(buf, sups);
        }
        if (objectClass.getType() != null) {
            buf.append(' ');
            buf.append((Object)objectClass.getType());
            buf.append('\n');
        }
        if ((must = objectClass.getMustAttributeTypes()) != null && must.size() > 0) {
            buf.append(" MUST ");
            DescriptionUtils.getQDStrings(buf, must);
        }
        if ((may = objectClass.getMayAttributeTypes()) != null && may.size() > 0) {
            buf.append(" MAY ");
            DescriptionUtils.getQDStrings(buf, may);
        }
        if (objectClass.getExtensions() != null) {
            DescriptionUtils.getExtensions(buf, objectClass.getExtensions());
        }
        buf.append(" )\n");
        return buf.toString();
    }

    public static String getDescription(LdapSyntax syntax) {
        StringBuilder buf = new StringBuilder("( ");
        buf.append(syntax.getOid());
        buf.append('\n');
        if (syntax.getDescription() != null) {
            buf.append(" DESC ");
            buf.append(syntax.getDescription());
            buf.append('\n');
        }
        if (syntax.getExtensions() != null) {
            DescriptionUtils.getExtensions(buf, syntax.getExtensions());
        }
        buf.append(" )");
        return buf.toString();
    }

    public static String getDescription(SyntaxChecker syntaxChecker) {
        return DescriptionUtils.getLoadableDescription(syntaxChecker);
    }

    private static void getExtensions(StringBuilder sb, Map<String, List<String>> extensions) {
        for (Map.Entry<String, List<String>> extension : extensions.entrySet()) {
            sb.append(" " + extension.getKey()).append(" ");
            List<String> values = extension.getValue();
            if (values != null && values.size() != 0) {
                if (values.size() == 1) {
                    sb.append(values.get(0));
                } else {
                    boolean isFirst = true;
                    sb.append("( ");
                    for (String value : values) {
                        if (isFirst) {
                            isFirst = false;
                        } else {
                            sb.append(" ");
                        }
                        sb.append(value);
                    }
                    sb.append(" )");
                }
            }
            sb.append('\n');
        }
    }

    private static void getQDStrings(StringBuilder sb, List<? extends SchemaObject> schemaObjects) {
        if (schemaObjects != null && schemaObjects.size() != 0) {
            if (schemaObjects.size() == 1) {
                sb.append('\'').append(schemaObjects.get(0).getName()).append('\'');
            } else {
                boolean isFirst = true;
                sb.append("( ");
                for (SchemaObject schemaObject : schemaObjects) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append(" $ ");
                    }
                    sb.append('\'').append(schemaObject.getName()).append('\'');
                }
                sb.append(" )");
            }
        }
        sb.append('\n');
    }

    private static void getQDescrs(StringBuilder sb, List<String> names) {
        if (names != null && names.size() != 0) {
            if (names.size() == 1) {
                sb.append('\'').append(names.get(0)).append('\'');
            } else {
                boolean isFirst = true;
                sb.append("( ");
                for (String name : names) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append(" ");
                    }
                    sb.append('\'').append(name).append('\'');
                }
                sb.append(" )");
            }
        }
        sb.append('\n');
    }

    private static String getLoadableDescription(LoadableSchemaObject schemaObject) {
        StringBuilder buf = new StringBuilder("( ");
        buf.append(schemaObject.getOid());
        buf.append('\n');
        if (schemaObject.getDescription() != null) {
            buf.append(" DESC ");
            buf.append(schemaObject.getDescription());
            buf.append('\n');
        }
        if (schemaObject.getFqcn() != null) {
            buf.append(" FQCN ");
            buf.append(schemaObject.getFqcn());
            buf.append('\n');
        }
        if (schemaObject.getBytecode() != null) {
            buf.append(" BYTECODE ");
            if (schemaObject.getBytecode().length() > 16) {
                buf.append(schemaObject.getBytecode().substring(0, 16));
            } else {
                buf.append(schemaObject.getBytecode());
            }
            buf.append('\n');
        }
        if (schemaObject.getExtensions() != null) {
            DescriptionUtils.getExtensions(buf, schemaObject.getExtensions());
        }
        buf.append(" ) ");
        return buf.toString();
    }
}

