/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(BooleanSyntaxChecker.class);

    public BooleanSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.7");
    }

    public boolean isValidSyntax(Object value) {
        boolean valid;
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            LOG.debug("Syntax invalid for '{}'", (Object)strValue);
            return false;
        }
        boolean bl = valid = "TRUE".equalsIgnoreCase(strValue) || "FALSE".equalsIgnoreCase(strValue);
        if (valid) {
            LOG.debug("Syntax valid for '{}'", (Object)strValue);
        } else {
            LOG.debug("Syntax invalid for '{}'", (Object)strValue);
        }
        return valid;
    }
}

