/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.extras.extended.PwdModifyRequestImpl;
import org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify.PasswordModifyRequestContainer;
import org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify.PasswordModifyRequestDecorator;
import org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify.PasswordModifyRequestStatesEnum;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordModifyRequestGrammar
extends AbstractGrammar<PasswordModifyRequestContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordModifyRequestGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar<PasswordModifyRequestContainer> instance = new PasswordModifyRequestGrammar();

    public PasswordModifyRequestGrammar() {
        this.setName(PasswordModifyRequestGrammar.class.getName());
        this.transitions = new GrammarTransition[PasswordModifyRequestStatesEnum.LAST_PASSWORD_MODIFY_REQUEST_STATE.ordinal()][256];
        this.transitions[PasswordModifyRequestStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition<PasswordModifyRequestContainer>(PasswordModifyRequestStatesEnum.START_STATE, PasswordModifyRequestStatesEnum.PASSWORD_MODIFY_REQUEST_SEQUENCE_STATE, UniversalTag.SEQUENCE.getValue(), new GrammarAction<PasswordModifyRequestContainer>("Init PasswordModifyRequest"){

            @Override
            public void action(PasswordModifyRequestContainer container) {
                PasswordModifyRequestDecorator passwordModifyRequestDecorator = new PasswordModifyRequestDecorator(LdapApiServiceFactory.getSingleton(), new PwdModifyRequestImpl());
                container.setPasswordModifyRequest(passwordModifyRequestDecorator);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[PasswordModifyRequestStatesEnum.PASSWORD_MODIFY_REQUEST_SEQUENCE_STATE.ordinal()][128] = new GrammarTransition<PasswordModifyRequestContainer>(PasswordModifyRequestStatesEnum.PASSWORD_MODIFY_REQUEST_SEQUENCE_STATE, PasswordModifyRequestStatesEnum.USER_IDENTITY_STATE, 128, new GrammarAction<PasswordModifyRequestContainer>("Set PasswordModifyRequest user identity"){

            @Override
            public void action(PasswordModifyRequestContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                byte[] userIdentity = value.getData();
                if (IS_DEBUG) {
                    LOG.debug("UserIdentity = " + Strings.dumpBytes(userIdentity));
                }
                if (userIdentity == null) {
                    userIdentity = Strings.EMPTY_BYTES;
                }
                ((PasswordModifyRequestDecorator)container.getPwdModifyRequest()).setUserIdentity(userIdentity);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[PasswordModifyRequestStatesEnum.USER_IDENTITY_STATE.ordinal()][129] = new GrammarTransition<PasswordModifyRequestContainer>(PasswordModifyRequestStatesEnum.USER_IDENTITY_STATE, PasswordModifyRequestStatesEnum.OLD_PASSWORD_STATE, 129, new GrammarAction<PasswordModifyRequestContainer>("Set PasswordModifyRequest oldPassword"){

            @Override
            public void action(PasswordModifyRequestContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                byte[] oldPassword = value.getData();
                if (IS_DEBUG) {
                    LOG.debug("oldPassword = " + Strings.dumpBytes(oldPassword));
                }
                if (oldPassword == null) {
                    oldPassword = Strings.EMPTY_BYTES;
                }
                ((PasswordModifyRequestDecorator)container.getPwdModifyRequest()).setOldPassword(oldPassword);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[PasswordModifyRequestStatesEnum.USER_IDENTITY_STATE.ordinal()][130] = new GrammarTransition<PasswordModifyRequestContainer>(PasswordModifyRequestStatesEnum.USER_IDENTITY_STATE, PasswordModifyRequestStatesEnum.NEW_PASSWORD_STATE, 130, new GrammarAction<PasswordModifyRequestContainer>("Set PasswordModifyRequest newPassword"){

            @Override
            public void action(PasswordModifyRequestContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                byte[] newPassword = value.getData();
                if (IS_DEBUG) {
                    LOG.debug("newPassword = " + Strings.dumpBytes(newPassword));
                }
                if (newPassword == null) {
                    newPassword = Strings.EMPTY_BYTES;
                }
                ((PasswordModifyRequestDecorator)container.getPwdModifyRequest()).setNewPassword(newPassword);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[PasswordModifyRequestStatesEnum.PASSWORD_MODIFY_REQUEST_SEQUENCE_STATE.ordinal()][129] = new GrammarTransition<PasswordModifyRequestContainer>(PasswordModifyRequestStatesEnum.PASSWORD_MODIFY_REQUEST_SEQUENCE_STATE, PasswordModifyRequestStatesEnum.OLD_PASSWORD_STATE, 129, new GrammarAction<PasswordModifyRequestContainer>("Set PasswordModifyRequest oldPassword"){

            @Override
            public void action(PasswordModifyRequestContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                byte[] oldPassword = value.getData();
                if (IS_DEBUG) {
                    LOG.debug("OldPassword = " + Strings.dumpBytes(oldPassword));
                }
                if (oldPassword == null) {
                    oldPassword = Strings.EMPTY_BYTES;
                }
                ((PasswordModifyRequestDecorator)container.getPwdModifyRequest()).setOldPassword(oldPassword);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[PasswordModifyRequestStatesEnum.PASSWORD_MODIFY_REQUEST_SEQUENCE_STATE.ordinal()][130] = new GrammarTransition<PasswordModifyRequestContainer>(PasswordModifyRequestStatesEnum.PASSWORD_MODIFY_REQUEST_SEQUENCE_STATE, PasswordModifyRequestStatesEnum.NEW_PASSWORD_STATE, 130, new GrammarAction<PasswordModifyRequestContainer>("Set PasswordModifyRequest newPassword"){

            @Override
            public void action(PasswordModifyRequestContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                byte[] newPassword = value.getData();
                if (IS_DEBUG) {
                    LOG.debug("NewPassword = " + Strings.dumpBytes(newPassword));
                }
                if (newPassword == null) {
                    newPassword = Strings.EMPTY_BYTES;
                }
                ((PasswordModifyRequestDecorator)container.getPwdModifyRequest()).setNewPassword(newPassword);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[PasswordModifyRequestStatesEnum.OLD_PASSWORD_STATE.ordinal()][130] = new GrammarTransition<PasswordModifyRequestContainer>(PasswordModifyRequestStatesEnum.OLD_PASSWORD_STATE, PasswordModifyRequestStatesEnum.NEW_PASSWORD_STATE, 130, new GrammarAction<PasswordModifyRequestContainer>("Set PasswordModifyRequest newPassword"){

            @Override
            public void action(PasswordModifyRequestContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                byte[] newPassword = value.getData();
                if (IS_DEBUG) {
                    LOG.debug("NewPassword = " + Strings.dumpBytes(newPassword));
                }
                if (newPassword == null) {
                    newPassword = Strings.EMPTY_BYTES;
                }
                ((PasswordModifyRequestDecorator)container.getPwdModifyRequest()).setNewPassword(newPassword);
                container.setGrammarEndAllowed(true);
            }
        });
    }

    public static Grammar<PasswordModifyRequestContainer> getInstance() {
        return instance;
    }
}

