/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.handler.demux.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LdapResponseHandler<T extends Response>
implements MessageHandler<T> {
    protected static final Logger LOG = LoggerFactory.getLogger(LdapResponseHandler.class);
    protected LdapServer ldapServer;

    public final LdapServer getLdapServer() {
        return this.ldapServer;
    }

    public final void setLdapServer(LdapServer ldapServer) {
        this.ldapServer = ldapServer;
    }

    @Override
    public final void handleMessage(IoSession session, T message) throws Exception {
        LdapSession ldapSession = this.ldapServer.getLdapSessionManager().getLdapSession(session);
        if (ldapSession == null) {
            LOG.info("ignoring the message {} received from null session", (Object)message);
            return;
        }
        ldapSession.setLdapServer(this.ldapServer);
        this.handle(ldapSession, message);
    }

    public abstract void handle(LdapSession var1, T var2) throws Exception;
}

