/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxes;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.DitContentRule;
import org.apache.directory.api.ldap.model.schema.DitStructureRule;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRuleUse;
import org.apache.directory.api.ldap.model.schema.MutableAttributeType;
import org.apache.directory.api.ldap.model.schema.MutableMatchingRule;
import org.apache.directory.api.ldap.model.schema.MutableObjectClass;
import org.apache.directory.api.ldap.model.schema.NameForm;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.ObjectClassTypeEnum;
import org.apache.directory.api.ldap.model.schema.UsageEnum;
import org.apache.directory.api.ldap.model.schema.parsers.LdapComparatorDescription;
import org.apache.directory.api.ldap.model.schema.parsers.NormalizerDescription;
import org.apache.directory.api.ldap.model.schema.parsers.ParserMonitor;
import org.apache.directory.api.ldap.model.schema.parsers.SyntaxCheckerDescription;
import org.apache.directory.api.ldap.model.schema.syntaxCheckers.OpenLdapObjectIdentifierMacro;
import org.apache.directory.api.ldap.model.schema.syntaxes.AntlrSchemaExtensionLexer;
import org.apache.directory.api.ldap.model.schema.syntaxes.AntlrSchemaExtensionParser;
import org.apache.directory.api.ldap.model.schema.syntaxes.AntlrSchemaQdstringLexer;
import org.apache.directory.api.ldap.model.schema.syntaxes.AntlrSchemaQdstringParser;
import org.apache.directory.api.ldap.model.schema.syntaxes.AntlrSchemaTokenTypes;
import org.apache.directory.api.ldap.model.schema.syntaxes.AntlrSchemaValueLexer;
import org.apache.directory.api.ldap.model.schema.syntaxes.AntlrSchemaValueParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntlrSchemaParser
extends LLkParser
implements AntlrSchemaTokenTypes {
    private ParserMonitor monitor = null;
    private boolean isQuirksModeEnabled = false;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "WHSP", "LPAR", "RPAR", "QUOTE", "DOLLAR", "LBRACKET", "RBRACKET", "LEN", "SINGLE_VALUE", "COLLECTIVE", "NO_USER_MODIFICATION", "OBSOLETE", "ABSTRACT", "STRUCTURAL", "AUXILIARY", "OBJECTIDENTIFIER", "OBJECTCLASS", "ATTRIBUTETYPE", "STARTNUMERICOID", "NAME", "DESC", "SUP", "MUST", "MAY", "AUX", "NOT", "FORM", "OC", "EQUALITY", "ORDERING", "SUBSTR", "SYNTAX", "APPLIES", "EXTENSION", "FQCN", "BYTECODE", "AUX_OR_AUXILIARY", "VALUES", "VALUE", "UNQUOTED_STRING", "QUOTED_STRING", "FQCN_VALUE", "FQCN_IDENTIFIER", "FQCN_LETTER", "FQCN_LETTERORDIGIT", "BYTECODE_VALUE", "USAGE", "USER_APPLICATIONS", "DIRECTORY_OPERATION", "DISTRIBUTED_OPERATION", "DSA_OPERATION"};

    public void setParserMonitor(ParserMonitor monitor) {
        this.monitor = monitor;
    }

    private void matchedProduction(String msg) {
        if (null != this.monitor) {
            this.monitor.matchedProduction(msg);
        }
    }

    public void setQuirksMode(boolean enabled) {
        this.isQuirksModeEnabled = enabled;
    }

    public boolean isQuirksMode() {
        return this.isQuirksModeEnabled;
    }

    protected AntlrSchemaParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public AntlrSchemaParser(TokenBuffer tokenBuf) {
        this(tokenBuf, 3);
    }

    protected AntlrSchemaParser(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    public AntlrSchemaParser(TokenStream lexer) {
        this(lexer, 3);
    }

    public AntlrSchemaParser(ParserSharedInputState state) {
        super(state, 3);
        this.tokenNames = _tokenNames;
    }

    public final List<Object> openLdapSchema() throws RecognitionException, TokenStreamException {
        ArrayList<Object> list = new ArrayList<Object>();
        AttributeType attributeType = null;
        ObjectClass objectClass = null;
        OpenLdapObjectIdentifierMacro oloid = null;
        block5: while (true) {
            switch (this.LA(1)) {
                case 19: {
                    oloid = this.openLdapObjectIdentifier();
                    list.add(oloid);
                    continue block5;
                }
                case 21: {
                    attributeType = this.openLdapAttributeType();
                    list.add(attributeType);
                    continue block5;
                }
                case 20: {
                    objectClass = this.openLdapObjectClass();
                    list.add(objectClass);
                    continue block5;
                }
            }
            break;
        }
        return list;
    }

    public final OpenLdapObjectIdentifierMacro openLdapObjectIdentifier() throws RecognitionException, TokenStreamException {
        Token oi = null;
        this.matchedProduction("openLdapObjectIdentifier()");
        oi = this.LT(1);
        this.match(19);
        String[] nameAndValue = oi.getText().split(" ");
        OpenLdapObjectIdentifierMacro oloid = new OpenLdapObjectIdentifierMacro();
        oloid.setName(nameAndValue[0]);
        oloid.setRawOidOrNameSuffix(nameAndValue[1]);
        return oloid;
    }

    public final AttributeType openLdapAttributeType() throws RecognitionException, TokenStreamException {
        this.matchedProduction("openLdapAttributeType()");
        this.match(21);
        MutableAttributeType attributeType = this.attributeTypeDescription();
        return attributeType;
    }

    public final ObjectClass openLdapObjectClass() throws RecognitionException, TokenStreamException {
        this.matchedProduction("openLdapObjectClass()");
        this.match(20);
        MutableObjectClass objectClass = this.objectClassDescription();
        return objectClass;
    }

    public final MutableObjectClass objectClassDescription() throws RecognitionException, TokenStreamException {
        Token oid = null;
        Token name = null;
        Token desc = null;
        Token obsolete = null;
        Token sup = null;
        Token kind1 = null;
        Token kind2 = null;
        Token kind3 = null;
        Token must = null;
        Token may = null;
        Token extension = null;
        this.matchedProduction("objectClassDescription()");
        ElementTracker et = new ElementTracker();
        oid = this.LT(1);
        this.match(22);
        MutableObjectClass objectClass = new MutableObjectClass(this.numericoid(oid.getText()));
        block15: while (true) {
            switch (this.LA(1)) {
                case 23: {
                    name = this.LT(1);
                    this.match(23);
                    et.track("NAME", name);
                    objectClass.setNames(this.qdescrs(name.getText()));
                    continue block15;
                }
                case 24: {
                    desc = this.LT(1);
                    this.match(24);
                    et.track("DESC", desc);
                    objectClass.setDescription(this.qdstring(desc.getText()));
                    continue block15;
                }
                case 15: {
                    obsolete = this.LT(1);
                    this.match(15);
                    et.track("OBSOLETE", obsolete);
                    objectClass.setObsolete(true);
                    continue block15;
                }
                case 25: {
                    sup = this.LT(1);
                    this.match(25);
                    et.track("SUP", sup);
                    objectClass.setSuperiorOids(this.oids(sup.getText()));
                    continue block15;
                }
                case 16: 
                case 17: 
                case 18: {
                    switch (this.LA(1)) {
                        case 16: {
                            kind1 = this.LT(1);
                            this.match(16);
                            et.track("KIND", kind1);
                            objectClass.setType(ObjectClassTypeEnum.ABSTRACT);
                            continue block15;
                        }
                        case 17: {
                            kind2 = this.LT(1);
                            this.match(17);
                            et.track("KIND", kind2);
                            objectClass.setType(ObjectClassTypeEnum.STRUCTURAL);
                            continue block15;
                        }
                        case 18: {
                            kind3 = this.LT(1);
                            this.match(18);
                            et.track("KIND", kind3);
                            objectClass.setType(ObjectClassTypeEnum.AUXILIARY);
                            continue block15;
                        }
                    }
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                case 26: {
                    must = this.LT(1);
                    this.match(26);
                    et.track("MUST", must);
                    objectClass.setMustAttributeTypeOids(this.oids(must.getText()));
                    continue block15;
                }
                case 27: {
                    may = this.LT(1);
                    this.match(27);
                    et.track("MAY", may);
                    objectClass.setMayAttributeTypeOids(this.oids(may.getText()));
                    continue block15;
                }
                case 37: {
                    extension = this.LT(1);
                    this.match(37);
                    Extension ex = this.extension(extension.getText());
                    et.track(ex.key, extension);
                    objectClass.addExtension(ex.key, ex.values);
                    continue block15;
                }
            }
            break;
        }
        this.match(6);
        return objectClass;
    }

    public final MutableAttributeType attributeTypeDescription() throws RecognitionException, TokenStreamException {
        Token oid = null;
        Token name = null;
        Token desc = null;
        Token obsolete = null;
        Token superior = null;
        Token equality = null;
        Token ordering = null;
        Token substring = null;
        Token syntax = null;
        Token singleValued = null;
        Token collective = null;
        Token noUserModification = null;
        Token usage1 = null;
        Token usage2 = null;
        Token usage3 = null;
        Token usage4 = null;
        Token extension = null;
        this.matchedProduction("attributeTypeDescription()");
        ElementTracker et = new ElementTracker();
        oid = this.LT(1);
        this.match(22);
        MutableAttributeType attributeType = new MutableAttributeType(this.numericoid(oid.getText()));
        block15: while (true) {
            switch (this.LA(1)) {
                case 23: {
                    name = this.LT(1);
                    this.match(23);
                    et.track("NAME", name);
                    attributeType.setNames(this.qdescrs(name.getText()));
                    continue block15;
                }
                case 24: {
                    desc = this.LT(1);
                    this.match(24);
                    et.track("DESC", desc);
                    attributeType.setDescription(this.qdstring(desc.getText()));
                    continue block15;
                }
                case 15: {
                    obsolete = this.LT(1);
                    this.match(15);
                    et.track("OBSOLETE", obsolete);
                    attributeType.setObsolete(true);
                    continue block15;
                }
                case 25: {
                    superior = this.LT(1);
                    this.match(25);
                    et.track("SUP", superior);
                    attributeType.setSuperiorOid(this.oid(superior.getText()));
                    continue block15;
                }
                case 32: {
                    equality = this.LT(1);
                    this.match(32);
                    et.track("EQUALITY", equality);
                    attributeType.setEqualityOid(this.oid(equality.getText()));
                    continue block15;
                }
                case 33: {
                    ordering = this.LT(1);
                    this.match(33);
                    et.track("ORDERING", ordering);
                    attributeType.setOrderingOid(this.oid(ordering.getText()));
                    continue block15;
                }
                case 34: {
                    substring = this.LT(1);
                    this.match(34);
                    et.track("SUBSTR", substring);
                    attributeType.setSubstringOid(this.oid(substring.getText()));
                    continue block15;
                }
                case 35: {
                    syntax = this.LT(1);
                    this.match(35);
                    et.track("SYNTAX", syntax);
                    NoidLen noidlen = this.noidlen(syntax.getText());
                    attributeType.setSyntaxOid(noidlen.noid);
                    attributeType.setSyntaxLength(noidlen.len);
                    continue block15;
                }
                case 12: {
                    singleValued = this.LT(1);
                    this.match(12);
                    et.track("SINGLE_VALUE", singleValued);
                    attributeType.setSingleValued(true);
                    continue block15;
                }
                case 13: {
                    collective = this.LT(1);
                    this.match(13);
                    et.track("COLLECTIVE", collective);
                    attributeType.setCollective(true);
                    continue block15;
                }
                case 14: {
                    noUserModification = this.LT(1);
                    this.match(14);
                    et.track("NO_USER_MODIFICATION", noUserModification);
                    attributeType.setUserModifiable(false);
                    continue block15;
                }
                case 50: {
                    if (this.LA(1) == 50 && (this.LA(2) == 4 || this.LA(2) == 51)) {
                        usage1 = this.LT(1);
                        this.match(50);
                        while (this.LA(1) == 4) {
                            this.match(4);
                        }
                        this.match(51);
                        et.track("USAGE", usage1);
                        attributeType.setUsage(UsageEnum.USER_APPLICATIONS);
                        continue block15;
                    }
                    if (this.LA(1) == 50 && this.LA(2) == 52) {
                        usage2 = this.LT(1);
                        this.match(50);
                        this.match(52);
                        et.track("USAGE", usage2);
                        attributeType.setUsage(UsageEnum.DIRECTORY_OPERATION);
                        continue block15;
                    }
                    if (this.LA(1) == 50 && this.LA(2) == 53) {
                        usage3 = this.LT(1);
                        this.match(50);
                        this.match(53);
                        et.track("USAGE", usage3);
                        attributeType.setUsage(UsageEnum.DISTRIBUTED_OPERATION);
                        continue block15;
                    }
                    if (this.LA(1) == 50 && this.LA(2) == 54) {
                        usage4 = this.LT(1);
                        this.match(50);
                        this.match(54);
                        et.track("USAGE", usage4);
                        attributeType.setUsage(UsageEnum.DSA_OPERATION);
                        continue block15;
                    }
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                case 37: {
                    extension = this.LT(1);
                    this.match(37);
                    Extension ex = this.extension(extension.getText());
                    et.track(ex.key, extension);
                    attributeType.addExtension(ex.key, ex.values);
                    continue block15;
                }
            }
            break;
        }
        this.match(6);
        if (!this.isQuirksModeEnabled) {
            if (!et.contains("SYNTAX") && !et.contains("SUP")) {
                throw new SemanticException("One of SYNTAX or SUP is required", null, 0, 0);
            }
            if (attributeType.isCollective() && attributeType.getUsage() != UsageEnum.USER_APPLICATIONS) {
                throw new SemanticException("COLLECTIVE requires USAGE userApplications", null, 0, 0);
            }
            if (!attributeType.isUserModifiable() && attributeType.getUsage() == UsageEnum.USER_APPLICATIONS) {
                throw new SemanticException("NO-USER-MODIFICATION requires an operational USAGE", null, 0, 0);
            }
        }
        return attributeType;
    }

    public final LdapSyntax ldapSyntaxDescription() throws RecognitionException, TokenStreamException {
        Token oid = null;
        Token name = null;
        Token desc = null;
        Token extension = null;
        this.matchedProduction("ldapSyntaxDescription()");
        ElementTracker et = new ElementTracker();
        oid = this.LT(1);
        this.match(22);
        LdapSyntax ldapSyntax = new LdapSyntax(this.numericoid(oid.getText()));
        block5: while (true) {
            switch (this.LA(1)) {
                case 23: {
                    name = this.LT(1);
                    this.match(23);
                    et.track("NAME", name);
                    ldapSyntax.setNames(this.qdescrs(name.getText()));
                    continue block5;
                }
                case 24: {
                    desc = this.LT(1);
                    this.match(24);
                    et.track("DESC", desc);
                    ldapSyntax.setDescription(this.qdstring(desc.getText()));
                    continue block5;
                }
                case 37: {
                    extension = this.LT(1);
                    this.match(37);
                    Extension ex = this.extension(extension.getText());
                    et.track(ex.key, extension);
                    ldapSyntax.addExtension(ex.key, ex.values);
                    continue block5;
                }
            }
            break;
        }
        this.match(6);
        return ldapSyntax;
    }

    public final MutableMatchingRule matchingRuleDescription() throws RecognitionException, TokenStreamException {
        Token oid = null;
        Token name = null;
        Token desc = null;
        Token obsolete = null;
        Token syntax = null;
        Token extension = null;
        this.matchedProduction("matchingRuleDescription()");
        ElementTracker et = new ElementTracker();
        oid = this.LT(1);
        this.match(22);
        MutableMatchingRule matchingRule = new MutableMatchingRule(this.numericoid(oid.getText()));
        block7: while (true) {
            switch (this.LA(1)) {
                case 23: {
                    name = this.LT(1);
                    this.match(23);
                    et.track("NAME", name);
                    matchingRule.setNames(this.qdescrs(name.getText()));
                    continue block7;
                }
                case 24: {
                    desc = this.LT(1);
                    this.match(24);
                    et.track("DESC", desc);
                    matchingRule.setDescription(this.qdstring(desc.getText()));
                    continue block7;
                }
                case 15: {
                    obsolete = this.LT(1);
                    this.match(15);
                    et.track("OBSOLETE", obsolete);
                    matchingRule.setObsolete(true);
                    continue block7;
                }
                case 35: {
                    syntax = this.LT(1);
                    this.match(35);
                    et.track("SYNTAX", syntax);
                    matchingRule.setSyntaxOid(this.numericoid(syntax.getText()));
                    continue block7;
                }
                case 37: {
                    extension = this.LT(1);
                    this.match(37);
                    Extension ex = this.extension(extension.getText());
                    et.track(ex.key, extension);
                    matchingRule.addExtension(ex.key, ex.values);
                    continue block7;
                }
            }
            break;
        }
        this.match(6);
        if (!this.isQuirksModeEnabled && !et.contains("SYNTAX")) {
            throw new SemanticException("SYNTAX is required", null, 0, 0);
        }
        return matchingRule;
    }

    public final MatchingRuleUse matchingRuleUseDescription() throws RecognitionException, TokenStreamException {
        Token oid = null;
        Token name = null;
        Token desc = null;
        Token obsolete = null;
        Token applies = null;
        Token extension = null;
        this.matchedProduction("matchingRuleUseDescription()");
        ElementTracker et = new ElementTracker();
        oid = this.LT(1);
        this.match(22);
        MatchingRuleUse matchingRuleUse = new MatchingRuleUse(this.numericoid(oid.getText()));
        block7: while (true) {
            switch (this.LA(1)) {
                case 23: {
                    name = this.LT(1);
                    this.match(23);
                    et.track("NAME", name);
                    matchingRuleUse.setNames(this.qdescrs(name.getText()));
                    continue block7;
                }
                case 24: {
                    desc = this.LT(1);
                    this.match(24);
                    et.track("DESC", desc);
                    matchingRuleUse.setDescription(this.qdstring(desc.getText()));
                    continue block7;
                }
                case 15: {
                    obsolete = this.LT(1);
                    this.match(15);
                    et.track("OBSOLETE", obsolete);
                    matchingRuleUse.setObsolete(true);
                    continue block7;
                }
                case 36: {
                    applies = this.LT(1);
                    this.match(36);
                    et.track("APPLIES", applies);
                    matchingRuleUse.setApplicableAttributeOids(this.oids(applies.getText()));
                    continue block7;
                }
                case 37: {
                    extension = this.LT(1);
                    this.match(37);
                    Extension ex = this.extension(extension.getText());
                    et.track(ex.key, extension);
                    matchingRuleUse.addExtension(ex.key, ex.values);
                    continue block7;
                }
            }
            break;
        }
        this.match(6);
        if (!this.isQuirksModeEnabled && !et.contains("APPLIES")) {
            throw new SemanticException("APPLIES is required", null, 0, 0);
        }
        return matchingRuleUse;
    }

    public final DitContentRule ditContentRuleDescription() throws RecognitionException, TokenStreamException {
        Token oid = null;
        Token name = null;
        Token desc = null;
        Token obsolete = null;
        Token aux = null;
        Token must = null;
        Token may = null;
        Token not = null;
        Token extension = null;
        this.matchedProduction("ditContentRuleDescription()");
        ElementTracker et = new ElementTracker();
        oid = this.LT(1);
        this.match(22);
        DitContentRule ditContentRule = new DitContentRule(this.numericoid(oid.getText()));
        block10: while (true) {
            switch (this.LA(1)) {
                case 23: {
                    name = this.LT(1);
                    this.match(23);
                    et.track("NAME", name);
                    ditContentRule.setNames(this.qdescrs(name.getText()));
                    continue block10;
                }
                case 24: {
                    desc = this.LT(1);
                    this.match(24);
                    et.track("DESC", desc);
                    ditContentRule.setDescription(this.qdstring(desc.getText()));
                    continue block10;
                }
                case 15: {
                    obsolete = this.LT(1);
                    this.match(15);
                    et.track("OBSOLETE", obsolete);
                    ditContentRule.setObsolete(true);
                    continue block10;
                }
                case 28: {
                    aux = this.LT(1);
                    this.match(28);
                    et.track("AUX", aux);
                    ditContentRule.setAuxObjectClassOids(this.oids(aux.getText()));
                    continue block10;
                }
                case 26: {
                    must = this.LT(1);
                    this.match(26);
                    et.track("MUST", must);
                    ditContentRule.setMustAttributeTypeOids(this.oids(must.getText()));
                    continue block10;
                }
                case 27: {
                    may = this.LT(1);
                    this.match(27);
                    et.track("MAY", may);
                    ditContentRule.setMayAttributeTypeOids(this.oids(may.getText()));
                    continue block10;
                }
                case 29: {
                    not = this.LT(1);
                    this.match(29);
                    et.track("NOT", not);
                    ditContentRule.setNotAttributeTypeOids(this.oids(not.getText()));
                    continue block10;
                }
                case 37: {
                    extension = this.LT(1);
                    this.match(37);
                    Extension ex = this.extension(extension.getText());
                    et.track(ex.key, extension);
                    ditContentRule.addExtension(ex.key, ex.values);
                    continue block10;
                }
            }
            break;
        }
        this.match(6);
        return ditContentRule;
    }

    public final DitStructureRule ditStructureRuleDescription() throws RecognitionException, TokenStreamException {
        Token ruleid = null;
        Token name = null;
        Token desc = null;
        Token obsolete = null;
        Token form = null;
        Token sup = null;
        Token extension = null;
        this.matchedProduction("ditStructureRuleDescription()");
        ElementTracker et = new ElementTracker();
        ruleid = this.LT(1);
        this.match(22);
        DitStructureRule ditStructureRule = new DitStructureRule(this.ruleid(ruleid.getText()));
        block8: while (true) {
            switch (this.LA(1)) {
                case 23: {
                    name = this.LT(1);
                    this.match(23);
                    et.track("NAME", name);
                    ditStructureRule.setNames(this.qdescrs(name.getText()));
                    continue block8;
                }
                case 24: {
                    desc = this.LT(1);
                    this.match(24);
                    et.track("DESC", desc);
                    ditStructureRule.setDescription(this.qdstring(desc.getText()));
                    continue block8;
                }
                case 15: {
                    obsolete = this.LT(1);
                    this.match(15);
                    et.track("OBSOLETE", obsolete);
                    ditStructureRule.setObsolete(true);
                    continue block8;
                }
                case 30: {
                    form = this.LT(1);
                    this.match(30);
                    et.track("FORM", form);
                    ditStructureRule.setForm(this.oid(form.getText()));
                    continue block8;
                }
                case 25: {
                    sup = this.LT(1);
                    this.match(25);
                    et.track("SUP", sup);
                    ditStructureRule.setSuperRules(this.ruleids(sup.getText()));
                    continue block8;
                }
                case 37: {
                    extension = this.LT(1);
                    this.match(37);
                    Extension ex = this.extension(extension.getText());
                    et.track(ex.key, extension);
                    ditStructureRule.addExtension(ex.key, ex.values);
                    continue block8;
                }
            }
            break;
        }
        this.match(6);
        if (!this.isQuirksModeEnabled && !et.contains("FORM")) {
            throw new SemanticException("FORM is required", null, 0, 0);
        }
        return ditStructureRule;
    }

    public final NameForm nameFormDescription() throws RecognitionException, TokenStreamException {
        Token oid = null;
        Token name = null;
        Token desc = null;
        Token obsolete = null;
        Token oc = null;
        Token must = null;
        Token may = null;
        Token extension = null;
        this.matchedProduction("nameFormDescription()");
        ElementTracker et = new ElementTracker();
        oid = this.LT(1);
        this.match(22);
        NameForm nameForm = new NameForm(this.numericoid(oid.getText()));
        block9: while (true) {
            switch (this.LA(1)) {
                case 23: {
                    name = this.LT(1);
                    this.match(23);
                    et.track("NAME", name);
                    nameForm.setNames(this.qdescrs(name.getText()));
                    continue block9;
                }
                case 24: {
                    desc = this.LT(1);
                    this.match(24);
                    et.track("DESC", desc);
                    nameForm.setDescription(this.qdstring(desc.getText()));
                    continue block9;
                }
                case 15: {
                    obsolete = this.LT(1);
                    this.match(15);
                    et.track("OBSOLETE", obsolete);
                    nameForm.setObsolete(true);
                    continue block9;
                }
                case 31: {
                    oc = this.LT(1);
                    this.match(31);
                    et.track("OC", oc);
                    nameForm.setStructuralObjectClassOid(this.oid(oc.getText()));
                    continue block9;
                }
                case 26: {
                    must = this.LT(1);
                    this.match(26);
                    et.track("MUST", must);
                    nameForm.setMustAttributeTypeOids(this.oids(must.getText()));
                    continue block9;
                }
                case 27: {
                    may = this.LT(1);
                    this.match(27);
                    et.track("MAY", may);
                    nameForm.setMayAttributeTypeOids(this.oids(may.getText()));
                    continue block9;
                }
                case 37: {
                    extension = this.LT(1);
                    this.match(37);
                    Extension ex = this.extension(extension.getText());
                    et.track(ex.key, extension);
                    nameForm.addExtension(ex.key, ex.values);
                    continue block9;
                }
            }
            break;
        }
        this.match(6);
        if (!this.isQuirksModeEnabled) {
            if (!et.contains("MUST")) {
                throw new SemanticException("MUST is required", null, 0, 0);
            }
            if (!et.contains("OC")) {
                throw new SemanticException("OC is required", null, 0, 0);
            }
        }
        return nameForm;
    }

    public final LdapComparatorDescription ldapComparator() throws RecognitionException, TokenStreamException {
        Token oid = null;
        Token desc = null;
        Token fqcn = null;
        Token bytecode = null;
        Token extension = null;
        this.matchedProduction("ldapComparator()");
        ElementTracker et = new ElementTracker();
        oid = this.LT(1);
        this.match(22);
        LdapComparatorDescription lcd = new LdapComparatorDescription(this.numericoid(oid.getText()));
        block6: while (true) {
            switch (this.LA(1)) {
                case 24: {
                    desc = this.LT(1);
                    this.match(24);
                    et.track("DESC", desc);
                    lcd.setDescription(this.qdstring(desc.getText()));
                    continue block6;
                }
                case 38: {
                    fqcn = this.LT(1);
                    this.match(38);
                    et.track("FQCN", fqcn);
                    lcd.setFqcn(fqcn.getText());
                    continue block6;
                }
                case 39: {
                    bytecode = this.LT(1);
                    this.match(39);
                    et.track("BYTECODE", bytecode);
                    lcd.setBytecode(bytecode.getText());
                    continue block6;
                }
                case 37: {
                    extension = this.LT(1);
                    this.match(37);
                    Extension ex = this.extension(extension.getText());
                    et.track(ex.key, extension);
                    lcd.addExtension(ex.key, ex.values);
                    continue block6;
                }
            }
            break;
        }
        this.match(6);
        if (!this.isQuirksModeEnabled) {
            if (!et.contains("FQCN")) {
                throw new SemanticException("FQCN is required", null, 0, 0);
            }
            if (lcd.getBytecode() != null && lcd.getBytecode().length() % 4 != 0) {
                throw new SemanticException("BYTECODE must be divisible by 4", null, 0, 0);
            }
        }
        return lcd;
    }

    public final NormalizerDescription normalizerDescription() throws RecognitionException, TokenStreamException {
        Token oid = null;
        Token desc = null;
        Token fqcn = null;
        Token bytecode = null;
        Token extension = null;
        this.matchedProduction("normalizerDescription()");
        ElementTracker et = new ElementTracker();
        oid = this.LT(1);
        this.match(22);
        NormalizerDescription nd = new NormalizerDescription(this.numericoid(oid.getText()));
        block6: while (true) {
            switch (this.LA(1)) {
                case 24: {
                    desc = this.LT(1);
                    this.match(24);
                    et.track("DESC", desc);
                    nd.setDescription(this.qdstring(desc.getText()));
                    continue block6;
                }
                case 38: {
                    fqcn = this.LT(1);
                    this.match(38);
                    et.track("FQCN", fqcn);
                    nd.setFqcn(fqcn.getText());
                    continue block6;
                }
                case 39: {
                    bytecode = this.LT(1);
                    this.match(39);
                    et.track("BYTECODE", bytecode);
                    nd.setBytecode(bytecode.getText());
                    continue block6;
                }
                case 37: {
                    extension = this.LT(1);
                    this.match(37);
                    Extension ex = this.extension(extension.getText());
                    et.track(ex.key, extension);
                    nd.addExtension(ex.key, ex.values);
                    continue block6;
                }
            }
            break;
        }
        this.match(6);
        if (!this.isQuirksModeEnabled) {
            if (!et.contains("FQCN")) {
                throw new SemanticException("FQCN is required", null, 0, 0);
            }
            if (nd.getBytecode() != null && nd.getBytecode().length() % 4 != 0) {
                throw new SemanticException("BYTECODE must be divisible by 4", null, 0, 0);
            }
        }
        return nd;
    }

    public final SyntaxCheckerDescription syntaxCheckerDescription() throws RecognitionException, TokenStreamException {
        Token oid = null;
        Token desc = null;
        Token fqcn = null;
        Token bytecode = null;
        Token extension = null;
        this.matchedProduction("syntaxCheckerDescription()");
        ElementTracker et = new ElementTracker();
        oid = this.LT(1);
        this.match(22);
        SyntaxCheckerDescription scd = new SyntaxCheckerDescription(this.numericoid(oid.getText()));
        block6: while (true) {
            switch (this.LA(1)) {
                case 24: {
                    desc = this.LT(1);
                    this.match(24);
                    et.track("DESC", desc);
                    scd.setDescription(this.qdstring(desc.getText()));
                    continue block6;
                }
                case 38: {
                    fqcn = this.LT(1);
                    this.match(38);
                    et.track("FQCN", fqcn);
                    scd.setFqcn(fqcn.getText());
                    continue block6;
                }
                case 39: {
                    bytecode = this.LT(1);
                    this.match(39);
                    et.track("BYTECODE", bytecode);
                    scd.setBytecode(bytecode.getText());
                    continue block6;
                }
                case 37: {
                    extension = this.LT(1);
                    this.match(37);
                    Extension ex = this.extension(extension.getText());
                    et.track(ex.key, extension);
                    scd.addExtension(ex.key, ex.values);
                    continue block6;
                }
            }
            break;
        }
        this.match(6);
        if (!this.isQuirksModeEnabled) {
            if (!et.contains("FQCN")) {
                throw new SemanticException("FQCN is required", null, 0, 0);
            }
            if (scd.getBytecode() != null && scd.getBytecode().length() % 4 != 0) {
                throw new SemanticException("BYTECODE must be divisible by 4", null, 0, 0);
            }
        }
        return scd;
    }

    public final NoidLen noidlen(String s) throws RecognitionException, TokenStreamException {
        this.matchedProduction("noidlen()");
        AntlrSchemaValueLexer lexer = new AntlrSchemaValueLexer(new StringReader(s));
        AntlrSchemaValueParser parser = new AntlrSchemaValueParser(lexer);
        parser.setParserMonitor(this.monitor);
        NoidLen noidlen = this.isQuirksModeEnabled ? parser.quirksNoidlen() : parser.noidlen();
        return noidlen;
    }

    public final Extension extension(String s) throws RecognitionException, TokenStreamException {
        this.matchedProduction("extension()");
        AntlrSchemaExtensionLexer lexer = new AntlrSchemaExtensionLexer(new StringReader(s));
        AntlrSchemaExtensionParser parser = new AntlrSchemaExtensionParser(lexer);
        Extension extension = parser.extension();
        return extension;
    }

    public final String numericoid(String s) throws RecognitionException, TokenStreamException {
        String numericoid;
        this.matchedProduction("numericoid()");
        if (this.isQuirksModeEnabled) {
            numericoid = this.oid(s);
        } else {
            AntlrSchemaValueLexer lexer = new AntlrSchemaValueLexer(new StringReader(s));
            AntlrSchemaValueParser parser = new AntlrSchemaValueParser(lexer);
            parser.setParserMonitor(this.monitor);
            numericoid = parser.numericoid();
        }
        return numericoid;
    }

    public final String oid(String s) throws RecognitionException, TokenStreamException {
        this.matchedProduction("oid()");
        List<String> oids = this.oids(s);
        if (oids.size() != 1) {
            throw new SemanticException("Exactly one OID expected", null, 0, 0);
        }
        String oid = oids.get(0);
        return oid;
    }

    public final List<String> oids(String s) throws RecognitionException, TokenStreamException {
        List<String> oids;
        this.matchedProduction("oids()");
        if (this.isQuirksModeEnabled) {
            oids = this.qdescrs(s);
        } else {
            AntlrSchemaValueLexer lexer = new AntlrSchemaValueLexer(new StringReader(s));
            AntlrSchemaValueParser parser = new AntlrSchemaValueParser(lexer);
            parser.setParserMonitor(this.monitor);
            oids = parser.oids();
        }
        return oids;
    }

    public final String qdescr(String s) throws RecognitionException, TokenStreamException {
        this.matchedProduction("qdescr()");
        List<String> qdescrs = this.qdescrs(s);
        if (qdescrs.size() != 1) {
            throw new SemanticException("Exactly one qdescrs expected", null, 0, 0);
        }
        String qdescr = qdescrs.get(0);
        return qdescr;
    }

    public final List<String> qdescrs(String s) throws RecognitionException, TokenStreamException {
        this.matchedProduction("qdescrs()");
        AntlrSchemaValueLexer lexer = new AntlrSchemaValueLexer(new StringReader(s));
        AntlrSchemaValueParser parser = new AntlrSchemaValueParser(lexer);
        parser.setParserMonitor(this.monitor);
        List<String> qdescrs = this.isQuirksModeEnabled ? parser.quirksQdescrs() : parser.qdescrs();
        return qdescrs;
    }

    public final String qdstring(String s) throws RecognitionException, TokenStreamException {
        this.matchedProduction("qdstring()");
        List<String> qdstrings = this.qdstrings(s);
        if (qdstrings.size() != 1) {
            throw new SemanticException("Exactly one qdstrings expected", null, 0, 0);
        }
        String qdstring = qdstrings.get(0);
        return qdstring;
    }

    public final List<String> qdstrings(String s) throws RecognitionException, TokenStreamException {
        this.matchedProduction("qdstrings()");
        AntlrSchemaQdstringLexer lexer = new AntlrSchemaQdstringLexer(new StringReader(s));
        AntlrSchemaQdstringParser parser = new AntlrSchemaQdstringParser(lexer);
        parser.setParserMonitor(this.monitor);
        List<String> qdstrings = parser.qdstrings();
        return qdstrings;
    }

    public final Integer ruleid(String s) throws RecognitionException, TokenStreamException {
        this.matchedProduction("ruleid()");
        AntlrSchemaValueLexer lexer = new AntlrSchemaValueLexer(new StringReader(s));
        AntlrSchemaValueParser parser = new AntlrSchemaValueParser(lexer);
        parser.setParserMonitor(this.monitor);
        Integer ruleid = parser.ruleid();
        return ruleid;
    }

    public final List<Integer> ruleids(String s) throws RecognitionException, TokenStreamException {
        this.matchedProduction("ruleids()");
        AntlrSchemaValueLexer lexer = new AntlrSchemaValueLexer(new StringReader(s));
        AntlrSchemaValueParser parser = new AntlrSchemaValueParser(lexer);
        parser.setParserMonitor(this.monitor);
        List<Integer> ruleids = parser.ruleids();
        return ruleids;
    }

    static class ElementTracker {
        Map<String, Integer> elementMap = new HashMap<String, Integer>();

        ElementTracker() {
        }

        void track(String element, Token token) throws SemanticException {
            if (this.elementMap.containsKey(element)) {
                throw new SemanticException(element + " appears twice.", token.getFilename(), token.getLine(), token.getColumn());
            }
            this.elementMap.put(element, 1);
        }

        boolean contains(String element) {
            return this.elementMap.containsKey(element);
        }
    }

    static class NoidLen {
        String noid = "";
        long len = 0L;

        NoidLen() {
        }
    }

    static class Extension {
        String key = "";
        List<String> values = new ArrayList<String>();

        Extension() {
        }

        public void addValue(String value) {
            this.values.add(value);
        }
    }
}

