/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.UsageEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableAttributeType
extends AttributeType {
    private static final Logger LOG = LoggerFactory.getLogger(MutableAttributeType.class);

    public MutableAttributeType(String oid) {
        super(oid);
    }

    public void setSingleValued(boolean singleValued) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        if (!this.isReadOnly) {
            this.isSingleValued = singleValued;
        }
    }

    public void setUserModifiable(boolean userModifiable) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        if (!this.isReadOnly) {
            this.canUserModify = userModifiable;
        }
    }

    public void updateCollective(boolean collective) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        this.isCollective = collective;
    }

    public void setCollective(boolean collective) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        if (!this.isReadOnly) {
            this.isCollective = collective;
        }
    }

    public void setUsage(UsageEnum usage) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        if (!this.isReadOnly) {
            this.usage = usage;
        }
    }

    public void updateUsage(UsageEnum newUsage) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        this.usage = newUsage;
    }

    public void setSyntaxLength(long length) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        if (!this.isReadOnly) {
            this.syntaxLength = length;
        }
    }

    public void setSuperiorOid(String superiorOid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        if (!this.isReadOnly) {
            this.superiorOid = superiorOid;
        }
    }

    public void setSuperior(MutableAttributeType superior) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        if (!this.isReadOnly) {
            this.superior = superior;
            this.superiorOid = superior.getOid();
        }
    }

    public void setSuperior(String newSuperiorOid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        if (!this.isReadOnly) {
            this.superiorOid = newSuperiorOid;
        }
    }

    public void updateSuperior(MutableAttributeType newSuperior) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        this.superior = newSuperior;
        this.superiorOid = newSuperior.getOid();
    }

    public void setSyntaxOid(String syntaxOid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        if (!this.isReadOnly) {
            this.syntaxOid = syntaxOid;
        }
    }

    public void setSyntax(LdapSyntax syntax) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        if (!this.isReadOnly) {
            this.syntax = syntax;
            this.syntaxOid = syntax.getOid();
        }
    }

    public void updateSyntax(LdapSyntax newSyntax) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        this.syntax = newSyntax;
        this.syntaxOid = newSyntax.getOid();
    }

    public void setEqualityOid(String equalityOid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        if (!this.isReadOnly) {
            this.equalityOid = equalityOid;
        }
    }

    public void setEquality(MatchingRule equality) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        if (!this.isReadOnly) {
            this.equality = equality;
            this.equalityOid = equality.getOid();
        }
    }

    public void updateEquality(MatchingRule newEquality) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        this.equality = newEquality;
        this.equalityOid = newEquality.getOid();
    }

    public void setOrderingOid(String orderingOid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        if (!this.isReadOnly) {
            this.orderingOid = orderingOid;
        }
    }

    public void setOrdering(MatchingRule ordering) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        if (!this.isReadOnly) {
            this.ordering = ordering;
            this.orderingOid = ordering.getOid();
        }
    }

    public void updateOrdering(MatchingRule newOrdering) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        this.ordering = newOrdering;
        this.orderingOid = newOrdering.getOid();
    }

    public void setSubstringOid(String substrOid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        if (!this.isReadOnly) {
            this.substringOid = substrOid;
        }
    }

    public void setSubstring(MatchingRule substring) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        if (!this.isReadOnly) {
            this.substring = substring;
            this.substringOid = substring.getOid();
        }
    }

    public void updateSubstring(MatchingRule newSubstring) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        this.substring = newSubstring;
        this.substringOid = newSubstring.getOid();
    }

    public void clear() {
        super.clear();
        this.equality = null;
        this.ordering = null;
        this.substring = null;
        this.superior = null;
        this.syntax = null;
    }
}

