/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulDisconnect;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulDisconnect.GracefulAction;
import org.apache.directory.api.ldap.model.url.LdapUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GracefulDisconnect
extends GracefulAction {
    private List<LdapUrl> replicatedContexts = new ArrayList<LdapUrl>(2);
    private int gracefulDisconnectSequenceLength;
    private int replicatedContextsLength;

    public GracefulDisconnect(int timeOffline, int delay) {
        super(timeOffline, delay);
    }

    public GracefulDisconnect() {
    }

    public List<LdapUrl> getReplicatedContexts() {
        return this.replicatedContexts;
    }

    public void addReplicatedContexts(LdapUrl replicatedContext) {
        this.replicatedContexts.add(replicatedContext);
    }

    @Override
    public int computeLength() {
        this.gracefulDisconnectSequenceLength = 0;
        if (this.timeOffline != 0) {
            this.gracefulDisconnectSequenceLength += 2 + BerValue.getNbBytes(this.timeOffline);
        }
        if (this.delay != 0) {
            this.gracefulDisconnectSequenceLength += 2 + BerValue.getNbBytes(this.delay);
        }
        if (this.replicatedContexts.size() > 0) {
            this.replicatedContextsLength = 0;
            for (LdapUrl replicatedContext : this.replicatedContexts) {
                int ldapUrlLength = replicatedContext.getNbBytes();
                this.replicatedContextsLength += 1 + TLV.getNbBytes(ldapUrlLength) + ldapUrlLength;
            }
            this.gracefulDisconnectSequenceLength += 1 + TLV.getNbBytes(this.replicatedContextsLength) + this.replicatedContextsLength;
        }
        return 1 + TLV.getNbBytes(this.gracefulDisconnectSequenceLength) + this.gracefulDisconnectSequenceLength;
    }

    public ByteBuffer encode() throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLength());
        bb.put(UniversalTag.SEQUENCE.getValue());
        bb.put(TLV.getBytes(this.gracefulDisconnectSequenceLength));
        if (this.timeOffline != 0) {
            BerValue.encode(bb, this.timeOffline);
        }
        if (this.delay != 0) {
            bb.put((byte)-128);
            bb.put((byte)TLV.getNbBytes(this.delay));
            bb.put(BerValue.getBytes(this.delay));
        }
        if (this.replicatedContexts.size() != 0) {
            bb.put(UniversalTag.SEQUENCE.getValue());
            bb.put(TLV.getBytes(this.replicatedContextsLength));
            for (LdapUrl replicatedContext : this.replicatedContexts) {
                BerValue.encode(bb, replicatedContext.getBytesReference());
            }
        }
        return bb;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Graceful Disconnect extended operation");
        sb.append("    TimeOffline : ").append(this.timeOffline).append('\n');
        sb.append("    Delay : ").append(this.delay).append('\n');
        if (this.replicatedContexts != null && this.replicatedContexts.size() != 0) {
            sb.append("    Replicated contexts :");
            for (LdapUrl url : this.replicatedContexts) {
                sb.append("\n        ").append(url);
            }
        }
        return sb.toString();
    }
}

