/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.cursor;

import java.io.IOException;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.filter.LeafNode;
import org.apache.directory.api.ldap.model.filter.SimpleNode;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.cursor.AllEntriesCursor;
import org.apache.directory.server.xdbm.search.evaluator.EqualityEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EqualityCursor<V>
extends AbstractIndexCursor<V> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger("CURSOR");
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private static final String UNSUPPORTED_MSG = I18n.err(I18n.ERR_714, new Object[0]);
    private final EqualityEvaluator<V> equalityEvaluator;
    private final Cursor<IndexEntry<V, String>> userIdxCursor;
    private final Cursor<IndexEntry<String, String>> uuidIdxCursor;

    public EqualityCursor(Store store, EqualityEvaluator<V> equalityEvaluator) throws Exception {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating EqualityCursor {}", (Object)this);
        }
        this.equalityEvaluator = equalityEvaluator;
        AttributeType attributeType = ((LeafNode)equalityEvaluator.getExpression()).getAttributeType();
        Value value = ((SimpleNode)equalityEvaluator.getExpression()).getValue();
        if (store.hasIndexOn(attributeType)) {
            Index<?, Entry, String> userIndex = store.getIndex(attributeType);
            this.userIdxCursor = userIndex.forwardCursor(value.getValue());
            this.uuidIdxCursor = null;
        } else {
            this.uuidIdxCursor = new AllEntriesCursor(store);
            this.userIdxCursor = null;
        }
    }

    @Override
    protected String getUnsupportedMessage() {
        return UNSUPPORTED_MSG;
    }

    @Override
    public boolean available() {
        if (this.userIdxCursor != null) {
            return this.userIdxCursor.available();
        }
        return super.available();
    }

    @Override
    public void before(IndexEntry<V, String> element) throws LdapException, CursorException, IOException {
        this.checkNotClosed("before()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.before(element);
        } else {
            super.before(element);
        }
    }

    @Override
    public void after(IndexEntry<V, String> element) throws LdapException, CursorException, IOException {
        this.checkNotClosed("after()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.after(element);
        } else {
            super.after(element);
        }
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException, IOException {
        this.checkNotClosed("beforeFirst()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.beforeFirst();
        } else {
            this.uuidIdxCursor.beforeFirst();
        }
        this.setAvailable(false);
    }

    @Override
    public void afterLast() throws LdapException, CursorException, IOException {
        this.checkNotClosed("afterLast()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.afterLast();
        } else {
            this.uuidIdxCursor.afterLast();
        }
        this.setAvailable(false);
    }

    @Override
    public boolean first() throws LdapException, CursorException, IOException {
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean last() throws LdapException, CursorException, IOException {
        this.afterLast();
        return this.previous();
    }

    @Override
    public boolean previous() throws LdapException, CursorException, IOException {
        if (this.userIdxCursor != null) {
            return this.userIdxCursor.previous();
        }
        while (this.uuidIdxCursor.previous()) {
            this.checkNotClosed("previous()");
            IndexEntry<String, String> candidate = this.uuidIdxCursor.get();
            if (!this.equalityEvaluator.evaluate(candidate)) continue;
            return this.setAvailable(true);
        }
        return this.setAvailable(false);
    }

    @Override
    public boolean next() throws LdapException, CursorException, IOException {
        if (this.userIdxCursor != null) {
            return this.userIdxCursor.next();
        }
        while (this.uuidIdxCursor.next()) {
            this.checkNotClosed("next()");
            IndexEntry<String, String> candidate = this.uuidIdxCursor.get();
            if (!this.equalityEvaluator.evaluate(candidate)) continue;
            return this.setAvailable(true);
        }
        return this.setAvailable(false);
    }

    @Override
    public IndexEntry<V, String> get() throws CursorException, IOException {
        this.checkNotClosed("get()");
        if (this.userIdxCursor != null) {
            return this.userIdxCursor.get();
        }
        if (this.available()) {
            return this.uuidIdxCursor.get();
        }
        throw new InvalidCursorPositionException(I18n.err(I18n.ERR_708, new Object[0]));
    }

    @Override
    public void close() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing EqualityCursor {}", (Object)this);
        }
        super.close();
        if (this.userIdxCursor != null) {
            this.userIdxCursor.close();
        } else {
            this.uuidIdxCursor.close();
        }
    }

    @Override
    public void close(Exception cause) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing EqualityCursor {}", (Object)this);
        }
        super.close(cause);
        if (this.userIdxCursor != null) {
            this.userIdxCursor.close(cause);
        } else {
            this.uuidIdxCursor.close(cause);
        }
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("EqualityCursor (");
        if (this.available()) {
            sb.append("available)");
        } else {
            sb.append("absent)");
        }
        sb.append(" :\n");
        sb.append(tabs + "  >>").append(this.equalityEvaluator);
        if (this.userIdxCursor != null) {
            sb.append(tabs + "  <user>\n");
            sb.append(this.userIdxCursor.toString(tabs + "    "));
        }
        if (this.uuidIdxCursor != null) {
            sb.append(tabs + "  <uuid>\n");
            sb.append(this.uuidIdxCursor.toString(tabs + "  "));
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

