/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.directory.SearchControls;
import org.apache.directory.api.ldap.aci.ACIItem;
import org.apache.directory.api.ldap.aci.ACIItemParser;
import org.apache.directory.api.ldap.aci.ACITuple;
import org.apache.directory.api.ldap.aci.MicroOperation;
import org.apache.directory.api.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapNoPermissionException;
import org.apache.directory.api.ldap.model.exception.LdapOperationErrorException;
import org.apache.directory.api.ldap.model.exception.LdapOperationException;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.OrNode;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.normalizers.ConcreteNameComponentNormalizer;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.entry.ServerEntryUtils;
import org.apache.directory.server.core.api.filtering.EntryFilter;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.partition.PartitionNexus;
import org.apache.directory.server.core.api.subtree.SubentryUtils;
import org.apache.directory.server.core.authz.GroupCache;
import org.apache.directory.server.core.authz.TupleCache;
import org.apache.directory.server.core.authz.support.ACDFEngine;
import org.apache.directory.server.core.authz.support.AciContext;
import org.apache.directory.server.core.shared.DefaultCoreSession;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AciAuthorizationInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(AciAuthorizationInterceptor.class);
    private static final Logger ACI_LOG = LoggerFactory.getLogger(Loggers.ACI_LOG.getName());
    private static final Collection<MicroOperation> ADD_PERMS;
    private static final Collection<MicroOperation> READ_PERMS;
    private static final Collection<MicroOperation> COMPARE_PERMS;
    private static final Collection<MicroOperation> SEARCH_ENTRY_PERMS;
    private static final Collection<MicroOperation> SEARCH_ATTRVAL_PERMS;
    private static final Collection<MicroOperation> REMOVE_PERMS;
    private static final Collection<MicroOperation> BROWSE_PERMS;
    private static final Collection<MicroOperation> LOOKUP_PERMS;
    private static final Collection<MicroOperation> REPLACE_PERMS;
    private static final Collection<MicroOperation> RENAME_PERMS;
    private static final Collection<MicroOperation> EXPORT_PERMS;
    private static final Collection<MicroOperation> IMPORT_PERMS;
    private static final Collection<MicroOperation> MOVERENAME_PERMS;
    private TupleCache tupleCache;
    private GroupCache groupCache;
    private ACIItemParser aciParser;
    private ACDFEngine engine;
    private String subschemaSubentryDn;
    private PartitionNexus nexus;
    public static final SearchControls DEFAULT_SEARCH_CONTROLS;
    private static SubentryUtils subentryUtils;

    public AciAuthorizationInterceptor() {
        super(InterceptorEnum.ACI_AUTHORIZATION_INTERCEPTOR);
    }

    private void initTupleCache() throws LdapException {
        Dn adminDn = new Dn(this.schemaManager, "uid=admin,ou=system");
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        controls.setReturningAttributes(new String[]{"prescriptiveACI"});
        EqualityNode<String> filter = new EqualityNode<String>(OBJECT_CLASS_AT, new StringValue("accessControlSubentry"));
        DefaultCoreSession adminSession = new DefaultCoreSession(new LdapPrincipal(this.schemaManager, adminDn, AuthenticationLevel.STRONG), this.directoryService);
        SearchOperationContext searchOperationContext = new SearchOperationContext((CoreSession)adminSession, Dn.ROOT_DSE, filter, controls);
        searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
        EntryFilteringCursor results = this.nexus.search(searchOperationContext);
        try {
            while (results.next()) {
                Entry entry = (Entry)results.get();
                this.tupleCache.subentryAdded(entry.getDn(), entry);
            }
            results.close();
        }
        catch (Exception e) {
            throw new LdapOperationException(e.getMessage(), e);
        }
    }

    private void initGroupCache() throws LdapException {
        Dn adminDn = new Dn(this.schemaManager, "uid=admin,ou=system");
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        controls.setReturningAttributes(new String[]{"member", "uniqueMember"});
        OrNode filter = new OrNode(new EqualityNode<String>(OBJECT_CLASS_AT, new StringValue("groupOfNames")), new EqualityNode<String>(OBJECT_CLASS_AT, new StringValue("groupOfUniqueNames")));
        DefaultCoreSession adminSession = new DefaultCoreSession(new LdapPrincipal(this.schemaManager, adminDn, AuthenticationLevel.STRONG), this.directoryService);
        SearchOperationContext searchOperationContext = new SearchOperationContext((CoreSession)adminSession, Dn.ROOT_DSE, filter, controls);
        searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
        EntryFilteringCursor results = this.nexus.search(searchOperationContext);
        try {
            while (results.next()) {
                Entry entry = (Entry)results.get();
                this.groupCache.groupAdded(entry.getDn(), entry);
            }
            results.close();
        }
        catch (Exception e) {
            throw new LdapOperationException(e.getMessage(), e);
        }
    }

    @Override
    public void init(DirectoryService directoryService) throws LdapException {
        LOG.debug("Initializing the AciAuthorizationInterceptor");
        super.init(directoryService);
        this.nexus = directoryService.getPartitionNexus();
        Dn adminDn = directoryService.getDnFactory().create("uid=admin,ou=system");
        DefaultCoreSession adminSession = new DefaultCoreSession(new LdapPrincipal(this.schemaManager, adminDn, AuthenticationLevel.STRONG), directoryService);
        this.tupleCache = new TupleCache(adminSession);
        this.groupCache = new GroupCache(directoryService);
        this.aciParser = new ACIItemParser(new ConcreteNameComponentNormalizer(this.schemaManager), this.schemaManager);
        this.engine = new ACDFEngine(this.schemaManager);
        Value<?> subschemaSubentry = directoryService.getPartitionNexus().getRootDse(null).get("subschemaSubentry").get();
        Dn subschemaSubentryDnName = directoryService.getDnFactory().create(subschemaSubentry.getString());
        this.subschemaSubentryDn = subschemaSubentryDnName.getNormName();
        this.initTupleCache();
        this.initGroupCache();
        subentryUtils = new SubentryUtils(directoryService);
    }

    private void protectCriticalEntries(OperationContext opCtx, Dn dn) throws LdapException {
        Dn principalDn = AciAuthorizationInterceptor.getPrincipal(opCtx).getDn();
        if (dn.isEmpty()) {
            String msg = I18n.err(I18n.ERR_8, new Object[0]);
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (this.isTheAdministrator(dn)) {
            String msg = I18n.err(I18n.ERR_9, principalDn.getName(), dn.getName());
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
    }

    private void addPerscriptiveAciTuples(OperationContext opContext, Collection<ACITuple> tuples, Dn dn, Entry entry) throws LdapException {
        Attribute subentries;
        Entry originalEntry = null;
        originalEntry = entry instanceof ClonedServerEntry ? ((ClonedServerEntry)entry).getOriginalEntry() : entry;
        Attribute oc = originalEntry.get(OBJECT_CLASS_AT);
        if (oc.contains("subentry")) {
            Dn parentDn = dn.getParent();
            CoreSession session = opContext.getSession();
            LookupOperationContext lookupContext = new LookupOperationContext(session, parentDn, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
            originalEntry = this.directoryService.getPartitionNexus().lookup(lookupContext);
        }
        if ((subentries = originalEntry.get(ACCESS_CONTROL_SUBENTRIES_AT)) == null) {
            return;
        }
        for (Value value : subentries) {
            String subentryDn = value.getString();
            tuples.addAll(this.tupleCache.getACITuples(subentryDn));
        }
    }

    private void addEntryAciTuples(Collection<ACITuple> tuples, Entry entry) throws LdapException {
        Attribute entryAci = entry.get(ENTRY_ACI_AT);
        if (entryAci == null) {
            return;
        }
        for (Value value : entryAci) {
            ACIItem item;
            String aciString = value.getString();
            try {
                item = this.aciParser.parse(aciString);
            }
            catch (ParseException e) {
                String msg = I18n.err(I18n.ERR_10, aciString);
                LOG.error(msg, e);
                throw new LdapOperationErrorException(msg);
            }
            tuples.addAll(item.toTuples());
        }
    }

    private void addSubentryAciTuples(OperationContext opContext, Collection<ACITuple> tuples, Dn dn, Entry entry) throws LdapException {
        if (!entry.contains("objectClass", "subentry")) {
            return;
        }
        Dn parentDn = dn.getParent();
        CoreSession session = opContext.getSession();
        LookupOperationContext lookupContext = new LookupOperationContext(session, parentDn, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        Entry administrativeEntry = ((ClonedServerEntry)this.directoryService.getPartitionNexus().lookup(lookupContext)).getOriginalEntry();
        Attribute subentryAci = administrativeEntry.get(SUBENTRY_ACI_AT);
        if (subentryAci == null) {
            return;
        }
        for (Value value : subentryAci) {
            ACIItem item;
            String aciString = value.getString();
            try {
                item = this.aciParser.parse(aciString);
            }
            catch (ParseException e) {
                String msg = I18n.err(I18n.ERR_11, aciString);
                LOG.error(msg, e);
                throw new LdapOperationErrorException(msg);
            }
            tuples.addAll(item.toTuples());
        }
    }

    @Override
    public void add(AddOperationContext addContext) throws LdapException {
        if (!this.directoryService.isAccessControlEnabled()) {
            ACI_LOG.debug("ACI interceptor disabled");
            this.next(addContext);
            return;
        }
        ACI_LOG.debug("Adding the entry {}", (Object)addContext.getEntry());
        LdapPrincipal principal = addContext.getSession().getEffectivePrincipal();
        Dn principalDn = principal.getDn();
        Entry serverEntry = addContext.getEntry();
        Dn dn = addContext.getDn();
        if (this.isPrincipalAnAdministrator(principalDn)) {
            ACI_LOG.debug("Addition done by the administartor : no check");
            this.next(addContext);
            this.tupleCache.subentryAdded(dn, serverEntry);
            this.groupCache.groupAdded(dn, serverEntry);
            return;
        }
        Entry subentry = subentryUtils.getSubentryAttributes(dn, serverEntry);
        for (Attribute attribute : serverEntry) {
            subentry.put(attribute);
        }
        Set<Dn> userGroups = this.groupCache.getGroups(principalDn.getNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(addContext, tuples, dn, subentry);
        this.addSubentryAciTuples(addContext, tuples, dn, subentry);
        AciContext entryAciCtx = new AciContext(this.schemaManager, addContext);
        entryAciCtx.setUserGroupNames(userGroups);
        entryAciCtx.setUserDn(principalDn);
        entryAciCtx.setAuthenticationLevel(principal.getAuthenticationLevel());
        entryAciCtx.setEntryDn(dn);
        entryAciCtx.setMicroOperations(ADD_PERMS);
        entryAciCtx.setAciTuples(tuples);
        entryAciCtx.setEntry(subentry);
        this.engine.checkPermission(entryAciCtx);
        for (Attribute attribute : serverEntry) {
            for (Value value : attribute) {
                AciContext attrAciContext = new AciContext(this.schemaManager, addContext);
                attrAciContext.setUserGroupNames(userGroups);
                attrAciContext.setUserDn(principalDn);
                attrAciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
                attrAciContext.setEntryDn(dn);
                attrAciContext.setAttributeType(attribute.getAttributeType());
                attrAciContext.setAttrValue(value);
                attrAciContext.setMicroOperations(ADD_PERMS);
                attrAciContext.setAciTuples(tuples);
                attrAciContext.setEntry(serverEntry);
                this.engine.checkPermission(attrAciContext);
            }
        }
        this.next(addContext);
        this.tupleCache.subentryAdded(dn, serverEntry);
        this.groupCache.groupAdded(dn, serverEntry);
    }

    @Override
    public boolean compare(CompareOperationContext compareContext) throws LdapException {
        CoreSession session = compareContext.getSession();
        Dn dn = compareContext.getDn();
        String oid = compareContext.getOid();
        Entry entry = compareContext.getOriginalEntry();
        LdapPrincipal principal = session.getEffectivePrincipal();
        Dn principalDn = principal.getDn();
        if (this.isPrincipalAnAdministrator(principalDn) || !this.directoryService.isAccessControlEnabled()) {
            return this.next(compareContext);
        }
        Set<Dn> userGroups = this.groupCache.getGroups(principalDn.getNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(compareContext, tuples, dn, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(compareContext, tuples, dn, entry);
        AciContext aciContext = new AciContext(this.schemaManager, compareContext);
        aciContext.setUserGroupNames(userGroups);
        aciContext.setUserDn(principalDn);
        aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
        aciContext.setEntryDn(dn);
        aciContext.setMicroOperations(READ_PERMS);
        aciContext.setAciTuples(tuples);
        aciContext.setEntry(entry);
        this.engine.checkPermission(aciContext);
        AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(oid);
        aciContext = new AciContext(this.schemaManager, compareContext);
        aciContext.setUserGroupNames(userGroups);
        aciContext.setUserDn(principalDn);
        aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
        aciContext.setEntryDn(dn);
        aciContext.setAttributeType(attributeType);
        aciContext.setMicroOperations(COMPARE_PERMS);
        aciContext.setAciTuples(tuples);
        aciContext.setEntry(entry);
        this.engine.checkPermission(aciContext);
        return this.next(compareContext);
    }

    @Override
    public void delete(DeleteOperationContext deleteContext) throws LdapException {
        CoreSession session = deleteContext.getSession();
        if (!this.directoryService.isAccessControlEnabled()) {
            this.next(deleteContext);
            return;
        }
        Dn dn = deleteContext.getDn();
        LdapPrincipal principal = session.getEffectivePrincipal();
        Dn principalDn = principal.getDn();
        Entry entry = deleteContext.getEntry();
        this.protectCriticalEntries(deleteContext, dn);
        if (this.isPrincipalAnAdministrator(principalDn)) {
            this.next(deleteContext);
            this.tupleCache.subentryDeleted(dn, entry);
            this.groupCache.groupDeleted(dn, entry);
            return;
        }
        Set<Dn> userGroups = this.groupCache.getGroups(principalDn.getNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(deleteContext, tuples, dn, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(deleteContext, tuples, dn, entry);
        AciContext aciContext = new AciContext(this.schemaManager, deleteContext);
        aciContext.setUserGroupNames(userGroups);
        aciContext.setUserDn(principalDn);
        aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
        aciContext.setEntryDn(dn);
        aciContext.setMicroOperations(REMOVE_PERMS);
        aciContext.setAciTuples(tuples);
        aciContext.setEntry(entry);
        this.engine.checkPermission(aciContext);
        this.next(deleteContext);
        this.tupleCache.subentryDeleted(dn, entry);
        this.groupCache.groupDeleted(dn, entry);
    }

    @Override
    public boolean hasEntry(HasEntryOperationContext hasEntryContext) throws LdapException {
        Dn dn = hasEntryContext.getDn();
        if (!this.directoryService.isAccessControlEnabled()) {
            return dn.isRootDse() || this.next(hasEntryContext);
        }
        boolean answer = this.next(hasEntryContext);
        if (dn.isRootDse()) {
            return answer;
        }
        CoreSession session = hasEntryContext.getSession();
        LdapPrincipal principal = session.getEffectivePrincipal();
        Dn principalDn = principal.getDn();
        if (this.isPrincipalAnAdministrator(principalDn)) {
            return answer;
        }
        LookupOperationContext lookupContext = new LookupOperationContext(session, dn, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        Entry entry = this.directoryService.getPartitionNexus().lookup(lookupContext);
        Set<Dn> userGroups = this.groupCache.getGroups(principalDn.getNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(hasEntryContext, tuples, dn, entry);
        this.addEntryAciTuples(tuples, ((ClonedServerEntry)entry).getOriginalEntry());
        this.addSubentryAciTuples(hasEntryContext, tuples, dn, ((ClonedServerEntry)entry).getOriginalEntry());
        AciContext aciContext = new AciContext(this.schemaManager, hasEntryContext);
        aciContext.setUserGroupNames(userGroups);
        aciContext.setUserDn(principalDn);
        aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
        aciContext.setEntryDn(dn);
        aciContext.setMicroOperations(BROWSE_PERMS);
        aciContext.setAciTuples(tuples);
        aciContext.setEntry(((ClonedServerEntry)entry).getOriginalEntry());
        this.engine.checkPermission(aciContext);
        return this.next(hasEntryContext);
    }

    @Override
    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        CoreSession session = lookupContext.getSession();
        Entry entry = this.next(lookupContext);
        LdapPrincipal principal = session.getEffectivePrincipal();
        Dn principalDn = principal.getDn();
        principalDn.apply(this.schemaManager);
        if (this.isPrincipalAnAdministrator(principalDn) || !this.directoryService.isAccessControlEnabled()) {
            return entry;
        }
        this.checkLookupAccess(lookupContext, entry);
        return entry;
    }

    @Override
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        Dn dn = modifyContext.getDn();
        Entry entry = modifyContext.getEntry();
        LdapPrincipal principal = modifyContext.getSession().getEffectivePrincipal();
        Dn principalDn = principal.getDn();
        if (!this.directoryService.isAccessControlEnabled()) {
            this.next(modifyContext);
            return;
        }
        List<Modification> mods = modifyContext.getModItems();
        if (this.isPrincipalAnAdministrator(principalDn)) {
            this.next(modifyContext);
            CoreSession session = modifyContext.getSession();
            LookupOperationContext lookupContext = new LookupOperationContext(session, dn, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
            Entry modifiedEntry = this.directoryService.getPartitionNexus().lookup(lookupContext);
            this.tupleCache.subentryModified(dn, mods, modifiedEntry);
            this.groupCache.groupModified(dn, mods, entry, this.schemaManager);
            return;
        }
        Set<Dn> userGroups = this.groupCache.getGroups(principalDn.getName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(modifyContext, tuples, dn, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(modifyContext, tuples, dn, entry);
        AciContext entryAciContext = new AciContext(this.schemaManager, modifyContext);
        entryAciContext.setUserGroupNames(userGroups);
        entryAciContext.setUserDn(principalDn);
        entryAciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
        entryAciContext.setEntryDn(dn);
        entryAciContext.setMicroOperations(Collections.singleton(MicroOperation.MODIFY));
        entryAciContext.setAciTuples(tuples);
        entryAciContext.setEntry(entry);
        this.engine.checkPermission(entryAciContext);
        Collection<MicroOperation> perms = null;
        Entry entryView = entry.clone();
        for (Modification mod : mods) {
            Attribute attr = mod.getAttribute();
            switch (mod.getOperation()) {
                case ADD_ATTRIBUTE: {
                    perms = ADD_PERMS;
                    if (entry.get(attr.getId()) != null) break;
                    AciContext attrAciContext = new AciContext(this.schemaManager, modifyContext);
                    attrAciContext.setUserGroupNames(userGroups);
                    attrAciContext.setUserDn(principalDn);
                    attrAciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
                    attrAciContext.setEntryDn(dn);
                    attrAciContext.setAttributeType(attr.getAttributeType());
                    attrAciContext.setMicroOperations(perms);
                    attrAciContext.setAciTuples(tuples);
                    attrAciContext.setEntry(entry);
                    this.engine.checkPermission(attrAciContext);
                    break;
                }
                case REMOVE_ATTRIBUTE: {
                    perms = REMOVE_PERMS;
                    Attribute entryAttr = entry.get(attr.getId());
                    if (entryAttr == null || entryAttr.size() != 1) break;
                    AciContext aciContext = new AciContext(this.schemaManager, modifyContext);
                    aciContext.setUserGroupNames(userGroups);
                    aciContext.setUserDn(principalDn);
                    aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
                    aciContext.setEntryDn(dn);
                    aciContext.setAttributeType(attr.getAttributeType());
                    aciContext.setMicroOperations(perms);
                    aciContext.setAciTuples(tuples);
                    aciContext.setEntry(entry);
                    this.engine.checkPermission(aciContext);
                    break;
                }
                case REPLACE_ATTRIBUTE: {
                    perms = REPLACE_PERMS;
                }
            }
            entryView = ServerEntryUtils.getTargetEntry(mod, entryView, this.schemaManager);
            for (Value value : attr) {
                AciContext aciContext = new AciContext(this.schemaManager, modifyContext);
                aciContext.setUserGroupNames(userGroups);
                aciContext.setUserDn(principalDn);
                aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
                aciContext.setEntryDn(dn);
                aciContext.setAttributeType(attr.getAttributeType());
                aciContext.setAttrValue(value);
                aciContext.setMicroOperations(perms);
                aciContext.setAciTuples(tuples);
                aciContext.setEntry(entry);
                aciContext.setEntryView(entryView);
                this.engine.checkPermission(aciContext);
            }
        }
        this.next(modifyContext);
        CoreSession session = modifyContext.getSession();
        LookupOperationContext lookupContext = new LookupOperationContext(session, dn, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        Entry modifiedEntry = this.directoryService.getPartitionNexus().lookup(lookupContext);
        this.tupleCache.subentryModified(dn, mods, modifiedEntry);
        this.groupCache.groupModified(dn, mods, entry, this.schemaManager);
    }

    @Override
    public void move(MoveOperationContext moveContext) throws LdapException {
        Dn oriChildName = moveContext.getDn();
        Entry entry = moveContext.getOriginalEntry();
        CoreSession session = moveContext.getSession();
        Dn newDn = moveContext.getNewDn();
        LdapPrincipal principal = session.getEffectivePrincipal();
        Dn principalDn = principal.getDn();
        if (!this.directoryService.isAccessControlEnabled()) {
            this.next(moveContext);
            return;
        }
        this.protectCriticalEntries(moveContext, oriChildName);
        if (this.isPrincipalAnAdministrator(principalDn)) {
            this.next(moveContext);
            this.tupleCache.subentryRenamed(oriChildName, newDn);
            this.groupCache.groupRenamed(oriChildName, newDn);
            return;
        }
        Set<Dn> userGroups = this.groupCache.getGroups(principalDn.getNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(moveContext, tuples, oriChildName, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(moveContext, tuples, oriChildName, entry);
        AciContext aciContext = new AciContext(this.schemaManager, moveContext);
        aciContext.setUserGroupNames(userGroups);
        aciContext.setUserDn(principalDn);
        aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
        aciContext.setEntryDn(oriChildName);
        aciContext.setMicroOperations(EXPORT_PERMS);
        aciContext.setAciTuples(tuples);
        aciContext.setEntry(entry);
        this.engine.checkPermission(aciContext);
        LookupOperationContext lookupContext = new LookupOperationContext(session, oriChildName, SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
        Entry importedEntry = this.directoryService.getPartitionNexus().lookup(lookupContext);
        Entry subentryAttrs = subentryUtils.getSubentryAttributes(newDn, importedEntry);
        for (Attribute attribute : importedEntry) {
            subentryAttrs.put(attribute);
        }
        HashSet<ACITuple> destTuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(moveContext, destTuples, newDn, subentryAttrs);
        aciContext = new AciContext(this.schemaManager, moveContext);
        aciContext.setUserGroupNames(userGroups);
        aciContext.setUserDn(principalDn);
        aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
        aciContext.setEntryDn(newDn);
        aciContext.setMicroOperations(IMPORT_PERMS);
        aciContext.setAciTuples(destTuples);
        aciContext.setEntry(subentryAttrs);
        this.engine.checkPermission(aciContext);
        this.next(moveContext);
        this.tupleCache.subentryRenamed(oriChildName, newDn);
        this.groupCache.groupRenamed(oriChildName, newDn);
    }

    @Override
    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        Dn oldDn = moveAndRenameContext.getDn();
        CoreSession session = moveAndRenameContext.getSession();
        Entry entry = moveAndRenameContext.getOriginalEntry();
        LdapPrincipal principal = session.getEffectivePrincipal();
        Dn principalDn = principal.getDn();
        Dn newDn = moveAndRenameContext.getNewDn();
        if (!this.directoryService.isAccessControlEnabled()) {
            this.next(moveAndRenameContext);
            return;
        }
        this.protectCriticalEntries(moveAndRenameContext, oldDn);
        if (this.isPrincipalAnAdministrator(principalDn)) {
            this.next(moveAndRenameContext);
            this.tupleCache.subentryRenamed(oldDn, newDn);
            this.groupCache.groupRenamed(oldDn, newDn);
            return;
        }
        Set<Dn> userGroups = this.groupCache.getGroups(principalDn.getNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(moveAndRenameContext, tuples, oldDn, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(moveAndRenameContext, tuples, oldDn, entry);
        AciContext aciContext = new AciContext(this.schemaManager, moveAndRenameContext);
        aciContext.setUserGroupNames(userGroups);
        aciContext.setUserDn(principalDn);
        aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
        aciContext.setEntryDn(oldDn);
        aciContext.setMicroOperations(MOVERENAME_PERMS);
        aciContext.setAciTuples(tuples);
        aciContext.setEntry(entry);
        this.engine.checkPermission(aciContext);
        LookupOperationContext lookupContext = new LookupOperationContext(session, oldDn, SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
        Entry importedEntry = this.directoryService.getPartitionNexus().lookup(lookupContext);
        Entry subentryAttrs = subentryUtils.getSubentryAttributes(newDn, importedEntry);
        for (Attribute attribute : importedEntry) {
            subentryAttrs.put(attribute);
        }
        HashSet<ACITuple> destTuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(moveAndRenameContext, destTuples, newDn, subentryAttrs);
        aciContext = new AciContext(this.schemaManager, moveAndRenameContext);
        aciContext.setUserGroupNames(userGroups);
        aciContext.setUserDn(principalDn);
        aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
        aciContext.setEntryDn(newDn);
        aciContext.setMicroOperations(IMPORT_PERMS);
        aciContext.setAciTuples(destTuples);
        aciContext.setEntry(subentryAttrs);
        this.engine.checkPermission(aciContext);
        this.next(moveAndRenameContext);
        this.tupleCache.subentryRenamed(oldDn, newDn);
        this.groupCache.groupRenamed(oldDn, newDn);
    }

    @Override
    public void rename(RenameOperationContext renameContext) throws LdapException {
        Dn oldName = renameContext.getDn();
        Entry originalEntry = null;
        if (renameContext.getEntry() != null) {
            originalEntry = ((ClonedServerEntry)renameContext.getEntry()).getOriginalEntry();
        }
        LdapPrincipal principal = renameContext.getSession().getEffectivePrincipal();
        Dn principalDn = principal.getDn();
        Dn newName = renameContext.getNewDn();
        if (!this.directoryService.isAccessControlEnabled()) {
            this.next(renameContext);
            return;
        }
        this.protectCriticalEntries(renameContext, oldName);
        if (this.isPrincipalAnAdministrator(principalDn)) {
            this.next(renameContext);
            this.tupleCache.subentryRenamed(oldName, newName);
            this.groupCache.groupRenamed(oldName, newName);
            return;
        }
        Set<Dn> userGroups = this.groupCache.getGroups(principalDn.getNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(renameContext, tuples, oldName, originalEntry);
        this.addEntryAciTuples(tuples, originalEntry);
        this.addSubentryAciTuples(renameContext, tuples, oldName, originalEntry);
        AciContext aciContext = new AciContext(this.schemaManager, renameContext);
        aciContext.setUserGroupNames(userGroups);
        aciContext.setUserDn(principalDn);
        aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
        aciContext.setEntryDn(oldName);
        aciContext.setMicroOperations(RENAME_PERMS);
        aciContext.setAciTuples(tuples);
        aciContext.setEntry(originalEntry);
        this.engine.checkPermission(aciContext);
        this.next(renameContext);
        this.tupleCache.subentryRenamed(oldName, newName);
        this.groupCache.groupRenamed(oldName, newName);
    }

    @Override
    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        boolean isRootDseLookup;
        LdapPrincipal user = searchContext.getSession().getEffectivePrincipal();
        Dn principalDn = user.getDn();
        EntryFilteringCursor cursor = this.next(searchContext);
        boolean isSubschemaSubentryLookup = this.subschemaSubentryDn.equals(searchContext.getDn().getNormName());
        boolean bl = isRootDseLookup = searchContext.getDn().size() == 0 && searchContext.getScope() == SearchScope.OBJECT;
        if (this.isPrincipalAnAdministrator(principalDn) || !this.directoryService.isAccessControlEnabled() || isRootDseLookup || isSubschemaSubentryLookup) {
            return cursor;
        }
        cursor.addEntryFilter(new AuthorizationFilter());
        return cursor;
    }

    private void checkLookupAccess(LookupOperationContext lookupContext, Entry entry) throws LdapException {
        Dn dn = lookupContext.getDn();
        if (dn.isRootDse()) {
            return;
        }
        LdapPrincipal principal = lookupContext.getSession().getEffectivePrincipal();
        Dn userName = principal.getDn();
        Set<Dn> userGroups = this.groupCache.getGroups(userName.getNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(lookupContext, tuples, dn, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(lookupContext, tuples, dn, entry);
        AciContext aciContext = new AciContext(this.schemaManager, lookupContext);
        aciContext.setUserGroupNames(userGroups);
        aciContext.setUserDn(userName);
        aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
        aciContext.setEntryDn(dn);
        aciContext.setMicroOperations(LOOKUP_PERMS);
        aciContext.setAciTuples(tuples);
        aciContext.setEntry(entry);
        this.engine.checkPermission(aciContext);
        for (Attribute attribute : entry) {
            for (Value value : attribute) {
                AciContext valueAciContext = new AciContext(this.schemaManager, lookupContext);
                valueAciContext.setUserGroupNames(userGroups);
                valueAciContext.setUserDn(userName);
                valueAciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
                valueAciContext.setEntryDn(dn);
                valueAciContext.setAttributeType(attribute.getAttributeType());
                valueAciContext.setAttrValue(value);
                valueAciContext.setMicroOperations(READ_PERMS);
                valueAciContext.setAciTuples(tuples);
                valueAciContext.setEntry(entry);
                this.engine.checkPermission(valueAciContext);
            }
        }
    }

    public final boolean isPrincipalAnAdministrator(Dn principalDn) {
        return this.groupCache.isPrincipalAnAdministrator(principalDn);
    }

    public void cacheNewGroup(Dn name, Entry entry) throws Exception {
        this.groupCache.groupAdded(name, entry);
    }

    private boolean filter(OperationContext opContext, Dn normName, Entry clonedEntry) throws LdapException {
        LdapPrincipal principal = opContext.getSession().getEffectivePrincipal();
        Dn userDn = principal.getDn();
        Set<Dn> userGroups = this.groupCache.getGroups(userDn.getNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(opContext, tuples, normName, clonedEntry);
        this.addEntryAciTuples(tuples, ((ClonedServerEntry)clonedEntry).getOriginalEntry());
        this.addSubentryAciTuples(opContext, tuples, normName, ((ClonedServerEntry)clonedEntry).getOriginalEntry());
        AciContext aciContext = new AciContext(this.schemaManager, opContext);
        aciContext.setUserGroupNames(userGroups);
        aciContext.setUserDn(userDn);
        aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
        aciContext.setEntryDn(normName);
        aciContext.setMicroOperations(SEARCH_ENTRY_PERMS);
        aciContext.setAciTuples(tuples);
        aciContext.setEntry(((ClonedServerEntry)clonedEntry).getOriginalEntry());
        if (!this.engine.hasPermission(aciContext)) {
            return false;
        }
        ArrayList<AttributeType> attributeToRemove = new ArrayList<AttributeType>();
        for (Attribute attribute : clonedEntry.getAttributes()) {
            AttributeType attributeType = attribute.getAttributeType();
            Attribute attr = clonedEntry.get(attributeType);
            aciContext = new AciContext(this.schemaManager, opContext);
            aciContext.setUserGroupNames(userGroups);
            aciContext.setUserDn(userDn);
            aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
            aciContext.setEntryDn(normName);
            aciContext.setAttributeType(attributeType);
            aciContext.setMicroOperations(SEARCH_ATTRVAL_PERMS);
            aciContext.setAciTuples(tuples);
            aciContext.setEntry(clonedEntry);
            if (!this.engine.hasPermission(aciContext)) {
                attributeToRemove.add(attributeType);
                continue;
            }
            ArrayList<Value> valueToRemove = new ArrayList<Value>();
            for (Value value : attr) {
                aciContext = new AciContext(this.schemaManager, opContext);
                aciContext.setUserGroupNames(userGroups);
                aciContext.setUserDn(userDn);
                aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
                aciContext.setEntryDn(normName);
                aciContext.setAttributeType(attr.getAttributeType());
                aciContext.setAttrValue(value);
                aciContext.setMicroOperations(SEARCH_ATTRVAL_PERMS);
                aciContext.setAciTuples(tuples);
                aciContext.setEntry(clonedEntry);
                if (this.engine.hasPermission(aciContext)) continue;
                valueToRemove.add(value);
            }
            for (Value value : valueToRemove) {
                attr.remove(value);
            }
            if (attr.size() != 0) continue;
            attributeToRemove.add(attributeType);
        }
        for (AttributeType attributeType : attributeToRemove) {
            clonedEntry.removeAttributes(attributeType);
        }
        return true;
    }

    private boolean isTheAdministrator(Dn normalizedDn) {
        return normalizedDn.getNormName().equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
    }

    static {
        HashSet<MicroOperation> set = new HashSet<MicroOperation>(2);
        set.add(MicroOperation.BROWSE);
        set.add(MicroOperation.RETURN_DN);
        SEARCH_ENTRY_PERMS = Collections.unmodifiableCollection(set);
        set = new HashSet(2);
        set.add(MicroOperation.READ);
        set.add(MicroOperation.BROWSE);
        LOOKUP_PERMS = Collections.unmodifiableCollection(set);
        set = new HashSet(2);
        set.add(MicroOperation.ADD);
        set.add(MicroOperation.REMOVE);
        REPLACE_PERMS = Collections.unmodifiableCollection(set);
        set = new HashSet(2);
        set.add(MicroOperation.EXPORT);
        set.add(MicroOperation.RENAME);
        MOVERENAME_PERMS = Collections.unmodifiableCollection(set);
        SEARCH_ATTRVAL_PERMS = Collections.singleton(MicroOperation.READ);
        ADD_PERMS = Collections.singleton(MicroOperation.ADD);
        READ_PERMS = Collections.singleton(MicroOperation.READ);
        COMPARE_PERMS = Collections.singleton(MicroOperation.COMPARE);
        REMOVE_PERMS = Collections.singleton(MicroOperation.REMOVE);
        BROWSE_PERMS = Collections.singleton(MicroOperation.BROWSE);
        RENAME_PERMS = Collections.singleton(MicroOperation.RENAME);
        EXPORT_PERMS = Collections.singleton(MicroOperation.EXPORT);
        IMPORT_PERMS = Collections.singleton(MicroOperation.IMPORT);
        DEFAULT_SEARCH_CONTROLS = new SearchControls();
    }

    private class AuthorizationFilter
    implements EntryFilter {
        private AuthorizationFilter() {
        }

        @Override
        public boolean accept(SearchOperationContext searchContext, Entry entry) throws LdapException {
            Dn normName = entry.getDn().apply(AciAuthorizationInterceptor.this.schemaManager);
            return AciAuthorizationInterceptor.this.filter(searchContext, normName, entry);
        }

        @Override
        public String toString(String tabs) {
            return tabs + "AuthorizationFilter";
        }
    }
}

