/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolableLdapConnectionFactory
implements PoolableObjectFactory<LdapConnection> {
    private LdapConnectionConfig config;
    private static final Logger LOG = LoggerFactory.getLogger(PoolableLdapConnectionFactory.class);

    public PoolableLdapConnectionFactory(LdapConnectionConfig config) {
        this.config = config;
    }

    @Override
    public void activateObject(LdapConnection connection) throws Exception {
        LOG.debug("Activating {}", (Object)connection);
    }

    @Override
    public void destroyObject(LdapConnection connection) throws Exception {
        LOG.debug("Destroying {}", (Object)connection);
        connection.unBind();
        connection.close();
    }

    @Override
    public LdapConnection makeObject() throws Exception {
        LOG.debug("Creating a LDAP connection");
        LdapNetworkConnection connection = new LdapNetworkConnection(this.config);
        try {
            connection.bind(this.config.getName(), this.config.getCredentials());
        }
        catch (Exception e) {
            LOG.warn("Cannot bind : {}", (Object)e.getMessage());
            connection.close();
            throw e;
        }
        return connection;
    }

    @Override
    public void passivateObject(LdapConnection connection) throws Exception {
        LOG.debug("Passivating {}", (Object)connection);
    }

    @Override
    public boolean validateObject(LdapConnection connection) {
        LOG.debug("Validating {}", (Object)connection);
        return connection.isConnected();
    }
}

