/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.controls.search.persistentSearch;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.Asn1Object;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ControlDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.controls.search.persistentSearch.PersistentSearchContainer;
import org.apache.directory.api.ldap.model.message.controls.ChangeType;
import org.apache.directory.api.ldap.model.message.controls.PersistentSearch;
import org.apache.directory.api.ldap.model.message.controls.PersistentSearchImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentSearchDecorator
extends ControlDecorator<PersistentSearch>
implements PersistentSearch {
    private int psearchSeqLength;
    private static final Asn1Decoder decoder = new Asn1Decoder();

    public PersistentSearchDecorator(LdapApiService codec) {
        this(codec, new PersistentSearchImpl());
    }

    public PersistentSearchDecorator(LdapApiService codec, PersistentSearch control) {
        super(codec, control);
    }

    @Override
    public int computeLength() {
        int changeTypesLength = 2 + BerValue.getNbBytes(this.getChangeTypes());
        int changesOnlyLength = 3;
        int returnRCsLength = 3;
        this.psearchSeqLength = changeTypesLength + changesOnlyLength + returnRCsLength;
        int valueLength = 1 + TLV.getNbBytes(this.psearchSeqLength) + this.psearchSeqLength;
        return valueLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_04023, new Object[0]));
        }
        buffer.put(UniversalTag.SEQUENCE.getValue());
        buffer.put(TLV.getBytes(this.psearchSeqLength));
        BerValue.encode(buffer, this.getChangeTypes());
        BerValue.encode(buffer, this.isChangesOnly());
        BerValue.encode(buffer, this.isReturnECs());
        return buffer;
    }

    @Override
    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                buffer.put(UniversalTag.SEQUENCE.getValue());
                buffer.put(TLV.getBytes(this.psearchSeqLength));
                BerValue.encode(buffer, this.getChangeTypes());
                BerValue.encode(buffer, this.isChangesOnly());
                BerValue.encode(buffer, this.isReturnECs());
                this.value = buffer.array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    private PersistentSearch getPersistentSearch() {
        return (PersistentSearch)this.getDecorated();
    }

    @Override
    public void setChangesOnly(boolean changesOnly) {
        this.getPersistentSearch().setChangesOnly(changesOnly);
    }

    @Override
    public boolean isChangesOnly() {
        return this.getPersistentSearch().isChangesOnly();
    }

    @Override
    public void setReturnECs(boolean returnECs) {
        this.getPersistentSearch().setReturnECs(returnECs);
    }

    @Override
    public boolean isReturnECs() {
        return this.getPersistentSearch().isReturnECs();
    }

    @Override
    public void setChangeTypes(int changeTypes) {
        this.getPersistentSearch().setChangeTypes(changeTypes);
    }

    @Override
    public int getChangeTypes() {
        return this.getPersistentSearch().getChangeTypes();
    }

    @Override
    public boolean isNotificationEnabled(ChangeType changeType) {
        return this.getPersistentSearch().isNotificationEnabled(changeType);
    }

    @Override
    public void enableNotification(ChangeType changeType) {
        this.getPersistentSearch().enableNotification(changeType);
    }

    @Override
    public Asn1Object decode(byte[] controlBytes) throws DecoderException {
        ByteBuffer bb = ByteBuffer.wrap(controlBytes);
        PersistentSearchContainer container = new PersistentSearchContainer(this.getCodecService(), this);
        decoder.decode(bb, container);
        return this;
    }
}

