/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.searchResultReference;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchResultReferenceDecorator;
import org.apache.directory.api.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.ldap.model.message.ReferralImpl;
import org.apache.directory.api.ldap.model.message.SearchResultReference;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreReference
extends GrammarAction<LdapMessageContainer<SearchResultReferenceDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreReference.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreReference() {
        super("Store a reference");
    }

    @Override
    public void action(LdapMessageContainer<SearchResultReferenceDecorator> container) throws DecoderException {
        SearchResultReference searchResultReference = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        Referral referral = searchResultReference.getReferral();
        if (referral == null) {
            referral = new ReferralImpl();
            searchResultReference.setReferral(referral);
        }
        LdapUrl url = LdapUrl.EMPTY_URL;
        if (tlv.getLength() == 0) {
            referral.addLdapUrl("");
        } else {
            String urlStr = Strings.utf8ToString(tlv.getValue().getData());
            try {
                url = new LdapUrl(urlStr);
                referral.addLdapUrl(urlStr);
            }
            catch (LdapURLEncodingException luee) {
                LOG.error(I18n.err(I18n.ERR_04021, urlStr, luee.getMessage()));
                throw new DecoderException(I18n.err(I18n.ERR_04016, luee.getMessage()));
            }
        }
        if (IS_DEBUG) {
            LOG.debug("Search reference URL found : {}", (Object)url);
        }
        container.setGrammarEndAllowed(true);
    }
}

