/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.nonstop.store;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.cluster.CacheCluster;
import net.sf.ehcache.cluster.ClusterNode;
import net.sf.ehcache.cluster.ClusterTopologyListener;
import net.sf.ehcache.config.NonstopConfiguration;
import net.sf.ehcache.constructs.nonstop.ClusterOperation;
import net.sf.ehcache.constructs.nonstop.NonstopActiveDelegateHolder;
import net.sf.ehcache.constructs.nonstop.concurrency.CacheOperationUnderExplicitLockCallable;
import net.sf.ehcache.constructs.nonstop.concurrency.ExplicitLockingContextThreadLocal;
import net.sf.ehcache.constructs.nonstop.store.ClusterOperationCallableImpl;
import net.sf.ehcache.constructs.nonstop.store.NonstopStore;
import net.sf.ehcache.constructs.nonstop.store.NonstopTimeoutBehaviorStoreResolver;
import net.sf.ehcache.constructs.nonstop.store.RejoinAwareBlockingOperation;
import net.sf.ehcache.constructs.nonstop.store.RejoinAwareNonstopStore;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Results;
import net.sf.ehcache.search.attribute.AttributeExtractor;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.StoreListener;
import net.sf.ehcache.store.StoreQuery;
import net.sf.ehcache.store.TerracottaStore;
import net.sf.ehcache.writer.CacheWriterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutorServiceStore
implements RejoinAwareNonstopStore {
    protected final NonstopConfiguration nonstopConfiguration;
    private final NonstopActiveDelegateHolder nonstopActiveDelegateHolder;
    private final NonstopTimeoutBehaviorStoreResolver timeoutBehaviorResolver;
    private final AtomicBoolean clusterOffline = new AtomicBoolean();
    private final List<RejoinAwareBlockingOperation> rejoinAwareOperations = new CopyOnWriteArrayList<RejoinAwareBlockingOperation>();
    private final ExplicitLockingContextThreadLocal explicitLockingContextThreadLocal;

    public ExecutorServiceStore(NonstopActiveDelegateHolder nonstopActiveDelegateHolder, NonstopConfiguration nonstopConfiguration, NonstopTimeoutBehaviorStoreResolver timeoutBehaviorResolver, CacheCluster cacheCluster, ExplicitLockingContextThreadLocal explicitLockingContextThreadLocal) {
        this.nonstopActiveDelegateHolder = nonstopActiveDelegateHolder;
        this.nonstopConfiguration = nonstopConfiguration;
        this.timeoutBehaviorResolver = timeoutBehaviorResolver;
        this.explicitLockingContextThreadLocal = explicitLockingContextThreadLocal;
        cacheCluster.addTopologyListener(new ClusterStatusListener(this, cacheCluster));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clusterOffline() {
        this.clusterOffline.set(true);
        AtomicBoolean atomicBoolean = this.clusterOffline;
        synchronized (atomicBoolean) {
            this.clusterOffline.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clusterOnline() {
        this.clusterOffline.set(false);
        AtomicBoolean atomicBoolean = this.clusterOffline;
        synchronized (atomicBoolean) {
            this.clusterOffline.notifyAll();
        }
    }

    private <V> V forceExecuteWithExecutor(Callable<V> callable) throws CacheException, TimeoutException {
        return this.forceExecuteWithExecutor(callable, this.nonstopConfiguration.getTimeoutMillis());
    }

    private <V> V forceExecuteWithExecutor(Callable<V> callable, long timeoutMillis) throws CacheException, TimeoutException {
        return this.executeWithExecutor(callable, timeoutMillis, true);
    }

    protected <V> V executeWithExecutor(Callable<V> callable) throws CacheException, TimeoutException {
        return this.executeWithExecutor(callable, this.nonstopConfiguration.getTimeoutMillis(), false);
    }

    protected <V> V executeWithExecutor(Callable<V> callable, long timeoutMillis) throws CacheException, TimeoutException {
        return this.executeWithExecutor(callable, timeoutMillis, false);
    }

    private <V> V executeWithExecutor(Callable<V> callable, long timeOutMills, boolean force) throws CacheException, TimeoutException {
        boolean operationUnderExplicitLock;
        Callable<V> effectiveCallable = callable;
        long start = System.nanoTime();
        if (!force) {
            this.checkForClusterOffline(start, timeOutMills);
        }
        if (operationUnderExplicitLock = this.explicitLockingContextThreadLocal.areAnyExplicitLocksAcquired()) {
            effectiveCallable = new CacheOperationUnderExplicitLockCallable<V>(this.explicitLockingContextThreadLocal.getCurrentThreadLockContext(), this.nonstopConfiguration, callable);
        }
        try {
            long remaining = timeOutMills - TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            return this.nonstopActiveDelegateHolder.getNonstopExecutorService().execute(effectiveCallable, remaining);
        }
        catch (InterruptedException e) {
            throw new CacheException(e);
        }
    }

    protected TerracottaStore underlyingTerracottaStore() {
        return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore();
    }

    protected NonstopStore resolveTimeoutBehaviorStore() {
        return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForClusterOffline(long start, long timeoutMills) throws TimeoutException {
        while (this.clusterOffline.get()) {
            if (this.nonstopConfiguration.isImmediateTimeout()) {
                throw new TimeoutException("Cluster is currently offline");
            }
            long remaining = timeoutMills - TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            if (remaining <= 0L) break;
            AtomicBoolean atomicBoolean = this.clusterOffline;
            synchronized (atomicBoolean) {
                try {
                    this.clusterOffline.wait(remaining);
                }
                catch (InterruptedException e) {
                    throw new CacheException(e);
                }
            }
        }
        if (this.clusterOffline.get()) {
            throw new TimeoutException("Cluster is currently offline");
        }
    }

    @Override
    public void dispose() {
        try {
            this.forceExecuteWithExecutor(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().dispose();
                    return null;
                }
            });
        }
        catch (TimeoutException e) {
            this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().dispose();
        }
    }

    @Override
    public void setNodeCoherent(final boolean coherent) throws UnsupportedOperationException {
        try {
            this.forceExecuteWithExecutor(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().setNodeCoherent(coherent);
                    return null;
                }
            }, this.nonstopConfiguration.getTimeoutMillis() * (long)this.nonstopConfiguration.getBulkOpsTimeoutMultiplyFactor());
        }
        catch (TimeoutException e) {
            this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().setNodeCoherent(coherent);
        }
    }

    @Override
    public void setAttributeExtractors(final Map<String, AttributeExtractor> extractors) {
        try {
            this.forceExecuteWithExecutor(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().setAttributeExtractors(extractors);
                    return null;
                }
            });
        }
        catch (TimeoutException e) {
            this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().setAttributeExtractors(extractors);
        }
    }

    @Override
    public void addStoreListener(final StoreListener listener) {
        try {
            this.forceExecuteWithExecutor(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().addStoreListener(listener);
                    return null;
                }
            });
        }
        catch (TimeoutException e) {
            this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().addStoreListener(listener);
        }
    }

    @Override
    public void removeStoreListener(final StoreListener listener) {
        try {
            this.executeWithExecutor(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().removeStoreListener(listener);
                    return null;
                }
            });
        }
        catch (TimeoutException e) {
            this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().removeStoreListener(listener);
        }
    }

    @Override
    public boolean put(final Element element) throws CacheException {
        boolean rv = false;
        try {
            rv = this.executeWithExecutor(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().put(element);
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().put(element);
        }
        return rv;
    }

    @Override
    public boolean putWithWriter(final Element element, final CacheWriterManager writerManager) throws CacheException {
        boolean rv = false;
        try {
            rv = this.executeWithExecutor(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().putWithWriter(element, writerManager);
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().putWithWriter(element, writerManager);
        }
        return rv;
    }

    @Override
    public Element get(final Object key) {
        Element rv = null;
        try {
            rv = this.executeWithExecutor(new Callable<Element>(){

                @Override
                public Element call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().get(key);
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().get(key);
        }
        return rv;
    }

    @Override
    public Element getQuiet(final Object key) {
        Element rv = null;
        try {
            rv = this.executeWithExecutor(new Callable<Element>(){

                @Override
                public Element call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getQuiet(key);
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().getQuiet(key);
        }
        return rv;
    }

    @Override
    public List getKeys() {
        List rv = null;
        try {
            rv = this.executeWithExecutor(new Callable<List>(){

                @Override
                public List call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getKeys();
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().getKeys();
        }
        return rv;
    }

    @Override
    public Element remove(final Object key) {
        Element rv = null;
        try {
            rv = this.executeWithExecutor(new Callable<Element>(){

                @Override
                public Element call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().remove(key);
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().remove(key);
        }
        return rv;
    }

    @Override
    public Element removeWithWriter(final Object key, final CacheWriterManager writerManager) throws CacheException {
        Element rv = null;
        try {
            rv = this.executeWithExecutor(new Callable<Element>(){

                @Override
                public Element call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().removeWithWriter(key, writerManager);
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().removeWithWriter(key, writerManager);
        }
        return rv;
    }

    @Override
    public void removeAll() throws CacheException {
        try {
            this.executeWithExecutor(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().removeAll();
                    return null;
                }
            }, this.nonstopConfiguration.getTimeoutMillis() * (long)this.nonstopConfiguration.getBulkOpsTimeoutMultiplyFactor());
        }
        catch (TimeoutException e) {
            this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().removeAll();
        }
    }

    @Override
    public Element putIfAbsent(final Element element) throws NullPointerException {
        Element rv = null;
        try {
            rv = this.executeWithExecutor(new Callable<Element>(){

                @Override
                public Element call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().putIfAbsent(element);
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().putIfAbsent(element);
        }
        return rv;
    }

    @Override
    public Element removeElement(final Element element, final ElementValueComparator comparator) throws NullPointerException {
        Element rv = null;
        try {
            rv = this.executeWithExecutor(new Callable<Element>(){

                @Override
                public Element call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().removeElement(element, comparator);
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().removeElement(element, comparator);
        }
        return rv;
    }

    @Override
    public boolean replace(final Element old, final Element element, final ElementValueComparator comparator) throws NullPointerException, IllegalArgumentException {
        boolean rv = false;
        try {
            rv = this.executeWithExecutor(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().replace(old, element, comparator);
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().replace(old, element, comparator);
        }
        return rv;
    }

    @Override
    public Element replace(final Element element) throws NullPointerException {
        Element rv = null;
        try {
            rv = this.executeWithExecutor(new Callable<Element>(){

                @Override
                public Element call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().replace(element);
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().replace(element);
        }
        return rv;
    }

    @Override
    public int getSize() {
        int rv = 0;
        try {
            rv = this.executeWithExecutor(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getSize();
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().getSize();
        }
        return rv;
    }

    @Override
    public int getInMemorySize() {
        int rv = 0;
        try {
            rv = this.executeWithExecutor(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getInMemorySize();
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().getInMemorySize();
        }
        return rv;
    }

    @Override
    public int getOffHeapSize() {
        int rv = 0;
        try {
            rv = this.executeWithExecutor(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getOffHeapSize();
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().getOffHeapSize();
        }
        return rv;
    }

    @Override
    public int getOnDiskSize() {
        int rv = 0;
        try {
            rv = this.executeWithExecutor(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getOnDiskSize();
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().getOnDiskSize();
        }
        return rv;
    }

    @Override
    public int getTerracottaClusteredSize() {
        int rv = 0;
        try {
            rv = this.executeWithExecutor(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getTerracottaClusteredSize();
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().getTerracottaClusteredSize();
        }
        return rv;
    }

    @Override
    public long getInMemorySizeInBytes() {
        long rv = 0L;
        try {
            rv = this.executeWithExecutor(new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getInMemorySizeInBytes();
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().getInMemorySizeInBytes();
        }
        return rv;
    }

    @Override
    public long getOffHeapSizeInBytes() {
        long rv = 0L;
        try {
            rv = this.executeWithExecutor(new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getOffHeapSizeInBytes();
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().getOffHeapSizeInBytes();
        }
        return rv;
    }

    @Override
    public long getOnDiskSizeInBytes() {
        long rv = 0L;
        try {
            rv = this.executeWithExecutor(new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getOnDiskSizeInBytes();
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().getOnDiskSizeInBytes();
        }
        return rv;
    }

    @Override
    public Status getStatus() {
        Status rv = null;
        try {
            rv = this.executeWithExecutor(new Callable<Status>(){

                @Override
                public Status call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getStatus();
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().getStatus();
        }
        return rv;
    }

    @Override
    public boolean containsKey(final Object key) {
        boolean rv = false;
        try {
            rv = this.executeWithExecutor(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().containsKey(key);
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().containsKey(key);
        }
        return rv;
    }

    @Override
    public boolean containsKeyOnDisk(final Object key) {
        boolean rv = false;
        try {
            rv = this.executeWithExecutor(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().containsKeyOnDisk(key);
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().containsKeyOnDisk(key);
        }
        return rv;
    }

    @Override
    public boolean containsKeyOffHeap(final Object key) {
        boolean rv = false;
        try {
            rv = this.executeWithExecutor(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().containsKeyOffHeap(key);
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().containsKeyOffHeap(key);
        }
        return rv;
    }

    @Override
    public boolean containsKeyInMemory(final Object key) {
        boolean rv = false;
        try {
            rv = this.executeWithExecutor(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().containsKeyInMemory(key);
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().containsKeyInMemory(key);
        }
        return rv;
    }

    @Override
    public void expireElements() {
        try {
            this.executeWithExecutor(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().expireElements();
                    return null;
                }
            });
        }
        catch (TimeoutException e) {
            this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().expireElements();
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.executeWithExecutor(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().flush();
                    return null;
                }
            });
        }
        catch (TimeoutException e) {
            this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().flush();
        }
    }

    @Override
    public boolean bufferFull() {
        boolean rv = false;
        try {
            rv = this.executeWithExecutor(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().bufferFull();
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().bufferFull();
        }
        return rv;
    }

    @Override
    public Policy getInMemoryEvictionPolicy() {
        Policy rv = null;
        try {
            rv = this.executeWithExecutor(new Callable<Policy>(){

                @Override
                public Policy call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getInMemoryEvictionPolicy();
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().getInMemoryEvictionPolicy();
        }
        return rv;
    }

    @Override
    public void setInMemoryEvictionPolicy(final Policy policy) {
        try {
            this.executeWithExecutor(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().setInMemoryEvictionPolicy(policy);
                    return null;
                }
            });
        }
        catch (TimeoutException e) {
            this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().setInMemoryEvictionPolicy(policy);
        }
    }

    @Override
    public Object getInternalContext() {
        Object rv = null;
        try {
            rv = this.executeWithExecutor(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getInternalContext();
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().getInternalContext();
        }
        return rv;
    }

    @Override
    public boolean isCacheCoherent() {
        boolean rv = false;
        try {
            rv = this.executeWithExecutor(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().isCacheCoherent();
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().isCacheCoherent();
        }
        return rv;
    }

    @Override
    public boolean isClusterCoherent() {
        boolean rv = false;
        try {
            rv = this.executeWithExecutor(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().isClusterCoherent();
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().isClusterCoherent();
        }
        return rv;
    }

    @Override
    public boolean isNodeCoherent() {
        boolean rv = false;
        try {
            rv = this.executeWithExecutor(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().isNodeCoherent();
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().isNodeCoherent();
        }
        return rv;
    }

    @Override
    public void waitUntilClusterCoherent() throws UnsupportedOperationException, InterruptedException {
        RejoinAwareBlockingOperation<Void> operation = new RejoinAwareBlockingOperation<Void>(this, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().waitUntilClusterCoherent();
                return null;
            }
        });
        this.rejoinAwareOperations.add(operation);
        try {
            operation.call();
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            throw new CacheException(e);
        }
        finally {
            this.rejoinAwareOperations.remove(operation);
        }
    }

    @Override
    public Object getMBean() {
        Object rv = null;
        try {
            rv = this.executeWithExecutor(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getMBean();
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().getMBean();
        }
        return rv;
    }

    @Override
    public Results executeQuery(final StoreQuery query) {
        Results rv = null;
        try {
            rv = this.executeWithExecutor(new Callable<Results>(){

                @Override
                public Results call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().executeQuery(query);
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().executeQuery(query);
        }
        return rv;
    }

    @Override
    public <T> Attribute<T> getSearchAttribute(final String attributeName) {
        try {
            return (Attribute)this.executeWithExecutor(new Callable<Attribute<T>>(){

                @Override
                public Attribute<T> call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getSearchAttribute(attributeName);
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().getSearchAttribute(attributeName);
        }
    }

    @Override
    public Set getLocalKeys() {
        try {
            return this.executeWithExecutor(new Callable<Set>(){

                @Override
                public Set call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getLocalKeys();
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().getLocalKeys();
        }
    }

    @Override
    public Element unlockedGet(final Object key) {
        try {
            return this.executeWithExecutor(new Callable<Element>(){

                @Override
                public Element call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().unlockedGet(key);
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().unlockedGet(key);
        }
    }

    @Override
    public Element unlockedGetQuiet(final Object key) {
        try {
            return this.executeWithExecutor(new Callable<Element>(){

                @Override
                public Element call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().unlockedGetQuiet(key);
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().unlockedGetQuiet(key);
        }
    }

    @Override
    public Element unsafeGet(final Object key) {
        try {
            return this.executeWithExecutor(new Callable<Element>(){

                @Override
                public Element call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().unsafeGet(key);
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().unsafeGet(key);
        }
    }

    @Override
    public Element unsafeGetQuiet(final Object key) {
        try {
            return this.executeWithExecutor(new Callable<Element>(){

                @Override
                public Element call() throws Exception {
                    return ExecutorServiceStore.this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().unsafeGetQuiet(key);
                }
            });
        }
        catch (TimeoutException e) {
            return this.timeoutBehaviorResolver.resolveTimeoutBehaviorStore().unsafeGetQuiet(key);
        }
    }

    @Override
    public <V> V executeClusterOperation(ClusterOperation<V> operation) {
        try {
            return this.executeWithExecutor(new ClusterOperationCallableImpl<V>(operation));
        }
        catch (TimeoutException e) {
            return operation.performClusterOperationTimedOut(this.nonstopConfiguration.getTimeoutBehavior().getTimeoutBehaviorType());
        }
    }

    protected <V> V executeClusterOperationNoTimeout(ClusterOperation<V> operation) throws InterruptedException {
        try {
            return this.executeWithExecutor(new ClusterOperationCallableImpl<V>(operation), Integer.MAX_VALUE, true);
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)"This should never happen as executed with no-timeout");
        }
        catch (CacheException e) {
            Throwable rootCause = this.getRootCause(e);
            if (rootCause instanceof InterruptedException) {
                throw (InterruptedException)rootCause;
            }
            throw e;
        }
    }

    private Throwable getRootCause(CacheException exception) {
        Throwable e = exception;
        while (e.getCause() != null) {
            e = e.getCause();
        }
        return e;
    }

    @Override
    public void clusterRejoined() {
        for (RejoinAwareBlockingOperation operation : this.rejoinAwareOperations) {
            operation.clusterRejoined();
        }
    }

    private static class ClusterStatusListener
    implements ClusterTopologyListener {
        private final ExecutorServiceStore executorServiceStore;
        private final CacheCluster cacheCluster;

        public ClusterStatusListener(ExecutorServiceStore executorServiceStore, CacheCluster cacheCluster) {
            this.executorServiceStore = executorServiceStore;
            this.cacheCluster = cacheCluster;
        }

        public void clusterOffline(ClusterNode node) {
            if (this.cacheCluster.getCurrentNode().equals(node)) {
                this.executorServiceStore.clusterOffline();
            }
        }

        public void clusterOnline(ClusterNode node) {
            if (this.cacheCluster.getCurrentNode().equals(node)) {
                this.executorServiceStore.clusterOnline();
            }
        }

        public void nodeJoined(ClusterNode node) {
        }

        public void nodeLeft(ClusterNode node) {
        }

        public void clusterRejoined(ClusterNode oldNode, ClusterNode newNode) {
        }
    }
}

