/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.config.builder;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.ldif.LdapLdifException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.config.ConfigurationException;
import org.apache.directory.server.config.beans.AuthenticationInterceptorBean;
import org.apache.directory.server.config.beans.AuthenticatorBean;
import org.apache.directory.server.config.beans.AuthenticatorImplBean;
import org.apache.directory.server.config.beans.ChangeLogBean;
import org.apache.directory.server.config.beans.DelegatingAuthenticatorBean;
import org.apache.directory.server.config.beans.DirectoryServiceBean;
import org.apache.directory.server.config.beans.ExtendedOpHandlerBean;
import org.apache.directory.server.config.beans.HttpServerBean;
import org.apache.directory.server.config.beans.HttpWebAppBean;
import org.apache.directory.server.config.beans.IndexBean;
import org.apache.directory.server.config.beans.InterceptorBean;
import org.apache.directory.server.config.beans.JdbmIndexBean;
import org.apache.directory.server.config.beans.JdbmPartitionBean;
import org.apache.directory.server.config.beans.JournalBean;
import org.apache.directory.server.config.beans.KdcServerBean;
import org.apache.directory.server.config.beans.LdapServerBean;
import org.apache.directory.server.config.beans.NtpServerBean;
import org.apache.directory.server.config.beans.PartitionBean;
import org.apache.directory.server.config.beans.PasswordPolicyBean;
import org.apache.directory.server.config.beans.ReplConsumerBean;
import org.apache.directory.server.config.beans.SaslMechHandlerBean;
import org.apache.directory.server.config.beans.TcpTransportBean;
import org.apache.directory.server.config.beans.TransportBean;
import org.apache.directory.server.config.beans.UdpTransportBean;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InstanceLayout;
import org.apache.directory.server.core.api.authn.ppolicy.PasswordPolicyConfiguration;
import org.apache.directory.server.core.api.changelog.ChangeLog;
import org.apache.directory.server.core.api.interceptor.Interceptor;
import org.apache.directory.server.core.api.journal.Journal;
import org.apache.directory.server.core.api.journal.JournalStore;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.authn.AuthenticationInterceptor;
import org.apache.directory.server.core.authn.Authenticator;
import org.apache.directory.server.core.authn.DelegatingAuthenticator;
import org.apache.directory.server.core.authn.ppolicy.PpolicyConfigContainer;
import org.apache.directory.server.core.changelog.DefaultChangeLog;
import org.apache.directory.server.core.journal.DefaultJournal;
import org.apache.directory.server.core.journal.DefaultJournalStore;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmRdnIndex;
import org.apache.directory.server.integration.http.HttpServer;
import org.apache.directory.server.integration.http.WebApp;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.handlers.bind.MechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.ntlm.NtlmMechanismHandler;
import org.apache.directory.server.ldap.replication.ReplicationConsumerConfig;
import org.apache.directory.server.ldap.replication.ReplicationTrustManager;
import org.apache.directory.server.ldap.replication.SyncReplConfiguration;
import org.apache.directory.server.ldap.replication.consumer.ReplicationConsumer;
import org.apache.directory.server.ldap.replication.consumer.ReplicationConsumerImpl;
import org.apache.directory.server.ldap.replication.provider.ReplicationRequestHandler;
import org.apache.directory.server.ldap.replication.provider.SyncReplRequestHandler;
import org.apache.directory.server.ntp.NtpServer;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceBuilder.class);
    private static FilenameFilter ldifFilter = new FilenameFilter(){

        @Override
        public boolean accept(File file, String name) {
            if (file.isDirectory()) {
                return true;
            }
            return Strings.toLowerCase((String)file.getName()).endsWith(".ldif");
        }
    };

    public static List<Interceptor> createInterceptors(List<InterceptorBean> interceptorBeans) throws LdapException {
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>(interceptorBeans.size());
        TreeSet<InterceptorBean> orderedInterceptorBeans = new TreeSet<InterceptorBean>();
        for (InterceptorBean interceptorBean : interceptorBeans) {
            if (!interceptorBean.isEnabled()) continue;
            orderedInterceptorBeans.add(interceptorBean);
        }
        for (InterceptorBean interceptorBean : orderedInterceptorBeans) {
            try {
                LOG.debug("loading the interceptor class {} and instantiating", (Object)interceptorBean.getInterceptorClassName());
                Interceptor interceptor = (Interceptor)Class.forName(interceptorBean.getInterceptorClassName()).newInstance();
                if (interceptorBean instanceof AuthenticationInterceptorBean) {
                    Authenticator[] authenticators = ServiceBuilder.createAuthenticators(((AuthenticationInterceptorBean)interceptorBean).getAuthenticators());
                    ((AuthenticationInterceptor)interceptor).setAuthenticators(authenticators);
                    List ppolicyBeans = ((AuthenticationInterceptorBean)interceptorBean).getPasswordPolicies();
                    PpolicyConfigContainer ppolicyContainer = new PpolicyConfigContainer();
                    for (PasswordPolicyBean ppolicyBean : ppolicyBeans) {
                        PasswordPolicyConfiguration ppolicyConfig = ServiceBuilder.createPwdPolicyConfig(ppolicyBean);
                        if (ppolicyConfig == null) continue;
                        if (ppolicyBean.getPwdId().equalsIgnoreCase("default")) {
                            ppolicyContainer.setDefaultPolicy(ppolicyConfig);
                            continue;
                        }
                        ppolicyContainer.addPolicy(ppolicyBean.getDn(), ppolicyConfig);
                    }
                    ((AuthenticationInterceptor)interceptor).setPwdPolicies(ppolicyContainer);
                }
                interceptors.add(interceptor);
            }
            catch (Exception e) {
                e.printStackTrace();
                String message = "Cannot initialize the " + interceptorBean.getInterceptorClassName() + ", error : " + e;
                LOG.error(message);
                throw new ConfigurationException(message);
            }
        }
        return interceptors;
    }

    public static PasswordPolicyConfiguration createPwdPolicyConfig(PasswordPolicyBean passwordPolicyBean) {
        if (passwordPolicyBean == null || passwordPolicyBean.isDisabled()) {
            return null;
        }
        PasswordPolicyConfiguration passwordPolicy = new PasswordPolicyConfiguration();
        passwordPolicy.setPwdAllowUserChange(passwordPolicyBean.isPwdAllowUserChange());
        passwordPolicy.setPwdAttribute(passwordPolicyBean.getPwdAttribute());
        passwordPolicy.setPwdCheckQuality(passwordPolicyBean.getPwdCheckQuality());
        passwordPolicy.setPwdExpireWarning(passwordPolicyBean.getPwdExpireWarning());
        passwordPolicy.setPwdFailureCountInterval(passwordPolicyBean.getPwdFailureCountInterval());
        passwordPolicy.setPwdGraceAuthNLimit(passwordPolicyBean.getPwdGraceAuthNLimit());
        passwordPolicy.setPwdGraceExpire(passwordPolicyBean.getPwdGraceExpire());
        passwordPolicy.setPwdInHistory(passwordPolicyBean.getPwdInHistory());
        passwordPolicy.setPwdLockout(passwordPolicyBean.isPwdLockout());
        passwordPolicy.setPwdLockoutDuration(passwordPolicyBean.getPwdLockoutDuration());
        passwordPolicy.setPwdMaxAge(passwordPolicyBean.getPwdMaxAge());
        passwordPolicy.setPwdMaxDelay(passwordPolicyBean.getPwdMaxDelay());
        passwordPolicy.setPwdMaxFailure(passwordPolicyBean.getPwdMaxFailure());
        passwordPolicy.setPwdMaxIdle(passwordPolicyBean.getPwdMaxIdle());
        passwordPolicy.setPwdMaxLength(passwordPolicyBean.getPwdMaxLength());
        passwordPolicy.setPwdMinAge(passwordPolicyBean.getPwdMinAge());
        passwordPolicy.setPwdMinDelay(passwordPolicyBean.getPwdMinDelay());
        passwordPolicy.setPwdMinLength(passwordPolicyBean.getPwdMinLength());
        passwordPolicy.setPwdMustChange(passwordPolicyBean.isPwdMustChange());
        passwordPolicy.setPwdSafeModify(passwordPolicyBean.isPwdSafeModify());
        return passwordPolicy;
    }

    public static ChangeLog createChangeLog(ChangeLogBean changeLogBean) {
        if (changeLogBean == null || changeLogBean.isDisabled()) {
            return null;
        }
        DefaultChangeLog changeLog = new DefaultChangeLog();
        changeLog.setEnabled(changeLogBean.isEnabled());
        changeLog.setExposed(changeLogBean.isChangeLogExposed());
        return changeLog;
    }

    public static Journal createJournal(JournalBean journalBean) {
        if (journalBean == null || journalBean.isDisabled()) {
            return null;
        }
        DefaultJournal journal = new DefaultJournal();
        journal.setRotation(journalBean.getJournalRotation());
        journal.setEnabled(journalBean.isEnabled());
        DefaultJournalStore store = new DefaultJournalStore();
        store.setFileName(journalBean.getJournalFileName());
        store.setWorkingDirectory(journalBean.getJournalWorkingDir());
        journal.setJournalStore((JournalStore)store);
        return journal;
    }

    public static List<LdifEntry> readTestEntries(String entryFilePath) throws ConfigurationException {
        ArrayList<LdifEntry> entries = new ArrayList<LdifEntry>();
        File file = new File(entryFilePath);
        if (!file.exists()) {
            LOG.warn("LDIF test entry file path doesn't exist {}", (Object)entryFilePath);
        } else {
            LOG.debug("parsing the LDIF file(s) present at the path {}", (Object)entryFilePath);
            try {
                ServiceBuilder.loadEntries(file, entries);
            }
            catch (LdapLdifException e) {
                String message = "Error while parsing a LdifEntry : " + e.getMessage();
                LOG.error(message);
                throw new ConfigurationException(message);
            }
            catch (IOException e) {
                String message = "cannot read the Ldif entries from the " + entryFilePath + " location";
                LOG.error(message);
                throw new ConfigurationException(message);
            }
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadEntries(File ldifFile, List<LdifEntry> entries) throws LdapLdifException, IOException {
        if (ldifFile.isDirectory()) {
            File[] files;
            for (File f : files = ldifFile.listFiles(ldifFilter)) {
                ServiceBuilder.loadEntries(f, entries);
            }
        } else {
            LdifReader reader = new LdifReader();
            try {
                entries.addAll(reader.parseLdifFile(ldifFile.getAbsolutePath()));
            }
            finally {
                reader.close();
            }
        }
    }

    public static MechanismHandler createSaslMechHandler(SaslMechHandlerBean saslMechHandlerBean) throws ConfigurationException {
        if (saslMechHandlerBean == null || saslMechHandlerBean.isDisabled()) {
            return null;
        }
        String mechClassName = saslMechHandlerBean.getSaslMechClassName();
        Class<?> mechClass = null;
        try {
            mechClass = Class.forName(mechClassName);
        }
        catch (ClassNotFoundException e) {
            String message = "Cannot find the class " + mechClassName;
            LOG.error(message);
            throw new ConfigurationException(message);
        }
        MechanismHandler handler = null;
        try {
            handler = (MechanismHandler)mechClass.newInstance();
        }
        catch (InstantiationException e) {
            String message = "Cannot instantiate the class : " + mechClassName;
            LOG.error(message);
            throw new ConfigurationException(message);
        }
        catch (IllegalAccessException e) {
            String message = "Cnnot invoke the class' constructor for " + mechClassName;
            LOG.error(message);
            throw new ConfigurationException(message);
        }
        if (mechClass == NtlmMechanismHandler.class) {
            NtlmMechanismHandler ntlmHandler = (NtlmMechanismHandler)handler;
            ntlmHandler.setNtlmProviderFqcn(saslMechHandlerBean.getNtlmMechProvider());
        }
        return handler;
    }

    public static Authenticator createAuthenticator(AuthenticatorBean authenticatorBean) throws ConfigurationException {
        if (authenticatorBean.isDisabled()) {
            return null;
        }
        DelegatingAuthenticator authenticator = null;
        if (authenticatorBean instanceof DelegatingAuthenticatorBean) {
            authenticator = new DelegatingAuthenticator();
            authenticator.setDelegateHost(((DelegatingAuthenticatorBean)authenticatorBean).getDelegateHost());
            authenticator.setDelegatePort(((DelegatingAuthenticatorBean)authenticatorBean).getDelegatePort());
        } else if (authenticatorBean instanceof AuthenticatorImplBean) {
            String fqcn = ((AuthenticatorImplBean)authenticatorBean).getAuthenticatorClass();
            try {
                Class<?> authnImplClass = Class.forName(fqcn);
                authenticator = (Authenticator)authnImplClass.newInstance();
            }
            catch (Exception e) {
                String errorMsg = "Failed to instantiate the configured authenticator " + authenticatorBean.getAuthenticatorId();
                LOG.warn(errorMsg);
                throw new ConfigurationException(errorMsg, (Throwable)e);
            }
        }
        return authenticator;
    }

    public static Transport createTransport(TransportBean transportBean) {
        if (transportBean == null || transportBean.isDisabled()) {
            return null;
        }
        TcpTransport transport = null;
        if (transportBean instanceof TcpTransportBean) {
            transport = new TcpTransport();
        } else if (transportBean instanceof UdpTransportBean) {
            transport = new UdpTransport();
        }
        transport.setPort(transportBean.getSystemPort());
        transport.setAddress(transportBean.getTransportAddress());
        transport.setBackLog(transportBean.getTransportBackLog());
        transport.setEnableSSL(transportBean.isTransportEnableSSL());
        transport.setNbThreads(transportBean.getTransportNbThreads());
        return transport;
    }

    public static Authenticator[] createAuthenticators(List<AuthenticatorBean> list) throws ConfigurationException {
        Authenticator[] authenticators = new Authenticator[list.size()];
        int i = 0;
        for (AuthenticatorBean authenticatorBean : list) {
            authenticators[i++] = ServiceBuilder.createAuthenticator(authenticatorBean);
        }
        return authenticators;
    }

    public static Transport[] createTransports(TransportBean[] transportBeans) {
        ArrayList<Transport> transports = new ArrayList<Transport>();
        for (TransportBean transportBean : transportBeans) {
            if (!transportBean.isEnabled()) continue;
            transports.add(ServiceBuilder.createTransport(transportBean));
        }
        return transports.toArray(new Transport[transports.size()]);
    }

    private static EncryptionType[] createEncryptionTypes(List<String> encryptionTypes) {
        if (encryptionTypes == null || encryptionTypes.size() == 0) {
            return new EncryptionType[0];
        }
        EncryptionType[] types = new EncryptionType[encryptionTypes.size()];
        int pos = 0;
        for (String encryptionType : encryptionTypes) {
            types[pos++] = EncryptionType.getByName((String)encryptionType);
        }
        return types;
    }

    public static NtpServer createNtpServer(NtpServerBean ntpServerBean, DirectoryService directoryService) throws LdapException {
        if (ntpServerBean == null || ntpServerBean.isDisabled()) {
            return null;
        }
        NtpServer ntpServer = new NtpServer();
        ntpServer.setServiceId(ntpServerBean.getServerId());
        Transport[] transports = ServiceBuilder.createTransports(ntpServerBean.getTransports());
        ntpServer.setTransports(transports);
        return ntpServer;
    }

    public static KdcServer createKdcServer(KdcServerBean kdcServerBean, DirectoryService directoryService) throws LdapException {
        if (kdcServerBean == null || kdcServerBean.isDisabled()) {
            return null;
        }
        KdcServer kdcServer = new KdcServer();
        kdcServer.setDirectoryService(directoryService);
        kdcServer.setEnabled(true);
        kdcServer.setDirectoryService(directoryService);
        kdcServer.setServiceId(kdcServerBean.getServerId());
        kdcServer.setAllowableClockSkew(kdcServerBean.getKrbAllowableClockSkew());
        kdcServer.setBodyChecksumVerified(kdcServerBean.isKrbBodyChecksumVerified());
        kdcServer.setEmptyAddressesAllowed(kdcServerBean.isKrbEmptyAddressesAllowed());
        EncryptionType[] encryptionTypes = ServiceBuilder.createEncryptionTypes(kdcServerBean.getKrbEncryptionTypes());
        kdcServer.setEncryptionTypes(encryptionTypes);
        kdcServer.setForwardableAllowed(kdcServerBean.isKrbForwardableAllowed());
        kdcServer.setKdcPrincipal(kdcServerBean.getKrbKdcPrincipal().toString());
        kdcServer.setMaximumRenewableLifetime(kdcServerBean.getKrbMaximumRenewableLifetime());
        kdcServer.setMaximumTicketLifetime(kdcServerBean.getKrbMaximumTicketLifetime());
        kdcServer.setPaEncTimestampRequired(kdcServerBean.isKrbPaEncTimestampRequired());
        kdcServer.setPostdatedAllowed(kdcServerBean.isKrbPostdatedAllowed());
        kdcServer.setPrimaryRealm(kdcServerBean.getKrbPrimaryRealm());
        kdcServer.setProxiableAllowed(kdcServerBean.isKrbProxiableAllowed());
        kdcServer.setRenewableAllowed(kdcServerBean.isKrbRenewableAllowed());
        kdcServer.setSearchBaseDn(kdcServerBean.getSearchBaseDn().getName());
        Transport[] transports = ServiceBuilder.createTransports(kdcServerBean.getTransports());
        kdcServer.setTransports(transports);
        return kdcServer;
    }

    public static Set<WebApp> createHttpWebApps(List<HttpWebAppBean> httpWebAppBeans, DirectoryService directoryService) throws LdapException {
        HashSet<WebApp> webApps = new HashSet<WebApp>();
        if (httpWebAppBeans == null) {
            return webApps;
        }
        for (HttpWebAppBean httpWebAppBean : httpWebAppBeans) {
            if (httpWebAppBean.isDisabled()) continue;
            WebApp webApp = new WebApp();
            webApp.setContextPath(httpWebAppBean.getHttpAppCtxPath());
            webApp.setWarFile(httpWebAppBean.getHttpWarFile());
            webApps.add(webApp);
        }
        return webApps;
    }

    public static HttpServer createHttpServer(HttpServerBean httpServerBean, DirectoryService directoryService) throws LdapException {
        TransportBean[] transports;
        if (httpServerBean == null || httpServerBean.isDisabled()) {
            return null;
        }
        HttpServer httpServer = new HttpServer();
        httpServer.setConfFile(httpServerBean.getHttpConfFile());
        for (TransportBean transportBean : transports = httpServerBean.getTransports()) {
            if (transportBean.isDisabled() || !(transportBean instanceof TcpTransportBean)) continue;
            TcpTransport transport = new TcpTransport(transportBean.getSystemPort());
            transport.setAddress(transportBean.getTransportAddress());
            if (transportBean.getTransportId().equalsIgnoreCase("http")) {
                httpServer.setHttpTransport(transport);
                continue;
            }
            if (transportBean.getTransportId().equalsIgnoreCase("https")) {
                httpServer.setHttpsTransport(transport);
                continue;
            }
            LOG.warn("Transport ids of HttpServer should be either 'http' or 'https'");
        }
        httpServer.setWebApps(ServiceBuilder.createHttpWebApps(httpServerBean.getHttpWebApps(), directoryService));
        return httpServer;
    }

    public static LdapServer createLdapServer(LdapServerBean ldapServerBean, DirectoryService directoryService) throws LdapException {
        String message;
        if (ldapServerBean == null || ldapServerBean.isDisabled()) {
            return null;
        }
        LdapServer ldapServer = new LdapServer();
        ldapServer.setDirectoryService(directoryService);
        ldapServer.setEnabled(true);
        ldapServer.setServiceId(ldapServerBean.getServerId());
        ldapServer.setSearchBaseDn(ldapServerBean.getSearchBaseDn().getName());
        ldapServer.setKeystoreFile(ldapServerBean.getLdapServerKeystoreFile());
        ldapServer.setCertificatePassword(ldapServerBean.getLdapServerCertificatePassword());
        ldapServer.setConfidentialityRequired(ldapServerBean.isLdapServerConfidentialityRequired());
        ldapServer.setMaxSizeLimit((long)ldapServerBean.getLdapServerMaxSizeLimit());
        ldapServer.setMaxTimeLimit(ldapServerBean.getLdapServerMaxTimeLimit());
        ldapServer.setMaxPDUSize(ldapServerBean.getMaxPDUSize());
        ldapServer.setSaslHost(ldapServerBean.getLdapServerSaslHost());
        ldapServer.setSaslPrincipal(ldapServerBean.getLdapServerSaslPrincipal());
        ldapServer.setSaslRealms(ldapServerBean.getLdapServerSaslRealms());
        Transport[] transports = ServiceBuilder.createTransports(ldapServerBean.getTransports());
        ldapServer.setTransports(transports);
        for (SaslMechHandlerBean saslMechHandlerBean : ldapServerBean.getSaslMechHandlers()) {
            if (!saslMechHandlerBean.isEnabled()) continue;
            String mechanism = saslMechHandlerBean.getSaslMechName();
            ldapServer.addSaslMechanismHandler(mechanism, ServiceBuilder.createSaslMechHandler(saslMechHandlerBean));
        }
        for (ExtendedOpHandlerBean extendedpHandlerBean : ldapServerBean.getExtendedOps()) {
            if (!extendedpHandlerBean.isEnabled()) continue;
            try {
                Class<?> extendedOpClass = Class.forName(extendedpHandlerBean.getExtendedOpHandlerClass());
                ExtendedOperationHandler extOpHandler = (ExtendedOperationHandler)extendedOpClass.newInstance();
                ldapServer.addExtendedOperationHandler(extOpHandler);
            }
            catch (Exception e) {
                message = "Failed to load and instantiate ExtendedOperationHandler implementation " + extendedpHandlerBean.getExtendedOpId() + ": " + e.getMessage();
                LOG.error(message);
                throw new ConfigurationException(message);
            }
        }
        boolean replicationEnabled = ldapServerBean.isReplEnabled();
        if (replicationEnabled) {
            String fqcn = ldapServerBean.getReplReqHandler();
            if (fqcn != null) {
                try {
                    Class<?> replProvImplClz = Class.forName(fqcn);
                    ReplicationRequestHandler rp = (ReplicationRequestHandler)replProvImplClz.newInstance();
                    ldapServer.setReplicationReqHandler(rp);
                }
                catch (Exception e) {
                    message = "Failed to load and instantiate ReplicationRequestHandler implementation : " + fqcn;
                    LOG.error(message);
                    throw new ConfigurationException(message);
                }
            } else {
                SyncReplRequestHandler rp = new SyncReplRequestHandler();
                ldapServer.setReplicationReqHandler((ReplicationRequestHandler)rp);
            }
        }
        ldapServer.setReplConsumers(ServiceBuilder.createReplConsumers(ldapServerBean.getReplConsumers()));
        return ldapServer;
    }

    public static List<ReplicationConsumer> createReplConsumers(List<ReplConsumerBean> replConsumerBeans) throws ConfigurationException {
        ArrayList<ReplicationConsumer> lst = new ArrayList<ReplicationConsumer>();
        if (replConsumerBeans == null) {
            return lst;
        }
        for (ReplConsumerBean replBean : replConsumerBeans) {
            String className = replBean.getReplConsumerImpl();
            ReplicationConsumerImpl consumer = null;
            Class<?> consumerClass = null;
            SyncReplConfiguration config = null;
            try {
                if (className == null) {
                    consumer = new ReplicationConsumerImpl();
                } else {
                    consumerClass = Class.forName(className);
                    consumer = (ReplicationConsumer)consumerClass.newInstance();
                }
                config = new SyncReplConfiguration();
                config.setBaseDn(replBean.getSearchBaseDn());
                config.setRemoteHost(replBean.getReplProvHostName());
                config.setRemotePort(replBean.getReplProvPort());
                try {
                    config.setAliasDerefMode(AliasDerefMode.getDerefMode((String)replBean.getReplAliasDerefMode()));
                }
                catch (IllegalArgumentException iae) {
                    LOG.error(iae.getMessage() + ", defaulted to 'never'");
                }
                config.setAttributes(replBean.getReplAttributes().toArray(new String[0]));
                config.setRefreshInterval(replBean.getReplRefreshInterval());
                config.setRefreshNPersist(replBean.isReplRefreshNPersist());
                int scope = SearchScope.getSearchScope((String)replBean.getReplSearchScope());
                config.setSearchScope(SearchScope.getSearchScope((int)scope));
                config.setFilter(replBean.getReplSearchFilter());
                config.setSearchTimeout(replBean.getReplSearchTimeout());
                config.setReplUserDn(replBean.getReplUserDn());
                config.setReplUserPassword(replBean.getReplUserPassword());
                config.setUseTls(replBean.isReplUseTls());
                config.setStrictCertVerification(replBean.isReplStrictCertValidation());
                config.setConfigEntryDn(replBean.getDn());
                if (replBean.getReplPeerCertificate() != null) {
                    ReplicationTrustManager.addCertificate((String)replBean.getReplConsumerId(), (byte[])replBean.getReplPeerCertificate());
                }
                consumer.setConfig((ReplicationConsumerConfig)config);
                lst.add((ReplicationConsumer)consumer);
            }
            catch (Exception e) {
                throw new ConfigurationException("cannot configure the replication consumer with FQCN " + className, (Throwable)e);
            }
        }
        return lst;
    }

    public static JdbmIndex<?, ?> createJdbmIndex(JdbmPartition partition, JdbmIndexBean<String, Entry> jdbmIndexBean, DirectoryService directoryService) {
        if (jdbmIndexBean == null || jdbmIndexBean.isDisabled()) {
            return null;
        }
        String indexFileName = jdbmIndexBean.getIndexFileName();
        if (indexFileName == null) {
            indexFileName = jdbmIndexBean.getIndexAttributeId();
        }
        Object index = null;
        boolean hasReverse = jdbmIndexBean.getIndexHasReverse();
        index = jdbmIndexBean.getIndexAttributeId().equalsIgnoreCase("apacheRdn") || jdbmIndexBean.getIndexAttributeId().equalsIgnoreCase("1.3.6.1.4.1.18060.0.4.1.2.50") ? new JdbmRdnIndex() : new JdbmIndex(jdbmIndexBean.getIndexAttributeId(), hasReverse);
        index.setCacheSize(jdbmIndexBean.getIndexCacheSize());
        index.setNumDupLimit(jdbmIndexBean.getIndexNumDupLimit());
        SchemaManager schemaManager = directoryService.getSchemaManager();
        try {
            AttributeType indexAT = schemaManager.lookupAttributeTypeRegistry(indexFileName);
            indexFileName = indexAT.getOid();
        }
        catch (LdapException le) {
            // empty catch block
        }
        if (jdbmIndexBean.getIndexWorkingDir() != null) {
            index.setWkDirPath(new File(jdbmIndexBean.getIndexWorkingDir()).toURI());
        } else {
            index.setWkDirPath(partition.getPartitionPath());
        }
        return index;
    }

    private static Set<Index<?, ?, String>> createJdbmIndexes(JdbmPartition partition, List<IndexBean> indexesBeans, DirectoryService directoryService) {
        HashSet indexes = new HashSet();
        for (IndexBean indexBean : indexesBeans) {
            if (!indexBean.isEnabled() || !(indexBean instanceof JdbmIndexBean)) continue;
            indexes.add((Index<?, ?, String>)ServiceBuilder.createJdbmIndex(partition, (JdbmIndexBean<String, Entry>)((JdbmIndexBean)indexBean), directoryService));
        }
        return indexes;
    }

    public static JdbmPartition createJdbmPartition(DirectoryService directoryService, JdbmPartitionBean jdbmPartitionBean) throws ConfigurationException {
        if (jdbmPartitionBean == null || jdbmPartitionBean.isDisabled()) {
            return null;
        }
        JdbmPartition jdbmPartition = new JdbmPartition(directoryService.getSchemaManager());
        jdbmPartition.setCacheSize(jdbmPartitionBean.getPartitionCacheSize());
        jdbmPartition.setId(jdbmPartitionBean.getPartitionId());
        jdbmPartition.setOptimizerEnabled(jdbmPartitionBean.isJdbmPartitionOptimizerEnabled());
        File partitionPath = new File(directoryService.getInstanceLayout().getPartitionsDirectory(), jdbmPartitionBean.getPartitionId());
        jdbmPartition.setPartitionPath(partitionPath.toURI());
        try {
            jdbmPartition.setSuffixDn(jdbmPartitionBean.getPartitionSuffix());
        }
        catch (LdapInvalidDnException lide) {
            String message = "Cannot set the Dn " + jdbmPartitionBean.getPartitionSuffix() + ", " + lide.getMessage();
            LOG.error(message);
            throw new ConfigurationException(message);
        }
        jdbmPartition.setSyncOnWrite(jdbmPartitionBean.isPartitionSyncOnWrite());
        jdbmPartition.setIndexedAttributes(ServiceBuilder.createJdbmIndexes(jdbmPartition, jdbmPartitionBean.getIndexes(), directoryService));
        String contextEntry = jdbmPartitionBean.getContextEntry();
        if (contextEntry != null) {
            try {
                String entryStr = contextEntry.replaceAll("\\\\n", "\n");
                LdifReader ldifReader = new LdifReader();
                List entries = ldifReader.parseLdif(entryStr);
                if (entries != null && entries.size() > 0) {
                    LdifEntry entry = (LdifEntry)entries.get(0);
                    jdbmPartition.setContextEntry(entry.getEntry());
                }
                try {
                    ldifReader.close();
                }
                catch (IOException ioe) {
                    LOG.error("Cannot close the ldif reader");
                }
            }
            catch (LdapLdifException lle) {
                String message = "Cannot parse the context entry : " + contextEntry + ", " + lle.getMessage();
                LOG.error(message);
                throw new ConfigurationException(message);
            }
        }
        return jdbmPartition;
    }

    public static Partition createPartition(DirectoryService directoryService, PartitionBean partitionBean) throws ConfigurationException {
        if (partitionBean == null || partitionBean.isDisabled()) {
            return null;
        }
        if (partitionBean instanceof JdbmPartitionBean) {
            return ServiceBuilder.createJdbmPartition(directoryService, (JdbmPartitionBean)partitionBean);
        }
        return null;
    }

    public static Map<String, Partition> createPartitions(DirectoryService directoryService, List<PartitionBean> partitionBeans) throws ConfigurationException {
        HashMap<String, Partition> partitions = new HashMap<String, Partition>(partitionBeans.size());
        for (PartitionBean partitionBean : partitionBeans) {
            Partition partition;
            if (partitionBean.isDisabled() || (partition = ServiceBuilder.createPartition(directoryService, partitionBean)) == null) continue;
            partitions.put(partitionBean.getPartitionId(), partition);
        }
        return partitions;
    }

    public static DirectoryService createDirectoryService(DirectoryServiceBean directoryServiceBean, InstanceLayout instanceLayout, SchemaManager schemaManager) throws Exception {
        DefaultDirectoryService directoryService = new DefaultDirectoryService();
        directoryService.setSchemaManager(schemaManager);
        directoryService.setInstanceId(directoryServiceBean.getDirectoryServiceId());
        directoryService.setReplicaId(directoryServiceBean.getDsReplicaId());
        directoryService.setInstanceLayout(instanceLayout);
        List<Interceptor> interceptors = ServiceBuilder.createInterceptors(directoryServiceBean.getInterceptors());
        directoryService.setInterceptors(interceptors);
        Map<String, Partition> partitions = ServiceBuilder.createPartitions((DirectoryService)directoryService, directoryServiceBean.getPartitions());
        Partition systemPartition = partitions.remove("system");
        if (systemPartition == null) {
            // empty if block
        }
        directoryService.setSystemPartition(systemPartition);
        directoryService.setPartitions(new HashSet<Partition>(partitions.values()));
        directoryService.setAccessControlEnabled(directoryServiceBean.isDsAccessControlEnabled());
        directoryService.setAllowAnonymousAccess(directoryServiceBean.isDsAllowAnonymousAccess());
        ChangeLog cl = ServiceBuilder.createChangeLog(directoryServiceBean.getChangeLog());
        if (cl != null) {
            directoryService.setChangeLog(cl);
        }
        directoryService.setDenormalizeOpAttrsEnabled(directoryServiceBean.isDsDenormalizeOpAttrsEnabled());
        Journal journal = ServiceBuilder.createJournal(directoryServiceBean.getJournal());
        if (journal != null) {
            directoryService.setJournal(journal);
        }
        directoryService.setPasswordHidden(directoryServiceBean.isDsPasswordHidden());
        directoryService.setSyncPeriodMillis(directoryServiceBean.getDsSyncPeriodMillis());
        String entryFilePath = directoryServiceBean.getDsTestEntries();
        if (entryFilePath != null) {
            directoryService.setTestEntries(ServiceBuilder.readTestEntries(entryFilePath));
        }
        if (!directoryServiceBean.isEnabled()) {
            // empty if block
        }
        return directoryService;
    }
}

