/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.configuration;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.registries.SchemaLoader;
import org.apache.directory.api.ldap.schemaextractor.impl.DefaultSchemaLdifExtractor;
import org.apache.directory.api.ldap.schemaloader.LdifSchemaLoader;
import org.apache.directory.api.ldap.schemamanager.impl.DefaultSchemaManager;
import org.apache.directory.api.util.Strings;
import org.apache.directory.api.util.exception.Exceptions;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.schema.SchemaPartition;
import org.apache.directory.server.core.partition.impl.btree.AbstractBTreePartition;
import org.apache.directory.server.core.partition.ldif.LdifPartition;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.protocol.shared.store.LdifFileLoader;
import org.apache.directory.server.protocol.shared.store.LdifLoadFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheDS {
    private static final Logger LOG = LoggerFactory.getLogger((String)ApacheDS.class.getName());
    private static final long DEFAULT_SYNC_PERIOD_MILLIS = 20000L;
    private long synchPeriodMillis = 20000L;
    private File ldifDirectory;
    private final List<LdifLoadFilter> ldifFilters = new ArrayList<LdifLoadFilter>();
    private final LdapServer ldapServer;
    private DirectoryService directoryService;

    public ApacheDS(LdapServer ldapServer) throws Exception {
        LOG.info("Starting the Apache Directory Server");
        this.ldapServer = ldapServer;
        this.directoryService = ldapServer.getDirectoryService();
        if (this.directoryService == null) {
            this.directoryService = new DefaultDirectoryService();
        }
    }

    public void startup() throws Exception {
        LOG.debug("Starting the server");
        this.initSchema();
        SchemaManager schemaManager = this.directoryService.getSchemaManager();
        if (!this.directoryService.isStarted()) {
            Set partitions = this.directoryService.getPartitions();
            for (Partition p : partitions) {
                if (p instanceof AbstractBTreePartition) {
                    File partitionPath = new File(this.directoryService.getInstanceLayout().getPartitionsDirectory(), p.getId());
                    ((AbstractBTreePartition)p).setPartitionPath(partitionPath.toURI());
                }
                if (p.getSchemaManager() != null) continue;
                LOG.info("setting the schema manager for partition {}", (Object)p.getSuffixDn());
                p.setSchemaManager(schemaManager);
            }
            Partition sysPartition = this.directoryService.getSystemPartition();
            if (sysPartition instanceof AbstractBTreePartition) {
                File partitionPath = new File(this.directoryService.getInstanceLayout().getPartitionsDirectory(), sysPartition.getId());
                ((AbstractBTreePartition)sysPartition).setPartitionPath(partitionPath.toURI());
            }
            if (sysPartition.getSchemaManager() == null) {
                LOG.info("setting the schema manager for partition {}", (Object)sysPartition.getSuffixDn());
                sysPartition.setSchemaManager(schemaManager);
            }
            LOG.debug("1. Starting the DirectoryService");
            this.directoryService.startup();
        }
        this.loadLdifs();
        if (this.ldapServer != null && !this.ldapServer.isStarted()) {
            LOG.debug("3. Starting the LDAP server");
            this.ldapServer.start();
        }
        LOG.debug("Server successfully started");
    }

    public boolean isStarted() {
        if (this.ldapServer != null) {
            return this.ldapServer.isStarted();
        }
        return this.directoryService.isStarted();
    }

    public void shutdown() throws Exception {
        if (this.ldapServer != null && this.ldapServer.isStarted()) {
            this.ldapServer.stop();
        }
        this.directoryService.shutdown();
    }

    public LdapServer getLdapServer() {
        return this.ldapServer;
    }

    public DirectoryService getDirectoryService() {
        return this.directoryService;
    }

    public long getSynchPeriodMillis() {
        return this.synchPeriodMillis;
    }

    public void setSynchPeriodMillis(long synchPeriodMillis) {
        LOG.info("Set the synchPeriodMillis to {}", (Object)synchPeriodMillis);
        this.synchPeriodMillis = synchPeriodMillis;
    }

    public File getLdifDirectory() {
        return this.ldifDirectory;
    }

    public void setLdifDirectory(File ldifDirectory) {
        LOG.info("The LDIF directory file is {}", (Object)ldifDirectory.getAbsolutePath());
        this.ldifDirectory = ldifDirectory;
    }

    private void ensureLdifFileBase() throws Exception {
        Dn dn = new Dn(new String[]{"ou=loadedLdifFiles,ou=configuration,ou=system"});
        Entry entry = null;
        try {
            entry = this.directoryService.getAdminSession().lookup(dn, new String[0]);
        }
        catch (Exception e) {
            LOG.info("Failure while looking up {}. The entry will be created now.", (Object)"ou=loadedLdifFiles,ou=configuration,ou=system", (Object)e);
        }
        if (entry == null) {
            entry = this.directoryService.newEntry(new Dn(new String[]{"ou=loadedLdifFiles,ou=configuration,ou=system"}));
            entry.add("ou", new String[]{"loadedLdifFiles"});
            entry.add("objectClass", new String[]{"top", "organizationalUnit"});
            this.directoryService.getAdminSession().add(entry);
        }
    }

    private Dn buildProtectedFileEntryDn(File ldif) throws Exception {
        String fileSep = File.separatorChar == '\\' ? "windowsFilePath" : "unixFilePath";
        return new Dn(new String[]{fileSep + "=" + Strings.dumpHexPairs((byte[])Strings.getBytesUtf8((String)this.getCanonical(ldif))) + "," + "ou=loadedLdifFiles,ou=configuration,ou=system"});
    }

    private void addFileEntry(File ldif) throws Exception {
        String rdnAttr = File.separatorChar == '\\' ? "windowsFilePath" : "unixFilePath";
        String oc = File.separatorChar == '\\' ? "windowsFile" : "unixFile";
        Entry entry = this.directoryService.newEntry(this.buildProtectedFileEntryDn(ldif));
        entry.add(rdnAttr, new String[]{this.getCanonical(ldif)});
        entry.add("objectClass", new String[]{"top", oc});
        this.directoryService.getAdminSession().add(entry);
    }

    private String getCanonical(File file) {
        String canonical;
        try {
            canonical = file.getCanonicalPath();
        }
        catch (IOException e) {
            LOG.error(I18n.err((I18n)I18n.ERR_179, (Object[])new Object[0]), (Throwable)e);
            return null;
        }
        return StringUtils.replace((String)canonical, (String)"\\", (String)"\\\\");
    }

    private void loadLdif(File ldifFile) throws Exception {
        Entry fileEntry = null;
        try {
            fileEntry = this.directoryService.getAdminSession().lookup(this.buildProtectedFileEntryDn(ldifFile), new String[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (fileEntry != null) {
            String time = ((ClonedServerEntry)fileEntry).getOriginalEntry().get("createTimestamp").getString();
            LOG.info("Load of LDIF file '" + this.getCanonical(ldifFile) + "' skipped.  It has already been loaded on " + time + ".");
        } else {
            LdifFileLoader loader = new LdifFileLoader(this.directoryService.getAdminSession(), ldifFile, this.ldifFilters);
            int count = loader.execute();
            LOG.info("Loaded " + count + " entries from LDIF file '" + this.getCanonical(ldifFile) + "'");
            this.addFileEntry(ldifFile);
        }
    }

    public void loadLdifs() throws Exception {
        if (this.ldifDirectory == null) {
            LOG.info("LDIF load directory not specified.  No LDIF files will be loaded.");
            return;
        }
        if (!this.ldifDirectory.exists()) {
            LOG.warn("LDIF load directory '{}' does not exist.  No LDIF files will be loaded.", (Object)this.getCanonical(this.ldifDirectory));
            return;
        }
        this.ensureLdifFileBase();
        if (this.ldifDirectory.isFile()) {
            if (LOG.isInfoEnabled()) {
                LOG.info("LDIF load directory '{}' is a file. Will attempt to load as LDIF.", (Object)this.getCanonical(this.ldifDirectory));
            }
            try {
                this.loadLdif(this.ldifDirectory);
            }
            catch (Exception ne) {
                LOG.error(I18n.err((I18n)I18n.ERR_180, (Object[])new Object[]{this.ldifDirectory.getAbsolutePath(), ne.getLocalizedMessage()}));
                throw ne;
            }
        } else {
            File[] ldifFiles = this.ldifDirectory.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    boolean isLdif = Strings.toLowerCase((String)pathname.getName()).endsWith(".ldif");
                    return pathname.isFile() && pathname.canRead() && isLdif;
                }
            });
            if (ldifFiles == null || ldifFiles.length == 0) {
                LOG.warn("LDIF load directory '{}' does not contain any LDIF files. No LDIF files will be loaded.", (Object)this.getCanonical(this.ldifDirectory));
                return;
            }
            Arrays.sort(ldifFiles, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    return f1.getName().compareTo(f2.getName());
                }
            });
            for (File ldifFile : ldifFiles) {
                try {
                    LOG.info("Loading LDIF file '{}'", (Object)ldifFile.getName());
                    this.loadLdif(ldifFile);
                }
                catch (Exception ne) {
                    LOG.error(I18n.err((I18n)I18n.ERR_180, (Object[])new Object[]{ldifFile.getAbsolutePath(), ne.getLocalizedMessage()}));
                    throw ne;
                }
            }
        }
    }

    private void initSchema() throws Exception {
        SchemaPartition schemaPartition = this.directoryService.getSchemaPartition();
        String workingDirectory = this.directoryService.getInstanceLayout().getPartitionsDirectory().getPath();
        File schemaRepository = new File(workingDirectory, "schema");
        if (schemaRepository.exists()) {
            LOG.info("schema partition already exists, skipping schema extraction");
        } else {
            DefaultSchemaLdifExtractor extractor = new DefaultSchemaLdifExtractor(new File(workingDirectory));
            extractor.extractOrCopy();
        }
        LdifSchemaLoader loader = new LdifSchemaLoader(schemaRepository);
        DefaultSchemaManager schemaManager = new DefaultSchemaManager((SchemaLoader)loader);
        this.directoryService.setSchemaManager((SchemaManager)schemaManager);
        LdifPartition ldifPartition = new LdifPartition((SchemaManager)schemaManager);
        ldifPartition.setPartitionPath(new File(workingDirectory, "schema").toURI());
        schemaPartition.setWrappedPartition((Partition)ldifPartition);
        schemaManager.loadAllEnabled();
        schemaPartition.setSchemaManager((SchemaManager)schemaManager);
        List errors = schemaManager.getErrors();
        if (errors.size() != 0) {
            throw new Exception(I18n.err((I18n)I18n.ERR_317, (Object[])new Object[]{Exceptions.printErrors((List)errors)}));
        }
    }
}

