/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.integ.state;

import java.io.File;
import java.io.IOException;
import org.apache.directory.server.core.integ.IntegrationUtils;
import org.apache.directory.server.integ.InheritableServerSettings;
import org.apache.directory.server.integ.state.AbstractState;
import org.apache.directory.server.integ.state.TestServerContext;
import org.apache.directory.server.ldap.LdapService;
import org.junit.internal.runners.TestClass;
import org.junit.internal.runners.TestMethod;
import org.junit.runner.notification.RunNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartedPristineState
extends AbstractState {
    private static final Logger LOG = LoggerFactory.getLogger(StartedPristineState.class);

    public StartedPristineState(TestServerContext context) {
        super(context);
    }

    public void cleanup() throws IOException {
        LOG.debug("calling cleanup()");
        IntegrationUtils.doDelete((File)this.context.getLdapServer().getDirectoryService().getWorkingDirectory());
    }

    public void startup() throws Exception {
        LOG.debug("calling start()");
        LdapService server = this.context.getLdapServer();
        server.getDirectoryService().startup();
        server.start();
    }

    public void shutdown() throws Exception {
        LOG.debug("calling stop()");
        LdapService server = this.context.getLdapServer();
        server.stop();
        server.getDirectoryService().shutdown();
    }

    public void destroy() {
        LOG.debug("calling destroy()");
        this.context.getLdapServer().setDirectoryService(null);
        this.context.setLdapServer(null);
        this.context.setState(this.context.getNonExistentState());
        System.gc();
    }

    public void test(TestClass testClass, TestMethod testMethod, RunNotifier notifier, InheritableServerSettings settings) {
        LOG.debug("calling test(): {}, mode {}", (Object)settings.getDescription().getDisplayName(), (Object)settings.getMode());
        if (testMethod.isIgnored()) {
            return;
        }
        switch (settings.getMode()) {
            case PRISTINE: {
                try {
                    this.injectLdifs(this.context.getLdapServer().getDirectoryService(), settings);
                }
                catch (Exception e) {
                    notifier.testAborted(settings.getDescription(), (Throwable)e);
                    return;
                }
                TestServerContext.invokeTest(testClass, testMethod, notifier, settings.getDescription());
                try {
                    this.shutdown();
                }
                catch (Exception e) {
                    notifier.testAborted(settings.getDescription(), (Throwable)e);
                    return;
                }
                try {
                    this.cleanup();
                }
                catch (IOException ioe) {
                    LOG.error("Failed to cleanup new server instance: " + ioe);
                    notifier.testAborted(settings.getDescription(), (Throwable)ioe);
                    return;
                }
                this.destroy();
                this.context.setState(this.context.getNonExistentState());
                return;
            }
            case ROLLBACK: {
                try {
                    this.context.getLdapServer().getDirectoryService().getChangeLog().tag();
                    this.injectLdifs(this.context.getLdapServer().getDirectoryService(), settings);
                }
                catch (Exception e) {
                    notifier.testAborted(settings.getDescription(), (Throwable)e);
                    return;
                }
                TestServerContext.invokeTest(testClass, testMethod, notifier, settings.getDescription());
                this.context.setState(this.context.getStartedNormalState());
                try {
                    this.context.getState().revert();
                }
                catch (Exception e) {
                    notifier.testAborted(settings.getDescription(), (Throwable)e);
                    return;
                }
                return;
            }
        }
    }
}

