/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.integ.state;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.DefaultServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.integ.InheritableServerSettings;
import org.apache.directory.server.integ.state.TestServerContext;
import org.apache.directory.server.integ.state.TestServerState;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.junit.internal.runners.TestClass;
import org.junit.internal.runners.TestMethod;
import org.junit.runner.notification.RunNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractState
implements TestServerState {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractState.class);
    protected final TestServerContext context;
    private static final String DESTROY_ERR = "Cannot destroy when service is in NonExistant state";
    private static final String CLEANUP_ERROR = "Cannot cleanup when service is in NonExistant state";
    private static final String STARTUP_ERR = "Cannot startup when service is in NonExistant state";
    private static final String SHUTDOWN_ERR = "Cannot shutdown service in NonExistant state.";
    private static final String REVERT_ERROR = "Cannot revert when service is in NonExistant state";

    protected AbstractState(TestServerContext context) {
        this.context = context;
    }

    public void create(InheritableServerSettings settings) throws NamingException {
    }

    public void destroy() {
        LOG.error(DESTROY_ERR);
        throw new IllegalStateException(DESTROY_ERR);
    }

    public void cleanup() throws IOException {
        LOG.error(CLEANUP_ERROR);
        throw new IllegalStateException(CLEANUP_ERROR);
    }

    public void startup() throws Exception {
        LOG.error(STARTUP_ERR);
        throw new IllegalStateException(STARTUP_ERR);
    }

    public void shutdown() throws Exception {
        LOG.error(SHUTDOWN_ERR);
        throw new IllegalStateException(SHUTDOWN_ERR);
    }

    public void test(TestClass testClass, TestMethod testMethod, RunNotifier notifier, InheritableServerSettings settings) {
    }

    public void revert() throws Exception {
        LOG.error(REVERT_ERROR);
        throw new IllegalStateException(REVERT_ERROR);
    }

    protected void injectLdifs(DirectoryService service, InheritableServerSettings settings) throws Exception {
        List<String> ldifs = new ArrayList<String>();
        if ((ldifs = settings.getLdifs(ldifs)).size() != 0) {
            for (String ldif : ldifs) {
                StringReader in = new StringReader(ldif);
                LdifReader ldifReader = new LdifReader((Reader)in);
                for (LdifEntry entry : ldifReader) {
                    service.getAdminSession().add((ServerEntry)new DefaultServerEntry(service.getRegistries(), entry.getEntry()));
                    LOG.debug("Successfully injected LDIF enry for test {}: {}", (Object)settings.getDescription(), (Object)entry);
                }
            }
        }
    }
}

