/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.config.beans;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.server.config.ConfigurationElement;
import org.apache.directory.server.config.beans.DSBasedServerBean;
import org.apache.directory.server.config.beans.ExtendedOpHandlerBean;
import org.apache.directory.server.config.beans.ReplConsumerBean;
import org.apache.directory.server.config.beans.SaslMechHandlerBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapServerBean
extends DSBasedServerBean {
    @ConfigurationElement(attributeType="ads-confidentialityRequired")
    private boolean confidentialityRequired;
    @ConfigurationElement(attributeType="ads-maxSizeLimit")
    private int maxSizeLimit;
    @ConfigurationElement(attributeType="ads-maxTimeLimit")
    private int maxTimeLimit;
    @ConfigurationElement(attributeType="ads-saslHost")
    private String saslHost;
    @ConfigurationElement(attributeType="ads-saslPrincipal")
    private String saslPrincipal;
    @ConfigurationElement(attributeType="ads-saslRealms")
    private List<String> saslRealms = new ArrayList<String>();
    @ConfigurationElement(attributeType="ads-keystoreFile")
    private String keystoreFile;
    @ConfigurationElement(attributeType="ads-certificatePassword")
    private String certificatePassword;
    @ConfigurationElement(attributeType="ads-replReqHandler")
    private String replReqHandler;
    @ConfigurationElement(attributeType="ads-replConsumers", container="replConsumers")
    private List<ReplConsumerBean> replConsumers = new ArrayList<ReplConsumerBean>();
    @ConfigurationElement(attributeType="ads-saslMechHandlers", container="saslMechHandlers")
    private List<SaslMechHandlerBean> saslMechHandlers = new ArrayList<SaslMechHandlerBean>();
    @ConfigurationElement(attributeType="ads-extendedOpHandlers", container="extendedOpHandlers")
    private List<ExtendedOpHandlerBean> extendedOpHandlers = new ArrayList<ExtendedOpHandlerBean>();

    public LdapServerBean() {
        this.setEnabled(true);
    }

    public boolean isLdapServerConfidentialityRequired() {
        return this.confidentialityRequired;
    }

    public void setLdapServerConfidentialityRequired(boolean ldapServerConfidentialityRequired) {
        this.confidentialityRequired = ldapServerConfidentialityRequired;
    }

    public int getLdapServerMaxSizeLimit() {
        return this.maxSizeLimit;
    }

    public void setLdapServerMaxSizeLimit(int ldapServerMaxSizeLimit) {
        this.maxSizeLimit = ldapServerMaxSizeLimit;
    }

    public int getLdapServerMaxTimeLimit() {
        return this.maxTimeLimit;
    }

    public void setLdapServerMaxTimeLimit(int ldapServerMaxTimeLimit) {
        this.maxTimeLimit = ldapServerMaxTimeLimit;
    }

    public String getLdapServerSaslHost() {
        return this.saslHost;
    }

    public void setLdapServerSaslHost(String ldapServerSaslHost) {
        this.saslHost = ldapServerSaslHost;
    }

    public String getLdapServerSaslPrincipal() {
        return this.saslPrincipal;
    }

    public void setLdapServerSaslPrincipal(String ldapServerSaslPrincipal) {
        this.saslPrincipal = ldapServerSaslPrincipal;
    }

    public List<String> getLdapServerSaslRealms() {
        return this.saslRealms;
    }

    public void setLdapServerSaslRealms(List<String> ldapServerSaslRealms) {
        this.saslRealms = ldapServerSaslRealms;
    }

    public void addSaslRealms(String ... ldapServerSaslRealms) {
        for (String saslRealm : ldapServerSaslRealms) {
            this.saslRealms.add(saslRealm);
        }
    }

    public String getLdapServerKeystoreFile() {
        return this.keystoreFile;
    }

    public void setLdapServerKeystoreFile(String ldapServerKeystoreFile) {
        this.keystoreFile = ldapServerKeystoreFile;
    }

    public String getLdapServerCertificatePassword() {
        return this.certificatePassword;
    }

    public void setLdapServerCertificatePassword(String ldapServerCertificatePassword) {
        this.certificatePassword = ldapServerCertificatePassword;
    }

    public String getReplReqHandler() {
        return this.replReqHandler;
    }

    public void setReplReqHandler(String replReqHandler) {
        this.replReqHandler = replReqHandler;
    }

    public List<SaslMechHandlerBean> getSaslMechHandlers() {
        return this.saslMechHandlers;
    }

    public void setSaslMechHandlers(List<SaslMechHandlerBean> saslMechHandlers) {
        this.saslMechHandlers = saslMechHandlers;
    }

    public void setSaslMechHandlers(SaslMechHandlerBean ... saslMechHandlers) {
        for (SaslMechHandlerBean saslMechHandler : saslMechHandlers) {
            this.saslMechHandlers.add(saslMechHandler);
        }
    }

    public List<ExtendedOpHandlerBean> getExtendedOps() {
        return this.extendedOpHandlers;
    }

    public void setExtendedOps(List<ExtendedOpHandlerBean> extendedOps) {
        this.extendedOpHandlers = extendedOps;
    }

    public void addExtendedOps(ExtendedOpHandlerBean ... extendedOps) {
        for (ExtendedOpHandlerBean extendedOp : extendedOps) {
            this.extendedOpHandlers.add(extendedOp);
        }
    }

    public List<ReplConsumerBean> getReplConsumers() {
        return this.replConsumers;
    }

    public void setReplConsumer(List<ReplConsumerBean> replConsumers) {
        this.replConsumers = replConsumers;
    }

    public void addReplConsumers(ReplConsumerBean ... replConsumers) {
        for (ReplConsumerBean bean : replConsumers) {
            this.replConsumers.add(bean);
        }
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("LdapServer :\n");
        sb.append(super.toString(tabs + "  "));
        sb.append(tabs).append("  max size limit : ").append(this.maxSizeLimit).append('\n');
        sb.append(tabs).append("  max time limit : ").append(this.maxTimeLimit).append('\n');
        sb.append(this.toString(tabs, "  certificate password", this.certificatePassword));
        sb.append(this.toString(tabs, "  keystore file", this.keystoreFile));
        sb.append(this.toString(tabs, "  sasl principal", this.saslPrincipal));
        sb.append(tabs).append("  sasl host : ").append(this.saslHost).append('\n');
        sb.append(this.toString(tabs, "  confidentiality required", this.confidentialityRequired));
        sb.append(this.toString(tabs, "  enable replication provider", this.replReqHandler));
        if (this.extendedOpHandlers != null && this.extendedOpHandlers.size() > 0) {
            sb.append(tabs).append("  extended operation handlers :\n");
            for (ExtendedOpHandlerBean extendedOpHandler : this.extendedOpHandlers) {
                sb.append(extendedOpHandler.toString(tabs + "    "));
            }
        }
        if (this.saslMechHandlers != null) {
            sb.append(tabs).append("  SASL mechanism handlers :\n");
            for (SaslMechHandlerBean saslMechHandler : this.saslMechHandlers) {
                sb.append(saslMechHandler.toString(tabs + "    "));
            }
        }
        if (this.saslRealms != null && this.saslRealms.size() > 0) {
            sb.append(tabs).append("  SASL realms :\n");
            for (String saslRealm : this.saslRealms) {
                sb.append(tabs).append("    ").append(saslRealm).append("\n");
            }
        }
        if (this.replConsumers != null && this.replConsumers.size() > 0) {
            sb.append(tabs).append("  replication consumers :\n");
            for (ReplConsumerBean replConsumer : this.replConsumers) {
                sb.append(replConsumer.toString(tabs + "    "));
            }
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toString("");
    }
}

