/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.config.beans;

import java.util.ArrayList;
import java.util.List;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.config.ConfigurationElement;
import org.apache.directory.server.config.beans.DSBasedServerBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KdcServerBean
extends DSBasedServerBean {
    private static final long DEFAULT_ALLOWABLE_CLOCKSKEW = 300000L;
    private static final boolean DEFAULT_EMPTY_ADDRESSES_ALLOWED = true;
    private static final boolean DEFAULT_TGS_FORWARDABLE_ALLOWED = true;
    private static final boolean DEFAULT_PA_ENC_TIMESTAMP_REQUIRED = true;
    private static final boolean DEFAULT_TGS_POSTDATED_ALLOWED = true;
    private static final boolean DEFAULT_TGS_PROXIABLE_ALLOWED = true;
    private static final boolean DEFAULT_TGS_RENEWABLE_ALLOWED = true;
    private static final int DEFAULT_TGS_MAXIMUM_RENEWABLE_LIFETIME = 604800000;
    private static final int DEFAULT_TGS_MAXIMUM_TICKET_LIFETIME = 86400000;
    private static final String DEFAULT_REALM = "EXAMPLE.COM";
    private static final boolean DEFAULT_VERIFY_BODY_CHECKSUM = true;
    private static final String DEFAULT_PRINCIPAL = "krbtgt/EXAMPLE.COM@EXAMPLE.COM";
    @ConfigurationElement(attributeType="ads-krbAllowableClockSkew")
    private long krbAllowableClockSkew = 300000L;
    @ConfigurationElement(attributeType="ads-krbEmptyAddressesAllowed")
    private boolean krbEmptyAddressesAllowed = true;
    @ConfigurationElement(attributeType="ads-krbForwardableAllowed")
    private boolean krbForwardableAllowed = true;
    @ConfigurationElement(attributeType="ads-krbPAEncTimestampRequired")
    private boolean krbPAEncTimestampRequired = true;
    @ConfigurationElement(attributeType="ads-krbPostdatedAllowed")
    private boolean krbPostdatedAllowed = true;
    @ConfigurationElement(attributeType="ads-krbProxiableAllowed")
    private boolean krbProxiableAllowed = true;
    @ConfigurationElement(attributeType="ads-krbRenewableAllowed")
    private boolean krbRenewableAllowed = true;
    @ConfigurationElement(attributeType="ads-krbMaximumRenewableLifetime")
    private long krbMaximumRenewableLifetime = 604800000L;
    @ConfigurationElement(attributeType="ads-krbMaximumTicketLifetime")
    private long krbMaximumTicketLifetime = 86400000L;
    @ConfigurationElement(attributeType="ads-krbPrimaryRealm")
    private String krbPrimaryRealm = "EXAMPLE.COM";
    @ConfigurationElement(attributeType="ads-krbBodyChecksumVerified")
    private boolean krbBodyChecksumVerified = true;
    @ConfigurationElement(attributeType="ads-krbEncryptionTypes")
    private List<String> krbEncryptionTypes = new ArrayList<String>();
    @ConfigurationElement(attributeType="ads-krbKdcPrincipal")
    private String krbKdcPrincipal = "krbtgt/EXAMPLE.COM@EXAMPLE.COM";

    public KdcServerBean() {
        this.setEnabled(true);
    }

    public long getKrbAllowableClockSkew() {
        return this.krbAllowableClockSkew;
    }

    public void setKrbAllowableClockSkew(long krbAllowableClockSkew) {
        this.krbAllowableClockSkew = krbAllowableClockSkew;
    }

    public List<String> getKrbEncryptionTypes() {
        return this.krbEncryptionTypes;
    }

    public void addKrbEncryptionTypes(String ... krbEncryptionTypes) {
        for (String encryptionType : krbEncryptionTypes) {
            this.krbEncryptionTypes.add(encryptionType);
        }
    }

    public boolean isKrbEmptyAddressesAllowed() {
        return this.krbEmptyAddressesAllowed;
    }

    public void setKrbEmptyAddressesAllowed(boolean krbEmptyAddressesAllowed) {
        this.krbEmptyAddressesAllowed = krbEmptyAddressesAllowed;
    }

    public boolean isKrbForwardableAllowed() {
        return this.krbForwardableAllowed;
    }

    public void setKrbForwardableAllowed(boolean krbForwardableAllowed) {
        this.krbForwardableAllowed = krbForwardableAllowed;
    }

    public boolean isKrbPaEncTimestampRequired() {
        return this.krbPAEncTimestampRequired;
    }

    public void setKrbPaEncTimestampRequired(boolean krbPaEncTimestampRequired) {
        this.krbPAEncTimestampRequired = krbPaEncTimestampRequired;
    }

    public boolean isKrbPostdatedAllowed() {
        return this.krbPostdatedAllowed;
    }

    public void setKrbPostdatedAllowed(boolean krbPostdatedAllowed) {
        this.krbPostdatedAllowed = krbPostdatedAllowed;
    }

    public boolean isKrbProxiableAllowed() {
        return this.krbProxiableAllowed;
    }

    public void setKrbProxiableAllowed(boolean krbProxiableAllowed) {
        this.krbProxiableAllowed = krbProxiableAllowed;
    }

    public boolean isKrbRenewableAllowed() {
        return this.krbRenewableAllowed;
    }

    public void setKrbRenewableAllowed(boolean krbRenewableAllowed) {
        this.krbRenewableAllowed = krbRenewableAllowed;
    }

    public long getKrbMaximumRenewableLifetime() {
        return this.krbMaximumRenewableLifetime;
    }

    public void setKrbMaximumRenewableLifetime(long krbMaximumRenewableLifetime) {
        this.krbMaximumRenewableLifetime = krbMaximumRenewableLifetime;
    }

    public long getKrbMaximumTicketLifetime() {
        return this.krbMaximumTicketLifetime;
    }

    public void setKrbMaximumTicketLifetime(long krbMaximumTicketLifetime) {
        this.krbMaximumTicketLifetime = krbMaximumTicketLifetime;
    }

    public String getKrbPrimaryRealm() {
        return this.krbPrimaryRealm;
    }

    public void setKrbPrimaryRealm(String krbPrimaryRealm) {
        this.krbPrimaryRealm = krbPrimaryRealm;
    }

    public boolean isKrbBodyChecksumVerified() {
        return this.krbBodyChecksumVerified;
    }

    public void setKrbBodyChecksumVerified(boolean krbBodyChecksumVerified) {
        this.krbBodyChecksumVerified = krbBodyChecksumVerified;
    }

    public KerberosPrincipal getKrbKdcPrincipal() {
        return new KerberosPrincipal(this.krbKdcPrincipal);
    }

    public void setKrbKdcPrincipal(String krbKdcPrincipal) {
        this.krbKdcPrincipal = krbKdcPrincipal;
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("KDCServer :\n");
        sb.append(super.toString(tabs + "  "));
        sb.append(this.toString(tabs, "  body checksum verified", this.krbBodyChecksumVerified));
        sb.append(this.toString(tabs, "  empty address alowed", this.krbEmptyAddressesAllowed));
        sb.append(this.toString(tabs, "  forwardable allowed", this.krbForwardableAllowed));
        sb.append(this.toString(tabs, "  PA encode timestamp required", this.krbPAEncTimestampRequired));
        sb.append(this.toString(tabs, "  postdated allowed", this.krbPostdatedAllowed));
        sb.append(this.toString(tabs, "  proxiable allowed", this.krbProxiableAllowed));
        sb.append(this.toString(tabs, "  renew allowed", this.krbRenewableAllowed));
        sb.append(this.toString(tabs, "  allowable clock skew", this.krbAllowableClockSkew));
        sb.append(this.toString(tabs, "  KDC principal", this.krbKdcPrincipal));
        sb.append(this.toString(tabs, "  maximum renewable lifetime", this.krbMaximumRenewableLifetime));
        sb.append(this.toString(tabs, "  maximum ticket lifetime", this.krbMaximumTicketLifetime));
        sb.append(this.toString(tabs, "  primary realm", this.krbPrimaryRealm));
        if (this.krbEncryptionTypes != null && this.krbEncryptionTypes.size() > 0) {
            sb.append(tabs).append("  encryption types :\n");
            for (String encryptionType : this.krbEncryptionTypes) {
                sb.append(this.toString(tabs, "    encryption type", encryptionType));
            }
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toString("");
    }
}

